/*
 *    Copyright (C) 2008
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package mediathek.filme;

import java.io.File;
import mediathek.Funktionen;
import mediathek.Konstanten;
import mediathek.daten.Daten;

public class DatenFilm implements Comparable<DatenFilm> {

    Daten daten;
    public String[] arr;
    public boolean thema = false;

    public DatenFilm(Daten ddaten) {
        daten = ddaten;
        makeArr();
    }

    public DatenFilm(Daten ddaten, String ssender, String tthema, String urlThema, String ttitel, String uurl, String datum, String zeit) {
        daten = ddaten;
        makeArr();
        arr[Konstanten.FILM_SENDER_NR] = ssender;
        arr[Konstanten.FILM_THEMA_NR] = tthema;
        arr[Konstanten.FILM_TITEL_NR] = ttitel;
        arr[Konstanten.FILM_URL_NR] = uurl;
        arr[Konstanten.FILM_DATUM_NR] = Funktionen.checkDatum(daten, datum, arr[Konstanten.FILM_SENDER_NR] + " " + arr[Konstanten.FILM_THEMA_NR] + " " + arr[Konstanten.FILM_TITEL_NR]);
        arr[Konstanten.FILM_ZEIT_NR] = Funktionen.checkZeit(daten, zeit, arr[Konstanten.FILM_SENDER_NR] + " " + arr[Konstanten.FILM_THEMA_NR] + " " + arr[Konstanten.FILM_TITEL_NR]);
        arr[Konstanten.FILM_URL_THEMA_NR] = urlThema;
//        arr[Konstanten.FILM_DATEI_NR] = Funktionen.getDateiName(daten, uurl);
        arr[Konstanten.FILM_ALT_NR] = Boolean.toString(false);
    }

    public DatenFilm(Daten ddaten, String ssender, String tthema, String urlThema, String ttitel, String uurl, String uurlorg, String uurlRtmp,
            String datum, String zeit, boolean alt) {
        daten = ddaten;
        makeArr();
        arr[Konstanten.FILM_SENDER_NR] = ssender;
        arr[Konstanten.FILM_THEMA_NR] = tthema;
        arr[Konstanten.FILM_TITEL_NR] = ttitel;
        arr[Konstanten.FILM_URL_NR] = uurl;
        arr[Konstanten.FILM_URL_ORG_NR] = uurlorg;
        arr[Konstanten.FILM_URL_RTMP_NR] = uurlRtmp;
        arr[Konstanten.FILM_URL_THEMA_NR] = urlThema;
        arr[Konstanten.FILM_DATUM_NR] = Funktionen.checkDatum(daten, datum, arr[Konstanten.FILM_SENDER_NR] + " " + arr[Konstanten.FILM_THEMA_NR] + " " + arr[Konstanten.FILM_TITEL_NR]);
        arr[Konstanten.FILM_ZEIT_NR] = Funktionen.checkZeit(daten, zeit, arr[Konstanten.FILM_SENDER_NR] + " " + arr[Konstanten.FILM_THEMA_NR] + " " + arr[Konstanten.FILM_TITEL_NR]);
//        arr[Konstanten.FILM_DATEI_NR] = Funktionen.getDateiName(daten, uurl);
        arr[Konstanten.FILM_ALT_NR] = Boolean.toString(alt);
    }

    public DatenFilm(Daten ddaten, String ssender, String tthema, String ttitel, String uurl, String zielPfad) {
        daten = ddaten;
        makeArr();
        arr[Konstanten.FILM_SENDER_NR] = ssender;
        arr[Konstanten.FILM_THEMA_NR] = tthema;
        arr[Konstanten.FILM_TITEL_NR] = ttitel;
        arr[Konstanten.FILM_URL_NR] = uurl;
        arr[Konstanten.FILM_ZIEL_PFAD_NR] = zielPfad;
//        arr[Konstanten.FILM_DATEI_NR] = Funktionen.getDateiName(daten, uurl);
        arr[Konstanten.FILM_ALT_NR] = Boolean.toString(false);
    }

    public DatenFilm getClean() {
        DatenFilm ret = new DatenFilm(daten);
        for (int i = 0; i < arr.length; ++i) {
            ret.arr[i] = new String(this.arr[i]);
        }
        // vor dem Speichern nicht benötigte Felder löschen
        ret.arr[Konstanten.FILM_NR_NR] = "";
        ret.arr[Konstanten.FILM_PROG_NR] = "";
        ret.arr[Konstanten.FILM_DATEI_NR] = "";
        ret.arr[Konstanten.FILM_ZIEL_DATEI_NR] = "";
        ret.arr[Konstanten.FILM_ZIEL_PFAD_NR] = "";
        ret.arr[Konstanten.FILM_ZIEL_PFAD_DATEI_NR] = "";
        ret.arr[Konstanten.FILM_ABO_NR] = "";
//        ret.arr[Konstanten.FILM_Alter_NR] = "";
        if (!ret.arr[Konstanten.FILM_SENDER_NR].equalsIgnoreCase(Konstanten.SENDER_ARD)) {
            ret.arr[Konstanten.FILM_URL_ORG_NR] = "";
        }
        return ret;
    }

    public String dateiNamenBauen(String pfad, String name) {
        //zieldatei und pfad bauen und eintragen
        //und gibt die Zieldatei mit Pfad zurück
        if (!name.equals("")) {
            name = name.replace("%D", arr[Konstanten.FILM_DATUM_NR].equals("")
                    ? Funktionen.getHeute_yyyyMMdd() : Funktionen.datumDatumZeitReinigen(Funktionen.datumDrehen(arr[Konstanten.FILM_DATUM_NR])));
            name = name.replace("%d", arr[Konstanten.FILM_ZEIT_NR].equals("")
                    ? Funktionen.getJetzt_HHMMSS() : Funktionen.datumDatumZeitReinigen(arr[Konstanten.FILM_ZEIT_NR]));
            name = name.replace("%l", arr[Konstanten.FILM_NR_NR]);
            name = name.replace("%t", arr[Konstanten.FILM_THEMA_NR]);
            name = name.replace("%T", arr[Konstanten.FILM_TITEL_NR]);
            name = name.replace("%n", Funktionen.getDateiName(daten, arr[Konstanten.FILM_URL_NR])); //vorsichtshalber
            name = name.replace("%N", Funktionen.getDateiName(daten, arr[Konstanten.FILM_URL_NR]));
            name = name.replace("%H", Funktionen.getHeute_yyyyMMdd());
            name = name.replace("%h", Funktionen.getJetzt_HHMMSS());
            arr[Konstanten.FILM_ZIEL_DATEI_NR] = Funktionen.replaceLeerDateiname(name, true /*keinPfadTrenner*/);
        } else {
            arr[Konstanten.FILM_ZIEL_DATEI_NR] = Funktionen.replaceLeerDateiname(Funktionen.getDateiName(daten, arr[Konstanten.FILM_URL_NR]), true /*keinPfadTrenner*/);
        }
        if (pfad.endsWith(File.separator)) {
            arr[Konstanten.FILM_ZIEL_PFAD_NR] = pfad.substring(0, pfad.length() - 1);
        } else {
            arr[Konstanten.FILM_ZIEL_PFAD_NR] = pfad;
        }
        arr[Konstanten.FILM_ZIEL_PFAD_DATEI_NR] = Funktionen.addsPfad(daten, pfad, arr[Konstanten.FILM_ZIEL_DATEI_NR]);
        return arr[Konstanten.FILM_ZIEL_PFAD_DATEI_NR];
    }

    @Override
    public int compareTo(DatenFilm arg0) {
        int ret = 0;
//        if ((ret = arr[Konstanten.FILM_SENDER_NR].compareToIgnoreCase(arg0.arr[Konstanten.FILM_SENDER_NR])) == 0) {
//            if ((ret = arr[Konstanten.FILM_THEMA_NR].compareToIgnoreCase(arg0.arr[Konstanten.FILM_THEMA_NR])) == 0) {
//                ret = arr[Konstanten.FILM_TITEL_NR].compareToIgnoreCase(arg0.arr[Konstanten.FILM_TITEL_NR]);
//            }
//        }
        if ((ret = arr[Konstanten.FILM_SENDER_NR].compareToIgnoreCase(arg0.arr[Konstanten.FILM_SENDER_NR])) == 0) {
            ret = arr[Konstanten.FILM_THEMA_NR].compareToIgnoreCase(arg0.arr[Konstanten.FILM_THEMA_NR]);
        }
        return ret;
    }

    private void makeArr() {
        arr = new String[Konstanten.FILME_MAX_ELEM];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = "";
        }
    }
}
