/*
 * Copyright (C) 2008 Michael Lamothe
 *
 * This file is part of Me TV
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */
 
#include "date_time.hh"
#include "exception.hh"
#include "application.hh"

DateTime::DateTime()
{
	time_t t = time(NULL);
	localtime_r(&t, &s);
}

DateTime::DateTime(time_t t, gboolean convert)
{
	if (convert)
	{
		t -= timezone;
	}
	localtime_r(&t, &s);
}

time_t DateTime::now()
{
	return time(NULL);
}

time_t DateTime::now_utc()
{
	struct tm s;
	time_t t = time(NULL);
	gmtime_r(&t, &s);
	return mktime(&s);
}

time_t DateTime::get_time()
{
	return mktime(&s);
}

String DateTime::ftime(const String& format)
{
	char buffer[200];
	strftime(buffer, 200, format.c_str(), &s);	
	return buffer;
}

String DateTime::get_day_of_week_text()
{
	return ftime("%A");
}

String DateTime::get_short_day_of_week_text()
{
	return ftime("%a");
}

String DateTime::get_short_month_text()
{
	return ftime("%b");
}

String DateTime::to_long_string()
{
	return ftime("%c");
}

String DateTime::to_short_string()
{
	return ftime("%x %T");
}

String DateTime::to_time_string()
{	
	return ftime("%H:%M");
}


