.\" 1999 PTM Przemek Borys
'\"
'\" Copyright (c) 1993 The Regents of the University of California.
'\" Copyright (c) 1994-1997 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" RCS: @(#) $Id: expr.n,v 1.1 2000/02/21 15:11:35 pborys Exp $
'\" 
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: expr.n,v 1.1 2000/02/21 15:11:35 pborys Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "OPCJE STANDARDOWE"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
Zobacz dla szczegw podrcznik \\fBoptions\\fR(n).
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Nazwa linii polece:	\\fB\\$1\\fR
Nazwa bazy danych:	\\fB\\$2\\fR
Klasa bazy danych:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH expr n 8.0 Tcl "Wbudowane komendy Tcl"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAZWA
expr \- Oblicz wyraenie
.SH SKADNIA
\fBexpr \fIarg \fR?\fIarg arg ...\fR?
.BE

.SH OPIS
.PP
czy kolejne parametry \fIarg\fR (dodajc midzy nimi spacje) i analizuje
wynik jako wyraenie Tcl, zwracajc warto. Dozwolone wyraenia Tcl s
podzbiorem operatorw dozwolonych w wyraeniach C i maj takie samo
znaczenie i pierwszestwo, jak odpowiadajce im operatory C.
Wyraenia daj prawie zawsze wyniki numeryczne (cakowite, lub
zmiennoprzecinkowe). Np. wyraenie
.CS
\fBexpr 8.2 + 6\fR
.CE
przechodzi w 14.2.
Wyraenia Tcl rni si od wyrae C tym, e operandy s podawane w inny
sposb. Poza tym, wyraenia Tcl obsuguj operandy nienumeryczne oraz
porwnania acuchw.
.SH OPERANDY
.PP
Wyraenie Tcl skada si z kombinacji operandw, operatorw i nawiasw.
Midzy operandami i operatorami mona uywa biaych spacji; s one
ignorowane. Tam gdzie mozliwe, operandy s interpretowane jako wartoci
cakowite. Wartoci cakowite mona podawa dziesitnie (normalny wypadek),
semkowo (jeli pierwszym znakiem operandu jest \fB0\fR) lub szesnastkowo
(jeli pierwszymi znakami operandu s \fB0x\fR).
Jeli operand nie jest w adnym z powyszszych formatw cakowitych, to o ile
jest to moliwe, jest traktowany jako liczba zmiennoprzecinkowa. Zmienne
zmiennoprzecinkowe mog by podawane w dowolny ze sposobw, obsugiwanych
przez zgodny z ANSI kompilator C (poza tym, e przyrostki
\fBf\fR, \fBF\fR, \fBl\fR i \fBL\fR w wikszoci instalacji nie bd
dozwolone).
Na przykad, wszystkie nastpujce liczby s poprawnymi liczbami
zmiennoprzecinkowymi: 2.1, 3., 6e4, 7.91e+16.
Jesli nie jest moliwa interpretacja numeryczna, to operand jest
pozostawiany jako acuch (wtedy jednak mona stosowa tylko ograniczony
zestaw operatorw).
.PP
Operandy mog by podawane w nastpujce sposoby:
.IP [1]
Jako warto numeryczn, cakowit albo zmiennoprzecinkow.
.IP [2]
Jako zmienn Tcl, przy uyciu standardowej notacji \fB$\fR.
Warto zmiennej zostanie wykorzystana jako operand.
.IP [3]
Jako acuch ujty w podwjne cudzysowy.
Przetwarzanie wyraenia bdzie wraliwe na podstawienia ukonikowe,
zmiennych i komend, i uyje wyniku jako operandu.
.IP [4]
Jako acuch ujty w nawiasy klamrowe. Znaki midzy klamr otwierajc i
zamykajc zostan uyte jako operand bez adnego podstawiania.
.IP [5]
Jako komenda Tcl w naiwasach kwadratowych. Komenda zostanie wykonana, a jej
wynik uyty jako operand.
.IP [6]
Jako funkcja matematyczna, ktrej argumenty maj dowoln z powyszych
postaci, taka jak \fBsin($x)\fR. Zobacz niej dla listy zdefiniowanych
funkcji.
.LP
Tam gdzie zachodz podstawienia, s one dokonywane przez instrukcje
wyraenia.
Jednak mg te zosta ju wykonany inny poziom podstawiania, dokonywany
przez przetwarzacza polece przed wywoaniem przetwarzacza wyrae.
Jak pokazuje ponisza dyskusja, zwykle najlepiej jest ujmowa wyraenia w
klamry, co zapobiega by przetwarzacz dokona podstawie zawartoci.
.PP
Dla pewnych przykadw prostych wyrae, zamy e zmienna
\fBa\fR ma warto 3, a
zmienna \fBb\fR warto 6.
Nastpnie, komenda po lewej stronie kadej z linii da wynik, widoczny po
prawej stronie.
.CS
.ta 6c
\fBexpr 3.1 + $a	6.1
expr 2 + "$a.$b"	5.6
expr 4*[llength "6 2"]	8
expr {{word one} < "word $a"}	0\fR
.CE
.SH OPERATORY
.PP
Poniej wymienione s prawidowe operatory; s one zgrupowane wedug
malejcego priorytetu:
.TP 20
\fB\-\0\0+\0\0~\0\0!\fR
Jednoargumentowy minus, jednoargumentowy plis, bitowy NOT i logiczny NOT.
aden z tych operatorw nie moe by stosowany do operandw acuchowych, a
bitowy NOT moe by stosowany tylko do liczb cakowitych.
.TP 20
\fB*\0\0/\0\0%\fR
Mnoenie, dzielenie, reszta. aden z tych operatorw nie moe by stosowany
do operandw acuchowych, a reszta moe by stosowana tylko do liczb
cakowitych.
Reszta ma zawsze znak dzielnika i jej warto absolutna jest zawsze mnijesza
ni warto dzielnika.
.TP 20
\fB+\0\0\-\fR
Dodawanie i odejmowanie. Prawidowe dla dowolnych operandw numerycznych.
.TP 20
\fB<<\0\0>>\fR
Przesuwanie w lewo i w prawo. Prawidowe tylko dla operandw cakowitych.
Przesuwanie w prawo propaguje bit znaku.
.TP 20
\fB<\0\0>\0\0<=\0\0>=\fR
Logiczny mniejszy, wikszy, mniejszy lub rwny, wikszy lub rwny.
Kady operator daje 1 jeli warunek jest speniony lub 0 w przeciwnym
wypadku. Operandami mog by zarwno wartoci numeryczne, jak i acuchowe,
w ktrym wypadku dokonywane jest porwnywanie acuchw.
.TP 20
\fB==\0\0!=\fR
Logiczna rwno i nierwno. Kady operator daje wynik zero/jeden.
Prawidowe dla wszelkich operandw.
.TP 20
\fB&\fR
Bitowy AND. Prawidowy tylko dla operandw cakowitych.
.TP 20
\fB^\fR
Bitowy XOR. Prawidowy tylko dla operandw cakowitych.
.TP 20
\fB|\fR
Bitowy OR. Prawidowy tylko dla operandw cakowitych.
.TP 20
\fB&&\fR
Logiczny AND. Daje 1 jeli obydwa operandy s niezerowe, lub 0 w przeciwnym
wypadku.
Prawidowe dla operandw logicznych i numerycznych.
.TP 20
\fB||\fR
Logiczny OR. Daje 0 jeli obydwa operandy s zerowe lub 1 w przeciwnym
wypadku. Prawidowe dla operandw logicznych i numerycznych.
.TP 20
\fIx\fB?\fIy\fB:\fIz\fR
Jeeli-to-inaczej, jak w C. Jeli \fIx\fR rozwija si na warto niezerow,
to wynikiem jest warto \fIy\fR. W przeciwnym wypadku wartoci wynikow
jest \fIz\fR.
Operand \fIx\fR musi mie warto numeryczn.
.LP
Zobacz podrcznik C dla dalszych szczegw o wynikach, dawanych przez
operatory. Wszystkie operatory binarne grupuj si od lewej do prawej w tym
samym priorytecie. Np. komenda
.CS
\fBexpr 4*2 < 7\fR
.CE
daje 0.
.PP
Operatory \fB&&\fR, \fB||\fR i \fB?:\fR maj ``leniw
analiz'', zupenie jak w C, co znaczy, e operandy nie s analizowane jeli
nie ma takiej potrzeby do okrelenia wyniku. Np. w komendzie
.CS
\fBexpr {$v ? [a] : [b]}\fR
.CE
analizowane bdzie tylko jedno z \fB[a]\fR lub \fB[b]\fR, zalenie od
wartoci \fB$v\fR. Zauwa jednak, e jest to prawdziwe tylko jeli cae
wyraenie jest ujte w nawiasy klamrowe; w przeciwnym wypadku przetwarzacz
Tcl przemieli zarwno \fB[a]\fR jak i \fB[b]\fR jeszcze przed wywoaniem
komendy \fBexpr\fR.
.SH "FUNKCJE MATEMATYCZNE"
.PP
Tcl obsuguje nastpujce funkcje matematyczne wyrae:
.DS
.ta 3c 6c 9c
\fBacos\fR	\fBcos\fR	\fBhypot\fR	\fBsinh\fR
\fBasin\fR	\fBcosh\fR	\fBlog\fR	\fBsqrt\fR
\fBatan\fR	\fBexp\fR	\fBlog10\fR	\fBtan\fR
\fBatan2\fR	\fBfloor\fR	\fBpow\fR	\fBtanh\fR
\fBceil\fR	\fBfmod\fR	\fBsin\fR
.DE
Kada z tych funkcji woa funkcj biblioteki matematycznej o tej samej
nazwie. Tcl ponadto implemntuje nastpujce funkcje dla konwersji midzy
liczbami cakowitymi, zmiennoprzecinkowymi i losowania liczb losowych:
.TP
\fBabs(\fIarg\fB)\fR
Zwraca warto moduu \fIarg\fR. \fIArg\fR moe by liczb cakowit, lub
zmiennoprzecinkow; wynik jest zwracany w tej samej postaci.
.TP
\fBdouble(\fIarg\fB)\fR
Jeli \fIarg\fR jest liczb zmiennoprzecinkow, zwracane jest \fIarg\fR. W
przeciwnym wypadku \fIarg\fR jest konwertowany na posta zmiennoprzecinkow
i zwracany w tej postaci.
.TP
\fBint(\fIarg\fB)\fR
Jak wyej, ale zamiana na liczb cakowit.
.TP
\fBrand()\fR
Zwraca liczb zmiennoprzecinkow w zakresie od zera do 1. Nasienie pochodzi
z wewntrznego zegara maszyny, lub moe by ustawiane rcznie funkcj srand.
.TP
\fBround(\fIarg\fB)\fR
Jeli \fIarg\fR jest cakowite, zwracane jest \fIarg\fR. W przeciwnym
wypadku \fIarg\fR jest konwertowane na posta cakowit poprzez
zaokrglanie.
.TP
\fBsrand(\fIarg\fB)\fR
Parametr \fIarg\fR, ktry musi by liczb cakowit, suy do resetowania
nasienia generatora liczb losowych. Zwraca pierwsz liczb losow dla tego
nasienia. Kady interpreter ma swoje wasne nasienie.
.PP
W dodatku do tych predefiniowanych funkcji, aplikacje mog definiowa inne
funkcje, korzystajc z \fBTcl_CreateMathFunc\fR().
.SH "TYPY, PRZEPENIENIE I PRECYZJA"
.PP
Wszystkie obliczenia wewntrzne na liczbach cakowitych s dokonywane w
typie \fIlong\fR z C, a wszystkie obliczenia zmiennoprzecinkowe na typie
\fIdouble\fR.
Podczas konwersji acucha na liczb zmiennoprzecinkow, wykrywane jest
przepenienie eksponentne, co powoduje bd Tcl.
Dla konwersji acucha na liczb cakowit, wykrywanie przepenienia zaley
od zachowania pewnych funkcji biblioteki C, wic raczej nie mona na tym
polega.
.PP
Konwersja midzy reprezentacjami cakowitymi, zmiennoprzecinkowymi i
acuchowymi operandw jest wykonywana automatycznie tam gdzie potrzeba.
Dla oblicze arytmetycznych zmienne cakowite s uywane tak dugo, a nie
pojawi si liczba zmiennoprzecinkowa i wtedy zaczyna si uywanie liczb
zmiennoprzecinkowych.
Na przykad,
.CS
\fBexpr 5 / 4\fR
.CE
zwraca 1, podczas gdy
.CS
\fBexpr 5 / 4.0\fR
\fBexpr 5 / ( [string length "abcd"] + 0.0 )\fR
.CE
zwraca 1.25.
Wartoci zmiennoprzecinkowe s zawsze zwracane z ``\fB.\fR'' lub \fBe\fR,
wic nie wygldaj jak liczby cakowite. Na przykad,
.CS
\fBexpr 20.0/5.0\fR
.CE
zwraca \fB4.0\fR, nie \fB4\fR.

.SH "OPERACJE ACUCHOWE"
.PP
Jeli jeden z operandw porwnania jest acuchem, a drugi ma warto
numeryczn, to operand numeryczny jest konwertowany z uyciem formatu
\fB%d\fR lub \fB%g\fR funkcji \fIsprintf\fR(3) jzyka C z powrotem na acuch. 
Na przykad komendy
.CS
\fBexpr {"0x03" > "2"}\fR
\fBexpr {"0y" < "0x12"}\fR
.CE
zwracaj 1. Pierwsze porwnanie jest dokonywane w porwnaniu cakowitym, a
drugie w porwnaniu acuchowym, po przekonwertowaniu drugiego operandu na
acuch \fB18\fR.
Poniewa Tcl ma tendencje do traktowania wartoci tam gdzie moliwe jako
liczby, to uywanie operatorw \fB==\fR i podobnych nie jest dobrym
pomysem, jeli naprawd chcesz porwnania acuchowego; lepiej uy komendy
\fBstring compare\fR.

.SH "ROZWAANIA O WYDAJNOCI"
.VS
.PP
Jeli chcesz jak najwikszej szybkoci i najmniejszego zajmowania pamici,
ujmuj wyraenia w klamry. Umoliwia to kompilatorowi kodu bitowego
Tcl wygenerowanie jak najlepszego kodu.
.PP
Jak wspomniano wyej, w wyraeniach dokonuje si dwch podstawie:
raz przez przetwarzacz Tcl, raz przez komend \fBexpr\fR.
Na przykad, komendy
.CS
\fBset a 3\fR
\fBset b {$a + 2}\fR
\fBexpr $b*4\fR
.CE
zwracaj 11, a nie wielokrotno 4.
Jest tak dlatego, e przetwarzacz Tcl najpierw podstawia za \fB$a + 2\fR
zmienn \fBb\fR, a nastpnie komenda \fBexpr\fR przetwarza wyraanie
\fB$a + 2*4\fR.
.PP
Wikszo wyrae nie wymaga drugiej kolejki podstawie. S one albo
ujmowane w klamry, albo ich proces podstawiania zmiennych i komend daje
liczby i acuchy, nie wymagajce podstawie jako takich. Jednak z uwagi na
to, e nieuklamrowione wyraenia wymagaj dwch rund podstawie, kompilator
kodu bitowego musi emitowa dodatkowe instrukcje obsugi takiej sytuacji.
Najkosztowniejszy kod generowany jest dla nieuklamrowionych wyrae, ktre
zawieraj podstawienia komend. Wyraenia te musz by implementowane przez
generowanie nowego kodu za kadym wykonaniem wyraenia.
.VE

.SH SOWA KLUCZOWE
arytmetyka, logiczny, porwnanie, wyraenie, porwnanie rozmyte
