/* This file is part of the KDE project
   Copyright (C) 2006-2007 KovoKs <info@kovoks.nl>
   Copyright (C) 2007 Frode M. Døving <frode@lnix.net>

   Original copied from showfoto:
    Copyright 2005 by Gilles Caulier <caulier.gilles@free.fr>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#ifndef SETUPIDENTITIES_H
#define SETUPIDENTITIES_H

#include "klistbox.h"
class KLineEdit;
class KTabWidget;
class QButtonGroup;
class QGroupBox;
class QVGroupBox;
class QListBoxItem;
class KPasswordEdit;
class KTextEdit;


namespace KWallet {
    class Wallet;
}

namespace Mailody {

class Identity
{
    public:
        explicit Identity(
            const QString& identityName,const QString& smtpServer,
            const QString& fullName,    const QString& emailAddress,
            const QString& smtpUserName,const QString& smtpPassword,
            int safeSMTP,               bool smtpNeedAuth,
            bool sigEnabled,            const QString& signature,
            int sigPos,                 int htmlPart )
            :
                m_identityName(identityName),   m_smtpServer(smtpServer),
                m_fullName(fullName),           m_emailAddress(emailAddress),
                m_smtpUserName(smtpUserName),   m_smtpPassword(smtpPassword),
                m_safeSMTP(safeSMTP),           m_smtpNeedAuth(smtpNeedAuth),
                m_sigEnabled(sigEnabled),       m_signature(signature),
                m_sigPos(sigPos),               m_htmlPart(htmlPart)
            { }
        ~Identity() { m_smtpPassword.fill(0); };
        QString identityName() const    { return m_identityName; };
        QString smtpServer() const      { return m_smtpServer; };
        QString fullName() const        { return m_fullName; };
        QString emailAddress() const    { return m_emailAddress; };
        QString smtpUserName() const    { return m_smtpUserName; };
        QString smtpPassword() const    { return m_smtpPassword; };
        int safeSMTP() const            { return m_safeSMTP; };
        bool smtpNeedAuth() const       { return m_smtpNeedAuth; };
        bool sigEnabled() const         { return m_sigEnabled; };
        QString signature() const       { return m_signature; };
        int sigPos() const              { return m_sigPos; };
        int htmlPart() const            { return m_htmlPart; };

    private:
        QString m_identityName;
        QString m_smtpServer;
        QString m_fullName;
        QString m_emailAddress;
        QString m_smtpUserName;
        QString m_smtpPassword;
        int     m_safeSMTP;
        bool    m_smtpNeedAuth;
        bool    m_sigEnabled;
        QString m_signature;
        int     m_sigPos;
        int     m_htmlPart;
};



/**
 * Simple reimplementation of a KListBox to prevent crash in mouseMoveEvent()
 *
 * #6  0xb6b345f8 in QListBox::setCurrentItem (this=0x85c6bb0, i=0x8603660)
 *   at widgets/qlistbox.cpp:1888
 * #7  0xb6b3278c in QListBox::updateSelection (this=0x85c6bb0)
 *   at widgets/qlistbox.cpp:2332
 * #8  0xb6b335c8 in QListBox::mouseMoveEvent (this=0x85c6bb0, e=0xbfc2fbfc)
 *   at widgets/qlistbox.cpp:2315
 *
 * @Author Tom Albers <tomalbers@kde.nl>
 */
class NoDragKListBox: public KListBox
{
    public:
        NoDragKListBox(QWidget* parent);
    protected:
        void mouseMoveEvent( QMouseEvent *e );
        void keyPressEvent( QKeyEvent *e );
};

/**
 * @class SetupIdentities
 * These contain the identites settings
 * This file is originally copied from showfoto
 * @author Gilles Caulier <caulier.gilles@free.fr>
 * @author Tom Albers <tomalbers@kde.nl>
 */
class SetupIdentities : public QWidget
{
    Q_OBJECT

    public:

        /**
         * Constructor
         * @param parent Parent Widget
         */
        SetupIdentities(QWidget* parent = 0);

        /**
         * Destructor
         */
        ~SetupIdentities();

        /**
         * Call this if you want the settings saved from this page.
         */
        void applySettings();

    private slots:
        void slotDel();
        void slotAdd();
        void slotSelectionChanged(QListBoxItem*);
        void slotIdentityNameEdit( const QString& text );

    private:
        void readSettings();
        void saveCurrent();

        QValueList<Identity*>   m_identityList;
        Identity*               m_currentIdentity;
        KWallet::Wallet*        m_wallet;

        KTabWidget*             m_tabWidget;
        NoDragKListBox*         m_identybox;

        KLineEdit*              m_identityName;
        KLineEdit*              m_fullName;
        KLineEdit*              m_emailAddress;
        KLineEdit*              m_smtpServer;
        QButtonGroup*           m_safeSMTP;
        QButtonGroup*           m_htmlPart;
        QVGroupBox*             m_smtpAuthBox;
        KLineEdit*              m_smtpUserName;
        KPasswordEdit*          m_smtpPassword;
        KTextEdit*              m_signature;
        QGroupBox*              m_sigBox;
        QButtonGroup*           m_sigPos;

};

}

#endif
