/* Generated by GOB (v2.0.15)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 15

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "mn-maildir-message.h"

#include "mn-maildir-message-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 28 "src/mn-maildir-message.gob"

#include <glib/gi18n.h>
#include "mn-vfs-mailbox.h"
#include "mn-vfs.h"
#include "mn-util.h"
#include "mn-message-private.h"
#include "mn-shell.h"

#define DELETE_DIALOG_MESSAGE	"mn-maildir-message-delete-dialog-message"

#line 37 "mn-maildir-message.c"
/* self casting macros */
#define SELF(x) MN_MAILDIR_MESSAGE(x)
#define SELF_CONST(x) MN_MAILDIR_MESSAGE_CONST(x)
#define IS_SELF(x) MN_IS_MAILDIR_MESSAGE(x)
#define TYPE_SELF MN_TYPE_MAILDIR_MESSAGE
#define SELF_CLASS(x) MN_MAILDIR_MESSAGE_CLASS(x)

#define SELF_GET_CLASS(x) MN_MAILDIR_MESSAGE_GET_CLASS(x)

/* self typedefs */
typedef MNMaildirMessage Self;
typedef MNMaildirMessageClass SelfClass;

/* here are local prototypes */
#line 0 "src/mn-maildir-message.gob"
static void mn_maildir_message_init (MNMaildirMessage * o);
#line 54 "mn-maildir-message.c"
#line 0 "src/mn-maildir-message.gob"
static void mn_maildir_message_class_init (MNMaildirMessageClass * c);
#line 57 "mn-maildir-message.c"
#line 41 "src/mn-maildir-message.gob"
static int mn_maildir_message_flags_sort_cb (const void * a, const void * b);
#line 60 "mn-maildir-message.c"
#line 52 "src/mn-maildir-message.gob"
static void ___2_mn_maildir_message_builtin_mark_as_read (MNMessage * message, MNMessageActionRequest * request);
#line 63 "mn-maildir-message.c"
#line 58 "src/mn-maildir-message.gob"
static GError * mn_maildir_message_builtin_mark_as_read_cb (MNMessage * message, gpointer data);
#line 66 "mn-maildir-message.c"
#line 114 "src/mn-maildir-message.gob"
static GnomeVFSURI * mn_maildir_message_get_trash_uri (MNMaildirMessage * self);
#line 69 "mn-maildir-message.c"
#line 145 "src/mn-maildir-message.gob"
static GError * mn_maildir_message_delete_with_prompt (MNMaildirMessage * self, const char * format, ...) G_GNUC_PRINTF(2, 3);
#line 72 "mn-maildir-message.c"
#line 192 "src/mn-maildir-message.gob"
static void mn_maildir_message_delete_messages_changed_h (MNMailboxes * mailboxes, gboolean has_new, gpointer user_data);
#line 75 "mn-maildir-message.c"
#line 207 "src/mn-maildir-message.gob"
static void ___7_mn_maildir_message_builtin_delete (MNMessage * message, MNMessageActionRequest * request);
#line 78 "mn-maildir-message.c"
#line 213 "src/mn-maildir-message.gob"
static GError * mn_maildir_message_builtin_delete_cb (MNMessage * message, gpointer data);
#line 81 "mn-maildir-message.c"

/* pointer to the class of our parent */
static MNVFSMessageClass *parent_class = NULL;

/* Short form macros */
#define self_flags_sort_cb mn_maildir_message_flags_sort_cb
#define self_builtin_mark_as_read_cb mn_maildir_message_builtin_mark_as_read_cb
#define self_get_trash_uri mn_maildir_message_get_trash_uri
#define self_delete_with_prompt mn_maildir_message_delete_with_prompt
#define self_delete_messages_changed_h mn_maildir_message_delete_messages_changed_h
#define self_builtin_delete_cb mn_maildir_message_builtin_delete_cb
GType
mn_maildir_message_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (MNMaildirMessageClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) mn_maildir_message_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (MNMaildirMessage),
			0 /* n_preallocs */,
			(GInstanceInitFunc) mn_maildir_message_init,
			NULL
		};

		type = g_type_register_static (MN_TYPE_VFS_MESSAGE, "MNMaildirMessage", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((MNMaildirMessage *)g_object_new(mn_maildir_message_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static MNMaildirMessage * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static MNMaildirMessage *
GET_NEW_VARG (const char *first, ...)
{
	MNMaildirMessage *ret;
	va_list ap;
	va_start (ap, first);
	ret = (MNMaildirMessage *)g_object_new_valist (mn_maildir_message_get_type (), first, ap);
	va_end (ap);
	return ret;
}

static void 
mn_maildir_message_init (MNMaildirMessage * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:Maildir:Message::init"
}
#undef __GOB_FUNCTION__
static void 
mn_maildir_message_class_init (MNMaildirMessageClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:Maildir:Message::class_init"
	MNMessageClass *mn_message_class = (MNMessageClass *)c;

	parent_class = g_type_class_ref (MN_TYPE_VFS_MESSAGE);

#line 52 "src/mn-maildir-message.gob"
	mn_message_class->builtin_mark_as_read = ___2_mn_maildir_message_builtin_mark_as_read;
#line 207 "src/mn-maildir-message.gob"
	mn_message_class->builtin_delete = ___7_mn_maildir_message_builtin_delete;
#line 153 "mn-maildir-message.c"
}
#undef __GOB_FUNCTION__



#line 41 "src/mn-maildir-message.gob"
static int 
mn_maildir_message_flags_sort_cb (const void * a, const void * b)
{
#line 163 "mn-maildir-message.c"
#define __GOB_FUNCTION__ "MN:Maildir:Message::flags_sort_cb"
{
#line 43 "src/mn-maildir-message.gob"
	
    char ca = *((char *) a);
    char cb = *((char *) b);

    /* sort flags using ASCII order, see http://cr.yp.to/proto/maildir.html */

    return ca - cb;
  }}
#line 175 "mn-maildir-message.c"
#undef __GOB_FUNCTION__

#line 52 "src/mn-maildir-message.gob"
static void 
___2_mn_maildir_message_builtin_mark_as_read (MNMessage * message G_GNUC_UNUSED, MNMessageActionRequest * request)
#line 181 "mn-maildir-message.c"
#define PARENT_HANDLER(___message,___request) \
	{ if(MN_MESSAGE_CLASS(parent_class)->builtin_mark_as_read) \
		(* MN_MESSAGE_CLASS(parent_class)->builtin_mark_as_read)(___message,___request); }
{
#define __GOB_FUNCTION__ "MN:Maildir:Message::builtin_mark_as_read"
{
#line 54 "src/mn-maildir-message.gob"
	
    mn_message_perform_action_in_thread(request, self_builtin_mark_as_read_cb, NULL);
  }}
#line 192 "mn-maildir-message.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 58 "src/mn-maildir-message.gob"
static GError * 
mn_maildir_message_builtin_mark_as_read_cb (MNMessage * message, gpointer data)
{
#line 200 "mn-maildir-message.c"
#define __GOB_FUNCTION__ "MN:Maildir:Message::builtin_mark_as_read_cb"
{
#line 60 "src/mn-maildir-message.gob"
	
    MNVFSMessage *vmessage = MN_VFS_MESSAGE(message);
    char *old_flags;
    char *old_filename;
    char *new_filename;
    GnomeVFSURI *dir_uri;
    GnomeVFSURI *new_uri;
    GError *err = NULL;

    /* http://cr.yp.to/proto/maildir.html */

    old_filename = gnome_vfs_uri_extract_short_name(vmessage->vfs_uri);

    old_flags = strrchr(old_filename, ',');
    if (old_flags)
      {
	char *new_flags;
	int old_len;
	char *base_filename;

	/* append the S (seen) flag */

	old_flags++;
	g_assert(strchr(old_flags, 'S') == NULL);

	old_len = strlen(old_flags);
	new_flags = g_new(char, old_len + 2); /* + space for S and nul */
	memcpy(new_flags, old_flags, old_len);
	new_flags[old_len] = 'S';
	new_flags[old_len + 1] = 0;
	qsort(new_flags, old_len + 1, sizeof(char), self_flags_sort_cb);

	base_filename = g_strndup(old_filename, old_flags - old_filename - 1);
	new_filename = g_strdup_printf("%s,%s", base_filename, new_flags);
	g_free(base_filename);
	g_free(new_flags);
      }
    else
      new_filename = g_strconcat(old_filename, ":2,S", NULL);

    g_free(old_filename);

    dir_uri = gnome_vfs_uri_append_path(MN_VFS_MAILBOX(message->mailbox)->vfs_uri, "cur");
    new_uri = gnome_vfs_uri_append_file_name(dir_uri, new_filename);
    gnome_vfs_uri_unref(dir_uri);
    g_free(new_filename);

    mn_vfs_result_to_g_error(gnome_vfs_move_uri(vmessage->vfs_uri, new_uri, TRUE), &err);
    gnome_vfs_uri_unref(new_uri);

    return err;
  }}
#line 256 "mn-maildir-message.c"
#undef __GOB_FUNCTION__

#line 114 "src/mn-maildir-message.gob"
static GnomeVFSURI * 
mn_maildir_message_get_trash_uri (MNMaildirMessage * self)
{
#line 263 "mn-maildir-message.c"
#define __GOB_FUNCTION__ "MN:Maildir:Message::get_trash_uri"
#line 114 "src/mn-maildir-message.gob"
	g_return_val_if_fail (self != NULL, (GnomeVFSURI * )0);
#line 114 "src/mn-maildir-message.gob"
	g_return_val_if_fail (MN_IS_MAILDIR_MESSAGE (self), (GnomeVFSURI * )0);
#line 269 "mn-maildir-message.c"
{
#line 116 "src/mn-maildir-message.gob"
	
    MNVFSMessage *vmessage = MN_VFS_MESSAGE(self);
    GnomeVFSURI *trash_uri;

    /*
     * Do what is advised in the gnome_vfs_find_directory()
     * documentation: first pass find_if_needed, then create_if_needed.
     */

    if (gnome_vfs_find_directory(vmessage->vfs_uri,
				 GNOME_VFS_DIRECTORY_KIND_TRASH,
				 &trash_uri,
				 FALSE,
				 TRUE,
				 0) == GNOME_VFS_OK)
      return trash_uri;

    if (gnome_vfs_find_directory(vmessage->vfs_uri,
				 GNOME_VFS_DIRECTORY_KIND_TRASH,
				 &trash_uri,
				 TRUE,
				 FALSE,
				 S_IRUSR | S_IWUSR | S_IXUSR) == GNOME_VFS_OK)
      return trash_uri;

    return NULL;
  }}
#line 299 "mn-maildir-message.c"
#undef __GOB_FUNCTION__

#line 145 "src/mn-maildir-message.gob"
static GError * 
mn_maildir_message_delete_with_prompt (MNMaildirMessage * self, const char * format, ...)
{
#line 306 "mn-maildir-message.c"
#define __GOB_FUNCTION__ "MN:Maildir:Message::delete_with_prompt"
#line 145 "src/mn-maildir-message.gob"
	g_return_val_if_fail (self != NULL, (GError * )0);
#line 145 "src/mn-maildir-message.gob"
	g_return_val_if_fail (MN_IS_MAILDIR_MESSAGE (self), (GError * )0);
#line 145 "src/mn-maildir-message.gob"
	g_return_val_if_fail (format != NULL, (GError * )0);
#line 314 "mn-maildir-message.c"
{
#line 147 "src/mn-maildir-message.gob"
	
    GtkWidget *dialog;
    char *prompt;
    int response;

    MN_STRDUP_VPRINTF(prompt, format);

    GDK_THREADS_ENTER();

    dialog = mn_alert_dialog_new(NULL,
				 GTK_MESSAGE_WARNING,
				 0,
				 _("Delete message?"),
				 prompt);
    g_free(prompt);

    gtk_dialog_add_buttons(GTK_DIALOG(dialog),
			   GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
			   GTK_STOCK_DELETE, GTK_RESPONSE_OK,
			   NULL);

    g_object_set_data(G_OBJECT(dialog), DELETE_DIALOG_MESSAGE, self);

    mn_g_object_connect(dialog, mn_shell->mailboxes,
			"signal::messages-changed", self_delete_messages_changed_h, dialog,
			NULL);

    response = mn_dialog_run_nonmodal(GTK_DIALOG(dialog));
    gtk_widget_destroy(dialog);

    gdk_flush();
    GDK_THREADS_LEAVE();

    if (response == GTK_RESPONSE_OK)
      {
	GError *err = NULL;

	mn_vfs_result_to_g_error(gnome_vfs_unlink_from_uri(MN_VFS_MESSAGE(self)->vfs_uri), &err);

	return err;
      }
    else
      return g_error_new(MN_MESSAGE_ACTION_ERROR, MN_MESSAGE_ACTION_ERROR_CANCELLED, "cancelled");
  }}
#line 361 "mn-maildir-message.c"
#undef __GOB_FUNCTION__

#line 192 "src/mn-maildir-message.gob"
static void 
mn_maildir_message_delete_messages_changed_h (MNMailboxes * mailboxes, gboolean has_new, gpointer user_data)
{
#line 368 "mn-maildir-message.c"
#define __GOB_FUNCTION__ "MN:Maildir:Message::delete_messages_changed_h"
{
#line 196 "src/mn-maildir-message.gob"
	
    GtkWidget *dialog = user_data;
    Self *self;

    self = g_object_get_data(G_OBJECT(dialog), DELETE_DIALOG_MESSAGE);

    /* if the message was removed, close the dialog */
    if (! g_hash_table_lookup(mn_shell->mailboxes->messages_hash_table, MN_MESSAGE(self)->id))
      gtk_dialog_response(GTK_DIALOG(dialog), GTK_RESPONSE_CANCEL);
  }}
#line 382 "mn-maildir-message.c"
#undef __GOB_FUNCTION__

#line 207 "src/mn-maildir-message.gob"
static void 
___7_mn_maildir_message_builtin_delete (MNMessage * message G_GNUC_UNUSED, MNMessageActionRequest * request)
#line 388 "mn-maildir-message.c"
#define PARENT_HANDLER(___message,___request) \
	{ if(MN_MESSAGE_CLASS(parent_class)->builtin_delete) \
		(* MN_MESSAGE_CLASS(parent_class)->builtin_delete)(___message,___request); }
{
#define __GOB_FUNCTION__ "MN:Maildir:Message::builtin_delete"
{
#line 209 "src/mn-maildir-message.gob"
	
    mn_message_perform_action_in_thread(request, self_builtin_delete_cb, NULL);
  }}
#line 399 "mn-maildir-message.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 213 "src/mn-maildir-message.gob"
static GError * 
mn_maildir_message_builtin_delete_cb (MNMessage * message, gpointer data)
{
#line 407 "mn-maildir-message.c"
#define __GOB_FUNCTION__ "MN:Maildir:Message::builtin_delete_cb"
{
#line 215 "src/mn-maildir-message.gob"
	
    Self *self = SELF(message);
    MNVFSMessage *vmessage = MN_VFS_MESSAGE(message);
    GnomeVFSURI *trash_uri;
    char *filename;
    GnomeVFSURI *dest_uri;
    GnomeVFSResult result;

    trash_uri = self_get_trash_uri(self);
    if (! trash_uri)
      return self_delete_with_prompt(self, _("The message cannot be moved to the trash. Permanently delete it?"));

    filename = gnome_vfs_uri_extract_short_name(vmessage->vfs_uri);
    dest_uri = gnome_vfs_uri_append_file_name(trash_uri, filename);
    gnome_vfs_uri_unref(trash_uri);
    g_free(filename);

    /*
     * Use gnome_vfs_xfer_uri() rather than gnome_vfs_move_uri(), in
     * case the trash resides on a different file system than the
     * message.
     */
    result = gnome_vfs_xfer_uri(vmessage->vfs_uri,
				dest_uri,
				GNOME_VFS_XFER_REMOVESOURCE
				| GNOME_VFS_XFER_FOLLOW_LINKS,
				GNOME_VFS_XFER_ERROR_MODE_ABORT,
				GNOME_VFS_XFER_OVERWRITE_MODE_REPLACE,
				NULL,
				NULL);
    gnome_vfs_uri_unref(dest_uri);

    if (result == GNOME_VFS_OK)
      return NULL;
    else
      return self_delete_with_prompt(self, _("The message could not be moved to the trash (%s). Permanently delete it?"), gnome_vfs_result_to_string(result));
  }}
#line 448 "mn-maildir-message.c"
#undef __GOB_FUNCTION__
