/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file DayDateAxisAttributes.cc
    \brief Implemtation of DayDateAxis Attributes class.
    \author MeteoroMagLogical Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!
   
    Generated: Tue Nov 22 10:53:40 2011
*/    

#include "DayDateAxisAttributes.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"
#include "XmlNode.h"
#include "ParameterSettings.h"


using namespace magics;


DayDateAxisAttributes::DayDateAxisAttributes():
	colour_(ParameterManager::getString("axis_days_label_colour")),
	type_(ParameterManager::getString("axis_days_label_internal")),
	quality_(ParameterManager::getString("axis_days_label_quality")),
	height_(ParameterManager::getDouble("axis_days_label_height")),
	composition_(ParameterManager::getString("axis_days_label_composition")),
	format_(ParameterManager::getString("axis_days_label_format"))
{
} 



DayDateAxisAttributes::~DayDateAxisAttributes()
{
}

    
void DayDateAxisAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(2);
	prefix[0] = "axis_days";
	prefix[1] = "axis";

	setAttribute(prefix, "axis_days_label_colour", colour_, params);
	setAttribute(prefix, "axis_days_label_internal", type_, params);
	setAttribute(prefix, "axis_days_label_quality", quality_, params);
	setAttribute(prefix, "axis_days_label_height", height_, params);
	setAttribute(prefix, "axis_days_label_composition", composition_, params);
	setAttribute(prefix, "axis_days_label_format", format_, params);
}

void DayDateAxisAttributes::copy(const DayDateAxisAttributes& other)
{
	colour_ = other.colour_;
	type_ = other.type_;
	quality_ = other.quality_;
	height_ = other.height_;
	composition_ = other.composition_;
	format_ = other.format_;
} 


bool DayDateAxisAttributes::accept(const string& node)
{	
	if ( magCompare(node, "day")  )
		return true;
	return false;
}

void DayDateAxisAttributes::set(const XmlNode& node)
{
	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "day") )
		set(node.attributes());
	else {
	}
	for (XmlNode::ElementIterator elt = node.firstElement(); elt != node.lastElement(); ++elt) {
	}
}

void DayDateAxisAttributes::print(ostream& out)  const
{
	out << "DayDateAxisAttributes[";
	out << "colour = " << colour_;
	out << ", type = " << type_;
	out << ", quality = " << quality_;
	out << ", height = " << height_;
	out << ", composition = " << composition_;
	out << ", format = " << format_;
	out << "]" << "\n";
}


void DayDateAxisAttributes::toxml(ostream& out, const string& tag, int tabs)  const
{
     out <<  "\"day\"";
	 out << ", \"axis_days_label_colour\":";
	 niceprint(out,colour_);
	 out << ", \"axis_days_label_internal\":";
	 niceprint(out,type_);
	 out << ", \"axis_days_label_quality\":";
	 niceprint(out,quality_);
	 out << ", \"axis_days_label_height\":";
	 niceprint(out,height_);
	 out << ", \"axis_days_label_composition\":";
	 niceprint(out,composition_);
	 out << ", \"axis_days_label_format\":";
	 niceprint(out,format_);
}
static MagicsParameter<string> axis_days_label_colour("axis_days_label_colour", "undef", "");
static MagicsParameter<string> axis_days_label_internal("axis_days_label_internal", "both", "");
static MagicsParameter<string> axis_days_label_quality("axis_days_label_quality", "medium", "");
static MagicsParameter<double> axis_days_label_height("axis_days_label_height", 0.2, "");
static MagicsParameter<string> axis_days_label_composition("axis_days_label_composition", "three", "");
static MagicsParameter<string> axis_days_label_format("axis_days_label_format", "three", "");
