/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file SymbolPlotting.cc
    \brief Implementation of the Template class SymbolPlotting.
    
    Magics Team - ECMWF 2004
    
    Started: Mon 19-Jan-2004
    
    Changes:
    
*/

#include "Colour.h"
#include "Factory.h"

#include "ProgressObject.h"
#include "MagicsFormat.h"

using namespace magics;


template <class P>
SymbolPlotting<P>::SymbolPlotting() 
{
}

template <class P>
SymbolPlotting<P>::~SymbolPlotting() 
{
}

/*!
 Class information are given to the output-stream.
*/	
template <class P>	
void SymbolPlotting<P>::print(ostream& out)  const
{
	out << "SymbolPlotting<P>[";
	SymbolPlottingAttributes::print(out);
	out << "]";
}



template <class P>
void SymbolPlotting<P>::operator()(const PaperPoint& point, BasicGraphicsObjectContainer&) const 
{
	vector<string> check;
	check.push_back("text");
	check.push_back("number");
	check.push_back("marker");
	
	bool valid = false;
	for ( vector<string>::iterator c = check.begin(); c != check.end(); ++c) {
		valid = magCompare(*c, type_);
		if ( valid) 
			break;
	}
    if ( !valid ) {
    	Log::warning() << type_ << " not yet implemented : reset to marker " << endl;
    	const_cast< SymbolPlotting<P> *>(this)->type_ = "marker";
    }
	try {
    	
    	if ( (*mode_).accept(point.value()) == false ) return;
    	
        SymbolProperties properties = (*mode_)(point.value());
        //properties.position(Symbol::M_NONE);
        
        string value;
		if  ( magCompare(type_, "number") ) {
			ostringstream nice;
			nice << MagicsFormat(format_, point.value());
			value = nice.str();
		}
       
       
         typename map<SymbolProperties, Symbol* >::const_iterator symb = symbols_.find(properties); 
         if ( symb  != symbols_.end() )
         {
        	    symb->second->push_back(point, value);
                return;
         } 	
        

         Symbol* symbol = properties.symbol(type_);
         symbols_[properties] = symbol;
      
         symbol->push_back(point, value);

         
         
        	 
         
        
    }
    catch ( ... ) { }
}

template <class P>
struct Print
{
	void operator()(const P& point)
	{ Log::debug() << point << "\n"; } 
};


struct SortHelper
{
	SortHelper() {}
	~SortHelper() {}
	MAGICS_NO_EXPORT bool operator()(const Symbol* first, const Symbol* second)
	{
 		return first->size() > second->size();
	}
};


template <class P>
void SymbolPlotting<P>::operator()(Data<P>& data, BasicGraphicsObjectContainer& out)
{
	mode_->prepare();
    symbols_.clear();
    try {
    	const Transformation& transformation = out.transformation();
    	PointsHandler<P>& points = data.points(transformation);
    	
    	
    	
    	//Print<P> print;
    	//points.for_each(print);
    	// Some Mode need to know the min and max of the data, in order to adjust the 
    	// computation of the levels.
    	
    	
    	Log::dev() << "Number of points-->" << points.size() << endl;
 		(*mode_).adjust(points.min(), points.max());
 		Log::dev() << "Number of points-->" << points.size() << endl;
    
    	points.setToFirst();
	    // No batch yet! 
	    //BatchPointsHandler<P> batch(*data_, 10000);        
	    //batch.for_each(*this);
	    
    	
    	
    		while (points.more()) {
    			vector<PaperPoint> pp;
    			
    			transformation(points.current(), pp);   			
    			for(vector<PaperPoint>::iterator p = pp.begin(); p != pp.end(); ++p) 
    				(*this)(*p, out);
    			points.advance();
    		}  
	    //points.for_each(*this);
	    // WE try to sorth them : send the longest one first! 
	    vector<Symbol* > work;
	    for (typename map<SymbolProperties, Symbol* >::iterator symbol = symbols_.begin(); symbol != symbols_.end(); ++symbol) 
			work.push_back(symbol->second);
	    
	    std::sort(work.begin(), work.end(), SortHelper());
	   
	    // Now we feed the task...     
	    for (typename vector<Symbol* >::iterator symbol = work.begin(); symbol != work.end(); ++symbol) {
	     	if ( !(*symbol)->empty() ) out.push_back(*symbol);
	    }
	    
	     for (typename vector<Text* >::iterator text = texts_.begin(); text != texts_.end(); ++text) {
	     	out.push_back(*text);
	    }
    }
    catch ( MagicsException& )
    {
    	// do nothing!  
    }
}

template <class P>
void SymbolPlotting<P>::visit(LegendVisitor& legend)
{
	Log::debug() <<  " SymbolPlotting<P>::visit to create a legend ... " << "\n";
	if ( !legend_ ) return;
	(*mode_).visit(legend);
}

template <class P>
void SymbolPlotting<P>::visit(Data<P>& data, HistoVisitor& histo)
{
	Log::debug() <<  " SymbolPlotting<P>::visit to create a histogram! ... " << "\n";
	mode_->visit(data, histo);
}
