/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file SymbolIndividualModeAttributes.h
    \brief Definition of SymbolIndividualMode Attributes class.
    \author Graphics Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Thu Jun 16 12:02:56 2011
*/
   

#ifndef SymbolIndividualModeAttributes_H
#define SymbolIndividualModeAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"


#include "Colour.h"

namespace magics {

class XmlNode;



class SymbolIndividualModeAttributes 
{
public:
//  --  constructor
    SymbolIndividualModeAttributes();
    
//  --  destructor
    virtual ~SymbolIndividualModeAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const SymbolIndividualModeAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

    void setXmlData(const string&)  {}
/*!
    Magics Information:
    \brief  Colour of symbols. Applies to INDIVIDUAL mode only  
    \param colour Setting symbol_colour - default=BLUE
*/
	void setColour(Colour* colour) 
		{ auto_ptr<Colour> tmp(colour); colour_ = tmp; } 
	const Colour&  getColour() const 
		{ return *colour_; }
/*!
    Magics Information:
    \brief  Height of symbols. Applies to INDIVIDUAL mode only 
    \param height Setting symbol_height - default=0.2
*/
	void setHeight(double height) 
		{ height_ =  height; } 
	double getHeight() const 
		{ return height_; } 
        
/*!
    Magics Information:
    \brief  Marker indice. Applies to INDIVIDUAL mode only 
    \param marker Setting symbol_marker - default=1
*/
	void setMarker(int marker) 
		{ marker_ =  marker; } 
	int getMarker() const 
		{ return marker_; } 
        
/*!
    Magics Information:
    \brief  Marker indices. Applies to INDIVIDUAL mode only 
    \param marker_list Setting symbol_input_marker_list - default=intarray()
*/
	void setMarker_list(intarray marker_list) 
		{ marker_list_ =  marker_list; } 
	intarray getMarker_list() const 
		{ return marker_list_; } 
        
/*!
    Magics Information:
    \brief  Symbol name. Applies to INDIVIDUAL mode only 
    \param symbol Setting symbol_name - default=
*/
	void setSymbol(string symbol) 
		{ symbol_ =  symbol; } 
	string getSymbol() const 
		{ return symbol_; } 
        
/*!
    Magics Information:
    \brief  Symbol name. Applies to INDIVIDUAL mode only 
    \param text Setting symbol_texts - default=stringarray()
*/
	void setText(stringarray text) 
		{ text_ =  text; } 
	stringarray getText() const 
		{ return text_; } 
        
/*!
    Magics Information:
    \brief  Symbol name. Applies to INDIVIDUAL mode only 
    \param text_position Setting symbol_text_position - default=right
*/
	void setText_position(string text_position) 
		{ text_position_ =  text_position; } 
	string getText_position() const 
		{ return text_position_; } 
        
/*!
    Magics Information:
    \brief  Symbol name. Applies to INDIVIDUAL mode only 
    \param text_font_name Setting symbol_text_font_name - default=sansserif
*/
	void setText_font_name(string text_font_name) 
		{ text_font_name_ =  text_font_name; } 
	string getText_font_name() const 
		{ return text_font_name_; } 
        
/*!
    Magics Information:
    \brief  Symbol name. Applies to INDIVIDUAL mode only 
    \param text_font_size Setting symbol_text_font_size - default=0.25
*/
	void setText_font_size(double text_font_size) 
		{ text_font_size_ =  text_font_size; } 
	double getText_font_size() const 
		{ return text_font_size_; } 
        
/*!
    Magics Information:
    \brief  Symbol name. Applies to INDIVIDUAL mode only 
    \param text_font_style Setting symbol_text_font_style - default=normal
*/
	void setText_font_style(string text_font_style) 
		{ text_font_style_ =  text_font_style; } 
	string getText_font_style() const 
		{ return text_font_style_; } 
        
/*!
    Magics Information:
    \brief  Symbol name. Applies to INDIVIDUAL mode only 
    \param text_font_colour Setting symbol_text_font_colour - default=automatic
*/
	void setText_font_colour(Colour* text_font_colour) 
		{ auto_ptr<Colour> tmp(text_font_colour); text_font_colour_ = tmp; } 
	const Colour&  getText_font_colour() const 
		{ return *text_font_colour_; }
	virtual void toxml(ostream& out, int tabs = 0) const { toxml(out, tag_, tabs); }

protected:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream&, const string&, int tabs) const;

	//  --  members:
	string tag_;
	auto_ptr<Colour> colour_;
	double height_;
	int marker_;
	intarray marker_list_;
	string symbol_;
	stringarray text_;
	string text_position_;
	string text_font_name_;
	double text_font_size_;
	string text_font_style_;
	auto_ptr<Colour> text_font_colour_;

private:
  
	friend ostream& operator<<(ostream& s,const SymbolIndividualModeAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
