/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file Histogram.cc
    \brief Implementation of the Template class Histogram.
    
    Magics Team - ECMWF 2004
    
    Started: Tue 18-May-2004
    
    Changes:
    
*/



#include "Histogram.h"
#include "Layout.h"
#include "PointsHandler.h"
#include "IntervalMap.h"
#include "Transformation.h"

using namespace magics;


template <class P>
Histogram<P>::Histogram() 
{
}

template <class P>
Histogram<P>::~Histogram() 
{
}

/*!
 Class information are given to the output-stream.
*/		
template <class P>
void Histogram<P>::print(ostream& out)  const
{
	out << "Histogram[";
    HistogramAttributes::print(out);
	out << "]";
}
template <class P> 
void Histogram<P>::prepare(Data<P>& data)
{
	if ( !counter_.empty() ) return;
	PointsHandler<P>& points = data.points(); 
		levels_->set(*this);
		
		levels_->calculate(points.min(), points.max(), false);
	
		LevelSelection::const_iterator min = levels_->begin();
		LevelSelection::const_iterator max = levels_->begin();
		++max;
		while ( max != levels_->end()) {
		
			counter_.insert(make_pair(Interval(*min, *max), 0));
			min++;
			max++;
			
		}
		
		points.setToFirst();
			 
		    	
		    	
		    		while (points.more()) {
		    			try {
		    			IntervalMap<int>::iterator count = counter_.get(points.current().value());
		    			
		    			count->second++;
		    			}
		    			catch (...)
		    			{
		    				Log::debug() <<  points.current().value() << " is not in range..." << endl;
		    			}
		    			//Log::dev()<< points.current().value();
		    			points.advance();
		    		}  
		  
}
template <class P> 
void Histogram<P>::visit(Transformation& transformation, Data<P>& data)
{
	Log::dev() << "Histogram::visit(Transformation&) :: can we do it now???" << endl; 
	prepare(data);
	 vector<int> y; 		
			   vector<double> x;
			   for ( IntervalMap<int>::const_iterator count = counter_.begin(); count != counter_.end(); ++count) {
				   y.push_back(count->second );
				   x.push_back(count->first.min_ )	;
				   x.push_back(count->first.max_ )	;
				   Log::dev() << "[" << count->first.min_ << "-" <<  count->first.max_ << "]-->" <<  count->second << endl;   
			   }
			   
			   Log::dev()<< "minx=" << *std::min_element(x.begin(), x.end()) << endl;
			   Log::dev()<<  "maxx=" << *std::max_element(x.begin(), x.end()) << endl;
			   
			   transformation.setMinX(*std::min_element(x.begin(), x.end()));
			   transformation.setMaxX(*std::max_element(x.begin(), x.end()));
			   transformation.setMinY(0);
			   Log::dev()<<  "maxy=" << *std::max_element(y.begin(), y.end()) << endl;
			   transformation.setMaxY(*std::max_element(y.begin(), y.end())*1.05);
			   
}
template <class P>
void Histogram<P>::operator()(Data<P>& data, BasicGraphicsObjectContainer& parent)
{
	Log::dev() << "YOUPI ---> we just need to implement the method !!" << endl; 
	Log::dev() << *this << endl;
	prepare(data);
	
	for ( IntervalMap<int>::const_iterator count = counter_.begin(); count != counter_.end(); ++count) {
		Polyline* bar = new Polyline();
		bar->setColour(Colour("black"));
		bar->setThickness(1);
		bar->setLineStyle(M_SOLID);
		
		bar->setFilled(true);
	    bar->setFillColour(*colour_);
				   		
			FillShadingProperties* shading = new FillShadingProperties();
				          
				   bar->setShading(shading);
		bar->push_back(PaperPoint(count->first.min_, 0));
		bar->push_back(PaperPoint(count->first.min_, count->second));
		bar->push_back(PaperPoint(count->first.max_, count->second));
		bar->push_back(PaperPoint(count->first.max_, 0));
		bar->push_back(PaperPoint(count->first.min_, 0));
	
		parent.push_back(bar);

	  }
   
}
template <class P>
void Histogram<P>::visit(LegendVisitor& legend)
{
	
}
