/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file AxisTickLabel.h
    \brief Definition of the Template class AxisTickLabel.
    
    Magics Team - ECMWF 2005
    
    Started: Fri 7-Oct-2005
    
    Changes:
    
*/

#ifndef AxisTickLabel_H
#define AxisTickLabel_H

#include "magics.h"
#include "Translator.h"
#include "Factory.h"



#include "AxisTickLabelAttributes.h"
#include "AxisItem.h"



namespace magics {

class HorizontalAxisVisitor;
class VerticalAxisVisitor;
class Transformation;

class AxisTickLabel: public AxisTickLabelAttributes {

public:
	AxisTickLabel();
	virtual ~AxisTickLabel();
    
    virtual void set(const XmlNode& node) {
        AxisTickLabelAttributes::set(node);
    }
    virtual void set(const map<string, string>& map) {
        AxisTickLabelAttributes::set(map);
    }
    virtual AxisTickLabel* clone() const {
        AxisTickLabel* label =  new AxisTickLabel();
        label->copy(*this);
        return label;
    }
    
    virtual void horizontal(const AxisItems&,const Colour&, HorizontalAxisVisitor&);
    virtual void vertical(const AxisItems&,const Colour&, VerticalAxisVisitor&);

protected:
     //! Method to print string about this class on to a stream of type ostream (virtual).
	 virtual void print(ostream&) const; 

private:
    //! Copy constructor - No copy allowed
	AxisTickLabel(const AxisTickLabel&);
    //! Overloaded << operator to copy - No copy allowed
	AxisTickLabel& operator=(const AxisTickLabel&);

// -- Friends
    //! Overloaded << operator to call print().
	friend ostream& operator<<(ostream& s,const AxisTickLabel& p)
		{ p.print(s); return s; }

};


class NoAxisTickLabel :public AxisTickLabel
{
public:
	NoAxisTickLabel() {}
	~NoAxisTickLabel() {}
protected:
 virtual void horizontal(const AxisItems&,const Colour&, HorizontalAxisVisitor&) {}
    virtual void vertical(const AxisItems&,const Colour&, VerticalAxisVisitor&) {}
    AxisTickLabel* clone() const { return new NoAxisTickLabel(); }
};

template <>
class Translator<string, AxisTickLabel> { 
public:
	AxisTickLabel* operator()(const string& val )
	{
		return SimpleObjectMaker<AxisTickLabel>::create(val);
	}     

	AxisTickLabel* magics(const string& param)
	{
		AxisTickLabel* object;
		ParameterManager::update(param, object);
		return object;
	}
};


} // namespace magics
#endif
