/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file GribLoopAttributes.h
    \brief Definition of GribLoop Attributes class.
    \author Graphics Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Thu Jun 16 12:02:55 2011
*/
   

#ifndef GribLoopAttributes_H
#define GribLoopAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"


#include "GribAddressMode.h"
#include "GribLoopStep.h"

namespace magics {

class XmlNode;



class GribLoopAttributes 
{
public:
//  --  constructor
    GribLoopAttributes();
    
//  --  destructor
    virtual ~GribLoopAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const GribLoopAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

    void setXmlData(const string&)  {}
/*!
    Magics Information:
    \brief  Normally GRIB fields are stored as records on a file. If the BYTE offset method is being used, the parameter GRIB_FILE_ADDRESS_MODE should be set to 'BYTE_OFFSET'.(RECORD_NUMBER/BYTE_OFFSET) 
    \param address_mode Setting grib_file_address_mode - default=record
*/
	void setAddress_mode(GribAddressMode* address_mode) 
		{ auto_ptr<GribAddressMode> tmp(address_mode); address_mode_ = tmp; } 
	const GribAddressMode&  getAddress_mode() const 
		{ return *address_mode_; }
/*!
    Magics Information:
    \brief  Metview:dimension of the input : 1 for field, 2 for wind 
    \param dimension Setting grib_dimension - default=1
*/
	void setDimension(int dimension) 
		{ dimension_ =  dimension; } 
	int getDimension() const 
		{ return dimension_; } 
        
/*!
    Magics Information:
    \brief  Metview:position of the fields for x component in the fieldset 
    \param dim_1 Setting grib_position_1 - default=intarray()
*/
	void setDim_1(intarray dim_1) 
		{ dim_1_ =  dim_1; } 
	intarray getDim_1() const 
		{ return dim_1_; } 
        
/*!
    Magics Information:
    \brief   Metview:position of the fields for y component in the fieldset 
    \param dim_2 Setting grib_position_2 - default=intarray()
*/
	void setDim_2(intarray dim_2) 
		{ dim_2_ =  dim_2; } 
	intarray getDim_2() const 
		{ return dim_2_; } 
        
/*!
    Magics Information:
    \brief  Metview:position of the fields to plot in the fieldset 
    \param dim Setting grib_position - default=intarray()
*/
	void setDim(intarray dim) 
		{ dim_ =  dim; } 
	intarray getDim() const 
		{ return dim_; } 
        
/*!
    Magics Information:
    \brief  Path of the grib to animate 
    \param path Setting grib_loop_path - default=
*/
	void setPath(string path) 
		{ path_ =  path; } 
	string getPath() const 
		{ return path_; } 
        
/*!
    Magics Information:
    \brief  Method to create the steps names for each plot of the animation
    \param step Setting grib_loop_step - default=loopondate
*/
	void setStep(GribLoopStep* step) 
		{ auto_ptr<GribLoopStep> tmp(step); step_ = tmp; } 
	const GribLoopStep&  getStep() const 
		{ return *step_; }
/*!
    Magics Information:
    \brief  Scaling of the decoded field (ON/OFF) 
    \param scaling Setting grib_automatic_scaling - default=on
*/
	void setScaling(bool scaling) 
		{ scaling_ =  scaling; } 
	bool getScaling() const 
		{ return scaling_; } 
        
/*!
    Magics Information:
    \brief  Apply a scaling factor to the field. 
    \param scaling_factor Setting grib_scaling_factor - default=1
*/
	void setScaling_factor(double scaling_factor) 
		{ scaling_factor_ =  scaling_factor; } 
	double getScaling_factor() const 
		{ return scaling_factor_; } 
        
/*!
    Magics Information:
    \brief  Apply a scaling offset to the field. 
    \param scaling_offset Setting grib_scaling_offset - default=0
*/
	void setScaling_offset(double scaling_offset) 
		{ scaling_offset_ =  scaling_offset; } 
	double getScaling_offset() const 
		{ return scaling_offset_; } 
        
	virtual void toxml(ostream& out, int tabs = 0) const { toxml(out, tag_, tabs); }

protected:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream&, const string&, int tabs) const;

	//  --  members:
	string tag_;
	auto_ptr<GribAddressMode> address_mode_;
	int dimension_;
	intarray dim_1_;
	intarray dim_2_;
	intarray dim_;
	string path_;
	auto_ptr<GribLoopStep> step_;
	bool scaling_;
	double scaling_factor_;
	double scaling_offset_;

private:
  
	friend ostream& operator<<(ostream& s,const GribLoopAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
