/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file EfiGraphAttributes.cc
    \brief Implemtation of EfiGraph Attributes class.
    \author Graphics Section, ECMWF

    This file is automatically generated.
    Do Not Edit!
   
    Generated: Wed May  5 10:05:13 2010
*/    

#include "EfiGraphAttributes.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "Translator.h"
#include "XmlNode.h"
#include "ParameterSettings.h"


using namespace magics;


EfiGraphAttributes::EfiGraphAttributes():
	colour_(Translator<stringarray, stringarray>().magics("efi_lines_colour_array")),
	style_(Translator<stringarray, stringarray>().magics("efi_lines_style_array")),
	thickness_(Translator<intarray, intarray>().magics("efi_lines_thickness_array")),
	clim_colour_(Translator<string, Colour>().magics("efi_clim_line_colour")),
	clim_thickness_(ParameterManager::getInt("efi_clim_line_thickness")),
	clim_style_(Translator<string, LineStyle>().magics("efi_clim_line_style"))
{
} 



EfiGraphAttributes::~EfiGraphAttributes()
{
}

    
void EfiGraphAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(1);
	prefix[0] = "efi";

	setAttribute(prefix, "efi_lines_colour_array", colour_, params);
	setAttribute(prefix, "efi_lines_style_array", style_, params);
	setAttribute(prefix, "efi_lines_thickness_array", thickness_, params);
	setAttribute(prefix, "efi_clim_line_colour", clim_colour_, params);
	setAttribute(prefix, "efi_clim_line_thickness", clim_thickness_, params);
	setAttribute(prefix, "efi_clim_line_style", clim_style_, params);
}

void EfiGraphAttributes::copy(const EfiGraphAttributes& other)
{
	colour_ = other.colour_;
	style_ = other.style_;
	thickness_ = other.thickness_;
	setClim_colour(other.clim_colour_->clone());
	clim_thickness_ = other.clim_thickness_;
	clim_style_ = other.clim_style_;
} 


bool EfiGraphAttributes::accept(const string& node)
{	
	if ( magCompare(node, "efigraph")  )
		return true;
	return false;
}

void EfiGraphAttributes::set(const XmlNode& node)
{
	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "efigraph") )
		set(node.attributes());
	else {
	}
	for (XmlNode::ElementIterator elt = node.firstElement(); elt != node.lastElement(); ++elt) {
	}
}

void EfiGraphAttributes::print(ostream& out)  const
{
	out << "EfiGraphAttributes[";
	out << "colour = " << colour_;
	out << ", style = " << style_;
	out << ", thickness = " << thickness_;
	out << ", clim_colour = " << *clim_colour_;
	out << ", clim_thickness = " << clim_thickness_;
	out << ", clim_style = " << clim_style_;
	out << "]" << "\n";
}


void EfiGraphAttributes::toxml(ostream& out, const string& tag, int tabs)  const
{
	string tab;
	for ( int t = 0; t < tabs; t++) tab = tab + "	";
	
	out << tab << "<" << tag << "\n";
	out << tab << "\tefi_lines_colour_array = \'" << colour_ << "\'\n";
	out << tab << "\tefi_lines_style_array = \'" << style_ << "\'\n";
	out << tab << "\tefi_lines_thickness_array = \'" << thickness_ << "\'\n";
	out << tab << "\tefi_clim_line_colour = \'" << *clim_colour_ << "\'\n";
	out << tab << "\tefi_clim_line_thickness = \'" << clim_thickness_ << "\'\n";
	out << tab << "\tefi_clim_line_style = \'" << clim_style_ << "\'\n";
	out << tab << ">";


	out << tab << "</" << tag << ">\n";
}

static MagicsParameter<stringarray> efi_lines_colour_array("efi_lines_colour_array", stringarray(), "");
static MagicsParameter<stringarray> efi_lines_style_array("efi_lines_style_array", stringarray(), "");
static MagicsParameter<intarray> efi_lines_thickness_array("efi_lines_thickness_array", intarray(), "");
static MagicsParameter<string> efi_clim_line_colour("efi_clim_line_colour", "black", "");
static MagicsParameter<int> efi_clim_line_thickness("efi_clim_line_thickness", 4, "");
static MagicsParameter<string> efi_clim_line_style("efi_clim_line_style", "solid", "");
