/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file DateAxisMethodAttributes.cc
    \brief Implemtation of DateAxisMethod Attributes class.
    \author Graphics Section, ECMWF

    This file is automatically generated.
    Do Not Edit!
   
    Generated: Wed May  5 10:05:15 2010
*/    

#include "DateAxisMethodAttributes.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "Translator.h"
#include "XmlNode.h"
#include "ParameterSettings.h"


using namespace magics;


DateAxisMethodAttributes::DateAxisMethodAttributes():
	interval_(ParameterManager::getDouble("axis_tick_interval"))
{
} 



DateAxisMethodAttributes::~DateAxisMethodAttributes()
{
}

    
void DateAxisMethodAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(1);
	prefix[0] = "axis";

	setAttribute(prefix, "axis_tick_interval", interval_, params);
}

void DateAxisMethodAttributes::copy(const DateAxisMethodAttributes& other)
{
	interval_ = other.interval_;
} 


bool DateAxisMethodAttributes::accept(const string& node)
{	
	if ( magCompare(node, "date")  )
		return true;
	return false;
}

void DateAxisMethodAttributes::set(const XmlNode& node)
{
	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "date") )
		set(node.attributes());
	else {
	}
	for (XmlNode::ElementIterator elt = node.firstElement(); elt != node.lastElement(); ++elt) {
	}
}

void DateAxisMethodAttributes::print(ostream& out)  const
{
	out << "DateAxisMethodAttributes[";
	out << "interval = " << interval_;
	out << "]" << "\n";
}


void DateAxisMethodAttributes::toxml(ostream& out, const string& tag, int tabs)  const
{
	string tab;
	for ( int t = 0; t < tabs; t++) tab = tab + "	";
	
	out << tab << "<" << tag << "\n";
	out << tab << "\taxis_tick_interval = \'" << interval_ << "\'\n";
	out << tab << ">";


	out << tab << "</" << tag << ">\n";
}

static MagicsParameter<double> axis_tick_interval("axis_tick_interval", INT_MAX, " New Magics: Parameter axis_tick_interval sent to new Magics[XYSystem].  ");
