/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file AxisTickLabelAttributes.cc
    \brief Implemtation of AxisTickLabel Attributes class.
    \author Graphics Section, ECMWF

    This file is automatically generated.
    Do Not Edit!
   
    Generated: Wed May  5 10:05:15 2010
*/    

#include "AxisTickLabelAttributes.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "Translator.h"
#include "XmlNode.h"
#include "ParameterSettings.h"


using namespace magics;


AxisTickLabelAttributes::AxisTickLabelAttributes():
	colour_(Translator<string, Colour>().magics("axis_tick_label_colour")),
	first_(Translator<string, bool>().magics("axis_tick_label_first")),
	frequency_(ParameterManager::getInt("axis_tick_label_frequency")),
	height_(ParameterManager::getDouble("axis_tick_label_height")),
	last_(Translator<string, bool>().magics("axis_tick_label_last")),
	orientation_(ParameterManager::getString("axis_tick_label_orientation")),
	position_(ParameterManager::getString("axis_tick_label_position")),
	quality_(ParameterManager::getString("axis_tick_label_quality")),
	type_(Translator<string, AxisTickLabelType>().magics("axis_tick_label_type"))
{
} 



AxisTickLabelAttributes::~AxisTickLabelAttributes()
{
}

    
void AxisTickLabelAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(2);
	prefix[0] = "axis_tick_label";
	prefix[1] = "axis";

	setAttribute(prefix, "axis_tick_label_colour", colour_, params);
	setAttribute(prefix, "axis_tick_label_first", first_, params);
	setAttribute(prefix, "axis_tick_label_frequency", frequency_, params);
	setAttribute(prefix, "axis_tick_label_height", height_, params);
	setAttribute(prefix, "axis_tick_label_last", last_, params);
	setAttribute(prefix, "axis_tick_label_orientation", orientation_, params);
	setAttribute(prefix, "axis_tick_label_position", position_, params);
	setAttribute(prefix, "axis_tick_label_quality", quality_, params);
	setMember(prefix, "axis_tick_label_type", type_, params);
}

void AxisTickLabelAttributes::copy(const AxisTickLabelAttributes& other)
{
	setColour(other.colour_->clone());
	first_ = other.first_;
	frequency_ = other.frequency_;
	height_ = other.height_;
	last_ = other.last_;
	orientation_ = other.orientation_;
	position_ = other.position_;
	quality_ = other.quality_;
	setType(other.type_->clone());
} 


bool AxisTickLabelAttributes::accept(const string& node)
{	
	if ( magCompare(node, "label")  )
		return true;

	if ( acceptNode(node, type_) )
		return true;
	return false;
}

void AxisTickLabelAttributes::set(const XmlNode& node)
{
	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "label") )
		set(node.attributes());
	else {
		setMember(node.name(), type_, node);
	}
	for (XmlNode::ElementIterator elt = node.firstElement(); elt != node.lastElement(); ++elt) {
		setMember((*elt)->name(), type_, *(*elt)); 
	}
}

void AxisTickLabelAttributes::print(ostream& out)  const
{
	out << "AxisTickLabelAttributes[";
	out << "colour = " << *colour_;
	out << ", first = " << first_;
	out << ", frequency = " << frequency_;
	out << ", height = " << height_;
	out << ", last = " << last_;
	out << ", orientation = " << orientation_;
	out << ", position = " << position_;
	out << ", quality = " << quality_;
	out << ", type = " << *type_;
	out << "]" << "\n";
}


void AxisTickLabelAttributes::toxml(ostream& out, const string& tag, int tabs)  const
{
	string tab;
	for ( int t = 0; t < tabs; t++) tab = tab + "	";
	
	out << tab << "<" << tag << "\n";
	out << tab << "\taxis_tick_label_colour = \'" << *colour_ << "\'\n";
	out << tab << "\taxis_tick_label_first = \'" << first_ << "\'\n";
	out << tab << "\taxis_tick_label_frequency = \'" << frequency_ << "\'\n";
	out << tab << "\taxis_tick_label_height = \'" << height_ << "\'\n";
	out << tab << "\taxis_tick_label_last = \'" << last_ << "\'\n";
	out << tab << "\taxis_tick_label_orientation = \'" << orientation_ << "\'\n";
	out << tab << "\taxis_tick_label_position = \'" << position_ << "\'\n";
	out << tab << "\taxis_tick_label_quality = \'" << quality_ << "\'\n";
	out << tab << ">";

 	type_->toxml(out, tabs+1);

	out << tab << "</" << tag << ">\n";
}

static MagicsParameter<string> axis_tick_label_colour("axis_tick_label_colour", "automatic", " New Magics: Parameter axis_tick_label_colour sent to new Magics[XYSystem].  ");
static MagicsParameter<string> axis_tick_label_first("axis_tick_label_first", "on", " New Magics: Parameter axis_tick_label_first sent to new Magics[XYSystem].  ");
static MagicsParameter<int> axis_tick_label_frequency("axis_tick_label_frequency", 1, " New Magics: Parameter axis_tick_label_frequency sent to new Magics[XYSystem].  ");
static MagicsParameter<double> axis_tick_label_height("axis_tick_label_height", 0.3, " New Magics: Parameter axis_tick_label_height sent to new Magics[XYSystem].  ");
static MagicsParameter<string> axis_tick_label_last("axis_tick_label_last", "on", " New Magics: Parameter axis_tick_label_last sent to new Magics[XYSystem].  ");
static MagicsParameter<string> axis_tick_label_orientation("axis_tick_label_orientation", "horizontal", " New Magics: Parameter axis_tick_label_orientation sent to new Magics[XYSystem].  ");
static MagicsParameter<string> axis_tick_label_position("axis_tick_label_position", "on_tick", " New Magics: Parameter axis_tick_label_position sent to new Magics[XYSystem].  ");
static MagicsParameter<string> axis_tick_label_quality("axis_tick_label_quality", "sansserif", " New Magics: Parameter axis_tick_label_quality sent to new Magics[XYSystem].  ");
static MagicsParameter<string> axis_tick_label_type("axis_tick_label_type", "number", "");
#include "AxisTickLabelType.h"
static SimpleObjectMaker<NumberLabelType, AxisTickLabelType> number_NumberLabelType("number");
static SimpleObjectMaker<LabelListLabelType, AxisTickLabelType> label_list_LabelListLabelType("label_list");
static SimpleObjectMaker<LabelListLabelType, AxisTickLabelType> list_LabelListLabelType("list");
