/******************************** LICENSE ********************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 ******************************** LICENSE ********************************/

/*!
    \file QtDriver.h
    \brief Definition of QtDriver.
    \author Graphics Section, ECMWF

    Started: Mon Jan  4 20:28:15 2010
*/

#ifndef _MPP_QtDriver_H
#define _MPP_QtDriver_H

#include <BaseDriver.h>
#include <QtDriverAttributes.h>
#include <XmlNode.h>

//#include <Qt/qqwidget.h>

//class QGraphicsScene;
class MgQBaseNode;
class MgQLayerNode;
class MgQLayoutNode;
class MgQStepNode;
class MgQSymbolItem;
class MgQSymbolManager;
class QGraphicsItem;
class MgQAnimationStep;
class MgQMagnifierLayoutNode;
class MgQPlotScene;

namespace magics
{

/*! \class QtDriver
    \brief This driver produces output for Qt
    \ingroup drivers

    This driver ...
*/
class QtDriver: public BaseDriver, public QtDriverAttributes
{
friend class MgQAnimationStep;
friend class MgQPlotScene;

public:
	QtDriver();
	~QtDriver();
	void open();
	void close();

	/*!
	  \brief sets a new XML node
	*/
	void set(const XmlNode& node)
	{
		if ( magCompare(node.name(), "binary") )
		{
			XmlNode basic = node;
			basic.name("driver");
			BaseDriver::set(basic);
			basic.name("qt");
			QtDriverAttributes::set(basic);
		}
	}

	/*!
	  \brief sets a new map
	*/
	void set(const map<std::string, std::string>& map)
	{
		BaseDriver::set(map);
		QtDriverAttributes::set(map);
	}
	void executeStep(const MgQAnimationStep&,MgQStepNode*) const;
	MAGICS_NO_EXPORT void redisplayMagnifier(MgQMagnifierLayoutNode*) const;

private:

	MAGICS_NO_EXPORT void startPage() const;
	MAGICS_NO_EXPORT void endPage() const;
	MAGICS_NO_EXPORT void project(const Layout&) const;
	MAGICS_NO_EXPORT void project(const PreviewLayout&) const;
	MAGICS_NO_EXPORT void project(const MagnifierLayout&) const;
	MAGICS_NO_EXPORT void unproject() const;
	MAGICS_NO_EXPORT void newLayer(const Layer&) const;
	MAGICS_NO_EXPORT void closeLayer(const Layer&) const;

	MAGICS_NO_EXPORT void setNewLineWidth(const float) const;
	MAGICS_NO_EXPORT void setNewColour(const Colour &col) const;
	MAGICS_NO_EXPORT int setLineParameters(const LineStyle style, const float w) const;

	MAGICS_NO_EXPORT void renderPolyline(const int, float *, float *) const;
	MAGICS_NO_EXPORT void renderPolyline2(const int n, float *x, float *y) const;
	MAGICS_NO_EXPORT void renderSimplePolygon(const int, float *, float *) const;
	MAGICS_NO_EXPORT void renderText(const Text& text) const;
	MAGICS_NO_EXPORT void circle(const float x, const float y, const float r, const int) const;
	MAGICS_NO_EXPORT bool renderPixmap(float,float,float,float,int,int,unsigned char*,int,bool) const;
	MAGICS_NO_EXPORT bool renderCellArray(const Image& obj) const;
	MAGICS_NO_EXPORT void renderSymbols(const Symbol&) const;

	//! Methods to redisplay an object (virtual).
	MAGICS_NO_EXPORT void redisplay(const Layer&) const;
	MAGICS_NO_EXPORT void redisplay(const PreviewLayout&) const;
	MAGICS_NO_EXPORT void redisplay(const MagnifierLayout&) const;
	MAGICS_NO_EXPORT void redisplay(const StepRenderer&) const;

	// QtDriver specific member functions BEGIN
	MAGICS_NO_EXPORT void project(MgQLayoutNode*) const;
	MAGICS_NO_EXPORT void renderTree(int,bool);
	MAGICS_NO_EXPORT void generateSymbolPath(MgQSymbolItem *,svgSymbol) const;
	MAGICS_NO_EXPORT void textToUnicode(const string&,QString &) const;
	//void executeStep(const MgQAnimationStep&,MgQStepNode*) const;
	//mutable QGraphicsScene* scene_;
	// QtDriver specific member functions END

	//! Method to print string about this class on to a stream of type ostream (virtual).
	void print(ostream&) const;
	MAGICS_NO_EXPORT void debugOutput(const string &s) const;

	//! Copy constructor - No copy allowed
	QtDriver(const QtDriver&);
	//! Overloaded << operator to copy - No copy allowed
	QtDriver& operator=(const QtDriver&);

	// -- Friends
	//! Overloaded << operator to call print().
	friend ostream& operator<<(ostream& s,const QtDriver& p)
		{ p.print(s); return s; }

	mutable int stepToRender_;
	mutable std::stack<MgQLayoutNode*>  layoutNodeStack_;
	mutable std::stack<MgQLayerNode*>   layerNodeStack_;
	mutable MgQBaseNode* currentNode_;
	mutable MgQLayoutNode* animationNode_;
	mutable bool initialized_;
	mutable bool magnifierIsBeingRedisplayed_;
	mutable float magnifierZoomFactor_;
	mutable MgQSymbolManager* symbolManager_;
	
	float lineWidthFactor_;
};

} // namespace magics
#endif
