/*! \file SceneVisitor.h
    \brief Definition of the Template class SceneVisitor.
    
    Magics Team - ECMWF 2008
    
    Started: Mon 29-Dec-2008
    
    Changes:
    
*/

#ifndef SceneVisitor_H
#define SceneVisitor_H

#include "magics.h"
#include "BasicGraphicsObject.h"
#include "BasicSceneObject.h"

namespace magics {
class Layout;

class SceneVisitor  {

public:
	SceneVisitor();
	virtual ~SceneVisitor();
	bool reproject(BasicGraphicsObjectContainer&) const;
	virtual void visit(BasicSceneObject& object) = 0;
	virtual void visit(BasicGraphicsObjectContainer&) {}
protected:
     //! Method to print string about this class on to a stream of type ostream (virtual).
	 virtual void print(ostream&) const; 

private:
    //! Copy constructor - No copy allowed
	SceneVisitor(const SceneVisitor&);
    //! Overloaded << operator to copy - No copy allowed
	SceneVisitor& operator=(const SceneVisitor&);

// -- Friends
    //! Overloaded << operator to call print().
	friend ostream& operator<<(ostream& s,const SceneVisitor& p)
		{ p.print(s); return s; }

};

class LayoutVisitor: public SceneVisitor, public Layout
{
public:
	LayoutVisitor()  {}
	~LayoutVisitor() {}
	void redisplay(const BaseDriver& driver) const;

protected:
	 void print(ostream&) const; 
	 	 
	 
};


class DrawingVisitor: public LayoutVisitor
{
public:
	DrawingVisitor();
	~DrawingVisitor();
	void visit(BasicSceneObject& object) { object.visit(*this); }
	Layout* execute(AnimationStep&, const Layout* visitor);
	
	
protected:
	
};


class HorizontalAxisVisitor: public LayoutVisitor
{
public:
	HorizontalAxisVisitor(const DrawingVisitor&);
	~HorizontalAxisVisitor();
	virtual void tick(double&, double&);
	virtual void minortick(double&, double&);
		virtual double offsetTickLabel(double, int);
		virtual double angleTickLabel();	
		virtual double angleTitle();
		virtual double offsetTitle();
	virtual Justification justificationTickLabel() { return MCENTRE; }	
protected:
	
	 
};
class VerticalAxisVisitor: public LayoutVisitor
{
public:
	VerticalAxisVisitor(const DrawingVisitor&);
	~VerticalAxisVisitor();
	virtual double offsetLine() { return 10; }
	virtual void tick(double&, double&);
	virtual void minortick(double&, double&);
	virtual double offsetTickLabel(double, int);
	virtual double angleTickLabel();	
	virtual double angleTitle();
	virtual double offsetTitle();
	virtual Justification justificationTickLabel() { return MCENTRE; }	
		
protected:
	
	 
};
class LeftAxisVisitor: public VerticalAxisVisitor
{
public:
	LeftAxisVisitor(const DrawingVisitor&);
	~LeftAxisVisitor();
	void visit(BasicSceneObject& object) { object.visit(*this); }
	virtual Justification justificationTickLabel() { return MRIGHT; }	
	virtual void tick(double&, double&);
	virtual void minortick(double&, double&);
	virtual double offsetTickLabel(double, int);
	virtual double angleTickLabel();	
	virtual double angleTitle();
	virtual double offsetTitle();
protected:
	
	 
};

class RightAxisVisitor: public VerticalAxisVisitor
{
public:
	RightAxisVisitor(const DrawingVisitor&);
	~RightAxisVisitor();
	void visit(BasicSceneObject& object) { object.visit(*this); }
	virtual Justification justificationTickLabel() { return MLEFT; }	
	virtual void tick(double&, double&);
	virtual void minortick(double&, double&);
	virtual double offsetTickLabel(double, int);
	virtual double angleTickLabel();	
	virtual double angleTitle();
	virtual double offsetTitle();
protected:
	
	
};



class TopAxisVisitor: public HorizontalAxisVisitor
{
public:
	TopAxisVisitor(const DrawingVisitor&);
	~TopAxisVisitor();
	void visit(BasicSceneObject& object) { object.visit(*this); }
	virtual void tick(double&, double&);
	virtual void minortick(double&, double&);
	virtual double offsetTickLabel(double, int);
	virtual double angleTickLabel();	
	virtual double angleTitle();
	virtual double offsetTitle();
	
	
protected:
	
};

class BottomAxisVisitor: public HorizontalAxisVisitor
{
public:
	BottomAxisVisitor(const DrawingVisitor&);
	~BottomAxisVisitor();
	void visit(BasicSceneObject& object) { object.visit(*this); }
	virtual void tick(double&, double&);
	virtual void minortick(double&, double&);
	virtual double offsetTickLabel(double, int);
	virtual double angleTickLabel();	
	virtual double angleTitle();
	virtual double offsetTitle();
protected:
	
	
};

} // namespace magics
#endif
