"""
Sprites that are a part of the world (tubes, lava, etc)

Copyright 2006  Peter Gebauer. Licensed as Public Domain.
(see LICENSE for more info)
"""

import random

from magicor.sprites import *
from magicor.sprites.blocks import Ice
from magicor import Text

class Lava(AnimatedSprite):
    
    def __init__(self, x, y, blocksGroup, players, fireGroup,
                 worldGroup, dormant):
        AnimatedSprite.__init__(
            self, x, y, 32, 64,
            {"default": (ImageFrame("sprites/lava", 32, 64),
                         AnimationFrame(0, 8),
                         AnimationFrame(1, 8),
                         AnimationFrame(2, 8),
                         AnimationFrame(3, 8),
                         JumpFrame(1)),
            "dormant": (ImageFrame("sprites/lava", 32, 64),
                        AnimationFrame(4, 8),),
            "erupt": (ImageFrame("sprites/lava", 32, 64),
                      AnimationFrame(4, 4),
                      AnimationFrame(5, 4),
                      AnimationFrame(6, 4),
                      AnimationFrame(7, 4),
                      CallbackFrame(self.ignitePeers),
                      AnimationFrame(0, 8),
                      AnimationFrame(1, 8),
                      AnimationFrame(2, 8),
                      AnimationFrame(3, 8),
                      JumpFrame(5)),
             }
            )
        self.dormant = dormant
        if dormant:
            self.setAnimation("dormant")
        self.worldGroup = worldGroup
        self.blocksGroup = blocksGroup
        self.players = players
        self.fireGroup = fireGroup

    def erupt(self):
        self.dormant = False
        self.setAnimation("erupt")
        self.resources.playSound("samples/erupt")

    def ignitePeers(self):
        for lava in self.worldGroup.getSprites(self.x - 1,
                                               self.y,
                                               0,
                                               self.height,
                                               self,
                                               Lava):
            if lava.dormant:
                lava.erupt()
        for lava in self.worldGroup.getSprites(self.x + self.width,
                                               self.y,
                                               0,
                                               self.height,
                                               self,
                                               Lava):
            if lava.dormant:
                lava.erupt()

    def update(self):
        AnimatedSprite.update(self)
        if self.dormant:
            for fire in self.fireGroup.sprites():
                if fire.x == self.x and fire.y == self.y:
                    self.erupt()
        else:
            for block in self.blocksGroup.sprites():
                if (isinstance(block, Ice)
                    and block.x == self.x and block.y == self.y):
                    block.melt()
            for player in self.players.sprites():
                if (player.x == self.x
                    and player.y == self.y
                    and not player.dead):
                    player.die()
            

class Tube(PhysicsSprite):
    
    def __init__(self, x, y, level, direction, name, blocks,
                 worldGroup, players):
        PhysicsSprite.__init__(
            self, level, x, y, 32, 32,
            {"default": (ImageFrame("sprites/tube-endings", 32, 32),
                         AnimationFrame(0, 0)),
             "left": (ImageFrame("sprites/tube-endings", 32, 32),
                         AnimationFrame(0, 0)),
             "right": (ImageFrame("sprites/tube-endings", 32, 32),
                         AnimationFrame(3, 0)),
             "up": (ImageFrame("sprites/tube-endings", 32, 32),
                         AnimationFrame(1, 0)),
             "down": (ImageFrame("sprites/tube-endings", 32, 32),
                         AnimationFrame(2, 0))
             },
            blocks
            )
        self.name = name
        self.direction = direction
        self.worldGroup = worldGroup
        self.players = players
        self.text = Text(None, self.resources["fonts/info"], 800)
        self.coverSurface = None
        self.setAnimation(direction)

    def testFall(self):
        return False

    def bounce(self, player):
        if self.direction == "left":
            player.x = self.x - 4
            player.moving = -7
            player.direction = 1
            player.setAnimation("tube-right")
            self.tubed = True
        elif self.direction == "right":
            player.x = self.x + 4
            player.moving = 7
            player.direction = -1
            self.tubed = True
            player.setAnimation("tube-left")
        elif self.direction == "up":
            player.y = self.y -4
            player.x = self.x
            player.moving = 0
            player.vertical = -6
            self.tubed = True
        elif self.direction == "down":
            player.y = self.y + 4
            player.x = self.x
            player.moving = 0
            player.vertical = 7
            self.tubed = True

    def blocked(self):
        if (self.direction == "left" and self.blockedLeft()
            or self.direction == "right" and self.blockedRight()
            or self.direction == "up" and self.blockedAbove()
            or self.direction == "down" and self.blockedBelow()):
            return True
        return False
            
    def getMatching(self):
        if self.name:
            for tube in self.worldGroup:
                if (isinstance(tube, Tube)
                    and tube != self
                    and tube.name == self.name
                    and not tube.blocked()):
                    return tube
        else:
            tubes = []
            for tube in self.worldGroup:
                if isinstance(tube, Tube) and tube != self:
                    tubes.append(tube)
            if tubes:
                return tubes[random.randint(0, len(tubes) - 1)]
        return None

    def output(self, player):
        tube = self.getMatching()
        if tube:
            if tube.direction == "right":
                player.x = tube.x + 4
                player.moving = 7
                player.direction = 1
                player.setAnimation("tube-right")
                player.tubed = True
                player.y = tube.y
            elif tube.direction == "left":
                player.x = tube.x - 4
                player.moving = -7
                player.direction = -1
                player.setAnimation("tube-left")
                player.tubed = True
                player.y = tube.y
            elif tube.direction == "down":
                self.tubed = True
                player.x = tube.x
                player.y = tube.y
                player.vertical = 8
            elif tube.direction == "up":
                self.tubed = True
                player.x = tube.x
                player.y = tube.y
                player.vertical = -8

    def draw(self, surface):
        PhysicsSprite.draw(self, surface)
