/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.trax;

import com.jclark.xsl.sax2.XMLProcessorImpl;
import com.jclark.xsl.trax.TemplatesHandlerImpl;
import com.jclark.xsl.trax.TransformerFilterImpl;
import com.jclark.xsl.trax.TransformerHandlerImpl;
import com.jclark.xsl.trax.TransformerImpl;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TemplatesHandler;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.ParserAdapter;

public class TransformerFactoryImpl
extends SAXTransformerFactory {
    private ErrorListener _errorListener;
    private URIResolver _uriResolver;
    private Class _readerClass = null;

    public Transformer newTransformer(Source source) throws TransformerConfigurationException {
        return this.newTemplates(source).newTransformer();
    }

    public Transformer newTransformer() throws TransformerConfigurationException {
        throw new TransformerConfigurationException("not yet implemented");
    }

    public Templates newTemplates(Source source) throws TransformerConfigurationException {
        try {
            XMLReader reader = this.getReader(source);
            TemplatesHandlerImpl th = new TemplatesHandlerImpl(this, new XMLProcessorImpl(reader));
            String sysId = source.getSystemId();
            th.setSystemId(sysId);
            reader.setContentHandler(th);
            InputSource src = SAXSource.sourceToInputSource(source);
            if (src == null) {
                src = sysId == null ? new InputSource("dummy") : new InputSource(sysId);
            }
            reader.parse(src);
            return th.getTemplates();
        }
        catch (Exception e) {
            throw this.toConfigException(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public XMLReader getReader(Source source) throws Exception {
        void var2_2;
        XMLReader reader;
        if (source instanceof StreamSource) {
            reader = this.newDefaultReader();
        } else if (source instanceof SAXSource) {
            reader = ((SAXSource)source).getXMLReader();
            if (reader == null) {
                reader = this.newDefaultReader();
            }
        } else {
            throw new Exception("unrecognized input Source type: " + source.getClass().getName());
        }
        var2_2.setFeature("http://xml.org/sax/features/namespaces", true);
        return var2_2;
    }

    private XMLReader newDefaultReader() throws Exception {
        XMLReader reader = null;
        try {
            reader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (reader == null) {
            Object parserObj;
            if (this._readerClass == null) {
                String parserClassName = System.getProperty("com.jclark.xsl.trax.reader");
                if (parserClassName == null) {
                    parserClassName = System.getProperty("com.jclark.xsl.sax.parser");
                }
                if (parserClassName == null) {
                    parserClassName = System.getProperty("org.xml.sax.parser");
                }
                if (parserClassName == null) {
                    parserClassName = "com.jclark.xml.sax.CommentDriver";
                }
                this._readerClass = Class.forName(parserClassName);
            }
            reader = (parserObj = this._readerClass.newInstance()) instanceof XMLReader ? (XMLReader)parserObj : new ParserAdapter((Parser)parserObj);
        }
        return reader;
    }

    public Source getAssociatedStylesheet(Source source, String media, String title, String charset) throws TransformerConfigurationException {
        throw new TransformerConfigurationException("getAssociatedStylesheet() not yet implemented");
    }

    public void setURIResolver(URIResolver uriResolver) {
        this._uriResolver = uriResolver;
    }

    public URIResolver getURIResolver() {
        return this._uriResolver;
    }

    public boolean getFeature(String name) {
        if ("http://javax.xml.transform.stream.StreamSource/feature".equals(name)) {
            return true;
        }
        if ("http://javax.xml.transform.stream.StreamResult/feature".equals(name)) {
            return true;
        }
        if ("http://javax.xml.transform.dom.DOMSource/feature".equals(name)) {
            return false;
        }
        if ("http://javax.xml.transform.dom.DOMResult/feature".equals(name)) {
            return false;
        }
        if ("http://javax.xml.transform.sax.SAXSource/feature".equals(name)) {
            return true;
        }
        if ("http://javax.xml.transform.sax.SAXResult/feature".equals(name)) {
            return true;
        }
        return "http://javax.xml.transform.sax.SAXTransformerFactory/feature".equals(name);
    }

    public void setAttribute(String name, Object value) throws IllegalArgumentException {
        throw new IllegalArgumentException("unrecognized attribute " + name);
    }

    public Object getAttribute(String name) throws IllegalArgumentException {
        throw new IllegalArgumentException("unrecognized attribute " + name);
    }

    public void setErrorListener(ErrorListener listener) throws IllegalArgumentException {
        this._errorListener = listener;
    }

    public ErrorListener getErrorListener() {
        return this._errorListener;
    }

    public TemplatesHandler newTemplatesHandler() throws TransformerConfigurationException {
        try {
            return new TemplatesHandlerImpl(this, new XMLProcessorImpl());
        }
        catch (Exception e) {
            throw this.toConfigException(e);
        }
    }

    public TransformerHandler newTransformerHandler() throws TransformerConfigurationException {
        throw new TransformerConfigurationException("newTransformerHandler() for null transform not yet implemented");
    }

    public TransformerHandler newTransformerHandler(Source source) throws TransformerConfigurationException {
        return this.newTransformerHandler(this.newTemplates(source));
    }

    public TransformerHandler newTransformerHandler(Templates templates) throws TransformerConfigurationException {
        try {
            return new TransformerHandlerImpl((TransformerImpl)templates.newTransformer());
        }
        catch (Exception e) {
            throw this.toConfigException(e);
        }
    }

    public XMLFilter newXMLFilter(Source source) throws TransformerConfigurationException {
        return this.newXMLFilter(this.newTemplates(source));
    }

    public XMLFilter newXMLFilter(Templates templates) throws TransformerConfigurationException {
        try {
            return new TransformerFilterImpl((TransformerImpl)templates.newTransformer());
        }
        catch (Exception e) {
            throw this.toConfigException(e);
        }
    }

    private TransformerConfigurationException toConfigException(Exception e) {
        if (e instanceof TransformerConfigurationException) {
            return (TransformerConfigurationException)e;
        }
        return new TransformerConfigurationException(e);
    }
}

