/* libwpd
 * Copyright (C) 2008 Miklos Vajna (vmiklos@frugalware.org)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * For further information visit http://libwpd.sourceforge.net
 */

/* "This product is not manufactured, approved, or supported by
 * Corel Corporation or Corel Corporation Limited."
 */

package org.libwpd;

import java.util.LinkedHashMap;
import java.util.Vector;
import java.lang.String;

class WPXDocumentInterfaceProxy extends WPXDocumentInterface
{
	private WPXDocumentJavaInterface pi;

	public WPXDocumentInterfaceProxy(WPXDocumentJavaInterface i)
	{
		pi = i;
	}

	private LinkedHashMap<String,String> toHashMap(WPXPropertyList propList)
	{
		LinkedHashMap<String,String> hm = new LinkedHashMap<String,String>();
		WPXPropertyList_Iter i = new WPXPropertyList_Iter(propList);
		if (!i.last())
		{
			hm.put(i.key(), i.getProperty().getStr().toString());
			for (; i.next(); )
				hm.put(i.key(), i.getProperty().getStr().toString());
		}
		return hm;
	}

	private Vector<LinkedHashMap<String,String>> toVector(WPXPropertyListVector itemList)
	{
		Vector<LinkedHashMap<String,String>> v = new Vector<LinkedHashMap<String,String>>();
		WPXPropertyListVector_Iter i = new WPXPropertyListVector_Iter(itemList);
		if (!i.last())
		{
			v.add(toHashMap(i.getList()));
			for (; i.next();)
				v.add(toHashMap(i.getList()));
		}
		return v;
	}

	public void setDocumentMetaData(WPXPropertyList propList)
	{
		pi.setDocumentMetaData(toHashMap(propList));
	}

	public void startDocument()
	{
		pi.startDocument();
	}

	public void endDocument()
	{
		pi.endDocument();
	}

	public void openPageSpan(WPXPropertyList propList)
	{
		pi.openPageSpan(toHashMap(propList));
	}

	public void closePageSpan()
	{
		pi.closePageSpan();
	}

	public void openHeader(WPXPropertyList propList)
	{
		pi.openHeader(toHashMap(propList));
	}

	public void closeHeader()
	{
		pi.closeHeader();
	}

	public void openFooter(WPXPropertyList propList)
	{
		pi.openFooter(toHashMap(propList));
	}

	public void closeFooter()
	{
		pi.closeFooter();
	}

	public void openParagraph(WPXPropertyList propList, WPXPropertyListVector tabStops)
	{
		pi.openParagraph(toHashMap(propList), toVector(tabStops));
	}

	public void closeParagraph()
	{
		pi.closeParagraph();
	}

	public void openSpan(WPXPropertyList propList)
	{
		pi.openSpan(toHashMap(propList));
	}

	public void closeSpan()
	{
		pi.closeSpan();
	}

	public void openSection(WPXPropertyList propList, WPXPropertyListVector columns)
	{
		pi.openSection(toHashMap(propList), toVector(columns));
	}

	public void closeSection()
	{
		pi.closeSection();
	}


	public void insertTab()
	{
		pi.insertTab();
	}

	public void insertText(WPXString text)
	{
		pi.insertText(text.toString());
	}

	public void insertLineBreak()
	{
		pi.insertLineBreak();
	}


	public void defineOrderedListLevel(WPXPropertyList propList)
	{
		pi.defineOrderedListLevel(toHashMap(propList));
	}

	public void defineUnorderedListLevel(WPXPropertyList propList)
	{
		pi.defineUnorderedListLevel(toHashMap(propList));
	}

	public void openOrderedListLevel(WPXPropertyList propList)
	{
		pi.openOrderedListLevel(toHashMap(propList));
	}

	public void openUnorderedListLevel(WPXPropertyList propList)
	{
		pi.openUnorderedListLevel(toHashMap(propList));
	}

	public void closeOrderedListLevel()
	{
		pi.closeOrderedListLevel();
	}

	public void closeUnorderedListLevel()
	{
		pi.closeUnorderedListLevel();
	}

	public void openListElement(WPXPropertyList propList, WPXPropertyListVector tabStops)
	{
		pi.openListElement(toHashMap(propList), toVector(tabStops));
	}

	public void closeListElement()
	{
		pi.closeListElement();
	}


	public void openFootnote(WPXPropertyList propList)
	{
		pi.openFootnote(toHashMap(propList));
	}

	public void closeFootnote()
	{
		pi.closeFootnote();
	}

	public void openEndnote(WPXPropertyList propList)
	{
		pi.openEndnote(toHashMap(propList));
	}

	public void closeEndnote()
	{
		pi.closeEndnote();
	}


	public void openComment(WPXPropertyList propList)
	{
		pi.openComment(toHashMap(propList));
	}

	public void closeComment()
	{
		pi.closeComment();
	}


	public void openTextBox(WPXPropertyList propList)
	{
		pi.openTextBox(toHashMap(propList));
	}

	public void closeTextBox()
	{
		pi.closeTextBox();
	}


	public void openTable(WPXPropertyList propList, WPXPropertyListVector columns)
	{
		pi.openTable(toHashMap(propList), toVector(columns));
	}

	public void openTableRow(WPXPropertyList propList)
	{
		pi.openTableRow(toHashMap(propList));
	}

	public void closeTableRow()
	{
		pi.closeTableRow();
	}

	public void openTableCell(WPXPropertyList propList)
	{
		pi.openTableCell(toHashMap(propList));
	}

	public void closeTableCell()
	{
		pi.closeTableCell();
	}

	public void insertCoveredTableCell(WPXPropertyList propList)
	{
		pi.insertCoveredTableCell(toHashMap(propList));
	}

	public void closeTable()
	{
		pi.closeTable();
	}


	public void openFrame(WPXPropertyList propList)
	{
		pi.openFrame(toHashMap(propList));
	}

	public void closeFrame()
	{
		pi.closeFrame();
	}


	public void insertBinaryObject(WPXPropertyList propList, WPXBinaryData object)
	{
		int length = (int)object.size();
		byte[] byteArray = new byte[length];
		for (int i= 0; i< length; i++)
			byteArray[i] = (byte)(object.arrayMember(i));
		pi.insertBinaryObject(toHashMap(propList), byteArray);
	}
		

}
