%module(directors="1") wpd

// generate directors for all classes that have virtual methods
%feature("director");

// Suppress SWIG warning
#pragma SWIG nowarn=SWIGWARN_PARSE_NESTED_CLASS

%{
#include <libwpd/WPDocument.h>
%}
%include <libwpd/WPDocument.h>

%{
#include <libwpd/WPXDocumentInterface.h>
%}
%include <libwpd/WPXDocumentInterface.h>

%include <libwpd/WPXProperty.h>

%rename(getProperty) WPXPropertyList_Iter::operator();
// this (from class till typedef) is a workaround as swig does not support
// nested classes
class WPXPropertyList_Iter
{
public:
        WPXPropertyList_Iter(const WPXPropertyList &propList);
        virtual ~WPXPropertyList_Iter();
        void rewind();
        bool next();
        bool last();
        const WPXProperty * operator()() const;
        const char * key();
private:
        WPXMapIterImpl *m_iterImpl;
        Iter(const Iter&);
        Iter& operator=(const Iter&);
};
%{
#include <libwpd/WPXPropertyList.h>
%}
%include <libwpd/WPXPropertyList.h>
%{
typedef WPXPropertyList::Iter WPXPropertyList_Iter;
%}

%rename(getList) WPXPropertyListVector_Iter::operator();
// same workaround again
class WPXPropertyListVector_Iter
{
public:
        WPXPropertyListVector_Iter(const WPXPropertyListVector &vect);
        virtual ~WPXPropertyListVector_Iter();
        void rewind();
        bool next();
        bool last();
        const WPXPropertyList & operator()() const;

private:
        WPXPropertyListVectorIterImpl *m_iterImpl;
        Iter(const Iter&);
        Iter& operator=(const Iter&);
};
%{
#include <libwpd/WPXPropertyListVector.h>
%}
%include <libwpd/WPXPropertyListVector.h>
%{
typedef WPXPropertyListVector::Iter WPXPropertyListVector_Iter;
%}
%include <libwpd-stream/WPXStream.h>
%include <libwpd-stream/WPXStreamImplementation.h>
%include <libwpd/WPXString.h>

%extend WPXString
{
	const char* toString()
	{
		return $self->cstr();
	}
}

%{
#include <libwpd-stream/WPXStream.h>
%}
%include <libwpd-stream/WPXStream.h>

%{
#include <libwpd-stream/WPXStreamImplementation.h>
%}
%include <libwpd-stream/WPXStreamImplementation.h>

%{
#include <libwpd/WPXBinaryData.h>
%}
%include <libwpd/WPXBinaryData.h>

%extend WPXBinaryData
{
	const char arrayMember(int i)
	{
		return (const char)(*($self->getDataBuffer()+i));
	}
}


%include <libwpd/libwpd.h>
