/* libwpd
 * Copyright (C) 2008 Miklos Vajna (vmiklos@frugalware.org)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * For further information visit http://libwpd.sourceforge.net
 */

/* "This product is not manufactured, approved, or supported by
 * Corel Corporation or Corel Corporation Limited."
 */

using System.Collections.Generic;
using System;

namespace org.libwpd {

class WPXDocumentInterfaceProxy : WPXDocumentInterface
{
	private WPXDocumentCSharpInterface pi;

	public WPXDocumentInterfaceProxy(WPXDocumentCSharpInterface i)
	{
		pi = i;
	}

	private Dictionary<String,String> toDictionary(WPXPropertyList propList)
	{
		Dictionary<String,String> hm = new Dictionary<String,String>();
		WPXPropertyList_Iter i = new WPXPropertyList_Iter(propList);
		if (!i.last())
		{
			hm.Add(i.key(), i.getProperty().getStr().toString());
			for (; i.next(); )
				hm.Add(i.key(), i.getProperty().getStr().toString());
		}
		return hm;
	}

	private List<Dictionary<String,String>> toList(WPXPropertyListVector itemList)
	{
		List<Dictionary<String,String>> v = new List<Dictionary<String,String>>();
		WPXPropertyListVector_Iter i = new WPXPropertyListVector_Iter(itemList);
		if (!i.last())
		{
			v.Add(toDictionary(i.getList()));
			for (; i.next();)
				v.Add(toDictionary(i.getList()));
		}
		return v;
	}

	public override void setDocumentMetaData(WPXPropertyList propList)
	{
		pi.setDocumentMetaData(toDictionary(propList));
	}

	public override void startDocument()
	{
		pi.startDocument();
	}

	public override void endDocument()
	{
		pi.endDocument();
	}

	public override void openPageSpan(WPXPropertyList propList)
	{
		pi.openPageSpan(toDictionary(propList));
	}

	public override void closePageSpan()
	{
		pi.closePageSpan();
	}

	public override void openHeader(WPXPropertyList propList)
	{
		pi.openHeader(toDictionary(propList));
	}

	public override void closeHeader()
	{
		pi.closeHeader();
	}

	public override void openFooter(WPXPropertyList propList)
	{
		pi.openFooter(toDictionary(propList));
	}

	public override void closeFooter()
	{
		pi.closeFooter();
	}

	public override void openParagraph(WPXPropertyList propList, WPXPropertyListVector tabStops)
	{
		pi.openParagraph(toDictionary(propList), toList(tabStops));
	}

	public override void closeParagraph()
	{
		pi.closeParagraph();
	}

	public override void openSpan(WPXPropertyList propList)
	{
		pi.openSpan(toDictionary(propList));
	}

	public override void closeSpan()
	{
		pi.closeSpan();
	}

	public override void openSection(WPXPropertyList propList, WPXPropertyListVector columns)
	{
		pi.openSection(toDictionary(propList), toList(columns));
	}

	public override void closeSection()
	{
		pi.closeSection();
	}


	public override void insertTab()
	{
		pi.insertTab();
	}

	public override void insertText(WPXString text)
	{
		pi.insertText(text.toString());
	}

	public override void insertLineBreak()
	{
		pi.insertLineBreak();
	}


	public override void defineOrderedListLevel(WPXPropertyList propList)
	{
		pi.defineOrderedListLevel(toDictionary(propList));
	}

	public override void defineUnorderedListLevel(WPXPropertyList propList)
	{
		pi.defineUnorderedListLevel(toDictionary(propList));
	}

	public override void openOrderedListLevel(WPXPropertyList propList)
	{
		pi.openOrderedListLevel(toDictionary(propList));
	}

	public override void openUnorderedListLevel(WPXPropertyList propList)
	{
		pi.openUnorderedListLevel(toDictionary(propList));
	}

	public override void closeOrderedListLevel()
	{
		pi.closeOrderedListLevel();
	}

	public override void closeUnorderedListLevel()
	{
		pi.closeUnorderedListLevel();
	}

	public override void openListElement(WPXPropertyList propList, WPXPropertyListVector tabStops)
	{
		pi.openListElement(toDictionary(propList), toList(tabStops));
	}

	public override void closeListElement()
	{
		pi.closeListElement();
	}


	public override void openFootnote(WPXPropertyList propList)
	{
		pi.openFootnote(toDictionary(propList));
	}

	public override void closeFootnote()
	{
		pi.closeFootnote();
	}

	public override void openEndnote(WPXPropertyList propList)
	{
		pi.openEndnote(toDictionary(propList));
	}

	public override void closeEndnote()
	{
		pi.closeEndnote();
	}


	public override void openComment(WPXPropertyList propList)
	{
		pi.openComment(toDictionary(propList));
	}

	public override void closeComment()
	{
		pi.closeComment();
	}


	public override void openTextBox(WPXPropertyList propList)
	{
		pi.openTextBox(toDictionary(propList));
	}

	public override void closeTextBox()
	{
		pi.closeTextBox();
	}


	public override void openTable(WPXPropertyList propList, WPXPropertyListVector columns)
	{
		pi.openTable(toDictionary(propList), toList(columns));
	}

	public override void openTableRow(WPXPropertyList propList)
	{
		pi.openTableRow(toDictionary(propList));
	}

	public override void closeTableRow()
	{
		pi.closeTableRow();
	}

	public override void openTableCell(WPXPropertyList propList)
	{
		pi.openTableCell(toDictionary(propList));
	}

	public override void closeTableCell()
	{
		pi.closeTableCell();
	}

	public override void insertCoveredTableCell(WPXPropertyList propList)
	{
		pi.insertCoveredTableCell(toDictionary(propList));
	}

	public override void closeTable()
	{
		pi.closeTable();
	}


	public override void openFrame(WPXPropertyList propList)
	{
		pi.openFrame(toDictionary(propList));
	}

	public override void closeFrame()
	{
		pi.closeFrame();
	}


	public override void insertBinaryObject(WPXPropertyList propList, WPXBinaryData data)
	{
		int length = (int)data.size();
		byte[] byteArray = new byte[length];
		for (int i= 0; i< length; i++)
			byteArray[i] = (byte)(data.arrayMember(i));
		pi.insertBinaryObject(toDictionary(propList), byteArray);
	}
		

};

}
