/* libwpd
 * Copyright (C) 2008 Miklos Vajna (vmiklos@frugalware.org)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * For further information visit http://libwpd.sourceforge.net
 */

/* "This product is not manufactured, approved, or supported by
 * Corel Corporation or Corel Corporation Limited."
 */
 
using System;

namespace org.libwpd {

public class WPDocumentCSharp
{
	public static bool isFileWordPerfectDocument(String file)
	{
		WPXInputStream input = new WPXFileStream(file);
		WPDConfidence confidence = WPDocument.isFileFormatSupported(input);
		if (confidence != WPDConfidence.WPD_CONFIDENCE_EXCELLENT)
			return false;
		else
			return true;
	}

	public static bool parseFile(String file, WPXDocumentCSharpInterface documentInterface)
	{
		/*
		 * FIXME later it would be nice to have support for
		 * password protected files as well.
		 */
		if(WPDocument.parse(new WPXFileStream(file), new WPXDocumentInterfaceProxy(documentInterface), null) != WPDResult.WPD_OK)
			return false;
		else
			return true;
	}
};

}
