/*
 * libSpiff - XSPF playlist handling library
 *
 * Copyright (C) 2007, Sebastian Pipping / Xiph.Org Foundation
 * All rights reserved.
 *
 * Redistribution  and use in source and binary forms, with or without
 * modification,  are permitted provided that the following conditions
 * are met:
 *
 *     * Redistributions   of  source  code  must  retain  the   above
 *       copyright  notice, this list of conditions and the  following
 *       disclaimer.
 *
 *     * Redistributions  in  binary  form must  reproduce  the  above
 *       copyright  notice, this list of conditions and the  following
 *       disclaimer   in  the  documentation  and/or  other  materials
 *       provided with the distribution.
 *
 *     * Neither  the name of the Xiph.Org Foundation nor the names of
 *       its  contributors may be used to endorse or promote  products
 *       derived  from  this software without specific  prior  written
 *       permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT  NOT
 * LIMITED  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS
 * FOR  A  PARTICULAR  PURPOSE ARE DISCLAIMED. IN NO EVENT  SHALL  THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL,    SPECIAL,   EXEMPLARY,   OR   CONSEQUENTIAL   DAMAGES
 * (INCLUDING,  BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES;  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT  LIABILITY,  OR  TORT (INCLUDING  NEGLIGENCE  OR  OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Sebastian Pipping, sping@xiph.org
 */

#include <spiff/Spiff.h>
#include <spiff/ProjectOpus/ProjectOpusPlaylistExtension.h>
#include <stdio.h>
using namespace Spiff;
using namespace Spiff::Toolbox;
using namespace Spiff::ProjectOpus;



void fillProps(SpiffProps & props) {
	props.giveTitle(_PT("Now playing"), true);
	props.giveAnnotation(_PT("Well, ..."), true);
	props.giveCreator(_PT("libSpiff XSPF library"), true);
	SpiffDateTime dateTime(2006, 8, 28, 11, 30, 11, 1, 0);
	props.giveDate(&dateTime, true);
	props.giveIdentifier(_PT("xspf:libSpiff:testId"), true);
	props.giveImage(_PT("http://big/balloons.jpg"), true);
	props.giveInfo(_PT("http://info/info"), true);
	props.giveLicense(_PT("http://license/free/"), true);
	props.giveLocation(_PT("http://playlist/home.xspf"), true);
	props.setVersion(0);
	props.giveAppendAttributionIdentifier(_PT("some:any/many"), true);
	props.giveAppendAttributionLocation(_PT("test:pest/west"), true);
	props.giveAppendLink(_PT("store:url"), true, _PT("http://expensive/dot/com"), true);
	props.giveAppendMeta(_PT("tag:meta:year"), true, _PT("2006"), true);

	// Add a playlist extension
	ProjectOpusPlaylistExtension playlistExtension;
	playlistExtension.setNodeId(123);
	playlistExtension.setType(TYPE_ALBUM);
	props.giveAppendExtension(&playlistExtension, true);
}



void fillTrack(SpiffTrack & track) {
	track.giveAlbum(_PT("Phobia"), true);
	track.giveCreator(_PT("Breaking Benjamin"), true);
	track.giveTitle(_PT("Unknown Soldier"), true);
	track.setTrackNum(10);
	track.giveAppendIdentifier(_PT("id:bb:unknownSoldier"), true);
	track.giveAppendLink(_PT("http://website"), true, _PT("http://website"), true);
	track.giveAppendLocation(_PT("http://download/mp3/"), true);
	track.giveAppendMeta(_PT("tag:meta:year"), true, _PT("2006"), true);
	track.giveAnnotation(_PT("Great song"), true);
	track.setDuration(123000);
	track.giveImage(_PT("http://big/balloons.jpg"), true);
	track.giveInfo(_PT("http://info/info"), true);
}



int PORT_MAIN() {
	// Set up playlist props
	SpiffProps props;
	SpiffPropsWriter propsWriter(&props);
	fillProps(props);

	// Version 1, well-indented XML
	SpiffIndentFormatter layout;
	SpiffWriter writer(1, layout, propsWriter);

	// Pre-register extension namespace so
	// it can appear in <playlist> already
	writer.registerNamespace(ProjectOpusPlaylistExtension
			::namespaceKey, _PT("po"));

	// Set up track
	SpiffTrack track;
	SpiffTrackWriter trackWriter;
	trackWriter.setTrack(&track);
	fillTrack(track);

	// Add track two times
	writer.addTrack(trackWriter);
	writer.addTrack(trackWriter);

	// Finish and write to file
	const int res = writer.writeFile(_PT("TEST.xspf"));
	if (res != SPIFF_WRITER_SUCCESS) {
		PORT_PRINTF(_PT("Could not write to file.\n"));
	} else {
		PORT_PRINTF(_PT("Everything fine.\n"));
	}
	return 0;
}
