/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2009 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.validation.api.builtin;

import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.netbeans.validation.api.Problem;
import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.Validator;
import static org.junit.Assert.*;

/**
 *
 * @author Tim Boudreau
 */
public class HostNameValidatorTest {

    public HostNameValidatorTest() {
    }

    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Test
    public void testValidate() {
        assertTrue(true);
        Validator<String> v = new HostNameValidator(true);
        Problems p = new Problems();

        assertTrue(v.validate(p, "", "www.foo.com"));
        assertTrue(v.validate(p, "", "www.foo.com:8080"));
        //test AIOOBE
        assertFalse(v.validate(p, "", "bar.com "));
        assertFalse(v.validate(p, "", " bar.com"));
        assertFalse(v.validate(p, "", ":"));

        v = new HostNameValidator(false);
        assertFalse(v.validate(p, "", "myhost.com:204-"));

        boolean val = v.validate(p, "", "205.foo.com");

        v = new HostNameValidator(true);
        val = v.validate(p, "", "128.foo.129");
        assertFalse(val);
        assertFalse(v.validate(p, "", "128.foo.129:1024"));
        assertFalse(v.validate(p, "", "www.foo.com:abcd"));
        assertFalse(v.validate(p, "", "foo."));
        assertFalse(v.validate(p, "", "128."));
        assertTrue(v.validate(p, "", "www.foo-bar.com"));
        assertFalse(v.validate(p, "", "www.foo-bar.com-"));
        assertFalse(v.validate(p, "", "-www.foo-bar.com"));
        assertFalse(v.validate(p, "", "www.foo-bar.com "));
        assertFalse(v.validate(p, "", " www.foo-bar.com"));
        assertFalse(v.validate(p, "", "204.128"));

        assertFalse(v.validate(p, "", "foo@bar.com"));
        assertFalse(v.validate(p, "", "foo.бar.com"));
        assertFalse(v.validate(p, "", "фу.бар.ком"));
        assertFalse(v.validate(p, "", "myhost:"));
        assertFalse(v.validate(p, "", "myhost::"));
        assertFalse(v.validate(p, "", "www.foo.com::2040"));
        assertFalse(v.validate(p, "", "www.foo.com:2040802"));
        val = v.validate(p, "", "www.foo.com:2040:2802");
        assertFalse(val);
        assertFalse(v.validate(p, "", "www.foo.com:2040:"));
    }

    @Test
    public void testValidateHostOrIP() {
        assertTrue(true);
        Validator<String> v = new ValidHostNameOrIPValidator(true);
        Problems p = new Problems();

        assertTrue(v.validate(p, "", "www.foo.com"));
        assertTrue(v.validate(p, "", "www.foo.com:8080"));
        boolean val = false;
        assertFalse(v.validate(p, "", "bar.com "));
        assertFalse(v.validate(p, "", " bar.com"));
        assertFalse(v.validate(p, "", ":"));
        val = v.validate(p, "", "myhost:");
        assertFalse(val);

        v = new HostNameValidator(false);
        assertFalse(v.validate(p, "", "myhost.com:204-"));

        val = v.validate(p, "", "205.foo.com");

        v = new HostNameValidator(true);
        val = v.validate(p, "", "128.foo.129");
        assertFalse(val);
        assertFalse(v.validate(p, "", "128.foo.129:1024"));
        assertFalse(v.validate(p, "", "www.foo.com:abcd"));
        assertFalse(v.validate(p, "", "foo."));
        assertFalse(v.validate(p, "", "128."));
        assertTrue(v.validate(p, "", "www.foo-bar.com"));
        assertFalse(v.validate(p, "", "www.foo-bar.com-"));
        assertFalse(v.validate(p, "", "-www.foo-bar.com"));
        assertFalse(v.validate(p, "", "www.foo-bar.com "));
        assertFalse(v.validate(p, "", " www.foo-bar.com"));
        assertFalse(v.validate(p, "", "204.128"));

        assertFalse(v.validate(p, "", "foo@bar.com"));
        assertFalse(v.validate(p, "", "foo.бar.com"));
        assertFalse(v.validate(p, "", "фу.бар.ком"));
        assertFalse(v.validate(p, "", "фу.бар.ком:1023"));
        assertFalse(v.validate(p, "", "фу.бар.ком:102a"));
        assertFalse(v.validate(p, "", "2050"));
        assertFalse(v.validate(p, "", ":2050"));
        assertFalse(v.validate(p, "", "фу.бар.ком:10232034"));
        assertTrue(v.validate(p, "", "www..foo.com"));
        assertFalse(v.validate(p, "", "192.168.2.1::1024"));
        assertFalse(v.validate(p, "", "192.168.2.1::1024:"));
        assertFalse(v.validate(p, "", "."));
        assertFalse(v.validate(p, "", ""));
    }
}