/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.4
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 * LibSBML implementation of SBML's SpeciesReference construct.
 * <p>
 * The {@link Reaction} structure provides a way to express which species act as
 * reactants and which species act as products in a reaction.  In a given
 * reaction, references to those species acting as reactants and/or
 * products are made using instances of {@link SpeciesReference} structures in a
 * {@link Reaction} object's lists of reactants and products.
 * <p>
 * A species can occur more than once in the lists of reactants and
 * products of a given {@link Reaction} instance.  The effective stoichiometry for
 * a species in a reaction is the sum of the stoichiometry values given on
 * the {@link SpeciesReference} object in the list of products minus the sum of
 * stoichiometry values given on the {@link SpeciesReference} objects in the list
 * of reactants.  A positive value indicates the species is effectively a
 * product and a negative value indicates the species is effectively a
 * reactant.  SBML places no restrictions on the effective stoichiometry of
 * a species in a reaction; for example, it can be zero.  In the following
 * SBML fragment, the two reactions have the same effective stoichiometry
 * for all their species:
 * <div class='fragment'><pre>
 * &lt;reaction id='x'&gt;
 *     &lt;listOfReactants&gt;
 *         &lt;speciesReference species='a'/&gt;
 *         &lt;speciesReference species='a'/&gt;
 *         &lt;speciesReference species='b'/&gt;
 *     &lt;/listOfReactants&gt;
 *     &lt;listOfProducts&gt;
 *         &lt;speciesReference species='c'/&gt;
 *         &lt;speciesReference species='b'/&gt;
 *     &lt;/listProducts&gt;
 * &lt;/reaction&gt;
 * &lt;reaction id='y'&gt;
 *     &lt;listOfReactants&gt;
 *         &lt;speciesReference species='a' stoichiometry='2'/&gt;
 *     &lt;/listOfReactants&gt;
 *     &lt;listOfProducts&gt;
 *         &lt;speciesReference species='c'/&gt;
 *     &lt;/listProducts&gt;
 * &lt;/reaction&gt;</pre></div>
 * <p>
 * The precise structure of {@link SpeciesReference} differs between SBML
 * Level&nbsp;2 and Level&nbsp;3.  We discuss the two variants in separate
 * sections below.
 * <p>
 * <h2>{@link SpeciesReference} in SBML Level 2</h2>
 * <p>
 * The mandatory 'species' attribute of {@link SpeciesReference} must have as its
 * value the identifier of an existing species defined in the enclosing
 * {@link Model}.  The species is thereby designated as a reactant or product in
 * the reaction.  Which one it is (i.e., reactant or product) is indicated
 * by whether the {@link SpeciesReference} appears in the {@link Reaction}'s 'reactant' or
 * 'product' lists.
 * <p>
 * Product and reactant stoichiometries can be specified using
 * <em>either</em> 'stoichiometry' or 'stoichiometryMath' in a
 * {@link SpeciesReference} object.  The 'stoichiometry' attribute is of type
 * double and should contain values greater than zero (0).  The
 * 'stoichiometryMath' element is implemented as an element containing a
 * MathML expression.  These two are mutually exclusive; only one of
 * 'stoichiometry' or 'stoichiometryMath' should be defined in a given
 * {@link SpeciesReference} instance.  When neither the attribute nor the element
 * is present, the value of 'stoichiometry' in the {@link SpeciesReference}
 * instance defaults to <code>1.</code>
 * <p>
 * For maximum interoperability, the 'stoichiometry' attribute should be
 * used in preference to 'stoichiometryMath' when a species' stoichiometry
 * is a simple scalar number (integer or decimal).  When the stoichiometry
 * is a rational number, or when it is a more complicated formula,
 * 'stoichiometryMath' must be used.  The MathML expression in
 * 'stoichiometryMath' may also refer to identifiers of entities in a model
 * (except reaction identifiers).  However, the only species identifiers
 * that can be used in 'stoichiometryMath' are those referenced in the
 * {@link Reaction} list of reactants, products and modifiers.
 * <p>
 * The following is a simple example of a species reference for species 
 * <code>X0</code>, with stoichiometry <code>2</code>, in a list of reactants within a reaction
 * having the identifier <code>J1:</code>
 * <div class='fragment'><pre>
 * &lt;model&gt;
 *     ...
 *     &lt;listOfReactions&gt;
 *         &lt;reaction id='J1'&gt;
 *             &lt;listOfReactants&gt;
 *                 &lt;speciesReference species='X0' stoichiometry='2'&gt;
 *             &lt;/listOfReactants&gt;
 *             ...
 *         &lt;/reaction&gt;
 *         ...
 *     &lt;/listOfReactions&gt;
 *     ...
 * &lt;/model&gt;</pre></div>
 * <p>
 * The following is a more complex example of a species reference for
 * species X0, with a stoichiometry formula consisting of the parameter
 * <code>x:</code>
 * <div class='fragment'><pre>
 * &lt;model&gt;
 *     ...
 *     &lt;listOfReactions&gt;
 *         &lt;reaction id='J1'&gt;
 *             &lt;listOfReactants&gt;
 *                 &lt;speciesReference species='X0'&gt;
 *                     &lt;stoichiometryMath&gt;
 *                         &lt;math xmlns='http://www.w3.org/1998/Math/MathML'&gt;
 *                             &lt;ci&gt;x&lt;/ci&gt;
 *                         &lt;/math&gt;
 *                     &lt;/stoichiometryMath&gt;
 *                 &lt;/speciesReference&gt;
 *             &lt;/listOfReactants&gt;
 *             ...
 *         &lt;/reaction&gt;
 *         ...
 *     &lt;/listOfReactions&gt;
 *     ...
 * &lt;/model&gt;</pre></div>
 * <p>
 * <p>
 * <h2>{@link SpeciesReference} in SBML Level 3</h2>
 * <p>
 * In Level 2's definition of a reaction, the stoichiometry attribute of a
 * {@link SpeciesReference} is actually a combination of two factors, the standard
 * biochemical stoichiometry and a conversion factor that may be needed to
 * translate the units of the species quantity to the units of the reaction
 * rate. Unfortunately, Level&nbsp;2 offers no direct way of decoupling
 * these two factors, or for explicitly indicating the units. The only way
 * to do it in Level&nbsp;2 is to use the {@link StoichiometryMath} object
 * associated with SpeciesReferences, and to reference SBML {@link Parameter}
 * objects from within the {@link StoichiometryMath} formula. This works because
 * {@link Parameter} offers a way to attach units to a numerical value, but the
 * solution is indirect and awkward for something that should be a simple
 * matter.  Moreover, the question of how to properly encode
 * stoichiometries in SBML reactions has caused much confusion among
 * implementors of SBML software.
 * <p>
 * SBML Level&nbsp;3 approaches this problem differently.  It (1) extends
 * the the use of the {@link SpeciesReference} identifier to represent the value of
 * the 'stoichiometry' attribute, (2) makes the 'stoichiometry' attribute
 * optional, (3) removes {@link StoichiometryMath}, and (4) adds a new 'constant'
 * boolean attribute on {@link SpeciesReference}.
 * <p>
 * As in Level&nbsp;2, the 'stoichiometry' attribute is of type
 * <code>double</code> and should contain values greater than zero (<code>0</code>).  A
 * missing 'stoichiometry' implies that the stoichiometry is either
 * unknown, or to be obtained from an external source, or determined by an
 * {@link InitialAssignment} object or other SBML construct elsewhere in the model.
 * <p>
 * A species reference's stoichiometry is set by its 'stoichiometry'
 * attribute exactly once.  If the {@link SpeciesReference} object's 'constant'
 * attribute has the value <code>true</code>, then the stoichiometry is fixed and
 * cannot be changed except by an {@link InitialAssignment} object.  These two
 * methods of setting the stoichiometry (i.e., using 'stoichiometry'
 * directly, or using {@link InitialAssignment}) differ in that the 'stoichiometry'
 * attribute can only be set to a literal floating-point number, whereas
 * {@link InitialAssignment} allows the value to be set using an arbitrary
 * mathematical expression.  (As an example, the approach could be used to
 * set the stoichiometry to a rational number of the form <em>p</em>/<em>q</em>,
 * where <em>p</em> and <em>q</em> are integers, something that is occasionally
 * useful in the context of biochemical reaction networks.)  If the species
 * reference's 'constant' attribute has the value <code>false</code>, the species
 * reference's value may be overridden by an {@link InitialAssignment} or changed
 * by {@link AssignmentRule} or {@link AlgebraicRule}, and in addition, for simulation time
 * <em>t &gt; 0</em>, it may also be changed by a {@link RateRule} or {@link Event}
 * objects.  (However, some of these constructs are mutually exclusive; see
 * the SBML Level&nbsp;3 Version&nbsp;1 Core specifiation for more
 * details.)  It is not an error to define 'stoichiometry' on a species
 * reference and also redefine the stoichiometry using an
 * {@link InitialAssignment}, but the 'stoichiometry' attribute in that case is
 * ignored.
 * <p>
 * The value of the 'id' attribute of a {@link SpeciesReference} can be used as the
 * content of a <code>&lt;ci&gt;</code> element in MathML formulas
 * elsewhere in the model.  When the identifier appears in a MathML
 * <code>&lt;ci&gt;</code> element, it represents the stoichiometry of the
 * corresponding species in the reaction where the {@link SpeciesReference} object
 * instance appears.  More specifically, it represents the value of the
 * 'stoichiometry' attribute on the {@link SpeciesReference} object.
 * <p>
 * In SBML Level 3, the unit of measurement associated with the value of a
 * species' stoichiometry is always considered to be <code>dimensionless.</code>
 * This has the following implications:
 * <ul>
 * <p>
 * <li> When a species reference's identifier appears in mathematical
 * formulas elsewhere in the model, the unit associated with that value is
 * <code>dimensionless.</code>
 * <p>
 * <li> The units of the 'math' elements of {@link AssignmentRule},
 * {@link InitialAssignment} and {@link EventAssignment} objects setting the stoichiometry
 * of the species reference should be <code>dimensionless.</code>
 * <p>
 * <li> If a species reference's identifier is the subject of a {@link RateRule},
 * the unit associated with the {@link RateRule} object's value should be
 * <code>dimensionless</code>/<em>time</em>, where <em>time</em> is the
 * model-wide unit of time set on the {@link Model} object.
 * <p>
 * </ul>
 * <p>
 * <!---------------------------------------------------------------------- -->
 * <p>
 */
public class SpeciesReference extends SimpleSpeciesReference {
   private long swigCPtr;

   protected SpeciesReference(long cPtr, boolean cMemoryOwn)
   {
     super(libsbmlJNI.SpeciesReference_SWIGUpcast(cPtr), cMemoryOwn);
     swigCPtr = cPtr;
   }

   protected static long getCPtr(SpeciesReference obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (SpeciesReference obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        libsbmlJNI.delete_SpeciesReference(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  
  /**
   * Creates a new {@link SpeciesReference} using the given SBML <code>level</code> and <code>version</code>
   * values.
   * <p>
   * @param level a long integer, the SBML Level to assign to this {@link SpeciesReference}
   * <p>
   * @param version a long integer, the SBML Version to assign to this
   * {@link SpeciesReference}
   * <p>
   * @note Upon the addition of a {@link SpeciesReference} object to a {@link Model} (e.g.,
   * using {@link Reaction#addReactant(SpeciesReference sr)} or
   * {@link Reaction#addProduct(SpeciesReference sr)}), the SBML Level,
   * SBML Version and XML namespace of the document <em>override</em> the values
   * used when creating the {@link SpeciesReference} object via this constructor.
   * This is necessary to ensure that an SBML document is a consistent
   * structure.  Nevertheless, the ability to supply the values at the time
   * of creation of a {@link SpeciesReference} is an important aid to producing
   * valid SBML.  Knowledge of the intented SBML Level and Version
   * determine whether it is valid to assign a particular value to an
   * attribute, or whether it is valid to add an object to an existing
   * {@link SBMLDocument}.
   */
 public SpeciesReference(long level, long version) throws org.sbml.libsbml.SBMLConstructorException {
    this(libsbmlJNI.new_SpeciesReference__SWIG_0(level, version), true);
  }

  
  /**
   * Creates a new {@link SpeciesReference} using the given {@link SBMLNamespaces} object
   * <code>sbmlns</code>.
   * <p>
   * @param sbmlns an {@link SBMLNamespaces} object.
   * <p>
   * @note Upon the addition of a {@link SpeciesReference} object to a {@link Model} (e.g.,
   * using {@link Reaction#addReactant(SpeciesReference sr)} or
   * {@link Reaction#addProduct(SpeciesReference sr)}), the SBML Level,
   * SBML Version and XML namespace of the document <em>override</em> the values
   * used when creating the {@link SpeciesReference} object via this constructor.
   * This is necessary to ensure that an SBML document is a consistent
   * structure.  Nevertheless, the ability to supply the values at the time
   * of creation of a {@link SpeciesReference} is an important aid to producing
   * valid SBML.  Knowledge of the intented SBML Level and Version
   * determine whether it is valid to assign a particular value to an
   * attribute, or whether it is valid to add an object to an existing
   * {@link SBMLDocument}.
   */
 public SpeciesReference(SBMLNamespaces sbmlns) throws org.sbml.libsbml.SBMLConstructorException {
    this(libsbmlJNI.new_SpeciesReference__SWIG_1(SBMLNamespaces.getCPtr(sbmlns), sbmlns), true);
  }

  
  /**
   * Copy constructor; creates a copy of this {@link SpeciesReference}.
   */
 public SpeciesReference(SpeciesReference orig) throws org.sbml.libsbml.SBMLConstructorException {
    this(libsbmlJNI.new_SpeciesReference__SWIG_2(SpeciesReference.getCPtr(orig), orig), true);
  }

  
  /**
   * Creates and returns a deep copy of this {@link SpeciesReference} instance.
   * <p>
   * @return a (deep) copy of this {@link SpeciesReference}.
   */
 public SpeciesReference cloneObject() {
    long cPtr = libsbmlJNI.SpeciesReference_cloneObject(swigCPtr, this);
    return (cPtr == 0) ? null : new SpeciesReference(cPtr, true);
  }

  
  /**
   * Initializes the fields of this {@link SpeciesReference} object to 'typical'
   * default values.
   * <p>
   * The SBML {@link SpeciesReference} component has slightly different aspects and
   * default attribute values in different SBML Levels and Versions.
   * This method sets the values to certain common defaults, based
   * mostly on what they are in SBML Level&nbsp;2.  Specifically:
   * <ul>
   * <li> Sets attribute 'stoichiometry' to <code>1.0</code>
   * <li> (Applies to Level&nbsp;1 models only) Sets attribute 'denominator' to <code>1</code>
   * </ul>
   * <p>
   * @see #getDenominator()
   * @see #setDenominator(int value)
   * @see #getStoichiometry()
   * @see #setStoichiometry(double value)
   * @see #getStoichiometryMath()
   * @see #setStoichiometryMath(StoichiometryMath math)
   */
 public void initDefaults() {
    libsbmlJNI.SpeciesReference_initDefaults(swigCPtr, this);
  }

  
  /**
   * Get the value of the 'stoichiometry' attribute.
   * <p>
   * In SBML Level 2, product and reactant stoichiometries can be specified
   * using <em>either</em> 'stoichiometry' or 'stoichiometryMath' in a
   * {@link SpeciesReference} object.  The former is to be used when a
   * stoichiometry is simply a scalar number, while the latter is for
   * occasions when it needs to be a rational number or it needs to
   * reference other mathematical expressions.  The 'stoichiometry'
   * attribute is of type <code>double</code> and should contain values greater than
   * zero (<code>0</code>).  The 'stoichiometryMath' element is implemented as an
   * element containing a MathML expression.  These two are mutually
   * exclusive; only one of 'stoichiometry' or 'stoichiometryMath' should
   * be defined in a given {@link SpeciesReference} instance.  When neither the
   * attribute nor the element is present, the value of 'stoichiometry' in
   * the {@link SpeciesReference} instance defaults to <code>1.</code>  For maximum
   * interoperability between different software tools, the 'stoichiometry'
   * attribute should be used in preference to 'stoichiometryMath' when a
   * species' stoichiometry is a simple scalar number (integer or
   * decimal).
   * <p>
   * In SBML Level 3, there is no {@link StoichiometryMath}, and {@link SpeciesReference}
   * objects have only the 'stoichiometry' attribute.
   * <p>
   * @return the value of the (scalar) 'stoichiometry' attribute of this
   * {@link SpeciesReference}.
   * <p>
   * @see #getStoichiometryMath()
   */
 public double getStoichiometry() {
    return libsbmlJNI.SpeciesReference_getStoichiometry(swigCPtr, this);
  }

  
  /**
   * Get the content of the 'stoichiometryMath' subelement as an {@link ASTNode}
   * tree.
   * <p>
   * The 'stoichiometryMath' element exists only in SBML Level 2.  There,
   * product and reactant stoichiometries can be specified using
   * <em>either</em> 'stoichiometry' or 'stoichiometryMath' in a
   * {@link SpeciesReference} object.  The former is to be used when a
   * stoichiometry is simply a scalar number, while the latter is for
   * occasions when it needs to be a rational number or it needs to
   * reference other mathematical expressions.  The 'stoichiometry'
   * attribute is of type <code>double</code> and should contain values greater than
   * zero (<code>0</code>).  The 'stoichiometryMath' element is implemented as an
   * element containing a MathML expression.  These two are mutually
   * exclusive; only one of 'stoichiometry' or 'stoichiometryMath' should
   * be defined in a given {@link SpeciesReference} instance.  When neither the
   * attribute nor the element is present, the value of 'stoichiometry' in
   * the {@link SpeciesReference} instance defaults to <code>1.</code>  For maximum
   * interoperability between different software tools, the 'stoichiometry'
   * attribute should be used in preference to 'stoichiometryMath' when a
   * species' stoichiometry is a simple scalar number (integer or decimal).
   * <p>
   * @return the content of the 'stoichiometryMath' subelement of this
   * {@link SpeciesReference}.
   */
 public StoichiometryMath getStoichiometryMath() {
    long cPtr = libsbmlJNI.SpeciesReference_getStoichiometryMath__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new StoichiometryMath(cPtr, false);
  }

  
  /**
   * Get the value of the 'denominator' attribute, for the case of a
   * rational-numbered stoichiometry or a model in SBML Level&nbsp;1.
   * <p>
   * The 'denominator' attribute is only actually written out in the case
   * of an SBML Level&nbsp;1 model.  In SBML Level&nbsp;2, rational-number
   * stoichiometries are written as MathML elements in the
   * 'stoichiometryMath' subelement.  However, as a convenience to users,
   * libSBML allows the creation and manipulation of rational-number
   * stoichiometries by supplying the numerator and denominator directly
   * rather than having to manually create an {@link ASTNode} structure.  LibSBML
   * will write out the appropriate constructs (either a combination of
   * 'stoichiometry' and 'denominator' in the case of SBML Level&nbsp;1, or a
   * 'stoichiometryMath' subelement in the case of SBML Level&nbsp;2).
   * <p>
   * @return the value of the 'denominator' attribute of this
   * {@link SpeciesReference}.
   */
 public int getDenominator() {
    return libsbmlJNI.SpeciesReference_getDenominator(swigCPtr, this);
  }

  
  /**
   * Get the value of the 'constant' attribute.
   * <p>
   * @return the value of the 'constant' attribute of this
   * {@link SpeciesReference}.
   */
 public boolean getConstant() {
    return libsbmlJNI.SpeciesReference_getConstant(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> if this
   * {@link SpeciesReference}'s 'stoichiometryMath' subelement is set
   * <p>
   * @return <code>true</code> if the 'stoichiometryMath' subelement of this
   * {@link SpeciesReference} is set, <code>false</code> otherwise.
   */
 public boolean isSetStoichiometryMath() {
    return libsbmlJNI.SpeciesReference_isSetStoichiometryMath(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> if this
   * {@link SpeciesReference}'s 'constant' attribute is set
   * <p>
   * @return <code>true</code> if the 'constant' attribute of this
   * {@link SpeciesReference} is set, <code>false</code> otherwise.
   */
 public boolean isSetConstant() {
    return libsbmlJNI.SpeciesReference_isSetConstant(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> if this
   * {@link SpeciesReference}'s 'stoichiometry' attribute is set.
   * <p>
   * @return <code>true</code> if the 'stoichiometry' attribute of this
   * {@link SpeciesReference} is set, <code>false</code> otherwise.
   */
 public boolean isSetStoichiometry() {
    return libsbmlJNI.SpeciesReference_isSetStoichiometry(swigCPtr, this);
  }

  
  /**
   * Sets the value of the 'stoichiometry' attribute of this
   * {@link SpeciesReference}.
   * <p>
   * In SBML Level 2, product and reactant stoichiometries can be specified
   * using <em>either</em> 'stoichiometry' or 'stoichiometryMath' in a
   * {@link SpeciesReference} object.  The former is to be used when a
   * stoichiometry is simply a scalar number, while the latter is for
   * occasions when it needs to be a rational number or it needs to
   * reference other mathematical expressions.  The 'stoichiometry'
   * attribute is of type <code>double</code> and should contain values greater than
   * zero (<code>0</code>).  The 'stoichiometryMath' element is implemented as an
   * element containing a MathML expression.  These two are mutually
   * exclusive; only one of 'stoichiometry' or 'stoichiometryMath' should
   * be defined in a given {@link SpeciesReference} instance.  When neither the
   * attribute nor the element is present, the value of 'stoichiometry' in
   * the {@link SpeciesReference} instance defaults to <code>1.</code>  For maximum
   * interoperability between different software tools, the 'stoichiometry'
   * attribute should be used in preference to 'stoichiometryMath' when a
   * species' stoichiometry is a simple scalar number (integer or
   * decimal).
   * <p>
   * In SBML Level 3, there is no {@link StoichiometryMath}, and {@link SpeciesReference}
   * objects have only the 'stoichiometry' attribute.
   * <p>
   * @param value the new value of the 'stoichiometry' attribute
   * <p>
   * @note In SBML Level&nbsp;2, the 'stoichiometryMath' subelement of this
   * {@link SpeciesReference} object will be unset because the 'stoichiometry'
   * attribute and the stoichiometryMath' subelement are mutually
   * exclusive.
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * </ul>
   */
 public int setStoichiometry(double value) {
    return libsbmlJNI.SpeciesReference_setStoichiometry(swigCPtr, this, value);
  }

  
  /**
   * Sets the 'stoichiometryMath' subelement of this {@link SpeciesReference}.
   * <p>
   * The Abstract Syntax Tree in <code>math</code> is copied.
   * <p>
   * In SBML Level 2, product and reactant stoichiometries can be specified
   * using <em>either</em> 'stoichiometry' or 'stoichiometryMath' in a
   * {@link SpeciesReference} object.  The former is to be used when a
   * stoichiometry is simply a scalar number, while the latter is for
   * occasions when it needs to be a rational number or it needs to
   * reference other mathematical expressions.  The 'stoichiometry'
   * attribute is of type <code>double</code> and should contain values greater than
   * zero (<code>0</code>).  The 'stoichiometryMath' element is implemented as an
   * element containing a MathML expression.  These two are mutually
   * exclusive; only one of 'stoichiometry' or 'stoichiometryMath' should
   * be defined in a given {@link SpeciesReference} instance.  When neither the
   * attribute nor the element is present, the value of 'stoichiometry' in
   * the {@link SpeciesReference} instance defaults to <code>1.</code>  For maximum
   * interoperability between different software tools, the 'stoichiometry'
   * attribute should be used in preference to 'stoichiometryMath' when a
   * species' stoichiometry is a simple scalar number (integer or
   * decimal).
   * <p>
   * In SBML Level 3, there is no {@link StoichiometryMath}, and {@link SpeciesReference}
   * objects have only the 'stoichiometry' attribute.
   * <p>
   * @param math the {@link StoichiometryMath} expression that is to be copied as the
   * content of the 'stoichiometryMath' subelement.
   * <p>
   * @note In SBML Level&nbsp;2, the 'stoichiometry' attribute of this
   * {@link SpeciesReference} object will be unset (isSetStoichiometry() will
   * return <code>false</code> although getStoichiometry() will return <code>1.0</code>) if the
   * given math is not null because the 'stoichiometry' attribute and the
   * stoichiometryMath' subelement are mutually exclusive.
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE }
   * <li> {@link  libsbmlConstants#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH }
   * <li> {@link  libsbmlConstants#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH }
   * </ul>
   */
 public int setStoichiometryMath(StoichiometryMath math) {
    return libsbmlJNI.SpeciesReference_setStoichiometryMath(swigCPtr, this, StoichiometryMath.getCPtr(math), math);
  }

  
  /**
   * Set the value of the 'denominator' attribute, for the case of a
   * rational-numbered stoichiometry or a model in SBML Level&nbsp;1.
   * <p>
   * The 'denominator' attribute is only actually written out in the case
   * of an SBML Level&nbsp;1 model.  In SBML Level&nbsp;2, rational-number
   * stoichiometries are written as MathML elements in the
   * 'stoichiometryMath' subelement.  However, as a convenience to users,
   * libSBML allows the creation and manipulation of rational-number
   * stoichiometries by supplying the numerator and denominator directly
   * rather than having to manually create an {@link ASTNode} structure.  LibSBML
   * will write out the appropriate constructs (either a combination of
   * 'stoichiometry' and 'denominator' in the case of SBML Level&nbsp;1, or
   * a 'stoichiometryMath' subelement in the case of SBML Level&nbsp;2).
   * <p>
   * @param value the scalar value 
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * </ul>
   */
 public int setDenominator(int value) {
    return libsbmlJNI.SpeciesReference_setDenominator(swigCPtr, this, value);
  }

  
  /**
   * Sets the 'constant' attribute of this {@link SpeciesReference} to the given boolean
   * <code>flag</code>.
   * <p>
   * @param flag a boolean, the value for the 'constant' attribute of this
   * {@link SpeciesReference} instance
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE }
   * </ul>
   */
 public int setConstant(boolean flag) {
    return libsbmlJNI.SpeciesReference_setConstant(swigCPtr, this, flag);
  }

  
  /**
   * Unsets the 'stoichiometryMath' subelement of this {@link SpeciesReference}.
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE }
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED }
   * </ul>
   * <p>
   * In SBML Level 2, product and reactant stoichiometries can be specified
   * using <em>either</em> 'stoichiometry' or 'stoichiometryMath' in a
   * {@link SpeciesReference} object.  The former is to be used when a
   * stoichiometry is simply a scalar number, while the latter is for
   * occasions when it needs to be a rational number or it needs to
   * reference other mathematical expressions.  The 'stoichiometry'
   * attribute is of type <code>double</code> and should contain values greater than
   * zero (<code>0</code>).  The 'stoichiometryMath' element is implemented as an
   * element containing a MathML expression.  These two are mutually
   * exclusive; only one of 'stoichiometry' or 'stoichiometryMath' should
   * be defined in a given {@link SpeciesReference} instance.  When neither the
   * attribute nor the element is present, the value of 'stoichiometry' in
   * the {@link SpeciesReference} instance defaults to <code>1.</code>  For maximum
   * interoperability between different software tools, the 'stoichiometry'
   * attribute should be used in preference to 'stoichiometryMath' when a
   * species' stoichiometry is a simple scalar number (integer or
   * decimal).
   * <p>
   * In SBML Level 3, there is no {@link StoichiometryMath}, and {@link SpeciesReference}
   * objects have only the 'stoichiometry' attribute.
   * <p>
   * @note In SBML Level&nbsp;2, the 'stoichiometry' attribute of this
   * {@link SpeciesReference} object will be reset to a default value (<code>1.0</code>) if
   * the 'stoichiometry' attribute has not been set.
   */
 public int unsetStoichiometryMath() {
    return libsbmlJNI.SpeciesReference_unsetStoichiometryMath(swigCPtr, this);
  }

  
  /**
   * Unsets the 'stoichiometry' attribute of this {@link SpeciesReference}.
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED }
   * </ul>
   * <p>
   * @note In SBML Level&nbsp;1, the 'stoichiometry' attribute of this
   * {@link SpeciesReference} object will be just reset to a default value (<code>1.0</code>)
   * and isSetStoichiometry() will still return <code>true.</code>  In SBML
   * Level&nbsp;2, the 'stoichiometry' attribute of this object will be
   * unset (which will result in isSetStoichiometry() returning <code>false</code>,
   * although getStoichiometry() will return <code>1.0</code>) if the
   * 'stoichiometryMath' subelement is set, otherwise the attribute
   * will be just reset to the default value (<code>1.0</code>) (and
   * isSetStoichiometry() will still return <code>true</code>).  In SBML
   * Level&nbsp;3, the 'stoichiometry' attribute of this object will be set
   * to <code>NaN</code> and isSetStoichiometry() will return <code>false.</code>
   */
 public int unsetStoichiometry() {
    return libsbmlJNI.SpeciesReference_unsetStoichiometry(swigCPtr, this);
  }

  
  /**
   * Creates a new, empty {@link StoichiometryMath} object, adds it to this
   * {@link SpeciesReference}, and returns it.
   * <p>
   * @return the newly created {@link StoichiometryMath} object instance
   * <p>
   * @see Reaction#addReactant(SpeciesReference sr)
   * @see Reaction#addProduct(SpeciesReference sr)
   */
 public StoichiometryMath createStoichiometryMath() {
    long cPtr = libsbmlJNI.SpeciesReference_createStoichiometryMath(swigCPtr, this);
    return (cPtr == 0) ? null : new StoichiometryMath(cPtr, false);
  }

  
  /**
   * Sets the value of the 'annotation' subelement of this SBML object to a
   * copy of <code>annotation</code>.
   * <p>
   * Any existing content of the 'annotation' subelement is discarded.
   * Unless you have taken steps to first copy and reconstitute any
   * existing annotations into the <code>annotation</code> that is about to be
   * assigned, it is likely that performing such wholesale replacement is
   * unfriendly towards other software applications whose annotations are
   * discarded.  An alternative may be to use appendAnnotation().
   * <p>
   * @param annotation an XML structure that is to be used as the content
   * of the 'annotation' subelement of this object
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * </ul>
   * <p>
   * @see #appendAnnotation(XMLNode annotation)
   * @see #appendAnnotation(String annotation)
   */
 public int setAnnotation(XMLNode annotation) {
    return libsbmlJNI.SpeciesReference_setAnnotation__SWIG_0(swigCPtr, this, XMLNode.getCPtr(annotation), annotation);
  }

  
  /**
   * Sets the value of the 'annotation' subelement of this SBML object to a
   * copy of <code>annotation</code>.
   * <p>
   * Any existing content of the 'annotation' subelement is discarded.
   * Unless you have taken steps to first copy and reconstitute any
   * existing annotations into the <code>annotation</code> that is about to be
   * assigned, it is likely that performing such wholesale replacement is
   * unfriendly towards other software applications whose annotations are
   * discarded.  An alternative may be to use appendAnnotation().
   * <p>
   * @param annotation an XML string that is to be used as the content
   * of the 'annotation' subelement of this object
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED }
   * </ul>
   * <p>
   * @see #appendAnnotation(XMLNode annotation)
   * @see #appendAnnotation(String annotation)
   */
 public int setAnnotation(String annotation) {
    return libsbmlJNI.SpeciesReference_setAnnotation__SWIG_1(swigCPtr, this, annotation);
  }

  
  /**
   * Appends annotation content to any existing content in the 'annotation'
   * subelement of this object.
   * <p>
   * The content in <code>annotation</code> is copied.  Unlike
   * {@link SpeciesReference#setAnnotation(String annotation)},
   * this method allows other annotations to be preserved when an application
   * adds its own data.
   * <p>
   * @param annotation an XML structure that is to be copied and appended
   * to the content of the 'annotation' subelement of this object
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED }
   * </ul>
   * <p>
   * @see #setAnnotation(String annotation)
   * @see #setAnnotation(XMLNode annotation)
   */
 public int appendAnnotation(XMLNode annotation) {
    return libsbmlJNI.SpeciesReference_appendAnnotation__SWIG_0(swigCPtr, this, XMLNode.getCPtr(annotation), annotation);
  }

  
  /**
   * Appends annotation content to any existing content in the 'annotation'
   * subelement of this object.
   * <p>
   * The content in <code>annotation</code> is copied.  Unlike
   * {@link SpeciesReference#setAnnotation(String annotation)}, this
   * method allows other annotations to be preserved when an application
   * adds its own data.
   * <p>
   * @param annotation an XML string that is to be copied and appended
   * to the content of the 'annotation' subelement of this object
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED }
   * </ul>
   * <p>
   * @see #setAnnotation(String annotation)
   * @see #setAnnotation(XMLNode annotation)
   */
 public int appendAnnotation(String annotation) {
    return libsbmlJNI.SpeciesReference_appendAnnotation__SWIG_1(swigCPtr, this, annotation);
  }

  
  /**
   * Returns the libSBML type code for this SBML object.
   * <p>
   * LibSBML attaches an identifying code to every
   * kind of SBML object.  These are known as <em>SBML type codes</em>.  In
   * other languages, the set of type codes is stored in an enumeration; in
   * the Java language interface for libSBML, the type codes are defined as
   * static integer constants in the interface class {@link
   * libsbmlConstants}.  The names of the type codes all begin with the
   * characters <code>SBML_.</code> 
   * <p>
   * @return the SBML type code for this object, or {@link  libsbmlConstants#SBML_UNKNOWN SBML_UNKNOWN} (default).
   * <p>
   * @see #getElementName()
   */
 public int getTypeCode() {
    return libsbmlJNI.SpeciesReference_getTypeCode(swigCPtr, this);
  }

  
  /**
   * Returns the XML element name of this object, which for
   * {@link SpeciesReference}, is always <code>'speciesReference'.</code>
   * <p>
   * @return the name of this element, i.e., <code>'speciesReference'.</code>
   */
 public String getElementName() {
    return libsbmlJNI.SpeciesReference_getElementName(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> if
   * all the required attributes for this {@link SpeciesReference} object
   * have been set.
   * <p>
   * @note The required attributes for a {@link SpeciesReference} object are:
   * <ul>
   * <li> 'species'
   * <li> 'constant' (only available SBML Level&nbsp;3)
   * </ul>
   * <p>
   * @return a boolean value indicating whether all the required
   * attributes for this object have been defined.
   */
 public boolean hasRequiredAttributes() {
    return libsbmlJNI.SpeciesReference_hasRequiredAttributes(swigCPtr, this);
  }

}
