// This is a roxen(.com) module for easy pressrelease handling

string cvs_version = "$Id: pressrelease-view.pike,v 1.11 2000/08/04 18:36:12 han Exp $";

#include <module.h>

inherit "module";
inherit "roxenlib";


string print_htmlhead(){
  // add html head
  return  "<html>\n<head>\n<title>" 
    + "Pressrelease:" 
    + "</title>\n</head>\n"
    + "<BODY BGCOLOR=\"white\">";
}

string print_htmlbot(){
  // add html bottom
  return "\n\n</body></html>\n";
  
}

int chechTaint( string input ){
  
  // we want rto remove all  &;`'\"|*?~<>^()[]{}$\n\r

  //  input = replace(input , &;`'\"|*?~<>^()[]{}$\n\r

}


// takes a title and a text and puts them in the template and returns it as a string.
string print_page(string title, string text){

  string page="";

  // file name
  string fileName = query("pagetemplate");

  // create file object
  object htmlFile = Stdio.File();

  //Stdio.File htmlFile;
  string htmlStage0;

  // open the template file and
  // read the whole file in to a string
  if( htmlFile->open( fileName, "r") ) {
    htmlStage0 = htmlFile->read();
    htmlFile->close();
  }else{
    write("Couldn't open " + fileName );
    htmlStage0 = "Couldn't open " + fileName;
  }

  // replcae the title tag in the html template
  string htmlStage1 = replace( htmlStage0, "<!--title-->" , title );

  // replcae the text tag in the html template    
  string htmlStage2 = replace( htmlStage1, "<!--text-->" , text);

  page += htmlStage2;
    
  return page;

}


mapping readFile( string fileName ){

  

  // static assignment
  //  string fileName = "/home/www/pressrel/releases/pressrelease-title-965220395.html";
  
  mapping valuesFromTheFile = ([ ]);

  // create file object
  object htmlFile = Stdio.FILE();
  
  
  // open the output file for writing
  if( htmlFile->open( fileName, "r") ) {
    
    string tili="";
    string teli="";
    int istitle=0;
    int istext=0;
    int cont=1;
    
    string inputline="";
  
    do{
      inputline = htmlFile->gets();      
      //      inputline = replace( inputline, "\n", "" );
      inputline = replace( inputline, "\r", "\n" );
      
      //      write("inputline ->" + inputline + "<-\n");
      
      // we're in line after title/text
      if( inputline == "</title>" ){
	istitle=0;
      }else if(  inputline == "</text>" ){
	istext=0;
	cont = 0;
      }
      
      // store title lines 
      if( istitle == 1){
	tili = inputline;
      }
      // store text lines 
      if( istext == 1){
	teli += inputline;
      }
    
      // we're in line before title/text
      if( inputline == "<title>" ){
	istitle=1;
      }else if(  inputline == "<text>" ){
	istext=1;
      }
    
    }while( cont == 1 );
  
    htmlFile->close();
  
    valuesFromTheFile["text"]  = teli;
    valuesFromTheFile["title"] = tili;
    
    return valuesFromTheFile;
    
  }else{
    // seek for a nonexisting file
    throw(({"Illegal file seach",backtrace()}));
  }
  
  return valuesFromTheFile;

}


void create()
{

  defvar("mountpoint", "/press/", "Mount point", TYPE_LOCATION, 
	 "Press.rel. module location in filesystem.");

  defvar("pageoutputdir", "/home/www/pressrel/releases/", "Output dir for Pressreleases", TYPE_STRING, 
	 "Output dir for Pressreleases, should be absolute path.");

  defvar("pagetemplate", "/home/www/pressrel/templates/pressrel1.html", "Template for pressreleases", TYPE_STRING, 
	 "Template for pressreleases, should be absolute path.");

}

mixed *register_module()
{
  return ({ 
    MODULE_LOCATION,
    "Pressrelease-view", 
    "This module adds an easy way to view site pressreleases",
  });
}

string query_location() { return query("mountpoint"); }

int my_time() {  return time(1); }


mapping find_file( string requestedFile , object id)
{
  
  string htmlPage="";

  string dirPath = query("pageoutputdir");


  // create file object
  object htmlFile = Stdio.File();

  object dir = Stdio.File();



  // ##################### get all #########################
  if( requestedFile == "listfiles"  ){


    htmlPage += print_htmlhead();

    if( dir->open(dirPath, "r") ) {

      array(string) entries = get_dir( dirPath );
      
      for(int i=0 ; i < sizeof( entries ) ; i=i+1 ){
	htmlPage += "File: " 
          + "<A HREF=\""
          + query_location() 
          + "/getthis?getThisFile="
	  +  entries[i] 
	  + "\" >"
	  + entries[i]
	  + "</A>"
	  + "<BR>\n";
      }

    }
    

    htmlPage += print_htmlbot();
    

    // ##################### get list of pressreleases #########################
  }else if( requestedFile == "listnews"){

    // get the info from the file
    mapping readFromTheFile;
    mixed error;

    htmlPage += print_htmlhead();
    // add content

    
    if( dir->open(dirPath, "r") ) {

      array(string) entries = get_dir( dirPath );

      entries = reverse( entries );
      
      for(int i=0 ; i < sizeof( entries ) ; i=i+1 ){
	string fileName = entries[i];
	string fileFullPath = dirPath + "/" + fileName;

	
	error = catch { readFromTheFile = readFile( fileFullPath ); };
	if (error) {
	  htmlPage += "Illigal file seach";
	  write( "Illigal file seach\n" + fileName );
	}else{
	  // print the page
	  string title = readFromTheFile["title"];
	  string date = replace(fileName, "pressrelease-title-", "");
	  string date = replace(date, ".html", "");
	  string date = replace(date, "_", " ");
	  htmlPage += "(" + date + ") "
	    + "<A HREF=\""
	    + query_location() 
	    + "/getthis?getThisFile="
	    + fileName
	    + "\" >"
	    + title
	    + "</A>"
	    //	    + "<i>File:" + fileName + "</i><BR>"
	    + "<P>";

	}
      }

    }else{
      htmlPage += "Couldn't open pressrelease dir";
    }
    

    htmlPage += print_htmlbot();


    // ##################### get list of five latest pressreleases #########################
  }else if( requestedFile == "list5news"){


    // get the info from the file
    mapping readFromTheFile;
    mixed error;

    htmlPage += print_htmlhead();
    // add content

    
    if( dir->open(dirPath, "r") ) {

      array(string) entries = get_dir( dirPath );

      entries = reverse( entries );
      
      for(int i=0 ; i < sizeof( entries ) ; i=i+1 ){
	string fileName = entries[i];
	string fileFullPath = dirPath + "/" + fileName;
	if( i >= 5 ){
	  break;
	}
	error = catch { readFromTheFile = readFile( fileFullPath ); };
	if (error) {
	  htmlPage += "Illigal file seach";
	  write( "Illigal file seach\n" + fileName );
	}else{
	  // print the page
	  string title = readFromTheFile["title"];
	  string date = replace(fileName, "pressrelease-title-", "");
	  string date = replace(date, ".html", "");
	  string date = replace(date, "_", " ");
	  htmlPage += "(" + date + ") "
	    + "<A HREF=\""
	    + query_location() 
	    + "/getthis?getThisFile="
	    + fileName
	    + "\" >"
	    + title
	    + "</A>"
	    //	    + "<i>File:" + fileName + "</i><BR>"
	    + "<P>";

	}
      }

    }else{
      htmlPage += "Couldn't open pressrelease dir";
    }
    

    htmlPage += print_htmlbot();

    // ##################### GET THIS #########################
  }else if( requestedFile == "getthis"){

    // get the requested file
    string fileName = id->variables->getThisFile;
    string fileFullPath = dirPath + "/" + fileName;

    // get the info from the file
    mapping readFromTheFile;
    mixed error;

    error = catch { 
      readFromTheFile = readFile( fileFullPath );
    };
    if (error) {
      htmlPage += "Illigal file seach";
      write( "Illigal file seach\n" + fileName );
    
    }else{

      // print the page
      string title = readFromTheFile["title"];
      string text  = readFromTheFile["text"];
      // replcae the \n in the text input
      string text2 = replace( text, "\n", "<BR>");
      string text2 = replace( text2 , "\r", "");
      
      htmlPage += print_page( title, text2 );

    }
    // ##################### ELSE #########################
  }else{

    htmlPage += print_htmlhead();
    // add content
    htmlPage += "<H1>ELSE STATEMENT ...</H1>\n"  
      + "<B><H2>h2 header</H2></B>\n";
    htmlPage += print_htmlbot();

  }


  // ##################### RETURN #########################  
  return http_string_answer( htmlPage );

}

string query_name()
{
  return query("mountpoint")+" ("+ctime(my_time())[11..15]+")";
}






