package installer;

/*
 * Welcome.java
 *
 * Created on 04 July 2002, 15:43
 */

/**
 *
 * @author  mike
 */

import java.awt.event.*;
import java.util.*;
import java.net.*;
import javax.swing.*;

public class Final extends javax.swing.JPanel implements ActionListener, InstallListener {

    /** Creates new form Welcome */
    public Final(InstallWizard wizard) {
        this.wizard = wizard;
        setBackground(java.awt.Color.white);
        xud = null;
        initComponents();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        statusPanel = new javax.swing.JPanel();
        statusPanel.setBackground(java.awt.Color.white);
        statusLine = new javax.swing.JLabel("Ready", javax.swing.JLabel.CENTER);

        setLayout(new java.awt.BorderLayout());

        statusPanel.setLayout(new java.awt.BorderLayout());

        statusLine.setText("Waiting to install. \n All Office processes must be terminated.");
        statusPanel.add(statusLine, java.awt.BorderLayout.CENTER);

        add(statusPanel, java.awt.BorderLayout.CENTER);
        nav = new NavPanel(wizard, true, true, true, InstallWizard.VERSIONS, "");
        nav.setNextListener(this);
        nav.removeCancelListener(nav);
        nav.setCancelListener(this);
        nav.navNext.setText("Install");
        add(nav, java.awt.BorderLayout.SOUTH);



    }//GEN-END:initComponents

    public java.awt.Dimension getPreferredSize() {
        return new java.awt.Dimension(InstallWizard.DEFWIDTH, InstallWizard.DEFHEIGHT);
    }

    public void actionPerformed(ActionEvent e) {
    // navNext is "Install"
        if (e.getSource() == nav.navNext)
    {
            JProgressBar progressBar=new JProgressBar();
            progressBar.setMaximum(10);
            progressBar.setValue(0);
            statusPanel.add(progressBar, java.awt.BorderLayout.SOUTH);
            nav.enableNext(false);
            nav.enableBack(false);
            nav.enableCancel(false);
            ArrayList locations = wizard.getLocations();
            //System.out.println("here "+locations.size());
            // Returned 1
            String progpath=null;
            String path=null;
            String classespath=null;
            for (int i =0;i<locations.size();i++){
                path= (String)locations.get(i);
            //InstallWizard.currentPath = path;
            xud = new XmlUpdater(path, statusLine,progressBar,InstallWizard.bNetworkInstall,InstallWizard.bBindingsInstall);
        xud.addInstallListener(this);
        InstallWizard.setInstallStarted(true);
        InstallWizard.setPatchedTypes(false);
        InstallWizard.setPatchedJava(false);
        InstallWizard.setPatchedRDB(false);
        xud.start();
            }
        }

    // set to "Exit" at end of installation process
    if (e.getSource() == nav.navCancel) {
        int answer = JOptionPane.showConfirmDialog(wizard, "Are you sure you want to exit?");
        if (answer == JOptionPane.YES_OPTION)
        {
            wizard.exitForm(null);
        }
        else
        {
            return;
        }
    }
    }// actionPerformed


    public void installationComplete(InstallationEvent ev) {
        //System.out.println("Detected installation complete");
    if( InstUtil.hasNetbeansInstallation() ) {
        //System.out.println("Detected installation complete (IDE(s) detected)");
        nav.removeCancelListener(this);
        nav.setCancelListener(nav);
        nav.navCancel.setText("Finish");
        nav.enableIDE(true);
        nav.enableCancel(true);
        xud = null;
    }
    else {
        //System.out.println("Detected installation complete (No IDE(s) detected)");
        nav.removeCancelListener(this);
        nav.setCancelListener(nav);
        nav.navCancel.setText("Finish");
        nav.enableCancel(true);
        xud = null;
    }
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel statusPanel;
    private javax.swing.JLabel statusLine;
    private InstallWizard wizard;
    private NavPanel nav;
    private XmlUpdater xud;
    // End of variables declaration//GEN-END:variables

}
