package Locales::DB::Language::be;

# Auto generated from CLDR

$Locales::DB::Language::be::VERSION = '0.09';

$Locales::DB::Language::be::cldr_version = '2.0';

%Locales::DB::Language::be::misc_info = (
    'characters'   => { 'more_information' => "\?" },
    'cldr_formats' => {
        '_decimal_format_decimal' => "\,",
        '_decimal_format_group'   => ' ',
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#0\.\#\#\#",
        'ellipsis'                => {
            'final'   => "\{0\}…",
            'initial' => "…\{0\}",
            'medial'  => "\{0\}…\{1\}"
        },
        'language' => "Мова\:\ \{0\}",
        'list'     => {
            2        => "\{0\}\ and\ \{1\}",
            'end'    => "\{0\}\,\ and\ \{1\}",
            'middle' => "\{0\}\,\ \{1\}",
            'start'  => "\{0\}\,\ \{1\}"
        },
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "Рэгіён\:\ \{0\}"
    },
    'delimiters' => {
        'alternate_quotation_end'   => '»',
        'alternate_quotation_start' => '«',
        'quotation_end'             => '”',
        'quotation_start'           => '„'
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'plural_forms' => {
        'category_list' => [
            'one',
            'few',
            'many',
            'other'
        ],
        'category_rules' => {
            'few'  => "n\ mod\ 10\ in\ 2\.\.4\ and\ n\ mod\ 100\ not\ in\ 12\.\.14",
            'many' => "n\ mod\ 10\ is\ 0\ or\ n\ mod\ 10\ in\ 5\.\.9\ or\ n\ mod\ 100\ in\ 11\.\.14",
            'one'  => "n\ mod\ 10\ is\ 1\ and\ n\ mod\ 100\ is\ not\ 11"
        },
        'category_rules_compiled' => {
            'few' => sub {
                if ( ( ( int( $_[0] ) == $_[0] && ( $_[0] % 10 ) >= 2 && ( $_[0] % 10 ) <= 4 ) && ( int( $_[0] ) != $_[0] || ( $_[0] % 100 ) < 12 || ( $_[0] % 100 ) > 14 ) ) ) { return 'few'; }
                return;
            },
            'many' => sub {
                if ( ( ( ( $_[0] % 10 ) == 0 ) ) || ( ( int( $_[0] ) == $_[0] && ( $_[0] % 10 ) >= 5 && ( $_[0] % 10 ) <= 9 ) ) || ( ( int( $_[0] ) == $_[0] && ( $_[0] % 100 ) >= 11 && ( $_[0] % 100 ) <= 14 ) ) ) { return 'many'; }
                return;
            },
            'one' => sub {
                if ( ( ( ( $_[0] % 10 ) == 1 ) && ( ( $_[0] % 100 ) != 11 ) ) ) { return 'one'; }
                return;
              }
        }
    },
    'posix' => {
        'nostr'  => "не\:н",
        'yesstr' => "так\:т"
    },
);

%Locales::DB::Language::be::code_to_name = (
    'aa'    => 'Afar',
    'ab'    => 'абхазская',
    'ace'   => 'Achinese',
    'ach'   => 'Acoli',
    'ada'   => 'Adangme',
    'ady'   => 'адыгейская',
    'ae'    => 'Avestan',
    'af'    => 'афрыкаанс',
    'afa'   => "афра\-азіяцкая\ мова",
    'afh'   => 'Afrihili',
    'agq'   => 'Aghem',
    'ain'   => 'Ainu',
    'ak'    => 'Akan',
    'akk'   => 'акадзкая',
    'ale'   => 'алеуцкая',
    'alg'   => "Algonquian\ Language",
    'alt'   => "Southern\ Altai",
    'am'    => 'амхарская',
    'an'    => 'арагонская',
    'ang'   => 'стараанглійская',
    'anp'   => 'Angika',
    'apa'   => "Apache\ Language",
    'ar'    => 'арабская',
    'arc'   => 'арамейская',
    'arn'   => 'Araucanian',
    'arp'   => 'Arapaho',
    'art'   => "штучная\ мова",
    'arw'   => 'Arawak',
    'as'    => 'асамская',
    'asa'   => 'Asu',
    'ast'   => 'астурыйская',
    'ath'   => "Athapascan\ Language",
    'aus'   => 'аўстралійская',
    'av'    => 'аварская',
    'awa'   => 'Awadhi',
    'ay'    => 'аймара',
    'az'    => 'азербайджанская',
    'ba'    => 'башкірская',
    'bad'   => 'Banda',
    'bai'   => "Bamileke\ Language",
    'bal'   => 'Baluchi',
    'ban'   => 'Balinese',
    'bas'   => 'Basaa',
    'bat'   => "Baltic\ Language",
    'be'    => 'беларуская',
    'bej'   => 'Beja',
    'bem'   => 'Bemba',
    'ber'   => 'Berber',
    'bez'   => 'Bena',
    'bg'    => 'балгарская',
    'bh'    => 'біхары',
    'bho'   => 'Bhojpuri',
    'bi'    => 'Bislama',
    'bik'   => 'Bikol',
    'bin'   => 'Bini',
    'bla'   => 'Siksika',
    'bm'    => 'Bambara',
    'bn'    => 'бенгальская',
    'bnt'   => 'Bantu',
    'bo'    => 'Tibetan',
    'br'    => 'брэтонская',
    'bra'   => 'Braj',
    'brx'   => 'Bodo',
    'bs'    => 'баснійская',
    'btk'   => 'Batak',
    'bua'   => 'бурацкая',
    'bug'   => 'Buginese',
    'byn'   => 'Blin',
    'ca'    => 'каталонская',
    'cad'   => 'Caddo',
    'cai'   => "мова\ індзейцаў\ Цэнтральнай\ Амерыкі",
    'car'   => 'Carib',
    'cau'   => "каўказская\ мова",
    'cay'   => 'Cayuga',
    'cch'   => 'Atsam',
    'ce'    => 'чачэнская',
    'ceb'   => 'Cebuano',
    'cel'   => "кельцкая\ мова",
    'cgg'   => 'Chiga',
    'ch'    => 'Chamorro',
    'chb'   => 'чыбча',
    'chg'   => 'Chagatai',
    'chk'   => 'Chuukese',
    'chm'   => 'Mari',
    'chn'   => "Chinook\ Jargon",
    'cho'   => 'Choctaw',
    'chp'   => 'Chipewyan',
    'chr'   => 'Cherokee',
    'chy'   => 'Cheyenne',
    'cmc'   => "Chamic\ Language",
    'co'    => 'Corsican',
    'cop'   => 'копцкая',
    'cpe'   => "English\-based\ Creole\ or\ Pidgin",
    'cpf'   => "French\-based\ Creole\ or\ Pidgin",
    'cpp'   => "Portuguese\-based\ Creole\ or\ Pidgin",
    'cr'    => 'Cree',
    'crh'   => "Crimean\ Turkish",
    'crp'   => "Creole\ or\ Pidgin",
    'cs'    => 'чэшская',
    'csb'   => 'Kashubian',
    'cu'    => "Church\ Slavic",
    'cus'   => "кушыцкая\ мова",
    'cv'    => 'чувашская',
    'cy'    => 'валійская',
    'da'    => 'дацкая',
    'dak'   => 'Dakota',
    'dar'   => 'Dargwa',
    'dav'   => 'Taita',
    'day'   => 'Dayak',
    'de'    => 'нямецкая',
    'de_at' => "нямецкая\ \(аўстр\.\)",
    'de_ch' => "нямецкая\ \(швейц\.\)",
    'del'   => 'Delaware',
    'den'   => 'Slave',
    'dgr'   => 'Dogrib',
    'din'   => 'Dinka',
    'dje'   => 'Zarma',
    'doi'   => 'Dogri',
    'dra'   => "Dravidian\ Language",
    'dsb'   => "Lower\ Sorbian",
    'dua'   => 'Duala',
    'dum'   => "Middle\ Dutch",
    'dv'    => 'Divehi',
    'dyo'   => "Jola\-Fonyi",
    'dyu'   => 'Dyula',
    'dz'    => 'Dzongkha',
    'ebu'   => 'Embu',
    'ee'    => 'Ewe',
    'efi'   => 'Efik',
    'egy'   => 'стараэгіпецкая',
    'eka'   => 'Ekajuk',
    'el'    => 'грэцкая',
    'elx'   => 'Elamite',
    'en'    => 'англійская',
    'en_au' => "англійская\ \(аўстрал\.\)",
    'en_ca' => "англійская\ \(канад\.\)",
    'en_gb' => "англійская\ \(Вялікабрытанія\)",
    'en_us' => "англійская\ \(ЗША\)",
    'enm'   => "Middle\ English",
    'eo'    => 'эсперанта',
    'es'    => 'іспанская',
    'es_es' => "Iberian\ Spanish",
    'et'    => 'эстонская',
    'eu'    => 'баскская',
    'ewo'   => 'Ewondo',
    'fa'    => 'фарсі',
    'fan'   => 'Fang',
    'fat'   => 'Fanti',
    'ff'    => 'Fulah',
    'fi'    => 'фінская',
    'fil'   => 'тагальская',
    'fiu'   => "Finno\-Ugrian\ Language",
    'fj'    => 'Fijian',
    'fo'    => 'фарэрская',
    'fon'   => 'Fon',
    'fr'    => 'французская',
    'fr_ca' => "французская\ \(канад\.\)",
    'fr_ch' => "французская\ \(швейц\.\)",
    'frm'   => "Middle\ French",
    'fro'   => 'старафранцузская',
    'frr'   => "Northern\ Frisian",
    'frs'   => "Eastern\ Frisian",
    'fur'   => 'Friulian',
    'fy'    => 'фрызская',
    'ga'    => 'ірландская',
    'gaa'   => 'Ga',
    'gay'   => 'Gayo',
    'gba'   => 'Gbaya',
    'gd'    => "шатландская\ гэльская",
    'gem'   => "Germanic\ Language",
    'gez'   => 'Geez',
    'gil'   => 'Gilbertese',
    'gl'    => 'галісійская',
    'gmh'   => "Middle\ High\ German",
    'gn'    => 'гуарані',
    'goh'   => "Old\ High\ German",
    'gon'   => 'Gondi',
    'gor'   => 'Gorontalo',
    'got'   => 'Gothic',
    'grb'   => 'Grebo',
    'grc'   => 'старагрэцкая',
    'gsw'   => "Swiss\ German",
    'gu'    => 'гуяраці',
    'guz'   => 'Gusii',
    'gv'    => 'Manx',
    'gwi'   => "Gwich\Ê\¼in",
    'ha'    => 'Hausa',
    'hai'   => 'Haida',
    'haw'   => 'Hawaiian',
    'he'    => 'іўрыт',
    'hi'    => 'хіндзі',
    'hil'   => 'Hiligaynon',
    'him'   => 'Himachali',
    'hit'   => 'Hittite',
    'hmn'   => 'Hmong',
    'ho'    => "Hiri\ Motu",
    'hr'    => 'харвацкая',
    'hsb'   => "Upper\ Sorbian",
    'ht'    => 'Haitian',
    'hu'    => 'венгерская',
    'hup'   => 'Hupa',
    'hy'    => 'армянская',
    'hz'    => 'Herero',
    'ia'    => 'інтэрлінгва',
    'iba'   => 'Iban',
    'id'    => 'інданезійская',
    'ie'    => 'інтэрлінгве',
    'ig'    => 'Igbo',
    'ii'    => "Sichuan\ Yi",
    'ijo'   => 'Ijo',
    'ik'    => 'Inupiaq',
    'ilo'   => 'Iloko',
    'inc'   => "Indic\ Language",
    'ine'   => "Indo\-European\ Language",
    'inh'   => 'Ingush',
    'io'    => 'Ido',
    'ira'   => "Iranian\ Language",
    'iro'   => "Iroquoian\ Language",
    'is'    => 'ісландская',
    'it'    => 'італьянская',
    'iu'    => 'Inuktitut',
    'ja'    => 'японская',
    'jbo'   => 'Lojban',
    'jmc'   => 'Machame',
    'jpr'   => "Judeo\-Persian",
    'jrb'   => "Judeo\-Arabic",
    'jv'    => 'яванская',
    'ka'    => 'грузінская',
    'kaa'   => "Kara\-Kalpak",
    'kab'   => 'Kabyle',
    'kac'   => 'Kachin',
    'kaj'   => 'Jju',
    'kam'   => 'Kamba',
    'kar'   => 'Karen',
    'kaw'   => 'Kawi',
    'kbd'   => 'Kabardian',
    'kcg'   => 'Tyap',
    'kde'   => 'Makonde',
    'kea'   => 'Kabuverdianu',
    'kfo'   => 'Koro',
    'kg'    => 'Kongo',
    'kha'   => 'Khasi',
    'khi'   => "Khoisan\ Language",
    'kho'   => 'Khotanese',
    'khq'   => "Koyra\ Chiini",
    'ki'    => 'Kikuyu',
    'kj'    => 'Kuanyama',
    'kk'    => 'казахская',
    'kl'    => 'Kalaallisut',
    'kln'   => 'Kalenjin',
    'km'    => 'Khmer',
    'kmb'   => 'Kimbundu',
    'kn'    => 'каннада',
    'ko'    => 'карэйская',
    'kok'   => 'Konkani',
    'kos'   => 'Kosraean',
    'kpe'   => 'Kpelle',
    'kr'    => 'Kanuri',
    'krc'   => "Karachay\-Balkar",
    'krl'   => 'Karelian',
    'kro'   => 'Kru',
    'kru'   => 'Kurukh',
    'ks'    => 'Kashmiri',
    'ksb'   => 'Shambala',
    'ksf'   => 'Bafia',
    'ksh'   => 'Colognian',
    'ku'    => 'курдская',
    'kum'   => 'Kumyk',
    'kut'   => 'Kutenai',
    'kv'    => 'Komi',
    'kw'    => 'Cornish',
    'ky'    => 'Kirghiz',
    'la'    => 'лацінская',
    'lad'   => 'Ladino',
    'lag'   => 'Langi',
    'lah'   => 'Lahnda',
    'lam'   => 'Lamba',
    'lb'    => 'Luxembourgish',
    'lez'   => 'Lezghian',
    'lg'    => 'Ganda',
    'li'    => 'Limburgish',
    'ln'    => 'лінгала',
    'lo'    => 'лаоская',
    'lol'   => 'монга',
    'loz'   => 'Lozi',
    'lt'    => 'літоўская',
    'lu'    => "Luba\-Katanga",
    'lua'   => "Luba\-Lulua",
    'lui'   => 'Luiseno',
    'lun'   => 'Lunda',
    'luo'   => 'луо',
    'lus'   => 'Lushai',
    'luy'   => 'Luyia',
    'lv'    => 'латышская',
    'mad'   => 'Madurese',
    'mag'   => 'Magahi',
    'mai'   => 'Maithili',
    'mak'   => 'Makasar',
    'man'   => 'мандынга',
    'map'   => 'аўстранезійская',
    'mas'   => 'масаі',
    'mdf'   => 'Moksha',
    'mdr'   => 'Mandar',
    'men'   => 'мендэ',
    'mer'   => 'Meru',
    'mfe'   => 'Morisyen',
    'mg'    => 'мальгашская',
    'mga'   => "Middle\ Irish",
    'mgh'   => "Makhuwa\-Meetto",
    'mh'    => 'Marshallese',
    'mi'    => 'Maori',
    'mic'   => 'Micmac',
    'min'   => 'Minangkabau',
    'mis'   => "Miscellaneous\ Language",
    'mk'    => 'македонская',
    'mkh'   => "Mon\-Khmer\ Language",
    'ml'    => 'малаяламская',
    'mn'    => 'мангольская',
    'mnc'   => 'Manchu',
    'mni'   => 'Manipuri',
    'mno'   => "Manobo\ Language",
    'mo'    => 'малдаўская',
    'moh'   => 'Mohawk',
    'mos'   => 'мосі',
    'mr'    => 'маратхі',
    'ms'    => 'малайская',
    'mt'    => 'мальтыйская',
    'mua'   => 'Mundang',
    'mul'   => "Multiple\ Languages",
    'mun'   => "Munda\ Language",
    'mus'   => 'Creek',
    'mwl'   => 'Mirandese',
    'mwr'   => 'Marwari',
    'my'    => 'Burmese',
    'myn'   => "Mayan\ Language",
    'myv'   => 'Erzya',
    'na'    => 'Nauru',
    'nah'   => 'Nahuatl',
    'nai'   => "мова\ індзейцаў\ Паўночнай\ Амерыкі",
    'nap'   => 'Neapolitan',
    'naq'   => 'Nama',
    'nb'    => "нарвэская\ букмал",
    'nd'    => "North\ Ndebele",
    'nds'   => "Low\ German",
    'ne'    => 'непальская',
    'new'   => 'Newari',
    'ng'    => 'Ndonga',
    'nia'   => 'Nias',
    'nic'   => "Niger\-Kordofanian\ Language",
    'niu'   => 'Niuean',
    'nl'    => 'галандская',
    'nl_be' => 'фламандская',
    'nmg'   => 'Kwasio',
    'nn'    => "нарвежская\ \(нюнорск\)",
    'no'    => 'нарвежская',
    'nog'   => 'нагайская',
    'non'   => 'старанарвежская',
    'nqo'   => "N\â\\Ko",
    'nr'    => "South\ Ndebele",
    'nso'   => "Northern\ Sotho",
    'nub'   => "нубійская\ мова",
    'nus'   => 'Nuer',
    'nv'    => 'Navajo',
    'nwc'   => "Classical\ Newari",
    'ny'    => 'Nyanja',
    'nym'   => 'Nyamwezi',
    'nyn'   => 'Nyankole',
    'nyo'   => 'Nyoro',
    'nzi'   => 'Nzima',
    'oc'    => 'правансальская',
    'oj'    => 'аджыбве',
    'om'    => 'Oromo',
    'or'    => 'орыя',
    'os'    => 'асецінская',
    'osa'   => 'Osage',
    'ota'   => "Ottoman\ Turkish",
    'oto'   => "Otomian\ Language",
    'pa'    => 'панджабі',
    'paa'   => "Papuan\ Language",
    'pag'   => 'Pangasinan',
    'pal'   => 'Pahlavi',
    'pam'   => 'Pampanga',
    'pap'   => 'Papiamento',
    'pau'   => 'Palauan',
    'peo'   => 'стараперсідская',
    'phi'   => "Philippine\ Language",
    'phn'   => 'фінікійская',
    'pi'    => 'Pali',
    'pl'    => 'польская',
    'pon'   => 'Pohnpeian',
    'pra'   => "Prakrit\ Language",
    'pro'   => 'стараправансальская',
    'ps'    => 'пушту',
    'pt'    => 'партугальская',
    'pt_br' => "партугальская\ \(бразіл\.\)",
    'pt_pt' => "Iberian\ Portuguese",
    'qu'    => 'кечуа',
    'raj'   => 'раджастханская',
    'rap'   => 'Rapanui',
    'rar'   => 'Rarotongan',
    'rm'    => "рэта\-раманская",
    'rn'    => 'Rundi',
    'ro'    => 'румынская',
    'roa'   => "Romance\ Language",
    'rof'   => 'Rombo',
    'rom'   => 'Romany',
    'ru'    => 'руская',
    'rup'   => 'Aromanian',
    'rw'    => 'Kinyarwanda',
    'rwk'   => 'Rwa',
    'sa'    => 'санскрыт',
    'sad'   => 'Sandawe',
    'sah'   => 'якуцкая',
    'sai'   => "мова\ індзейцаў\ Паўднёвай\ Амерыкі",
    'sal'   => "Salishan\ Language",
    'sam'   => "Samaritan\ Aramaic",
    'saq'   => 'Samburu',
    'sas'   => 'Sasak',
    'sat'   => 'Santali',
    'sbp'   => 'Sangu',
    'sc'    => 'Sardinian',
    'scn'   => 'Sicilian',
    'sco'   => 'Scots',
    'sd'    => 'сіндхі',
    'se'    => "Northern\ Sami",
    'see'   => 'Seneca',
    'seh'   => 'Sena',
    'sel'   => 'Selkup',
    'sem'   => "семіцкая\ мова",
    'ses'   => "Koyraboro\ Senni",
    'sg'    => 'Sango',
    'sga'   => 'стараірландская',
    'sgn'   => "знакавая\ мова",
    'sh'    => "сербска\-харвацкая",
    'shi'   => 'Tachelhit',
    'shn'   => 'Shan',
    'si'    => 'сінгальская',
    'sid'   => 'Sidamo',
    'sio'   => "Siouan\ Language",
    'sit'   => "кітайска\-тыбецкая\ мова",
    'sk'    => 'славацкая',
    'sl'    => 'славенская',
    'sla'   => "славянская\ мова",
    'sm'    => 'Samoan',
    'sma'   => "Southern\ Sami",
    'smi'   => "Sami\ Language",
    'smj'   => "Lule\ Sami",
    'smn'   => "Inari\ Sami",
    'sms'   => "Skolt\ Sami",
    'sn'    => 'Shona',
    'snk'   => 'Soninke',
    'so'    => 'самалійская',
    'sog'   => 'Sogdien',
    'son'   => 'Songhai',
    'sq'    => 'албанская',
    'sr'    => 'сербская',
    'srn'   => "Sranan\ Tongo",
    'srr'   => 'Serer',
    'ss'    => 'Swati',
    'ssa'   => "Nilo\-Saharan\ Language",
    'ssy'   => 'Saho',
    'st'    => "Southern\ Sotho",
    'su'    => 'суданская',
    'suk'   => 'Sukuma',
    'sus'   => 'Susu',
    'sux'   => 'шумерская',
    'sv'    => 'шведская',
    'sw'    => 'суахілі',
    'swb'   => 'Comorian',
    'swc'   => "Congo\ Swahili",
    'syc'   => "Classical\ Syriac",
    'syr'   => 'Syriac',
    'ta'    => 'тамільская',
    'tai'   => "мова\ таі",
    'te'    => 'тэлугу',
    'tem'   => 'Timne',
    'teo'   => 'Teso',
    'ter'   => 'Tereno',
    'tet'   => 'Tetum',
    'tg'    => 'таджыкская',
    'th'    => 'тайская',
    'ti'    => 'тыгрынья',
    'tig'   => 'Tigre',
    'tiv'   => 'Tiv',
    'tk'    => 'туркменская',
    'tkl'   => 'Tokelau',
    'tl'    => 'Tagalog',
    'tlh'   => 'клінгон',
    'tli'   => 'Tlingit',
    'tmh'   => 'Tamashek',
    'tn'    => 'Tswana',
    'to'    => 'Tonga',
    'tog'   => "Nyasa\ Tonga",
    'tpi'   => "Tok\ Pisin",
    'tr'    => 'турэцкая',
    'trv'   => 'Taroko',
    'ts'    => 'Tsonga',
    'tsi'   => 'Tsimshian',
    'tt'    => 'татарская',
    'tum'   => 'Tumbuka',
    'tup'   => "мова\ тупі",
    'tut'   => "алтайская\ мова",
    'tvl'   => 'Tuvalu',
    'tw'    => 'Twi',
    'twq'   => 'Tasawaq',
    'ty'    => 'Tahitian',
    'tyv'   => 'тувінская',
    'tzm'   => "Central\ Morocco\ Tamazight",
    'udm'   => 'Udmurt',
    'ug'    => 'уйгурская',
    'uga'   => 'Ugaritic',
    'uk'    => 'украінская',
    'umb'   => 'Umbundu',
    'und'   => "невядомая\ мова",
    'ur'    => 'урду',
    'uz'    => 'узбекская',
    'vai'   => 'Vai',
    've'    => 'Venda',
    'vi'    => "в\'етнамская",
    'vo'    => 'валапюк',
    'vot'   => 'Votic',
    'vun'   => 'Vunjo',
    'wa'    => 'Walloon',
    'wae'   => 'Walser',
    'wak'   => "Wakashan\ Language",
    'wal'   => 'Walamo',
    'war'   => 'Waray',
    'was'   => 'Washo',
    'wen'   => "Sorbian\ Language",
    'wo'    => 'Wolof',
    'xal'   => 'Kalmyk',
    'xh'    => 'хоса',
    'xog'   => 'Soga',
    'yao'   => 'Yao',
    'yap'   => 'Yapese',
    'yav'   => 'Yangben',
    'yi'    => 'ідыш',
    'yo'    => 'Yoruba',
    'ypk'   => "Yupik\ Language",
    'yue'   => 'Cantonese',
    'za'    => 'Zhuang',
    'zap'   => 'сапатэкаў',
    'zbl'   => 'Blissymbols',
    'zen'   => 'Zenaga',
    'zh'    => 'кітайская',
    'znd'   => 'Zande',
    'zu'    => 'зулу',
    'zun'   => 'Zuni',
    'zxx'   => "No\ linguistic\ content",
    'zza'   => 'Zaza',
);

%Locales::DB::Language::be::name_to_code = (
    'achinese'                                                       => 'ace',
    'acoli'                                                          => 'ach',
    'adangme'                                                        => 'ada',
    'afar'                                                           => 'aa',
    'afrihili'                                                       => 'afh',
    'aghem'                                                          => 'agq',
    'ainu'                                                           => 'ain',
    'akan'                                                           => 'ak',
    'algonquianlanguage'                                             => 'alg',
    'angika'                                                         => 'anp',
    'apachelanguage'                                                 => 'apa',
    'arapaho'                                                        => 'arp',
    'araucanian'                                                     => 'arn',
    'arawak'                                                         => 'arw',
    'aromanian'                                                      => 'rup',
    'asu'                                                            => 'asa',
    'athapascanlanguage'                                             => 'ath',
    'atsam'                                                          => 'cch',
    'avestan'                                                        => 'ae',
    'awadhi'                                                         => 'awa',
    'bafia'                                                          => 'ksf',
    'balinese'                                                       => 'ban',
    'balticlanguage'                                                 => 'bat',
    'baluchi'                                                        => 'bal',
    'bambara'                                                        => 'bm',
    'bamilekelanguage'                                               => 'bai',
    'banda'                                                          => 'bad',
    'bantu'                                                          => 'bnt',
    'basaa'                                                          => 'bas',
    'batak'                                                          => 'btk',
    'beja'                                                           => 'bej',
    'bemba'                                                          => 'bem',
    'bena'                                                           => 'bez',
    'berber'                                                         => 'ber',
    'bhojpuri'                                                       => 'bho',
    'bikol'                                                          => 'bik',
    'bini'                                                           => 'bin',
    'bislama'                                                        => 'bi',
    'blin'                                                           => 'byn',
    'blissymbols'                                                    => 'zbl',
    'bodo'                                                           => 'brx',
    'braj'                                                           => 'bra',
    'buginese'                                                       => 'bug',
    'burmese'                                                        => 'my',
    'caddo'                                                          => 'cad',
    'cantonese'                                                      => 'yue',
    'carib'                                                          => 'car',
    'cayuga'                                                         => 'cay',
    'cebuano'                                                        => 'ceb',
    'centralmoroccotamazight'                                        => 'tzm',
    'chagatai'                                                       => 'chg',
    'chamiclanguage'                                                 => 'cmc',
    'chamorro'                                                       => 'ch',
    'cherokee'                                                       => 'chr',
    'cheyenne'                                                       => 'chy',
    'chiga'                                                          => 'cgg',
    'chinookjargon'                                                  => 'chn',
    'chipewyan'                                                      => 'chp',
    'choctaw'                                                        => 'cho',
    'churchslavic'                                                   => 'cu',
    'chuukese'                                                       => 'chk',
    'classicalnewari'                                                => 'nwc',
    'classicalsyriac'                                                => 'syc',
    'colognian'                                                      => 'ksh',
    'comorian'                                                       => 'swb',
    'congoswahili'                                                   => 'swc',
    'cornish'                                                        => 'kw',
    'corsican'                                                       => 'co',
    'cree'                                                           => 'cr',
    'creek'                                                          => 'mus',
    'creoleorpidgin'                                                 => 'crp',
    'crimeanturkish'                                                 => 'crh',
    'dakota'                                                         => 'dak',
    'dargwa'                                                         => 'dar',
    'dayak'                                                          => 'day',
    'delaware'                                                       => 'del',
    'dinka'                                                          => 'din',
    'divehi'                                                         => 'dv',
    'dogri'                                                          => 'doi',
    'dogrib'                                                         => 'dgr',
    'dravidianlanguage'                                              => 'dra',
    'duala'                                                          => 'dua',
    'dyula'                                                          => 'dyu',
    'dzongkha'                                                       => 'dz',
    'easternfrisian'                                                 => 'frs',
    'efik'                                                           => 'efi',
    'ekajuk'                                                         => 'eka',
    'elamite'                                                        => 'elx',
    'embu'                                                           => 'ebu',
    'englishbasedcreoleorpidgin'                                     => 'cpe',
    'erzya'                                                          => 'myv',
    'ewe'                                                            => 'ee',
    'ewondo'                                                         => 'ewo',
    'fang'                                                           => 'fan',
    'fanti'                                                          => 'fat',
    'fijian'                                                         => 'fj',
    'finnougrianlanguage'                                            => 'fiu',
    'fon'                                                            => 'fon',
    'frenchbasedcreoleorpidgin'                                      => 'cpf',
    'friulian'                                                       => 'fur',
    'fulah'                                                          => 'ff',
    'ga'                                                             => 'gaa',
    'ganda'                                                          => 'lg',
    'gayo'                                                           => 'gay',
    'gbaya'                                                          => 'gba',
    'geez'                                                           => 'gez',
    'germaniclanguage'                                               => 'gem',
    'gilbertese'                                                     => 'gil',
    'gondi'                                                          => 'gon',
    'gorontalo'                                                      => 'gor',
    'gothic'                                                         => 'got',
    'grebo'                                                          => 'grb',
    'gusii'                                                          => 'guz',
    "gwich\Ê\¼in"                                                  => 'gwi',
    'haida'                                                          => 'hai',
    'haitian'                                                        => 'ht',
    'hausa'                                                          => 'ha',
    'hawaiian'                                                       => 'haw',
    'herero'                                                         => 'hz',
    'hiligaynon'                                                     => 'hil',
    'himachali'                                                      => 'him',
    'hirimotu'                                                       => 'ho',
    'hittite'                                                        => 'hit',
    'hmong'                                                          => 'hmn',
    'hupa'                                                           => 'hup',
    'iban'                                                           => 'iba',
    'iberianportuguese'                                              => 'pt_pt',
    'iberianspanish'                                                 => 'es_es',
    'ido'                                                            => 'io',
    'igbo'                                                           => 'ig',
    'ijo'                                                            => 'ijo',
    'iloko'                                                          => 'ilo',
    'inarisami'                                                      => 'smn',
    'indiclanguage'                                                  => 'inc',
    'indoeuropeanlanguage'                                           => 'ine',
    'ingush'                                                         => 'inh',
    'inuktitut'                                                      => 'iu',
    'inupiaq'                                                        => 'ik',
    'iranianlanguage'                                                => 'ira',
    'iroquoianlanguage'                                              => 'iro',
    'jju'                                                            => 'kaj',
    'jolafonyi'                                                      => 'dyo',
    'judeoarabic'                                                    => 'jrb',
    'judeopersian'                                                   => 'jpr',
    'kabardian'                                                      => 'kbd',
    'kabuverdianu'                                                   => 'kea',
    'kabyle'                                                         => 'kab',
    'kachin'                                                         => 'kac',
    'kalaallisut'                                                    => 'kl',
    'kalenjin'                                                       => 'kln',
    'kalmyk'                                                         => 'xal',
    'kamba'                                                          => 'kam',
    'kanuri'                                                         => 'kr',
    'karachaybalkar'                                                 => 'krc',
    'karakalpak'                                                     => 'kaa',
    'karelian'                                                       => 'krl',
    'karen'                                                          => 'kar',
    'kashmiri'                                                       => 'ks',
    'kashubian'                                                      => 'csb',
    'kawi'                                                           => 'kaw',
    'khasi'                                                          => 'kha',
    'khmer'                                                          => 'km',
    'khoisanlanguage'                                                => 'khi',
    'khotanese'                                                      => 'kho',
    'kikuyu'                                                         => 'ki',
    'kimbundu'                                                       => 'kmb',
    'kinyarwanda'                                                    => 'rw',
    'kirghiz'                                                        => 'ky',
    'komi'                                                           => 'kv',
    'kongo'                                                          => 'kg',
    'konkani'                                                        => 'kok',
    'koro'                                                           => 'kfo',
    'kosraean'                                                       => 'kos',
    'koyraborosenni'                                                 => 'ses',
    'koyrachiini'                                                    => 'khq',
    'kpelle'                                                         => 'kpe',
    'kru'                                                            => 'kro',
    'kuanyama'                                                       => 'kj',
    'kumyk'                                                          => 'kum',
    'kurukh'                                                         => 'kru',
    'kutenai'                                                        => 'kut',
    'kwasio'                                                         => 'nmg',
    'ladino'                                                         => 'lad',
    'lahnda'                                                         => 'lah',
    'lamba'                                                          => 'lam',
    'langi'                                                          => 'lag',
    'lezghian'                                                       => 'lez',
    'limburgish'                                                     => 'li',
    'lojban'                                                         => 'jbo',
    'lowersorbian'                                                   => 'dsb',
    'lowgerman'                                                      => 'nds',
    'lozi'                                                           => 'loz',
    'lubakatanga'                                                    => 'lu',
    'lubalulua'                                                      => 'lua',
    'luiseno'                                                        => 'lui',
    'lulesami'                                                       => 'smj',
    'lunda'                                                          => 'lun',
    'lushai'                                                         => 'lus',
    'luxembourgish'                                                  => 'lb',
    'luyia'                                                          => 'luy',
    'machame'                                                        => 'jmc',
    'madurese'                                                       => 'mad',
    'magahi'                                                         => 'mag',
    'maithili'                                                       => 'mai',
    'makasar'                                                        => 'mak',
    'makhuwameetto'                                                  => 'mgh',
    'makonde'                                                        => 'kde',
    'manchu'                                                         => 'mnc',
    'mandar'                                                         => 'mdr',
    'manipuri'                                                       => 'mni',
    'manobolanguage'                                                 => 'mno',
    'manx'                                                           => 'gv',
    'maori'                                                          => 'mi',
    'mari'                                                           => 'chm',
    'marshallese'                                                    => 'mh',
    'marwari'                                                        => 'mwr',
    'mayanlanguage'                                                  => 'myn',
    'meru'                                                           => 'mer',
    'micmac'                                                         => 'mic',
    'middledutch'                                                    => 'dum',
    'middleenglish'                                                  => 'enm',
    'middlefrench'                                                   => 'frm',
    'middlehighgerman'                                               => 'gmh',
    'middleirish'                                                    => 'mga',
    'minangkabau'                                                    => 'min',
    'mirandese'                                                      => 'mwl',
    'miscellaneouslanguage'                                          => 'mis',
    'mohawk'                                                         => 'moh',
    'moksha'                                                         => 'mdf',
    'monkhmerlanguage'                                               => 'mkh',
    'morisyen'                                                       => 'mfe',
    'multiplelanguages'                                              => 'mul',
    'mundalanguage'                                                  => 'mun',
    'mundang'                                                        => 'mua',
    'nahuatl'                                                        => 'nah',
    'nama'                                                           => 'naq',
    'nauru'                                                          => 'na',
    'navajo'                                                         => 'nv',
    'ndonga'                                                         => 'ng',
    'neapolitan'                                                     => 'nap',
    'newari'                                                         => 'new',
    'nias'                                                           => 'nia',
    'nigerkordofanianlanguage'                                       => 'nic',
    'nilosaharanlanguage'                                            => 'ssa',
    'niuean'                                                         => 'niu',
    'nolinguisticcontent'                                            => 'zxx',
    'northernfrisian'                                                => 'frr',
    'northernsami'                                                   => 'se',
    'northernsotho'                                                  => 'nso',
    'northndebele'                                                   => 'nd',
    'nuer'                                                           => 'nus',
    'nyamwezi'                                                       => 'nym',
    'nyanja'                                                         => 'ny',
    'nyankole'                                                       => 'nyn',
    'nyasatonga'                                                     => 'tog',
    'nyoro'                                                          => 'nyo',
    'nzima'                                                          => 'nzi',
    "n\â\\ko"                                                   => 'nqo',
    'oldhighgerman'                                                  => 'goh',
    'oromo'                                                          => 'om',
    'osage'                                                          => 'osa',
    'otomianlanguage'                                                => 'oto',
    'ottomanturkish'                                                 => 'ota',
    'pahlavi'                                                        => 'pal',
    'palauan'                                                        => 'pau',
    'pali'                                                           => 'pi',
    'pampanga'                                                       => 'pam',
    'pangasinan'                                                     => 'pag',
    'papiamento'                                                     => 'pap',
    'papuanlanguage'                                                 => 'paa',
    'philippinelanguage'                                             => 'phi',
    'pohnpeian'                                                      => 'pon',
    'portuguesebasedcreoleorpidgin'                                  => 'cpp',
    'prakritlanguage'                                                => 'pra',
    'rapanui'                                                        => 'rap',
    'rarotongan'                                                     => 'rar',
    'romancelanguage'                                                => 'roa',
    'romany'                                                         => 'rom',
    'rombo'                                                          => 'rof',
    'rundi'                                                          => 'rn',
    'rwa'                                                            => 'rwk',
    'saho'                                                           => 'ssy',
    'salishanlanguage'                                               => 'sal',
    'samaritanaramaic'                                               => 'sam',
    'samburu'                                                        => 'saq',
    'samilanguage'                                                   => 'smi',
    'samoan'                                                         => 'sm',
    'sandawe'                                                        => 'sad',
    'sango'                                                          => 'sg',
    'sangu'                                                          => 'sbp',
    'santali'                                                        => 'sat',
    'sardinian'                                                      => 'sc',
    'sasak'                                                          => 'sas',
    'scots'                                                          => 'sco',
    'selkup'                                                         => 'sel',
    'sena'                                                           => 'seh',
    'seneca'                                                         => 'see',
    'serer'                                                          => 'srr',
    'shambala'                                                       => 'ksb',
    'shan'                                                           => 'shn',
    'shona'                                                          => 'sn',
    'sichuanyi'                                                      => 'ii',
    'sicilian'                                                       => 'scn',
    'sidamo'                                                         => 'sid',
    'siksika'                                                        => 'bla',
    'siouanlanguage'                                                 => 'sio',
    'skoltsami'                                                      => 'sms',
    'slave'                                                          => 'den',
    'soga'                                                           => 'xog',
    'sogdien'                                                        => 'sog',
    'songhai'                                                        => 'son',
    'soninke'                                                        => 'snk',
    'sorbianlanguage'                                                => 'wen',
    'southernaltai'                                                  => 'alt',
    'southernsami'                                                   => 'sma',
    'southernsotho'                                                  => 'st',
    'southndebele'                                                   => 'nr',
    'sranantongo'                                                    => 'srn',
    'sukuma'                                                         => 'suk',
    'susu'                                                           => 'sus',
    'swati'                                                          => 'ss',
    'swissgerman'                                                    => 'gsw',
    'syriac'                                                         => 'syr',
    'tachelhit'                                                      => 'shi',
    'tagalog'                                                        => 'tl',
    'tahitian'                                                       => 'ty',
    'taita'                                                          => 'dav',
    'tamashek'                                                       => 'tmh',
    'taroko'                                                         => 'trv',
    'tasawaq'                                                        => 'twq',
    'tereno'                                                         => 'ter',
    'teso'                                                           => 'teo',
    'tetum'                                                          => 'tet',
    'tibetan'                                                        => 'bo',
    'tigre'                                                          => 'tig',
    'timne'                                                          => 'tem',
    'tiv'                                                            => 'tiv',
    'tlingit'                                                        => 'tli',
    'tokelau'                                                        => 'tkl',
    'tokpisin'                                                       => 'tpi',
    'tonga'                                                          => 'to',
    'tsimshian'                                                      => 'tsi',
    'tsonga'                                                         => 'ts',
    'tswana'                                                         => 'tn',
    'tumbuka'                                                        => 'tum',
    'tuvalu'                                                         => 'tvl',
    'twi'                                                            => 'tw',
    'tyap'                                                           => 'kcg',
    'udmurt'                                                         => 'udm',
    'ugaritic'                                                       => 'uga',
    'umbundu'                                                        => 'umb',
    'uppersorbian'                                                   => 'hsb',
    'vai'                                                            => 'vai',
    'venda'                                                          => 've',
    'votic'                                                          => 'vot',
    'vunjo'                                                          => 'vun',
    'wakashanlanguage'                                               => 'wak',
    'walamo'                                                         => 'wal',
    'walloon'                                                        => 'wa',
    'walser'                                                         => 'wae',
    'waray'                                                          => 'war',
    'washo'                                                          => 'was',
    'wolof'                                                          => 'wo',
    'yangben'                                                        => 'yav',
    'yao'                                                            => 'yao',
    'yapese'                                                         => 'yap',
    'yoruba'                                                         => 'yo',
    'yupiklanguage'                                                  => 'ypk',
    'zande'                                                          => 'znd',
    'zarma'                                                          => 'dje',
    'zaza'                                                           => 'zza',
    'zenaga'                                                         => 'zen',
    'zhuang'                                                         => 'za',
    'zuni'                                                           => 'zun',
    'абхазская'                                             => 'ab',
    'аварская'                                               => 'av',
    'аджыбве'                                                 => 'oj',
    'адыгейская'                                           => 'ady',
    'азербайджанская'                                 => 'az',
    'аймара'                                                   => 'ay',
    'акадзкая'                                               => 'akk',
    'албанская'                                             => 'sq',
    'алеуцкая'                                               => 'ale',
    'алтайскаямова'                                     => 'tut',
    'амхарская'                                             => 'am',
    'англійская'                                           => 'en',
    'англійскаяВялікабрытанія'               => 'en_gb',
    'англійскаяЗША'                                     => 'en_us',
    "англійскаяаўстрал\."                           => 'en_au',
    "англійскаяканад\."                               => 'en_ca',
    'арабская'                                               => 'ar',
    'арагонская'                                           => 'an',
    'арамейская'                                           => 'arc',
    'армянская'                                             => 'hy',
    'асамская'                                               => 'as',
    'асецінская'                                           => 'os',
    'астурыйская'                                         => 'ast',
    'афраазіяцкаямова'                               => 'afa',
    'афрыкаанс'                                             => 'af',
    'аўстралійская'                                     => 'aus',
    'аўстранезійская'                                 => 'map',
    'балгарская'                                           => 'bg',
    'баскская'                                               => 'eu',
    'баснійская'                                           => 'bs',
    'башкірская'                                           => 'ba',
    'беларуская'                                           => 'be',
    'бенгальская'                                         => 'bn',
    'брэтонская'                                           => 'br',
    'бурацкая'                                               => 'bua',
    'біхары'                                                   => 'bh',
    'валапюк'                                                 => 'vo',
    'валійская'                                             => 'cy',
    'венгерская'                                           => 'hu',
    'ветнамская'                                           => 'vi',
    'галандская'                                           => 'nl',
    'галісійская'                                         => 'gl',
    'грузінская'                                           => 'ka',
    'грэцкая'                                                 => 'el',
    'гуарані'                                                 => 'gn',
    'гуяраці'                                                 => 'gu',
    'дацкая'                                                   => 'da',
    'знакаваямова'                                       => 'sgn',
    'зулу'                                                       => 'zu',
    'казахская'                                             => 'kk',
    'каннада'                                                 => 'kn',
    'карэйская'                                             => 'ko',
    'каталонская'                                         => 'ca',
    'каўказскаямова'                                   => 'cau',
    'кельцкаямова'                                       => 'cel',
    'кечуа'                                                     => 'qu',
    'клінгон'                                                 => 'tlh',
    'копцкая'                                                 => 'cop',
    'курдская'                                               => 'ku',
    'кушыцкаямова'                                       => 'cus',
    'кітайскатыбецкаямова'                       => 'sit',
    'кітайская'                                             => 'zh',
    'лаоская'                                                 => 'lo',
    'латышская'                                             => 'lv',
    'лацінская'                                             => 'la',
    'луо'                                                         => 'luo',
    'лінгала'                                                 => 'ln',
    'літоўская'                                             => 'lt',
    'македонская'                                         => 'mk',
    'малайская'                                             => 'ms',
    'малаяламская'                                       => 'ml',
    'малдаўская'                                           => 'mo',
    'мальгашская'                                         => 'mg',
    'мальтыйская'                                         => 'mt',
    'мангольская'                                         => 'mn',
    'мандынга'                                               => 'man',
    'маратхі'                                                 => 'mr',
    'масаі'                                                     => 'mas',
    'мендэ'                                                     => 'men',
    'моватаі'                                                 => 'tai',
    'моватупі'                                               => 'tup',
    'моваіндзейцаўПаўднёвайАмерыкі'     => 'sai',
    'моваіндзейцаўПаўночнайАмерыкі'     => 'nai',
    'моваіндзейцаўЦэнтральнайАмерыкі' => 'cai',
    'монга'                                                     => 'lol',
    'мосі'                                                       => 'mos',
    'нагайская'                                             => 'nog',
    'нарвежская'                                           => 'no',
    'нарвежскаянюнорск'                             => 'nn',
    'нарвэскаябукмал'                                 => 'nb',
    'невядомаямова'                                     => 'und',
    'непальская'                                           => 'ne',
    'нубійскаямова'                                     => 'nub',
    'нямецкая'                                               => 'de',
    "нямецкаяаўстр\."                                   => 'de_at',
    "нямецкаяшвейц\."                                   => 'de_ch',
    'орыя'                                                       => 'or',
    'панджабі'                                               => 'pa',
    'партугальская'                                     => 'pt',
    "партугальскаябразіл\."                       => 'pt_br',
    'польская'                                               => 'pl',
    'правансальская'                                   => 'oc',
    'пушту'                                                     => 'ps',
    'раджастханская'                                   => 'raj',
    'румынская'                                             => 'ro',
    'руская'                                                   => 'ru',
    'рэтараманская'                                     => 'rm',
    'самалійская'                                         => 'so',
    'санскрыт'                                               => 'sa',
    'сапатэкаў'                                             => 'zap',
    'семіцкаямова'                                       => 'sem',
    'сербскахарвацкая'                               => 'sh',
    'сербская'                                               => 'sr',
    'славацкая'                                             => 'sk',
    'славенская'                                           => 'sl',
    'славянскаямова'                                   => 'sla',
    'стараанглійская'                                 => 'ang',
    'старагрэцкая'                                       => 'grc',
    'старанарвежская'                                 => 'non',
    'стараперсідская'                                 => 'peo',
    'стараправансальская'                         => 'pro',
    'старафранцузская'                               => 'fro',
    'стараэгіпецкая'                                   => 'egy',
    'стараірландская'                                 => 'sga',
    'суахілі'                                                 => 'sw',
    'суданская'                                             => 'su',
    'сінгальская'                                         => 'si',
    'сіндхі'                                                   => 'sd',
    'тагальская'                                           => 'fil',
    'таджыкская'                                           => 'tg',
    'тайская'                                                 => 'th',
    'тамільская'                                           => 'ta',
    'татарская'                                             => 'tt',
    'тувінская'                                             => 'tyv',
    'туркменская'                                         => 'tk',
    'турэцкая'                                               => 'tr',
    'тыгрынья'                                               => 'ti',
    'тэлугу'                                                   => 'te',
    'узбекская'                                             => 'uz',
    'уйгурская'                                             => 'ug',
    'украінская'                                           => 'uk',
    'урду'                                                       => 'ur',
    'фарсі'                                                     => 'fa',
    'фарэрская'                                             => 'fo',
    'фламандская'                                         => 'nl_be',
    'французская'                                         => 'fr',
    "французскаяканад\."                             => 'fr_ca',
    "французскаяшвейц\."                             => 'fr_ch',
    'фрызская'                                               => 'fy',
    'фінская'                                                 => 'fi',
    'фінікійская'                                         => 'phn',
    'харвацкая'                                             => 'hr',
    'хоса'                                                       => 'xh',
    'хіндзі'                                                   => 'hi',
    'чачэнская'                                             => 'ce',
    'чувашская'                                             => 'cv',
    'чыбча'                                                     => 'chb',
    'чэшская'                                                 => 'cs',
    'шатландскаягэльская'                         => 'gd',
    'шведская'                                               => 'sv',
    'штучнаямова'                                         => 'art',
    'шумерская'                                             => 'sux',
    'эсперанта'                                             => 'eo',
    'эстонская'                                             => 'et',
    'яванская'                                               => 'jv',
    'якуцкая'                                                 => 'sah',
    'японская'                                               => 'ja',
    'ідыш'                                                       => 'yi',
    'інданезійская'                                     => 'id',
    'інтэрлінгва'                                         => 'ia',
    'інтэрлінгве'                                         => 'ie',
    'ірландская'                                           => 'ga',
    'ісландская'                                           => 'is',
    'іспанская'                                             => 'es',
    'італьянская'                                         => 'it',
    'іўрыт'                                                     => 'he',
);

1;
