package Locales::DB::Language::de;

# Auto generated from CLDR

$Locales::DB::Language::de::VERSION = '0.08';

$Locales::DB::Language::de::cldr_version = '2.0';

%Locales::DB::Language::de::misc_info = (
    'characters'   => { 'more_information' => "\?" },
    'cldr_formats' => {
        '_decimal_format_decimal' => "\,",
        '_decimal_format_group'   => "\.",
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#0\.\#\#\#",
        'ellipsis'                => {
            'final'   => "\{0\}\ …",
            'initial' => "…\ \{0\}",
            'medial'  => "\{0\}\ …\ \{1\}"
        },
        'language' => "Sprache\:\ \{0\}",
        'list'     => {
            2        => "\{0\}\ und\ \{1\}",
            'end'    => "\{0\}\ und\ \{1\}",
            'middle' => "\{0\}\,\ \{1\}",
            'start'  => "\{0\}\,\ \{1\}"
        },
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0 \%",
        'territory' => "Region\:\ \{0\}"
    },
    'delimiters' => {
        'alternate_quotation_end'   => '‘',
        'alternate_quotation_start' => '‚',
        'quotation_end'             => '“',
        'quotation_start'           => '„'
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'plural_forms' => {
        'category_list' => [
            'one',
            'other'
        ],
        'category_rules'          => { 'one' => "n\ is\ 1" },
        'category_rules_compiled' => { 'one' => "sub\ \{\ return\ \'one\'\ if\ \(\ \(\(\ \$_\[0\]\ \=\=\ 1\)\)\)\;\ return\;\}\;" }
    },
    'posix' => {
        'nostr'  => "nein\:n",
        'yesstr' => "ja\:j"
    },
);

%Locales::DB::Language::de::code_to_name = (
    'aa'    => 'Afar',
    'ab'    => 'Abchasisch',
    'ace'   => "Aceh\-Sprache",
    'ach'   => "Acholi\-Sprache",
    'ada'   => 'Adangme',
    'ady'   => 'Adygeisch',
    'ae'    => 'Avestisch',
    'af'    => 'Afrikaans',
    'afa'   => 'Afroasiatisch',
    'afh'   => 'Afrihili',
    'agq'   => 'Aghem',
    'ain'   => "Ainu\-Sprache",
    'ak'    => 'Akan',
    'akk'   => 'Akkadisch',
    'ale'   => 'Aleutisch',
    'alg'   => "Algonkin\-Sprache",
    'alt'   => "Süd\-Altaisch",
    'am'    => 'Amharisch',
    'an'    => 'Aragonesisch',
    'ang'   => 'Altenglisch',
    'anp'   => 'Angika',
    'apa'   => "Apache\-Sprache",
    'ar'    => 'Arabisch',
    'arc'   => 'Aramäisch',
    'arn'   => 'Araukanisch',
    'arp'   => "Arapaho\-Sprache",
    'art'   => 'Kunstsprache',
    'arw'   => "Arawak\-Sprache",
    'as'    => 'Assamesisch',
    'asa'   => "Asu\ \(Tanzania\)",
    'ast'   => 'Asturianisch',
    'ath'   => 'Athapaskisch',
    'aus'   => 'Australisch',
    'av'    => 'Awarisch',
    'awa'   => 'Awadhi',
    'ay'    => 'Aymara',
    'az'    => 'Aserbaidschanisch',
    'ba'    => 'Baschkirisch',
    'bad'   => "Banda\-Sprache",
    'bai'   => "Bamileke\-Sprache",
    'bal'   => 'Belutschisch',
    'ban'   => 'Balinesisch',
    'bas'   => "Basaa\-Sprache",
    'bat'   => 'Baltisch',
    'be'    => 'Weißrussisch',
    'bej'   => 'Bedauye',
    'bem'   => "Bemba\-Sprache",
    'ber'   => 'Berbersprache',
    'bez'   => "Bena\ \(Tanzania\)",
    'bg'    => 'Bulgarisch',
    'bh'    => 'Biharisch',
    'bho'   => 'Bhodschpuri',
    'bi'    => 'Bislama',
    'bik'   => "Bikol\-Sprache",
    'bin'   => "Bini\-Sprache",
    'bla'   => "Blackfoot\-Sprache",
    'bm'    => "Bambara\-Sprache",
    'bn'    => 'Bengalisch',
    'bnt'   => 'Bantusprache',
    'bo'    => 'Tibetisch',
    'br'    => 'Bretonisch',
    'bra'   => "Braj\-Bhakha",
    'brx'   => 'Bodo',
    'bs'    => 'Bosnisch',
    'btk'   => 'Batak',
    'bua'   => 'Burjatisch',
    'bug'   => 'Buginesisch',
    'byn'   => 'Blin',
    'ca'    => 'Katalanisch',
    'cad'   => 'Caddo',
    'cai'   => "Zentralamerikanische\ Indianersprache",
    'car'   => 'Karibisch',
    'cau'   => 'Kaukasisch',
    'cay'   => 'Cayuga',
    'cch'   => 'Atsam',
    'ce'    => 'Tschetschenisch',
    'ceb'   => 'Cebuano',
    'cel'   => 'Keltisch',
    'cgg'   => 'Chiga',
    'ch'    => "Chamorro\-Sprache",
    'chb'   => "Chibcha\-Sprache",
    'chg'   => 'Tschagataisch',
    'chk'   => 'Trukesisch',
    'chm'   => 'Tscheremissisch',
    'chn'   => 'Chinook',
    'cho'   => 'Choctaw',
    'chp'   => 'Chipewyan',
    'chr'   => 'Cherokee',
    'chy'   => 'Cheyenne',
    'cmc'   => "Cham\-Sprache",
    'co'    => 'Korsisch',
    'cop'   => 'Koptisch',
    'cpe'   => "Kreolisch\-Englische\ Sprache",
    'cpf'   => "Kreolisch\-Französische\ Sprache",
    'cpp'   => "Kreolisch\-Portugiesische\ Sprache",
    'cr'    => 'Cree',
    'crh'   => 'Krimtatarisch',
    'crp'   => "Kreolische\ Sprache",
    'cs'    => 'Tschechisch',
    'csb'   => 'Kaschubisch',
    'cu'    => 'Kirchenslawisch',
    'cus'   => 'Kuschitisch',
    'cv'    => 'Tschuwaschisch',
    'cy'    => 'Walisisch',
    'da'    => 'Dänisch',
    'dak'   => "Dakota\-Sprache",
    'dar'   => 'Darginisch',
    'dav'   => 'Taita',
    'day'   => 'Dajak',
    'de'    => 'Deutsch',
    'de_at' => "Österreichisches\ Deutsch",
    'de_ch' => "Schweizer\ Hochdeutsch",
    'del'   => "Delaware\-Sprache",
    'den'   => 'Slave',
    'dgr'   => 'Dogrib',
    'din'   => "Dinka\-Sprache",
    'dje'   => 'Zarma',
    'doi'   => 'Dogri',
    'dra'   => 'Drawidisch',
    'dsb'   => 'Niedersorbisch',
    'dua'   => 'Duala',
    'dum'   => 'Mittelniederländisch',
    'dv'    => 'Maledivisch',
    'dyo'   => "Jola\-Fonyi",
    'dyu'   => "Dyula\-Sprache",
    'dz'    => 'Bhutanisch',
    'ebu'   => 'Kiembu',
    'ee'    => "Ewe\-Sprache",
    'efi'   => 'Efik',
    'egy'   => 'Ägyptisch',
    'eka'   => 'Ekajuk',
    'el'    => 'Griechisch',
    'elx'   => 'Elamisch',
    'en'    => 'Englisch',
    'en_au' => "Australisches\ Englisch",
    'en_ca' => "Kanadisches\ Englisch",
    'en_gb' => "Britisches\ Englisch",
    'en_us' => "Amerikanisches\ Englisch",
    'enm'   => 'Mittelenglisch',
    'eo'    => 'Esperanto',
    'es'    => 'Spanisch',
    'es_es' => "Iberisches\ Spanisch",
    'et'    => 'Estnisch',
    'eu'    => 'Baskisch',
    'ewo'   => 'Ewondo',
    'fa'    => 'Persisch',
    'fan'   => "Pangwe\-Sprache",
    'fat'   => "Fanti\-Sprache",
    'ff'    => 'Ful',
    'fi'    => 'Finnisch',
    'fil'   => 'Filipino',
    'fiu'   => 'Finnougrisch',
    'fj'    => 'Fidschianisch',
    'fo'    => 'Färöisch',
    'fon'   => "Fon\-Sprache",
    'fr'    => 'Französisch',
    'fr_ca' => "Kanadisches\ Französisch",
    'fr_ch' => "Schweizer\ Französisch",
    'frm'   => 'Mittelfranzösisch',
    'fro'   => 'Altfranzösisch',
    'frr'   => 'Nordfriesisch',
    'frs'   => 'Ostfriesisch',
    'fur'   => 'Friulisch',
    'fy'    => 'Friesisch',
    'ga'    => 'Irisch',
    'gaa'   => "Ga\-Sprache",
    'gay'   => 'Gayo',
    'gba'   => "Gbaya\-Sprache",
    'gd'    => "Schottisches\ Gälisch",
    'gem'   => 'Germanisch',
    'gez'   => 'Geez',
    'gil'   => 'Gilbertesisch',
    'gl'    => 'Galizisch',
    'gmh'   => 'Mittelhochdeutsch',
    'gn'    => 'Guarani',
    'goh'   => 'Althochdeutsch',
    'gon'   => "Gondi\-Sprache",
    'gor'   => 'Mongondou',
    'got'   => 'Gotisch',
    'grb'   => "Grebo\-Sprache",
    'grc'   => 'Altgriechisch',
    'gsw'   => 'Schweizerdeutsch',
    'gu'    => 'Gujarati',
    'guz'   => 'Gusii',
    'gv'    => 'Manx',
    'gwi'   => "Kutchin\-Sprache",
    'ha'    => 'Hausa',
    'hai'   => "Haida\-Sprache",
    'haw'   => 'Hawaiisch',
    'he'    => 'Hebräisch',
    'hi'    => 'Hindi',
    'hil'   => "Hiligaynon\-Sprache",
    'him'   => 'Himachali',
    'hit'   => 'Hethitisch',
    'hmn'   => "Miao\-Sprache",
    'ho'    => "Hiri\-Motu",
    'hr'    => 'Kroatisch',
    'hsb'   => 'Obersorbisch',
    'ht'    => 'Haitianisch',
    'hu'    => 'Ungarisch',
    'hup'   => 'Hupa',
    'hy'    => 'Armenisch',
    'hz'    => "Herero\-Sprache",
    'ia'    => 'Interlingua',
    'iba'   => 'Iban',
    'id'    => 'Indonesisch',
    'ie'    => 'Interlingue',
    'ig'    => "Igbo\-Sprache",
    'ii'    => "Sichuan\ Yi",
    'ijo'   => "Ijo\-Sprache",
    'ik'    => 'Inupiak',
    'ilo'   => "Ilokano\-Sprache",
    'inc'   => 'Indoarisch',
    'ine'   => 'Indogermanisch',
    'inh'   => 'Inguschisch',
    'io'    => "Ido\-Sprache",
    'ira'   => "Iranische\ Sprache",
    'iro'   => "Irokesische\ Sprache",
    'is'    => 'Isländisch',
    'it'    => 'Italienisch',
    'iu'    => 'Inukitut',
    'ja'    => 'Japanisch',
    'jbo'   => 'Lojban',
    'jmc'   => 'Machame',
    'jpr'   => "Jüdisch\-Persisch",
    'jrb'   => "Jüdisch\-Arabisch",
    'jv'    => 'Javanisch',
    'ka'    => 'Georgisch',
    'kaa'   => 'Karakalpakisch',
    'kab'   => 'Kabylisch',
    'kac'   => "Kachin\-Sprache",
    'kaj'   => 'Jju',
    'kam'   => 'Kamba',
    'kar'   => 'Karenisch',
    'kaw'   => 'Kawi',
    'kbd'   => 'Kabardinisch',
    'kcg'   => 'Tyap',
    'kde'   => 'Makonde',
    'kea'   => 'Kabuverdianu',
    'kfo'   => 'Koro',
    'kg'    => 'Kongolesisch',
    'kha'   => "Khasi\-Sprache",
    'khi'   => "Khoisan\-Sprache",
    'kho'   => 'Sakisch',
    'khq'   => "Koyra\ Chiini",
    'ki'    => "Kikuyu\-Sprache",
    'kj'    => 'Kwanyama',
    'kk'    => 'Kasachisch',
    'kl'    => 'Grönländisch',
    'kln'   => 'Kalenjin',
    'km'    => 'Kambodschanisch',
    'kmb'   => "Kimbundu\-Sprache",
    'kn'    => 'Kannada',
    'ko'    => 'Koreanisch',
    'kok'   => 'Konkani',
    'kos'   => 'Kosraeanisch',
    'kpe'   => "Kpelle\-Sprache",
    'kr'    => "Kanuri\-Sprache",
    'krc'   => "Karatschaiisch\-Balkarisch",
    'krl'   => 'Karelisch',
    'kro'   => "Kru\-Sprache",
    'kru'   => "Oraon\-Sprache",
    'ks'    => 'Kaschmirisch',
    'ksb'   => 'Shambala',
    'ksf'   => 'Bafia',
    'ksh'   => 'Colognian',
    'ku'    => 'Kurdisch',
    'kum'   => 'Kumükisch',
    'kut'   => "Kutenai\-Sprache",
    'kv'    => "Komi\-Sprache",
    'kw'    => 'Kornisch',
    'ky'    => 'Kirgisisch',
    'la'    => 'Latein',
    'lad'   => 'Ladino',
    'lag'   => 'Langi',
    'lah'   => 'Lahnda',
    'lam'   => "Lamba\-Sprache",
    'lb'    => 'Luxemburgisch',
    'lez'   => 'Lesgisch',
    'lg'    => "Ganda\-Sprache",
    'li'    => 'Limburgisch',
    'ln'    => 'Lingala',
    'lo'    => 'Laotisch',
    'lol'   => 'Mongo',
    'loz'   => "Rotse\-Sprache",
    'lt'    => 'Litauisch',
    'lu'    => "Luba\-Katanga",
    'lua'   => "Luba\-Lulua",
    'lui'   => "Luiseno\-Sprache",
    'lun'   => "Lunda\-Sprache",
    'luo'   => "Luo\-Sprache",
    'lus'   => "Lushai\-Sprache",
    'luy'   => 'Olulujia',
    'lv'    => 'Lettisch',
    'mad'   => 'Maduresisch',
    'mag'   => 'Khotta',
    'mai'   => 'Maithili',
    'mak'   => 'Makassarisch',
    'man'   => "Manding\-Sprache",
    'map'   => 'Austronesisch',
    'mas'   => "Massai\-Sprache",
    'mdf'   => 'Moksha',
    'mdr'   => 'Mandaresisch',
    'men'   => "Mende\-Sprache",
    'mer'   => 'Meru',
    'mfe'   => 'Morisyen',
    'mg'    => "Malagassi\-Sprache",
    'mga'   => 'Mittelirisch',
    'mgh'   => "Makhuwa\-Meetto",
    'mh'    => 'Marschallesisch',
    'mi'    => 'Maori',
    'mic'   => "Micmac\-Sprache",
    'min'   => "Minangkabau\-Sprache",
    'mis'   => "Andere\ Sprache",
    'mk'    => 'Mazedonisch',
    'mkh'   => "Mon\-Khmer\-Sprache",
    'ml'    => 'Malayalam',
    'mn'    => 'Mongolisch',
    'mnc'   => 'Mandschurisch',
    'mni'   => "Meithei\-Sprache",
    'mno'   => "Manobo\-Sprache",
    'mo'    => 'Moldauisch',
    'moh'   => "Mohawk\-Sprache",
    'mos'   => "Mossi\-Sprache",
    'mr'    => 'Marathi',
    'ms'    => 'Malaiisch',
    'mt'    => 'Maltesisch',
    'mua'   => 'Mundang',
    'mul'   => 'Mehrsprachig',
    'mun'   => "Munda\-Sprache",
    'mus'   => "Muskogee\-Sprache",
    'mwl'   => 'Mirandesisch',
    'mwr'   => 'Marwari',
    'my'    => 'Birmanisch',
    'myn'   => "Maya\-Sprache",
    'myv'   => "Ersja\-Mordwinisch",
    'na'    => 'Nauruisch',
    'nah'   => 'Nahuatl',
    'nai'   => "Nordamerikanische\ Indianersprache",
    'nap'   => 'Neapolitanisch',
    'naq'   => 'Nama',
    'nb'    => "Norwegisch\ Bokmål",
    'nd'    => "Nord\-Ndebele\-Sprache",
    'nds'   => 'Niederdeutsch',
    'ne'    => 'Nepalesisch',
    'new'   => 'Newari',
    'ng'    => 'Ndonga',
    'nia'   => "Nias\-Sprache",
    'nic'   => 'Nigerkordofanisch',
    'niu'   => "Niue\-Sprache",
    'nl'    => 'Niederländisch',
    'nl_be' => 'Flämisch',
    'nmg'   => 'Kwasio',
    'nn'    => "Norwegisch\ Nynorsk",
    'no'    => 'Norwegisch',
    'nog'   => 'Nogai',
    'non'   => 'Altnordisch',
    'nqo'   => 'N’Ko',
    'nr'    => "Süd\-Ndebele\-Sprache",
    'nso'   => "Nord\-Sotho\-Sprache",
    'nub'   => 'Nubisch',
    'nus'   => 'Nuer',
    'nv'    => 'Navajo',
    'nwc'   => "Alt\-Newari",
    'ny'    => "Nyanja\-Sprache",
    'nym'   => "Nyamwezi\-Sprache",
    'nyn'   => 'Nyankole',
    'nyo'   => 'Nyoro',
    'nzi'   => 'Nzima',
    'oc'    => 'Okzitanisch',
    'oj'    => "Ojibwa\-Sprache",
    'om'    => 'Oromo',
    'or'    => 'Orija',
    'os'    => 'Ossetisch',
    'osa'   => "Osage\-Sprache",
    'ota'   => 'Osmanisch',
    'oto'   => "Otomangue\-Sprache",
    'pa'    => 'Pandschabisch',
    'paa'   => 'Papuasprache',
    'pag'   => "Pangasinan\-Sprache",
    'pal'   => 'Mittelpersisch',
    'pam'   => "Pampanggan\-Sprache",
    'pap'   => 'Papiamento',
    'pau'   => 'Palau',
    'peo'   => 'Altpersisch',
    'phi'   => "Philippinen\-Austronesisch",
    'phn'   => 'Phönikisch',
    'pi'    => 'Pali',
    'pl'    => 'Polnisch',
    'pon'   => 'Ponapeanisch',
    'pra'   => 'Prakrit',
    'pro'   => 'Altprovenzalisch',
    'ps'    => 'Paschtu',
    'pt'    => 'Portugiesisch',
    'pt_br' => "Brasilianisches\ Portugiesisch",
    'pt_pt' => "Iberisches\ Portugiesisch",
    'qu'    => 'Quechua',
    'raj'   => 'Rajasthani',
    'rap'   => "Osterinsel\-Sprache",
    'rar'   => 'Rarotonganisch',
    'rm'    => 'Rätoromanisch',
    'rn'    => "Rundi\-Sprache",
    'ro'    => 'Rumänisch',
    'roa'   => "Romanische\ Sprache",
    'rof'   => 'Rombo',
    'rom'   => 'Romani',
    'ru'    => 'Russisch',
    'rup'   => 'Aromunisch',
    'rw'    => 'Ruandisch',
    'rwk'   => 'Rwa',
    'sa'    => 'Sanskrit',
    'sad'   => "Sandawe\-Sprache",
    'sah'   => 'Jakutisch',
    'sai'   => "Südamerikanische\ Indianersprache",
    'sal'   => "Salish\-Sprache",
    'sam'   => 'Samaritanisch',
    'saq'   => 'Samburu',
    'sas'   => 'Sasak',
    'sat'   => 'Santali',
    'sbp'   => 'Sangu',
    'sc'    => 'Sardisch',
    'scn'   => 'Sizilianisch',
    'sco'   => 'Schottisch',
    'sd'    => 'Sindhi',
    'se'    => "Nord\-Samisch",
    'see'   => 'Seneca',
    'seh'   => 'Sena',
    'sel'   => 'Selkupisch',
    'sem'   => 'Semitisch',
    'ses'   => "Koyraboro\ Senni",
    'sg'    => 'Sango',
    'sga'   => 'Altirisch',
    'sgn'   => 'Gebärdensprache',
    'sh'    => "Serbo\-Kroatisch",
    'shi'   => 'Tachelhit',
    'shn'   => "Schan\-Sprache",
    'si'    => 'Singhalesisch',
    'sid'   => 'Sidamo',
    'sio'   => "Sioux\-Sprache",
    'sit'   => 'Sinotibetisch',
    'sk'    => 'Slowakisch',
    'sl'    => 'Slowenisch',
    'sla'   => 'Slawisch',
    'sm'    => 'Samoanisch',
    'sma'   => "Süd\-Samisch",
    'smi'   => 'Lappisch',
    'smj'   => "Lule\-Lappisch",
    'smn'   => "Inari\-Lappisch",
    'sms'   => "Skolt\-Lappisch",
    'sn'    => 'Shona',
    'snk'   => "Soninke\-Sprache",
    'so'    => 'Somali',
    'sog'   => 'Sogdisch',
    'son'   => "Songhai\-Sprache",
    'sq'    => 'Albanisch',
    'sr'    => 'Serbisch',
    'srn'   => 'Srananisch',
    'srr'   => "Serer\-Sprache",
    'ss'    => 'Swazi',
    'ssa'   => 'Nilosaharanisch',
    'ssy'   => 'Saho',
    'st'    => "Süd\-Sotho\-Sprache",
    'su'    => 'Sundanesisch',
    'suk'   => "Sukuma\-Sprache",
    'sus'   => 'Susu',
    'sux'   => 'Sumerisch',
    'sv'    => 'Schwedisch',
    'sw'    => 'Suaheli',
    'swb'   => 'Komorisch',
    'swc'   => "Congo\ Swahili",
    'syc'   => 'Altsyrisch',
    'syr'   => 'Syrisch',
    'ta'    => 'Tamilisch',
    'tai'   => "Tai\-Sprache",
    'te'    => 'Telugu',
    'tem'   => 'Temne',
    'teo'   => 'Teso',
    'ter'   => "Tereno\-Sprache",
    'tet'   => "Tetum\-Sprache",
    'tg'    => 'Tadschikisch',
    'th'    => 'Thailändisch',
    'ti'    => 'Tigrinja',
    'tig'   => 'Tigre',
    'tiv'   => "Tiv\-Sprache",
    'tk'    => 'Turkmenisch',
    'tkl'   => 'Tokelauanisch',
    'tl'    => 'Tagalog',
    'tlh'   => 'Klingonisch',
    'tli'   => "Tlingit\-Sprache",
    'tmh'   => 'Tamaseq',
    'tn'    => "Tswana\-Sprache",
    'to'    => 'Tongaisch',
    'tog'   => "Tsonga\-Sprache",
    'tpi'   => 'Neumelanesisch',
    'tr'    => 'Türkisch',
    'trv'   => 'Taroko',
    'ts'    => 'Tsonga',
    'tsi'   => "Tsimshian\-Sprache",
    'tt'    => 'Tatarisch',
    'tum'   => "Tumbuka\-Sprache",
    'tup'   => "Tupi\-Sprache",
    'tut'   => 'Altaisch',
    'tvl'   => 'Elliceanisch',
    'tw'    => 'Twi',
    'twq'   => 'Tasawaq',
    'ty'    => 'Tahitisch',
    'tyv'   => 'Tuwinisch',
    'tzm'   => "Central\ Morocco\ Tamazight",
    'udm'   => 'Udmurtisch',
    'ug'    => 'Uigurisch',
    'uga'   => 'Ugaritisch',
    'uk'    => 'Ukrainisch',
    'umb'   => "Mbundu\-Sprache",
    'und'   => "Unbestimmte\ Sprache",
    'ur'    => 'Urdu',
    'uz'    => 'Usbekisch',
    'vai'   => "Vai\-Sprache",
    've'    => "Venda\-Sprache",
    'vi'    => 'Vietnamesisch',
    'vo'    => 'Volapük',
    'vot'   => 'Wotisch',
    'vun'   => 'Vunjo',
    'wa'    => 'Wallonisch',
    'wae'   => 'Walser',
    'wak'   => 'Wakashanisch',
    'wal'   => "Walamo\-Sprache",
    'war'   => 'Waray',
    'was'   => "Washo\-Sprache",
    'wen'   => 'Sorbisch',
    'wo'    => 'Wolof',
    'xal'   => 'Kalmückisch',
    'xh'    => 'Xhosa',
    'xog'   => 'Soga',
    'yao'   => "Yao\-Sprache",
    'yap'   => 'Yapesisch',
    'yav'   => 'Yangben',
    'yi'    => 'Jiddisch',
    'yo'    => 'Yoruba',
    'ypk'   => "Yupik\-Sprache",
    'yue'   => 'Kantonesisch',
    'za'    => 'Zhuang',
    'zap'   => 'Zapotekisch',
    'zbl'   => "Bliss\-Symbole",
    'zen'   => 'Zenaga',
    'zh'    => 'Chinesisch',
    'znd'   => "Zande\-Sprache",
    'zu'    => 'Zulu',
    'zun'   => "Zuni\-Sprache",
    'zxx'   => "Keine\ Sprachinhalte",
    'zza'   => 'Zaza',
);

%Locales::DB::Language::de::name_to_code = (
    'abchasisch'                          => 'ab',
    'acehsprache'                         => 'ace',
    'acholisprache'                       => 'ach',
    'adangme'                             => 'ada',
    'adygeisch'                           => 'ady',
    'afar'                                => 'aa',
    'afrihili'                            => 'afh',
    'afrikaans'                           => 'af',
    'afroasiatisch'                       => 'afa',
    'aghem'                               => 'agq',
    'ainusprache'                         => 'ain',
    'akan'                                => 'ak',
    'akkadisch'                           => 'akk',
    'albanisch'                           => 'sq',
    'aleutisch'                           => 'ale',
    'algonkinsprache'                     => 'alg',
    'altaisch'                            => 'tut',
    'altenglisch'                         => 'ang',
    'altfranzösisch'                     => 'fro',
    'altgriechisch'                       => 'grc',
    'althochdeutsch'                      => 'goh',
    'altirisch'                           => 'sga',
    'altnewari'                           => 'nwc',
    'altnordisch'                         => 'non',
    'altpersisch'                         => 'peo',
    'altprovenzalisch'                    => 'pro',
    'altsyrisch'                          => 'syc',
    'amerikanischesenglisch'              => 'en_us',
    'amharisch'                           => 'am',
    'anderesprache'                       => 'mis',
    'angika'                              => 'anp',
    'apachesprache'                       => 'apa',
    'arabisch'                            => 'ar',
    'aragonesisch'                        => 'an',
    'aramäisch'                          => 'arc',
    'arapahosprache'                      => 'arp',
    'araukanisch'                         => 'arn',
    'arawaksprache'                       => 'arw',
    'armenisch'                           => 'hy',
    'aromunisch'                          => 'rup',
    'aserbaidschanisch'                   => 'az',
    'assamesisch'                         => 'as',
    'asturianisch'                        => 'ast',
    'asutanzania'                         => 'asa',
    'athapaskisch'                        => 'ath',
    'atsam'                               => 'cch',
    'australisch'                         => 'aus',
    'australischesenglisch'               => 'en_au',
    'austronesisch'                       => 'map',
    'avestisch'                           => 'ae',
    'awadhi'                              => 'awa',
    'awarisch'                            => 'av',
    'aymara'                              => 'ay',
    'bafia'                               => 'ksf',
    'balinesisch'                         => 'ban',
    'baltisch'                            => 'bat',
    'bambarasprache'                      => 'bm',
    'bamilekesprache'                     => 'bai',
    'bandasprache'                        => 'bad',
    'bantusprache'                        => 'bnt',
    'basaasprache'                        => 'bas',
    'baschkirisch'                        => 'ba',
    'baskisch'                            => 'eu',
    'batak'                               => 'btk',
    'bedauye'                             => 'bej',
    'belutschisch'                        => 'bal',
    'bembasprache'                        => 'bem',
    'benatanzania'                        => 'bez',
    'bengalisch'                          => 'bn',
    'berbersprache'                       => 'ber',
    'bhodschpuri'                         => 'bho',
    'bhutanisch'                          => 'dz',
    'biharisch'                           => 'bh',
    'bikolsprache'                        => 'bik',
    'binisprache'                         => 'bin',
    'birmanisch'                          => 'my',
    'bislama'                             => 'bi',
    'blackfootsprache'                    => 'bla',
    'blin'                                => 'byn',
    'blisssymbole'                        => 'zbl',
    'bodo'                                => 'brx',
    'bosnisch'                            => 'bs',
    'brajbhakha'                          => 'bra',
    'brasilianischesportugiesisch'        => 'pt_br',
    'bretonisch'                          => 'br',
    'britischesenglisch'                  => 'en_gb',
    'buginesisch'                         => 'bug',
    'bulgarisch'                          => 'bg',
    'burjatisch'                          => 'bua',
    'caddo'                               => 'cad',
    'cayuga'                              => 'cay',
    'cebuano'                             => 'ceb',
    'centralmoroccotamazight'             => 'tzm',
    'chamorrosprache'                     => 'ch',
    'chamsprache'                         => 'cmc',
    'cherokee'                            => 'chr',
    'cheyenne'                            => 'chy',
    'chibchasprache'                      => 'chb',
    'chiga'                               => 'cgg',
    'chinesisch'                          => 'zh',
    'chinook'                             => 'chn',
    'chipewyan'                           => 'chp',
    'choctaw'                             => 'cho',
    'colognian'                           => 'ksh',
    'congoswahili'                        => 'swc',
    'cree'                                => 'cr',
    'dajak'                               => 'day',
    'dakotasprache'                       => 'dak',
    'darginisch'                          => 'dar',
    'delawaresprache'                     => 'del',
    'deutsch'                             => 'de',
    'dinkasprache'                        => 'din',
    'dogri'                               => 'doi',
    'dogrib'                              => 'dgr',
    'drawidisch'                          => 'dra',
    'duala'                               => 'dua',
    'dyulasprache'                        => 'dyu',
    'dänisch'                            => 'da',
    'efik'                                => 'efi',
    'ekajuk'                              => 'eka',
    'elamisch'                            => 'elx',
    'elliceanisch'                        => 'tvl',
    'englisch'                            => 'en',
    'ersjamordwinisch'                    => 'myv',
    'esperanto'                           => 'eo',
    'estnisch'                            => 'et',
    'ewesprache'                          => 'ee',
    'ewondo'                              => 'ewo',
    'fantisprache'                        => 'fat',
    'fidschianisch'                       => 'fj',
    'filipino'                            => 'fil',
    'finnisch'                            => 'fi',
    'finnougrisch'                        => 'fiu',
    'flämisch'                           => 'nl_be',
    'fonsprache'                          => 'fon',
    'französisch'                        => 'fr',
    'friesisch'                           => 'fy',
    'friulisch'                           => 'fur',
    'ful'                                 => 'ff',
    'färöisch'                          => 'fo',
    'galizisch'                           => 'gl',
    'gandasprache'                        => 'lg',
    'gasprache'                           => 'gaa',
    'gayo'                                => 'gay',
    'gbayasprache'                        => 'gba',
    'gebärdensprache'                    => 'sgn',
    'geez'                                => 'gez',
    'georgisch'                           => 'ka',
    'germanisch'                          => 'gem',
    'gilbertesisch'                       => 'gil',
    'gondisprache'                        => 'gon',
    'gotisch'                             => 'got',
    'grebosprache'                        => 'grb',
    'griechisch'                          => 'el',
    'grönländisch'                      => 'kl',
    'guarani'                             => 'gn',
    'gujarati'                            => 'gu',
    'gusii'                               => 'guz',
    'haidasprache'                        => 'hai',
    'haitianisch'                         => 'ht',
    'hausa'                               => 'ha',
    'hawaiisch'                           => 'haw',
    'hebräisch'                          => 'he',
    'hererosprache'                       => 'hz',
    'hethitisch'                          => 'hit',
    'hiligaynonsprache'                   => 'hil',
    'himachali'                           => 'him',
    'hindi'                               => 'hi',
    'hirimotu'                            => 'ho',
    'hupa'                                => 'hup',
    'iban'                                => 'iba',
    'iberischesportugiesisch'             => 'pt_pt',
    'iberischesspanisch'                  => 'es_es',
    'idosprache'                          => 'io',
    'igbosprache'                         => 'ig',
    'ijosprache'                          => 'ijo',
    'ilokanosprache'                      => 'ilo',
    'inarilappisch'                       => 'smn',
    'indoarisch'                          => 'inc',
    'indogermanisch'                      => 'ine',
    'indonesisch'                         => 'id',
    'inguschisch'                         => 'inh',
    'interlingua'                         => 'ia',
    'interlingue'                         => 'ie',
    'inukitut'                            => 'iu',
    'inupiak'                             => 'ik',
    'iranischesprache'                    => 'ira',
    'irisch'                              => 'ga',
    'irokesischesprache'                  => 'iro',
    'isländisch'                         => 'is',
    'italienisch'                         => 'it',
    'jakutisch'                           => 'sah',
    'japanisch'                           => 'ja',
    'javanisch'                           => 'jv',
    'jiddisch'                            => 'yi',
    'jju'                                 => 'kaj',
    'jolafonyi'                           => 'dyo',
    'jüdischarabisch'                    => 'jrb',
    'jüdischpersisch'                    => 'jpr',
    'kabardinisch'                        => 'kbd',
    'kabuverdianu'                        => 'kea',
    'kabylisch'                           => 'kab',
    'kachinsprache'                       => 'kac',
    'kalenjin'                            => 'kln',
    'kalmückisch'                        => 'xal',
    'kamba'                               => 'kam',
    'kambodschanisch'                     => 'km',
    'kanadischesenglisch'                 => 'en_ca',
    'kanadischesfranzösisch'             => 'fr_ca',
    'kannada'                             => 'kn',
    'kantonesisch'                        => 'yue',
    'kanurisprache'                       => 'kr',
    'karakalpakisch'                      => 'kaa',
    'karatschaiischbalkarisch'            => 'krc',
    'karelisch'                           => 'krl',
    'karenisch'                           => 'kar',
    'karibisch'                           => 'car',
    'kasachisch'                          => 'kk',
    'kaschmirisch'                        => 'ks',
    'kaschubisch'                         => 'csb',
    'katalanisch'                         => 'ca',
    'kaukasisch'                          => 'cau',
    'kawi'                                => 'kaw',
    'keinesprachinhalte'                  => 'zxx',
    'keltisch'                            => 'cel',
    'khasisprache'                        => 'kha',
    'khoisansprache'                      => 'khi',
    'khotta'                              => 'mag',
    'kiembu'                              => 'ebu',
    'kikuyusprache'                       => 'ki',
    'kimbundusprache'                     => 'kmb',
    'kirchenslawisch'                     => 'cu',
    'kirgisisch'                          => 'ky',
    'klingonisch'                         => 'tlh',
    'komisprache'                         => 'kv',
    'komorisch'                           => 'swb',
    'kongolesisch'                        => 'kg',
    'konkani'                             => 'kok',
    'koptisch'                            => 'cop',
    'koreanisch'                          => 'ko',
    'kornisch'                            => 'kw',
    'koro'                                => 'kfo',
    'korsisch'                            => 'co',
    'kosraeanisch'                        => 'kos',
    'koyraborosenni'                      => 'ses',
    'koyrachiini'                         => 'khq',
    'kpellesprache'                       => 'kpe',
    'kreolischenglischesprache'           => 'cpe',
    'kreolischesprache'                   => 'crp',
    'kreolischfranzösischesprache'       => 'cpf',
    'kreolischportugiesischesprache'      => 'cpp',
    'krimtatarisch'                       => 'crh',
    'kroatisch'                           => 'hr',
    'krusprache'                          => 'kro',
    'kumükisch'                          => 'kum',
    'kunstsprache'                        => 'art',
    'kurdisch'                            => 'ku',
    'kuschitisch'                         => 'cus',
    'kutchinsprache'                      => 'gwi',
    'kutenaisprache'                      => 'kut',
    'kwanyama'                            => 'kj',
    'kwasio'                              => 'nmg',
    'ladino'                              => 'lad',
    'lahnda'                              => 'lah',
    'lambasprache'                        => 'lam',
    'langi'                               => 'lag',
    'laotisch'                            => 'lo',
    'lappisch'                            => 'smi',
    'latein'                              => 'la',
    'lesgisch'                            => 'lez',
    'lettisch'                            => 'lv',
    'limburgisch'                         => 'li',
    'lingala'                             => 'ln',
    'litauisch'                           => 'lt',
    'lojban'                              => 'jbo',
    'lubakatanga'                         => 'lu',
    'lubalulua'                           => 'lua',
    'luisenosprache'                      => 'lui',
    'lulelappisch'                        => 'smj',
    'lundasprache'                        => 'lun',
    'luosprache'                          => 'luo',
    'lushaisprache'                       => 'lus',
    'luxemburgisch'                       => 'lb',
    'machame'                             => 'jmc',
    'maduresisch'                         => 'mad',
    'maithili'                            => 'mai',
    'makassarisch'                        => 'mak',
    'makhuwameetto'                       => 'mgh',
    'makonde'                             => 'kde',
    'malagassisprache'                    => 'mg',
    'malaiisch'                           => 'ms',
    'malayalam'                           => 'ml',
    'maledivisch'                         => 'dv',
    'maltesisch'                          => 'mt',
    'mandaresisch'                        => 'mdr',
    'mandingsprache'                      => 'man',
    'mandschurisch'                       => 'mnc',
    'manobosprache'                       => 'mno',
    'manx'                                => 'gv',
    'maori'                               => 'mi',
    'marathi'                             => 'mr',
    'marschallesisch'                     => 'mh',
    'marwari'                             => 'mwr',
    'massaisprache'                       => 'mas',
    'mayasprache'                         => 'myn',
    'mazedonisch'                         => 'mk',
    'mbundusprache'                       => 'umb',
    'mehrsprachig'                        => 'mul',
    'meitheisprache'                      => 'mni',
    'mendesprache'                        => 'men',
    'meru'                                => 'mer',
    'miaosprache'                         => 'hmn',
    'micmacsprache'                       => 'mic',
    'minangkabausprache'                  => 'min',
    'mirandesisch'                        => 'mwl',
    'mittelenglisch'                      => 'enm',
    'mittelfranzösisch'                  => 'frm',
    'mittelhochdeutsch'                   => 'gmh',
    'mittelirisch'                        => 'mga',
    'mittelniederländisch'               => 'dum',
    'mittelpersisch'                      => 'pal',
    'mohawksprache'                       => 'moh',
    'moksha'                              => 'mdf',
    'moldauisch'                          => 'mo',
    'mongo'                               => 'lol',
    'mongolisch'                          => 'mn',
    'mongondou'                           => 'gor',
    'monkhmersprache'                     => 'mkh',
    'morisyen'                            => 'mfe',
    'mossisprache'                        => 'mos',
    'mundang'                             => 'mua',
    'mundasprache'                        => 'mun',
    'muskogeesprache'                     => 'mus',
    'nahuatl'                             => 'nah',
    'nama'                                => 'naq',
    'nauruisch'                           => 'na',
    'navajo'                              => 'nv',
    'ndonga'                              => 'ng',
    'neapolitanisch'                      => 'nap',
    'nepalesisch'                         => 'ne',
    'neumelanesisch'                      => 'tpi',
    'newari'                              => 'new',
    'niassprache'                         => 'nia',
    'niederdeutsch'                       => 'nds',
    'niederländisch'                     => 'nl',
    'niedersorbisch'                      => 'dsb',
    'nigerkordofanisch'                   => 'nic',
    'nilosaharanisch'                     => 'ssa',
    'niuesprache'                         => 'niu',
    'nogai'                               => 'nog',
    'nordamerikanischeindianersprache'    => 'nai',
    'nordfriesisch'                       => 'frr',
    'nordndebelesprache'                  => 'nd',
    'nordsamisch'                         => 'se',
    'nordsothosprache'                    => 'nso',
    'norwegisch'                          => 'no',
    'norwegischbokmål'                   => 'nb',
    'norwegischnynorsk'                   => 'nn',
    'nubisch'                             => 'nub',
    'nuer'                                => 'nus',
    'nyamwezisprache'                     => 'nym',
    'nyanjasprache'                       => 'ny',
    'nyankole'                            => 'nyn',
    'nyoro'                               => 'nyo',
    'nzima'                               => 'nzi',
    'n’ko'                              => 'nqo',
    'obersorbisch'                        => 'hsb',
    'ojibwasprache'                       => 'oj',
    'okzitanisch'                         => 'oc',
    'olulujia'                            => 'luy',
    'oraonsprache'                        => 'kru',
    'orija'                               => 'or',
    'oromo'                               => 'om',
    'osagesprache'                        => 'osa',
    'osmanisch'                           => 'ota',
    'ossetisch'                           => 'os',
    'osterinselsprache'                   => 'rap',
    'ostfriesisch'                        => 'frs',
    'otomanguesprache'                    => 'oto',
    'palau'                               => 'pau',
    'pali'                                => 'pi',
    'pampanggansprache'                   => 'pam',
    'pandschabisch'                       => 'pa',
    'pangasinansprache'                   => 'pag',
    'pangwesprache'                       => 'fan',
    'papiamento'                          => 'pap',
    'papuasprache'                        => 'paa',
    'paschtu'                             => 'ps',
    'persisch'                            => 'fa',
    'philippinenaustronesisch'            => 'phi',
    'phönikisch'                         => 'phn',
    'polnisch'                            => 'pl',
    'ponapeanisch'                        => 'pon',
    'portugiesisch'                       => 'pt',
    'prakrit'                             => 'pra',
    'quechua'                             => 'qu',
    'rajasthani'                          => 'raj',
    'rarotonganisch'                      => 'rar',
    'romani'                              => 'rom',
    'romanischesprache'                   => 'roa',
    'rombo'                               => 'rof',
    'rotsesprache'                        => 'loz',
    'ruandisch'                           => 'rw',
    'rumänisch'                          => 'ro',
    'rundisprache'                        => 'rn',
    'russisch'                            => 'ru',
    'rwa'                                 => 'rwk',
    'rätoromanisch'                      => 'rm',
    'saho'                                => 'ssy',
    'sakisch'                             => 'kho',
    'salishsprache'                       => 'sal',
    'samaritanisch'                       => 'sam',
    'samburu'                             => 'saq',
    'samoanisch'                          => 'sm',
    'sandawesprache'                      => 'sad',
    'sango'                               => 'sg',
    'sangu'                               => 'sbp',
    'sanskrit'                            => 'sa',
    'santali'                             => 'sat',
    'sardisch'                            => 'sc',
    'sasak'                               => 'sas',
    'schansprache'                        => 'shn',
    'schottisch'                          => 'sco',
    'schottischesgälisch'                => 'gd',
    'schwedisch'                          => 'sv',
    'schweizerdeutsch'                    => 'gsw',
    'schweizerfranzösisch'               => 'fr_ch',
    'schweizerhochdeutsch'                => 'de_ch',
    'selkupisch'                          => 'sel',
    'semitisch'                           => 'sem',
    'sena'                                => 'seh',
    'seneca'                              => 'see',
    'serbisch'                            => 'sr',
    'serbokroatisch'                      => 'sh',
    'serersprache'                        => 'srr',
    'shambala'                            => 'ksb',
    'shona'                               => 'sn',
    'sichuanyi'                           => 'ii',
    'sidamo'                              => 'sid',
    'sindhi'                              => 'sd',
    'singhalesisch'                       => 'si',
    'sinotibetisch'                       => 'sit',
    'siouxsprache'                        => 'sio',
    'sizilianisch'                        => 'scn',
    'skoltlappisch'                       => 'sms',
    'slave'                               => 'den',
    'slawisch'                            => 'sla',
    'slowakisch'                          => 'sk',
    'slowenisch'                          => 'sl',
    'soga'                                => 'xog',
    'sogdisch'                            => 'sog',
    'somali'                              => 'so',
    'songhaisprache'                      => 'son',
    'soninkesprache'                      => 'snk',
    'sorbisch'                            => 'wen',
    'spanisch'                            => 'es',
    'srananisch'                          => 'srn',
    'suaheli'                             => 'sw',
    'sukumasprache'                       => 'suk',
    'sumerisch'                           => 'sux',
    'sundanesisch'                        => 'su',
    'susu'                                => 'sus',
    'swazi'                               => 'ss',
    'syrisch'                             => 'syr',
    'südaltaisch'                        => 'alt',
    'südamerikanischeindianersprache'    => 'sai',
    'südndebelesprache'                  => 'nr',
    'südsamisch'                         => 'sma',
    'südsothosprache'                    => 'st',
    'tachelhit'                           => 'shi',
    'tadschikisch'                        => 'tg',
    'tagalog'                             => 'tl',
    'tahitisch'                           => 'ty',
    'taisprache'                          => 'tai',
    'taita'                               => 'dav',
    'tamaseq'                             => 'tmh',
    'tamilisch'                           => 'ta',
    'taroko'                              => 'trv',
    'tasawaq'                             => 'twq',
    'tatarisch'                           => 'tt',
    'telugu'                              => 'te',
    'temne'                               => 'tem',
    'terenosprache'                       => 'ter',
    'teso'                                => 'teo',
    'tetumsprache'                        => 'tet',
    'thailändisch'                       => 'th',
    'tibetisch'                           => 'bo',
    'tigre'                               => 'tig',
    'tigrinja'                            => 'ti',
    'tivsprache'                          => 'tiv',
    'tlingitsprache'                      => 'tli',
    'tokelauanisch'                       => 'tkl',
    'tongaisch'                           => 'to',
    'trukesisch'                          => 'chk',
    'tschagataisch'                       => 'chg',
    'tschechisch'                         => 'cs',
    'tscheremissisch'                     => 'chm',
    'tschetschenisch'                     => 'ce',
    'tschuwaschisch'                      => 'cv',
    'tsimshiansprache'                    => 'tsi',
    'tsonga'                              => 'ts',
    'tsongasprache'                       => 'tog',
    'tswanasprache'                       => 'tn',
    'tumbukasprache'                      => 'tum',
    'tupisprache'                         => 'tup',
    'turkmenisch'                         => 'tk',
    'tuwinisch'                           => 'tyv',
    'twi'                                 => 'tw',
    'tyap'                                => 'kcg',
    'türkisch'                           => 'tr',
    'udmurtisch'                          => 'udm',
    'ugaritisch'                          => 'uga',
    'uigurisch'                           => 'ug',
    'ukrainisch'                          => 'uk',
    'unbestimmtesprache'                  => 'und',
    'ungarisch'                           => 'hu',
    'urdu'                                => 'ur',
    'usbekisch'                           => 'uz',
    'vaisprache'                          => 'vai',
    'vendasprache'                        => 've',
    'vietnamesisch'                       => 'vi',
    'volapük'                            => 'vo',
    'vunjo'                               => 'vun',
    'wakashanisch'                        => 'wak',
    'walamosprache'                       => 'wal',
    'walisisch'                           => 'cy',
    'wallonisch'                          => 'wa',
    'walser'                              => 'wae',
    'waray'                               => 'war',
    'washosprache'                        => 'was',
    'weißrussisch'                       => 'be',
    'wolof'                               => 'wo',
    'wotisch'                             => 'vot',
    'xhosa'                               => 'xh',
    'yangben'                             => 'yav',
    'yaosprache'                          => 'yao',
    'yapesisch'                           => 'yap',
    'yoruba'                              => 'yo',
    'yupiksprache'                        => 'ypk',
    'zandesprache'                        => 'znd',
    'zapotekisch'                         => 'zap',
    'zarma'                               => 'dje',
    'zaza'                                => 'zza',
    'zenaga'                              => 'zen',
    'zentralamerikanischeindianersprache' => 'cai',
    'zhuang'                              => 'za',
    'zulu'                                => 'zu',
    'zunisprache'                         => 'zun',
    'Ägyptisch'                          => 'egy',
    'Österreichischesdeutsch'            => 'de_at',
);

1;
