package Locales::DB::Language::ca;

# Auto generated from CLDR

$Locales::DB::Language::ca::VERSION = '0.08';

$Locales::DB::Language::ca::cldr_version = '2.0';

%Locales::DB::Language::ca::misc_info = (
    'characters'   => { 'more_information' => "\?" },
    'cldr_formats' => {
        '_decimal_format_decimal' => "\,",
        '_decimal_format_group'   => "\.",
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#0\.\#\#\#",
        'ellipsis'                => {
            'final'   => "\{0\}…",
            'initial' => "…\{0\}",
            'medial'  => "\{0\}…\{1\}"
        },
        'language' => "Idioma\:\ \{0\}",
        'list'     => {
            2        => "\{0\}\ i\ \{1\}",
            'end'    => "\{0\}\ i\ \{1\}",
            'middle' => "\{0\}\,\ \{1\}",
            'start'  => "\{0\}\,\ \{1\}"
        },
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "Regió\:\ \{0\}"
    },
    'delimiters' => {
        'alternate_quotation_end'   => '”',
        'alternate_quotation_start' => '“',
        'quotation_end'             => '’',
        'quotation_start'           => '‘'
    },
    'fallback'    => [ 'es_ES' ],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'plural_forms' => {
        'category_list' => [
            'one',
            'other'
        ],
        'category_rules'          => { 'one' => "n\ is\ 1" },
        'category_rules_compiled' => { 'one' => "sub\ \{\ return\ \'one\'\ if\ \(\ \(\(\ \$_\[0\]\ \=\=\ 1\)\)\)\;\ return\;\}\;" }
    },
    'posix' => {
        'nostr'  => "no\:n",
        'yesstr' => "sí\:s"
    },
);

%Locales::DB::Language::ca::code_to_name = (
    'aa'    => 'àfar',
    'ab'    => 'abkhaz',
    'ace'   => 'atjeh',
    'ach'   => 'acoli',
    'ada'   => 'adangme',
    'ady'   => 'adigué',
    'ae'    => 'avèstic',
    'af'    => 'afrikaans',
    'afa'   => "llengua\ afroasiàtica",
    'afh'   => 'afrihili',
    'agq'   => 'Aghem',
    'ain'   => 'ainu',
    'ak'    => 'àkan',
    'akk'   => 'accadi',
    'ale'   => 'aleuta',
    'alg'   => "llengua\ algonquina",
    'alt'   => "altaic\ meridional",
    'am'    => 'amhàric',
    'an'    => 'aragonès',
    'ang'   => "anglès\ antic",
    'anp'   => 'angika',
    'apa'   => "llengua\ apatxe",
    'ar'    => 'àrab',
    'arc'   => 'arameu',
    'arn'   => 'araucà',
    'arp'   => 'arapaho',
    'art'   => "llengua\ artificial",
    'arw'   => 'arauac',
    'as'    => 'assamès',
    'asa'   => 'Asu',
    'ast'   => 'asturià',
    'ath'   => "llengua\ atapascana",
    'aus'   => "llengua\ australiana",
    'av'    => 'àvar',
    'awa'   => 'awadhi',
    'ay'    => 'aimara',
    'az'    => 'àzeri',
    'ba'    => 'baixkir',
    'bad'   => 'banda',
    'bai'   => 'bamileké',
    'bal'   => 'balutxi',
    'ban'   => 'balinès',
    'bas'   => 'basa',
    'bat'   => "llengua\ bàltica",
    'be'    => 'bielorús',
    'bej'   => 'beja',
    'bem'   => 'bemba',
    'ber'   => 'berber',
    'bez'   => 'Bena',
    'bg'    => 'búlgar',
    'bh'    => 'bihari',
    'bho'   => 'bhojpuri',
    'bi'    => 'bislama',
    'bik'   => 'bicol',
    'bin'   => 'bini',
    'bla'   => 'blackfoot',
    'bm'    => 'bambara',
    'bn'    => 'bengalí',
    'bnt'   => 'bantu',
    'bo'    => 'tibetà',
    'br'    => 'bretó',
    'bra'   => 'braj',
    'brx'   => 'Bodo',
    'bs'    => 'bosnià',
    'btk'   => 'batak',
    'bua'   => 'buriat',
    'bug'   => 'bugui',
    'byn'   => 'bilin',
    'ca'    => 'català',
    'cad'   => 'caddo',
    'cai'   => "llengua\ ameríndia\ d\'Amèrica\ Central",
    'car'   => 'carib',
    'cau'   => "llengua\ caucàsica",
    'cay'   => 'Cayuga',
    'cch'   => 'atsam',
    'ce'    => 'txetxè',
    'ceb'   => 'cebuà',
    'cel'   => "llengua\ cèltica",
    'cgg'   => 'Chiga',
    'ch'    => 'chamorro',
    'chb'   => 'txibtxa',
    'chg'   => 'txagatai',
    'chk'   => 'chuuk',
    'chm'   => 'mari',
    'chn'   => "pidgin\ chinook",
    'cho'   => 'choctaw',
    'chp'   => 'chipewyan',
    'chr'   => 'cherokee',
    'chy'   => 'xeienne',
    'cmc'   => 'txam',
    'co'    => 'cors',
    'cop'   => 'copte',
    'cpe'   => "llengua\ criolla\ o\ pidgin\ basada\ en\ l\'anglès",
    'cpf'   => "llengua\ criolla\ o\ pidgin\ basada\ en\ el\ francès",
    'cpp'   => "llengua\ criolla\ o\ pidgin\ basada\ en\ el\ portuguès",
    'cr'    => 'cree',
    'crh'   => "tàtar\ de\ Crimea",
    'crp'   => "llengua\ criolla\ o\ pidgin",
    'cs'    => 'txec',
    'csb'   => 'caixubi',
    'cu'    => "eslau\ eclesiàstic",
    'cus'   => "llengua\ cuixítica",
    'cv'    => 'txuvaix',
    'cy'    => 'gal·lès',
    'da'    => 'danès',
    'dak'   => 'dakota',
    'dar'   => 'darguà',
    'dav'   => 'Taita',
    'day'   => 'daiak',
    'de'    => 'alemany',
    'de_at' => "alemany\ austríac",
    'de_ch' => "alt\ alemany\ suís",
    'del'   => 'delaware',
    'den'   => 'slavey',
    'dgr'   => 'dogrib',
    'din'   => 'dinka',
    'dje'   => 'Zarma',
    'doi'   => 'dogri',
    'dra'   => "llengua\ dravídica",
    'dsb'   => "baix\ sòrab",
    'dua'   => 'duala',
    'dum'   => "neerlandès\ mitjà",
    'dv'    => 'divehi',
    'dyo'   => "Jola\-Fonyi",
    'dyu'   => 'jula',
    'dz'    => 'dzongka',
    'ebu'   => 'Embu',
    'ee'    => 'ewe',
    'efi'   => 'efik',
    'egy'   => "egipci\ antic",
    'eka'   => 'ekajuk',
    'el'    => 'grec',
    'elx'   => 'elamita',
    'en'    => 'anglès',
    'en_au' => "anglès\ australià",
    'en_ca' => "anglès\ canadenc",
    'en_gb' => "anglès\ britànic",
    'en_us' => "anglès\ americà",
    'enm'   => "anglès\ mitjà",
    'eo'    => 'esperanto',
    'es'    => 'espanyol',
    'es_es' => "espanyol\ d\'Espanya",
    'et'    => 'estonià',
    'eu'    => 'basc',
    'ewo'   => 'ewondo',
    'fa'    => 'persa',
    'fan'   => 'fang',
    'fat'   => 'fanti',
    'ff'    => 'ful',
    'fi'    => 'finès',
    'fil'   => 'filipí',
    'fiu'   => "llengua\ finoúgrica",
    'fj'    => 'fijià',
    'fo'    => 'feroès',
    'fon'   => 'fon',
    'fr'    => 'francès',
    'fr_ca' => "francès\ canadenc",
    'fr_ch' => "francès\ suís",
    'frm'   => "francès\ mitjà",
    'fro'   => "francès\ antic",
    'frr'   => "frisó\ septentrional",
    'frs'   => "frisó\ occidental",
    'fur'   => 'friülà',
    'fy'    => "frisó\ oriental",
    'ga'    => 'irlandès',
    'gaa'   => 'ga',
    'gay'   => 'gayo',
    'gba'   => 'gbaya',
    'gd'    => "gaèlic\ escocès",
    'gem'   => "llengua\ germànica",
    'gez'   => 'gueez',
    'gil'   => 'gilbertès',
    'gl'    => 'gallec',
    'gmh'   => "alt\ alemany\ mitjà",
    'gn'    => 'guaraní',
    'goh'   => "alt\ alemany\ antic",
    'gon'   => 'gondi',
    'gor'   => 'gorontalo',
    'got'   => 'gòtic',
    'grb'   => 'grebo',
    'grc'   => "grec\ antic",
    'gsw'   => "alemany\ suís",
    'gu'    => 'gujarati',
    'guz'   => 'Gusii',
    'gv'    => 'manx',
    'gwi'   => 'gwichin',
    'ha'    => 'haussa',
    'hai'   => 'haida',
    'haw'   => 'hawaià',
    'he'    => 'hebreu',
    'hi'    => 'hindi',
    'hil'   => 'hiligainon',
    'him'   => 'himachali',
    'hit'   => 'hitita',
    'hmn'   => 'hmong',
    'ho'    => "hiri\ motu",
    'hr'    => 'croat',
    'hsb'   => "alt\ sòrab",
    'ht'    => 'haitià',
    'hu'    => 'hongarès',
    'hup'   => 'hupa',
    'hy'    => 'armeni',
    'hz'    => 'herero',
    'ia'    => 'interlingua',
    'iba'   => 'iban',
    'id'    => 'indonesi',
    'ie'    => 'interlingue',
    'ig'    => 'igbo',
    'ii'    => "yi\ sichuan",
    'ijo'   => 'ijo',
    'ik'    => 'inupiak',
    'ilo'   => 'ilocà',
    'inc'   => "llengua\ índica",
    'ine'   => "llengua\ indoeuropea",
    'inh'   => 'ingúix',
    'io'    => 'ido',
    'ira'   => "llengua\ irànica",
    'iro'   => 'iroquès',
    'is'    => 'islandès',
    'it'    => 'italià',
    'iu'    => 'inuktitut',
    'ja'    => 'japonès',
    'jbo'   => 'lojban',
    'jmc'   => 'Machame',
    'jpr'   => 'judeopersa',
    'jrb'   => 'judeoàrab',
    'jv'    => 'javanès',
    'ka'    => 'georgià',
    'kaa'   => 'karakalpak',
    'kab'   => 'cabilenc',
    'kac'   => 'katxin',
    'kaj'   => 'jju',
    'kam'   => 'kamba',
    'kar'   => 'karen',
    'kaw'   => 'kawi',
    'kbd'   => 'kabardí',
    'kcg'   => 'tyap',
    'kde'   => 'Makonde',
    'kea'   => 'Kabuverdianu',
    'kfo'   => 'koro',
    'kg'    => 'kongo',
    'kha'   => 'khasi',
    'khi'   => "llengua\ khoisan",
    'kho'   => 'khotanès',
    'khq'   => "Koyra\ Chiini",
    'ki'    => 'kikuiu',
    'kj'    => 'kuanyama',
    'kk'    => 'kazakh',
    'kl'    => 'grenlandès',
    'kln'   => 'Kalenjin',
    'km'    => 'khmer',
    'kmb'   => 'kimbundu',
    'kn'    => 'kannada',
    'ko'    => 'coreà',
    'kok'   => 'konkani',
    'kos'   => 'kosraeà',
    'kpe'   => 'kpelle',
    'kr'    => 'kanuri',
    'krc'   => 'karatxai',
    'krl'   => 'carelià',
    'kro'   => 'kru',
    'kru'   => 'kurukh',
    'ks'    => 'caixmiri',
    'ksb'   => 'Shambala',
    'ksf'   => 'Bafia',
    'ksh'   => 'Colognian',
    'ku'    => 'kurd',
    'kum'   => 'kúmik',
    'kut'   => 'kutenai',
    'kv'    => 'komi',
    'kw'    => 'còrnic',
    'ky'    => 'kirguís',
    'la'    => 'llatí',
    'lad'   => 'ladí',
    'lag'   => 'Langi',
    'lah'   => "panjabi\ occidental",
    'lam'   => 'lamba',
    'lb'    => 'luxemburguès',
    'lez'   => 'lesguià',
    'lg'    => 'ganda',
    'li'    => 'limburguès',
    'ln'    => 'lingala',
    'lo'    => 'laosià',
    'lol'   => 'mongo',
    'loz'   => 'lozi',
    'lt'    => 'lituà',
    'lu'    => "luba\ katanga",
    'lua'   => "luba\-lulua",
    'lui'   => 'luisenyo',
    'lun'   => 'lunda',
    'luo'   => 'luo',
    'lus'   => 'mizo',
    'luy'   => 'Luyia',
    'lv'    => 'letó',
    'mad'   => 'madurès',
    'mag'   => 'magahi',
    'mai'   => 'maithili',
    'mak'   => 'makassar',
    'man'   => 'mandinga',
    'map'   => "llengua\ austronèsia",
    'mas'   => 'massai',
    'mdf'   => "mordovià\ moksa",
    'mdr'   => 'mandar',
    'men'   => 'mende',
    'mer'   => 'Meru',
    'mfe'   => 'Morisyen',
    'mg'    => 'malgaix',
    'mga'   => "gaèlic\ irlandès\ mitjà",
    'mgh'   => "Makhuwa\-Meetto",
    'mh'    => 'marshallès',
    'mi'    => 'maori',
    'mic'   => 'micmac',
    'min'   => 'minangkabau',
    'mis'   => "llengua\ miscel·lània",
    'mk'    => 'macedoni',
    'mkh'   => "llengua\ monkhmer",
    'ml'    => 'malaialam',
    'mn'    => 'mongol',
    'mnc'   => 'manxú',
    'mni'   => 'manipurí',
    'mno'   => "llengua\ manobo",
    'mo'    => 'moldau',
    'moh'   => 'mohawk',
    'mos'   => 'moré',
    'mr'    => 'marathi',
    'ms'    => 'malai',
    'mt'    => 'maltès',
    'mua'   => 'Mundang',
    'mul'   => "llengües\ vàries",
    'mun'   => "llengua\ munda",
    'mus'   => 'creek',
    'mwl'   => 'mirandès',
    'mwr'   => 'marwari',
    'my'    => 'birmà',
    'myn'   => "llengua\ maia",
    'myv'   => "mordovià\ erza",
    'na'    => 'nauruà',
    'nah'   => 'nàhuatl',
    'nai'   => "llengua\ ameríndia\ septentrional",
    'nap'   => 'napolità',
    'naq'   => 'Nama',
    'nb'    => "noruec\ bokmål",
    'nd'    => "ndebele\ septentrional",
    'nds'   => "baix\ alemany",
    'ne'    => 'nepalès',
    'new'   => 'newari',
    'ng'    => 'ndonga',
    'nia'   => 'nias',
    'nic'   => "llengua\ nigerokurdufaniana",
    'niu'   => 'niueà',
    'nl'    => 'neerlandès',
    'nl_be' => 'flamenc',
    'nmg'   => 'Kwasio',
    'nn'    => "noruec\ nynorsk",
    'no'    => 'noruec',
    'nog'   => 'nogai',
    'non'   => "nòrdic\ antic",
    'nqo'   => 'n’Ko',
    'nr'    => "ndebele\ meridional",
    'nso'   => "sotho\ septentrional",
    'nub'   => "llengua\ nubiana",
    'nus'   => 'Nuer',
    'nv'    => 'navaho',
    'nwc'   => "newari\ clàssic",
    'ny'    => 'nyanja',
    'nym'   => 'nyamwesi',
    'nyn'   => 'nyankore',
    'nyo'   => 'nyoro',
    'nzi'   => 'nzema',
    'oc'    => 'occità',
    'oj'    => 'ojibwa',
    'om'    => 'oromo',
    'or'    => 'oriya',
    'os'    => 'osset',
    'osa'   => 'osage',
    'ota'   => "turc\ otomà",
    'oto'   => "llengua\ otomangueana",
    'pa'    => 'panjabi',
    'paa'   => "llengua\ papú",
    'pag'   => 'pangasi',
    'pal'   => 'pahlavi',
    'pam'   => 'pampangà',
    'pap'   => 'papiamento',
    'pau'   => 'palauà',
    'peo'   => "persa\ antic",
    'phi'   => "llengua\ filipina",
    'phn'   => 'fenici',
    'pi'    => 'pali',
    'pl'    => 'polonès',
    'pon'   => 'ponapeà',
    'pra'   => 'pràcrit',
    'pro'   => "provençal\ antic",
    'ps'    => 'pushto',
    'pt'    => 'portuguès',
    'pt_br' => "portuguès\ de\ Brasil",
    'pt_pt' => "portuguès\ de\ Portugal",
    'qu'    => 'quètxua',
    'raj'   => 'rajasthani',
    'rap'   => 'rapanui',
    'rar'   => 'rarotongà',
    'rm'    => 'retoromànic',
    'rn'    => 'rundi',
    'ro'    => 'romanès',
    'roa'   => "llengua\ romànica",
    'rof'   => 'Rombo',
    'rom'   => 'romaní',
    'ru'    => 'rus',
    'rup'   => 'aromanès',
    'rw'    => 'ruandès',
    'rwk'   => 'Rwa',
    'sa'    => 'sànscrit',
    'sad'   => 'sandawe',
    'sah'   => 'iacut',
    'sai'   => "llengua\ ameríndia\ meridional",
    'sal'   => "llengua\ salish",
    'sam'   => "arameu\ samarità",
    'saq'   => 'Samburu',
    'sas'   => 'sasak',
    'sat'   => 'santali',
    'sbp'   => 'Sangu',
    'sc'    => 'sard',
    'scn'   => 'sicilià',
    'sco'   => 'escocès',
    'sd'    => 'sindhi',
    'se'    => "sami\ septentrional",
    'see'   => 'Seneca',
    'seh'   => 'Sena',
    'sel'   => 'selkup',
    'sem'   => "llengua\ semítica",
    'ses'   => "Koyraboro\ Senni",
    'sg'    => 'sango',
    'sga'   => "irlandès\ antic",
    'sgn'   => "llengua\ de\ signes",
    'sh'    => 'serbocroat',
    'shi'   => 'Tachelhit',
    'shn'   => 'xan',
    'si'    => 'singalès',
    'sid'   => 'sidamo',
    'sio'   => "llengua\ sioux",
    'sit'   => "llengua\ sinotibetana",
    'sk'    => 'eslovac',
    'sl'    => 'eslovè',
    'sla'   => "llengua\ eslava",
    'sm'    => 'samoà',
    'sma'   => "sami\ meridional",
    'smi'   => "llengua\ sami",
    'smj'   => "sami\ lule",
    'smn'   => "sami\ d\'Inari",
    'sms'   => "sami\ skolt",
    'sn'    => 'shona',
    'snk'   => 'soninke',
    'so'    => 'somali',
    'sog'   => 'sogdià',
    'son'   => 'songhai',
    'sq'    => 'albanès',
    'sr'    => 'serbi',
    'srn'   => 'sranan',
    'srr'   => 'serer',
    'ss'    => 'siswati',
    'ssa'   => "llengua\ nilosahariana",
    'ssy'   => 'Saho',
    'st'    => "sotho\ meridional",
    'su'    => 'sundanès',
    'suk'   => 'sukuma',
    'sus'   => 'susú',
    'sux'   => 'sumeri',
    'sv'    => 'suec',
    'sw'    => 'suahili',
    'swb'   => 'comorià',
    'swc'   => "Congo\ Swahili",
    'syc'   => "siríac\ clàssic",
    'syr'   => 'siríac',
    'ta'    => 'tàmil',
    'tai'   => "llengua\ tai",
    'te'    => 'telugu',
    'tem'   => 'temne',
    'teo'   => 'Teso',
    'ter'   => 'terena',
    'tet'   => 'tetun',
    'tg'    => 'tadjik',
    'th'    => 'thai',
    'ti'    => 'tigrinya',
    'tig'   => 'tigre',
    'tiv'   => 'tiv',
    'tk'    => 'turcman',
    'tkl'   => 'tokelauès',
    'tl'    => 'tagàlog',
    'tlh'   => 'klingonià',
    'tli'   => 'tlingit',
    'tmh'   => 'tamazight',
    'tn'    => 'tswana',
    'to'    => 'tongalès',
    'tog'   => 'tonga',
    'tpi'   => "tok\ pisin",
    'tr'    => 'turc',
    'trv'   => 'Taroko',
    'ts'    => 'tsonga',
    'tsi'   => 'tsimshià',
    'tt'    => 'tàtar',
    'tum'   => 'tumbuka',
    'tup'   => "llengua\ tupí",
    'tut'   => "llengua\ altaica",
    'tvl'   => 'tuvaluà',
    'tw'    => 'twi',
    'twq'   => 'Tasawaq',
    'ty'    => 'tahitià',
    'tyv'   => 'tuvinià',
    'tzm'   => "Central\ Morocco\ Tamazight",
    'udm'   => 'udmurt',
    'ug'    => 'uigur',
    'uga'   => 'ugarític',
    'uk'    => 'ucraïnès',
    'umb'   => 'umbundu',
    'und'   => "idioma\ desconegut\ o\ no\ vàlid",
    'ur'    => 'urdú',
    'uz'    => 'uzbek',
    'vai'   => 'vai',
    've'    => 'venda',
    'vi'    => 'vietnamita',
    'vo'    => 'volapük',
    'vot'   => 'vòtic',
    'vun'   => 'Vunjo',
    'wa'    => 'való',
    'wae'   => 'Walser',
    'wak'   => "llengua\ wakash",
    'wal'   => 'ameto',
    'war'   => "waray\-waray",
    'was'   => 'washo',
    'wen'   => 'sòrab',
    'wo'    => 'wòlof',
    'xal'   => 'calmuc',
    'xh'    => 'xosa',
    'xog'   => 'Soga',
    'yao'   => 'yao',
    'yap'   => 'yapeà',
    'yav'   => 'Yangben',
    'yi'    => 'jiddisch',
    'yo'    => 'ioruba',
    'ypk'   => "llengua\ iupik",
    'yue'   => 'cantonès',
    'za'    => 'zhuang',
    'zap'   => 'zapoteca',
    'zbl'   => "símbols\ Bliss",
    'zen'   => 'zenaga',
    'zh'    => 'xinès',
    'znd'   => 'zande',
    'zu'    => 'zulu',
    'zun'   => 'zuni',
    'zxx'   => "sense\ contingut\ lingüístic",
    'zza'   => 'zaza',
);

%Locales::DB::Language::ca::name_to_code = (
    'abkhaz'                                    => 'ab',
    'accadi'                                    => 'akk',
    'acoli'                                     => 'ach',
    'adangme'                                   => 'ada',
    'adigué'                                   => 'ady',
    'afrihili'                                  => 'afh',
    'afrikaans'                                 => 'af',
    'aghem'                                     => 'agq',
    'aimara'                                    => 'ay',
    'ainu'                                      => 'ain',
    'albanès'                                  => 'sq',
    'alemany'                                   => 'de',
    'alemanyaustríac'                          => 'de_at',
    'alemanysuís'                              => 'gsw',
    'aleuta'                                    => 'ale',
    'altaicmeridional'                          => 'alt',
    'altalemanyantic'                           => 'goh',
    'altalemanymitjà'                          => 'gmh',
    'altalemanysuís'                           => 'de_ch',
    'altsòrab'                                 => 'hsb',
    'ameto'                                     => 'wal',
    'amhàric'                                  => 'am',
    'angika'                                    => 'anp',
    'anglès'                                   => 'en',
    'anglèsamericà'                           => 'en_us',
    'anglèsantic'                              => 'ang',
    'anglèsaustralià'                         => 'en_au',
    'anglèsbritànic'                          => 'en_gb',
    'anglèscanadenc'                           => 'en_ca',
    'anglèsmitjà'                             => 'enm',
    'aragonès'                                 => 'an',
    'arameu'                                    => 'arc',
    'arameusamarità'                           => 'sam',
    'arapaho'                                   => 'arp',
    'arauac'                                    => 'arw',
    'araucà'                                   => 'arn',
    'armeni'                                    => 'hy',
    'aromanès'                                 => 'rup',
    'assamès'                                  => 'as',
    'asturià'                                  => 'ast',
    'asu'                                       => 'asa',
    'atjeh'                                     => 'ace',
    'atsam'                                     => 'cch',
    'avèstic'                                  => 'ae',
    'awadhi'                                    => 'awa',
    'bafia'                                     => 'ksf',
    'baixalemany'                               => 'nds',
    'baixkir'                                   => 'ba',
    'baixsòrab'                                => 'dsb',
    'balinès'                                  => 'ban',
    'balutxi'                                   => 'bal',
    'bambara'                                   => 'bm',
    'bamileké'                                 => 'bai',
    'banda'                                     => 'bad',
    'bantu'                                     => 'bnt',
    'basa'                                      => 'bas',
    'basc'                                      => 'eu',
    'batak'                                     => 'btk',
    'beja'                                      => 'bej',
    'bemba'                                     => 'bem',
    'bena'                                      => 'bez',
    'bengalí'                                  => 'bn',
    'berber'                                    => 'ber',
    'bhojpuri'                                  => 'bho',
    'bicol'                                     => 'bik',
    'bielorús'                                 => 'be',
    'bihari'                                    => 'bh',
    'bilin'                                     => 'byn',
    'bini'                                      => 'bin',
    'birmà'                                    => 'my',
    'bislama'                                   => 'bi',
    'blackfoot'                                 => 'bla',
    'bodo'                                      => 'brx',
    'bosnià'                                   => 'bs',
    'braj'                                      => 'bra',
    'bretó'                                    => 'br',
    'bugui'                                     => 'bug',
    'buriat'                                    => 'bua',
    'búlgar'                                   => 'bg',
    'cabilenc'                                  => 'kab',
    'caddo'                                     => 'cad',
    'caixmiri'                                  => 'ks',
    'caixubi'                                   => 'csb',
    'calmuc'                                    => 'xal',
    'cantonès'                                 => 'yue',
    'carelià'                                  => 'krl',
    'carib'                                     => 'car',
    'català'                                   => 'ca',
    'cayuga'                                    => 'cay',
    'cebuà'                                    => 'ceb',
    'centralmoroccotamazight'                   => 'tzm',
    'chamorro'                                  => 'ch',
    'cherokee'                                  => 'chr',
    'chiga'                                     => 'cgg',
    'chipewyan'                                 => 'chp',
    'choctaw'                                   => 'cho',
    'chuuk'                                     => 'chk',
    'colognian'                                 => 'ksh',
    'comorià'                                  => 'swb',
    'congoswahili'                              => 'swc',
    'copte'                                     => 'cop',
    'coreà'                                    => 'ko',
    'cors'                                      => 'co',
    'cree'                                      => 'cr',
    'creek'                                     => 'mus',
    'croat'                                     => 'hr',
    'còrnic'                                   => 'kw',
    'daiak'                                     => 'day',
    'dakota'                                    => 'dak',
    'danès'                                    => 'da',
    'darguà'                                   => 'dar',
    'delaware'                                  => 'del',
    'dinka'                                     => 'din',
    'divehi'                                    => 'dv',
    'dogri'                                     => 'doi',
    'dogrib'                                    => 'dgr',
    'duala'                                     => 'dua',
    'dzongka'                                   => 'dz',
    'efik'                                      => 'efi',
    'egipciantic'                               => 'egy',
    'ekajuk'                                    => 'eka',
    'elamita'                                   => 'elx',
    'embu'                                      => 'ebu',
    'escocès'                                  => 'sco',
    'eslaueclesiàstic'                         => 'cu',
    'eslovac'                                   => 'sk',
    'eslovè'                                   => 'sl',
    'espanyol'                                  => 'es',
    'espanyoldespanya'                          => 'es_es',
    'esperanto'                                 => 'eo',
    'estonià'                                  => 'et',
    'ewe'                                       => 'ee',
    'ewondo'                                    => 'ewo',
    'fang'                                      => 'fan',
    'fanti'                                     => 'fat',
    'fenici'                                    => 'phn',
    'feroès'                                   => 'fo',
    'fijià'                                    => 'fj',
    'filipí'                                   => 'fil',
    'finès'                                    => 'fi',
    'flamenc'                                   => 'nl_be',
    'fon'                                       => 'fon',
    'francès'                                  => 'fr',
    'francèsantic'                             => 'fro',
    'francèscanadenc'                          => 'fr_ca',
    'francèsmitjà'                            => 'frm',
    'francèssuís'                             => 'fr_ch',
    'frisóoccidental'                          => 'frs',
    'frisóoriental'                            => 'fy',
    'frisóseptentrional'                       => 'frr',
    'friülà'                                  => 'fur',
    'ful'                                       => 'ff',
    'ga'                                        => 'gaa',
    'gallec'                                    => 'gl',
    'gal·lès'                                 => 'cy',
    'ganda'                                     => 'lg',
    'gayo'                                      => 'gay',
    'gaèlicescocès'                           => 'gd',
    'gaèlicirlandèsmitjà'                    => 'mga',
    'gbaya'                                     => 'gba',
    'georgià'                                  => 'ka',
    'gilbertès'                                => 'gil',
    'gondi'                                     => 'gon',
    'gorontalo'                                 => 'gor',
    'grebo'                                     => 'grb',
    'grec'                                      => 'el',
    'grecantic'                                 => 'grc',
    'grenlandès'                               => 'kl',
    'guaraní'                                  => 'gn',
    'gueez'                                     => 'gez',
    'gujarati'                                  => 'gu',
    'gusii'                                     => 'guz',
    'gwichin'                                   => 'gwi',
    'gòtic'                                    => 'got',
    'haida'                                     => 'hai',
    'haitià'                                   => 'ht',
    'haussa'                                    => 'ha',
    'hawaià'                                   => 'haw',
    'hebreu'                                    => 'he',
    'herero'                                    => 'hz',
    'hiligainon'                                => 'hil',
    'himachali'                                 => 'him',
    'hindi'                                     => 'hi',
    'hirimotu'                                  => 'ho',
    'hitita'                                    => 'hit',
    'hmong'                                     => 'hmn',
    'hongarès'                                 => 'hu',
    'hupa'                                      => 'hup',
    'iacut'                                     => 'sah',
    'iban'                                      => 'iba',
    'idiomadesconegutonovàlid'                 => 'und',
    'ido'                                       => 'io',
    'igbo'                                      => 'ig',
    'ijo'                                       => 'ijo',
    'ilocà'                                    => 'ilo',
    'indonesi'                                  => 'id',
    'ingúix'                                   => 'inh',
    'interlingua'                               => 'ia',
    'interlingue'                               => 'ie',
    'inuktitut'                                 => 'iu',
    'inupiak'                                   => 'ik',
    'ioruba'                                    => 'yo',
    'irlandès'                                 => 'ga',
    'irlandèsantic'                            => 'sga',
    'iroquès'                                  => 'iro',
    'islandès'                                 => 'is',
    'italià'                                   => 'it',
    'japonès'                                  => 'ja',
    'javanès'                                  => 'jv',
    'jiddisch'                                  => 'yi',
    'jju'                                       => 'kaj',
    'jolafonyi'                                 => 'dyo',
    'judeopersa'                                => 'jpr',
    'judeoàrab'                                => 'jrb',
    'jula'                                      => 'dyu',
    'kabardí'                                  => 'kbd',
    'kabuverdianu'                              => 'kea',
    'kalenjin'                                  => 'kln',
    'kamba'                                     => 'kam',
    'kannada'                                   => 'kn',
    'kanuri'                                    => 'kr',
    'karakalpak'                                => 'kaa',
    'karatxai'                                  => 'krc',
    'karen'                                     => 'kar',
    'katxin'                                    => 'kac',
    'kawi'                                      => 'kaw',
    'kazakh'                                    => 'kk',
    'khasi'                                     => 'kha',
    'khmer'                                     => 'km',
    'khotanès'                                 => 'kho',
    'kikuiu'                                    => 'ki',
    'kimbundu'                                  => 'kmb',
    'kirguís'                                  => 'ky',
    'klingonià'                                => 'tlh',
    'komi'                                      => 'kv',
    'kongo'                                     => 'kg',
    'konkani'                                   => 'kok',
    'koro'                                      => 'kfo',
    'kosraeà'                                  => 'kos',
    'koyraborosenni'                            => 'ses',
    'koyrachiini'                               => 'khq',
    'kpelle'                                    => 'kpe',
    'kru'                                       => 'kro',
    'kuanyama'                                  => 'kj',
    'kurd'                                      => 'ku',
    'kurukh'                                    => 'kru',
    'kutenai'                                   => 'kut',
    'kwasio'                                    => 'nmg',
    'kúmik'                                    => 'kum',
    'ladí'                                     => 'lad',
    'lamba'                                     => 'lam',
    'langi'                                     => 'lag',
    'laosià'                                   => 'lo',
    'lesguià'                                  => 'lez',
    'letó'                                     => 'lv',
    'limburguès'                               => 'li',
    'lingala'                                   => 'ln',
    'lituà'                                    => 'lt',
    'llatí'                                    => 'la',
    'llenguaafroasiàtica'                      => 'afa',
    'llenguaalgonquina'                         => 'alg',
    'llenguaaltaica'                            => 'tut',
    'llenguaameríndiadamèricacentral'         => 'cai',
    'llenguaameríndiameridional'               => 'sai',
    'llenguaameríndiaseptentrional'            => 'nai',
    'llenguaapatxe'                             => 'apa',
    'llenguaartificial'                         => 'art',
    'llenguaatapascana'                         => 'ath',
    'llenguaaustraliana'                        => 'aus',
    'llenguaaustronèsia'                       => 'map',
    'llenguabàltica'                           => 'bat',
    'llenguacaucàsica'                         => 'cau',
    'llenguacriollaopidgin'                     => 'crp',
    'llenguacriollaopidginbasadaenelfrancès'   => 'cpf',
    'llenguacriollaopidginbasadaenelportuguès' => 'cpp',
    'llenguacriollaopidginbasadaenlanglès'     => 'cpe',
    'llenguacuixítica'                         => 'cus',
    'llenguacèltica'                           => 'cel',
    'llenguadesignes'                           => 'sgn',
    'llenguadravídica'                         => 'dra',
    'llenguaeslava'                             => 'sla',
    'llenguafilipina'                           => 'phi',
    'llenguafinoúgrica'                        => 'fiu',
    'llenguagermànica'                         => 'gem',
    'llenguaindoeuropea'                        => 'ine',
    'llenguairànica'                           => 'ira',
    'llenguaiupik'                              => 'ypk',
    'llenguakhoisan'                            => 'khi',
    'llenguamaia'                               => 'myn',
    'llenguamanobo'                             => 'mno',
    'llenguamiscel·lània'                     => 'mis',
    'llenguamonkhmer'                           => 'mkh',
    'llenguamunda'                              => 'mun',
    'llenguanigerokurdufaniana'                 => 'nic',
    'llenguanilosahariana'                      => 'ssa',
    'llenguanubiana'                            => 'nub',
    'llenguaotomangueana'                       => 'oto',
    'llenguapapú'                              => 'paa',
    'llenguaromànica'                          => 'roa',
    'llenguasalish'                             => 'sal',
    'llenguasami'                               => 'smi',
    'llenguasemítica'                          => 'sem',
    'llenguasinotibetana'                       => 'sit',
    'llenguasioux'                              => 'sio',
    'llenguatai'                                => 'tai',
    'llenguatupí'                              => 'tup',
    'llenguawakash'                             => 'wak',
    'llenguaíndica'                            => 'inc',
    'llengüesvàries'                          => 'mul',
    'lojban'                                    => 'jbo',
    'lozi'                                      => 'loz',
    'lubakatanga'                               => 'lu',
    'lubalulua'                                 => 'lua',
    'luisenyo'                                  => 'lui',
    'lunda'                                     => 'lun',
    'luo'                                       => 'luo',
    'luxemburguès'                             => 'lb',
    'luyia'                                     => 'luy',
    'macedoni'                                  => 'mk',
    'machame'                                   => 'jmc',
    'madurès'                                  => 'mad',
    'magahi'                                    => 'mag',
    'maithili'                                  => 'mai',
    'makassar'                                  => 'mak',
    'makhuwameetto'                             => 'mgh',
    'makonde'                                   => 'kde',
    'malai'                                     => 'ms',
    'malaialam'                                 => 'ml',
    'malgaix'                                   => 'mg',
    'maltès'                                   => 'mt',
    'mandar'                                    => 'mdr',
    'mandinga'                                  => 'man',
    'manipurí'                                 => 'mni',
    'manx'                                      => 'gv',
    'manxú'                                    => 'mnc',
    'maori'                                     => 'mi',
    'marathi'                                   => 'mr',
    'mari'                                      => 'chm',
    'marshallès'                               => 'mh',
    'marwari'                                   => 'mwr',
    'massai'                                    => 'mas',
    'mende'                                     => 'men',
    'meru'                                      => 'mer',
    'micmac'                                    => 'mic',
    'minangkabau'                               => 'min',
    'mirandès'                                 => 'mwl',
    'mizo'                                      => 'lus',
    'mohawk'                                    => 'moh',
    'moldau'                                    => 'mo',
    'mongo'                                     => 'lol',
    'mongol'                                    => 'mn',
    'mordoviàerza'                             => 'myv',
    'mordoviàmoksa'                            => 'mdf',
    'morisyen'                                  => 'mfe',
    'moré'                                     => 'mos',
    'mundang'                                   => 'mua',
    'nama'                                      => 'naq',
    'napolità'                                 => 'nap',
    'nauruà'                                   => 'na',
    'navaho'                                    => 'nv',
    'ndebelemeridional'                         => 'nr',
    'ndebeleseptentrional'                      => 'nd',
    'ndonga'                                    => 'ng',
    'neerlandès'                               => 'nl',
    'neerlandèsmitjà'                         => 'dum',
    'nepalès'                                  => 'ne',
    'newari'                                    => 'new',
    'newariclàssic'                            => 'nwc',
    'nias'                                      => 'nia',
    'niueà'                                    => 'niu',
    'nogai'                                     => 'nog',
    'noruec'                                    => 'no',
    'noruecbokmål'                             => 'nb',
    'noruecnynorsk'                             => 'nn',
    'nuer'                                      => 'nus',
    'nyamwesi'                                  => 'nym',
    'nyanja'                                    => 'ny',
    'nyankore'                                  => 'nyn',
    'nyoro'                                     => 'nyo',
    'nzema'                                     => 'nzi',
    'nàhuatl'                                  => 'nah',
    'nòrdicantic'                              => 'non',
    'n’ko'                                    => 'nqo',
    'occità'                                   => 'oc',
    'ojibwa'                                    => 'oj',
    'oriya'                                     => 'or',
    'oromo'                                     => 'om',
    'osage'                                     => 'osa',
    'osset'                                     => 'os',
    'pahlavi'                                   => 'pal',
    'palauà'                                   => 'pau',
    'pali'                                      => 'pi',
    'pampangà'                                 => 'pam',
    'pangasi'                                   => 'pag',
    'panjabi'                                   => 'pa',
    'panjabioccidental'                         => 'lah',
    'papiamento'                                => 'pap',
    'persa'                                     => 'fa',
    'persaantic'                                => 'peo',
    'pidginchinook'                             => 'chn',
    'polonès'                                  => 'pl',
    'ponapeà'                                  => 'pon',
    'portuguès'                                => 'pt',
    'portuguèsdebrasil'                        => 'pt_br',
    'portuguèsdeportugal'                      => 'pt_pt',
    'provençalantic'                           => 'pro',
    'pràcrit'                                  => 'pra',
    'pushto'                                    => 'ps',
    'quètxua'                                  => 'qu',
    'rajasthani'                                => 'raj',
    'rapanui'                                   => 'rap',
    'rarotongà'                                => 'rar',
    'retoromànic'                              => 'rm',
    'romanès'                                  => 'ro',
    'romaní'                                   => 'rom',
    'rombo'                                     => 'rof',
    'ruandès'                                  => 'rw',
    'rundi'                                     => 'rn',
    'rus'                                       => 'ru',
    'rwa'                                       => 'rwk',
    'saho'                                      => 'ssy',
    'samburu'                                   => 'saq',
    'samidinari'                                => 'smn',
    'samilule'                                  => 'smj',
    'samimeridional'                            => 'sma',
    'samiseptentrional'                         => 'se',
    'samiskolt'                                 => 'sms',
    'samoà'                                    => 'sm',
    'sandawe'                                   => 'sad',
    'sango'                                     => 'sg',
    'sangu'                                     => 'sbp',
    'santali'                                   => 'sat',
    'sard'                                      => 'sc',
    'sasak'                                     => 'sas',
    'selkup'                                    => 'sel',
    'sena'                                      => 'seh',
    'seneca'                                    => 'see',
    'sensecontingutlingüístic'                => 'zxx',
    'serbi'                                     => 'sr',
    'serbocroat'                                => 'sh',
    'serer'                                     => 'srr',
    'shambala'                                  => 'ksb',
    'shona'                                     => 'sn',
    'sicilià'                                  => 'scn',
    'sidamo'                                    => 'sid',
    'sindhi'                                    => 'sd',
    'singalès'                                 => 'si',
    'siríac'                                   => 'syr',
    'siríacclàssic'                           => 'syc',
    'siswati'                                   => 'ss',
    'slavey'                                    => 'den',
    'soga'                                      => 'xog',
    'sogdià'                                   => 'sog',
    'somali'                                    => 'so',
    'songhai'                                   => 'son',
    'soninke'                                   => 'snk',
    'sothomeridional'                           => 'st',
    'sothoseptentrional'                        => 'nso',
    'sranan'                                    => 'srn',
    'suahili'                                   => 'sw',
    'suec'                                      => 'sv',
    'sukuma'                                    => 'suk',
    'sumeri'                                    => 'sux',
    'sundanès'                                 => 'su',
    'susú'                                     => 'sus',
    'sànscrit'                                 => 'sa',
    'símbolsbliss'                             => 'zbl',
    'sòrab'                                    => 'wen',
    'tachelhit'                                 => 'shi',
    'tadjik'                                    => 'tg',
    'tagàlog'                                  => 'tl',
    'tahitià'                                  => 'ty',
    'taita'                                     => 'dav',
    'tamazight'                                 => 'tmh',
    'taroko'                                    => 'trv',
    'tasawaq'                                   => 'twq',
    'telugu'                                    => 'te',
    'temne'                                     => 'tem',
    'terena'                                    => 'ter',
    'teso'                                      => 'teo',
    'tetun'                                     => 'tet',
    'thai'                                      => 'th',
    'tibetà'                                   => 'bo',
    'tigre'                                     => 'tig',
    'tigrinya'                                  => 'ti',
    'tiv'                                       => 'tiv',
    'tlingit'                                   => 'tli',
    'tokelauès'                                => 'tkl',
    'tokpisin'                                  => 'tpi',
    'tonga'                                     => 'tog',
    'tongalès'                                 => 'to',
    'tsimshià'                                 => 'tsi',
    'tsonga'                                    => 'ts',
    'tswana'                                    => 'tn',
    'tumbuka'                                   => 'tum',
    'turc'                                      => 'tr',
    'turcman'                                   => 'tk',
    'turcotomà'                                => 'ota',
    'tuvaluà'                                  => 'tvl',
    'tuvinià'                                  => 'tyv',
    'twi'                                       => 'tw',
    'txagatai'                                  => 'chg',
    'txam'                                      => 'cmc',
    'txec'                                      => 'cs',
    'txetxè'                                   => 'ce',
    'txibtxa'                                   => 'chb',
    'txuvaix'                                   => 'cv',
    'tyap'                                      => 'kcg',
    'tàmil'                                    => 'ta',
    'tàtar'                                    => 'tt',
    'tàtardecrimea'                            => 'crh',
    'ucraïnès'                                => 'uk',
    'udmurt'                                    => 'udm',
    'ugarític'                                 => 'uga',
    'uigur'                                     => 'ug',
    'umbundu'                                   => 'umb',
    'urdú'                                     => 'ur',
    'uzbek'                                     => 'uz',
    'vai'                                       => 'vai',
    'való'                                     => 'wa',
    'venda'                                     => 've',
    'vietnamita'                                => 'vi',
    'volapük'                                  => 'vo',
    'vunjo'                                     => 'vun',
    'vòtic'                                    => 'vot',
    'walser'                                    => 'wae',
    'waraywaray'                                => 'war',
    'washo'                                     => 'was',
    'wòlof'                                    => 'wo',
    'xan'                                       => 'shn',
    'xeienne'                                   => 'chy',
    'xinès'                                    => 'zh',
    'xosa'                                      => 'xh',
    'yangben'                                   => 'yav',
    'yao'                                       => 'yao',
    'yapeà'                                    => 'yap',
    'yisichuan'                                 => 'ii',
    'zande'                                     => 'znd',
    'zapoteca'                                  => 'zap',
    'zarma'                                     => 'dje',
    'zaza'                                      => 'zza',
    'zenaga'                                    => 'zen',
    'zhuang'                                    => 'za',
    'zulu'                                      => 'zu',
    'zuni'                                      => 'zun',
    'àfar'                                     => 'aa',
    'àkan'                                     => 'ak',
    'àrab'                                     => 'ar',
    'àvar'                                     => 'av',
    'àzeri'                                    => 'az',
);

1;
