/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.ExecuteWatchdog;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.taskdefs.ProcessDestroyer;
import org.apache.tools.ant.taskdefs.PumpStreamHandler;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.apache.tools.ant.types.Commandline;

public class Execute {
    public static final int INVALID = Integer.MAX_VALUE;
    private String[] cmdl = null;
    private String[] env = null;
    private int exitValue = Integer.MAX_VALUE;
    private ExecuteStreamHandler streamHandler;
    private ExecuteWatchdog watchdog;
    private File workingDirectory = null;
    private Project project = null;
    private boolean newEnvironment = false;
    private boolean useVMLauncher = true;
    private static String antWorkingDirectory = System.getProperty("user.dir");
    private static CommandLauncher vmLauncher = null;
    private static CommandLauncher shellLauncher = null;
    private static Vector procEnvironment = null;
    private static ProcessDestroyer processDestroyer = new ProcessDestroyer();

    /*
     * WARNING - void declaration
     */
    public static synchronized Vector getProcEnvironment() {
        if (procEnvironment != null) {
            return procEnvironment;
        }
        procEnvironment = new Vector();
        try {
            String line;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Execute exe = new Execute(new PumpStreamHandler(out));
            exe.setCommandline(Execute.getProcEnvCommand());
            exe.setNewenvironment(true);
            int retval = exe.execute();
            if (retval != 0) {
                // empty if block
            }
            BufferedReader in = new BufferedReader(new StringReader(Execute.toString(out)));
            String var = null;
            String lineSep = System.getProperty("line.separator");
            while ((line = in.readLine()) != null) {
                void var5_7;
                if (var5_7.indexOf(61) == -1) {
                    if (var == null) {
                        var = lineSep + (String)var5_7;
                        continue;
                    }
                    var = var + lineSep + (String)var5_7;
                    continue;
                }
                if (var != null) {
                    procEnvironment.addElement(var);
                }
                var = var5_7;
            }
            if (var != null) {
                procEnvironment.addElement(var);
            }
        }
        catch (IOException exc) {
            exc.printStackTrace();
        }
        return procEnvironment;
    }

    private static String[] getProcEnvCommand() {
        if (Os.isFamily("os/2")) {
            String[] cmd = new String[]{"cmd", "/c", "set"};
            return cmd;
        }
        if (Os.isFamily("windows")) {
            if (!Os.isFamily("win9x")) {
                String[] cmd = new String[]{"cmd", "/c", "set"};
                return cmd;
            }
            String[] cmd = new String[]{"command.com", "/c", "set"};
            return cmd;
        }
        if (Os.isFamily("z/os")) {
            String[] cmd = new String[]{"/bin/env"};
            return cmd;
        }
        if (Os.isFamily("unix")) {
            String[] cmd = new String[]{"/usr/bin/env"};
            return cmd;
        }
        if (Os.isFamily("netware")) {
            String[] cmd = new String[]{"env"};
            return cmd;
        }
        String[] cmd = null;
        return cmd;
    }

    public static String toString(ByteArrayOutputStream bos) {
        if (Os.isFamily("z/os")) {
            try {
                return bos.toString("Cp1047");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return bos.toString();
    }

    public Execute() {
        this(new PumpStreamHandler(), null);
    }

    public Execute(ExecuteStreamHandler streamHandler) {
        this(streamHandler, null);
    }

    public Execute(ExecuteStreamHandler streamHandler, ExecuteWatchdog watchdog) {
        this.streamHandler = streamHandler;
        this.watchdog = watchdog;
    }

    public String[] getCommandline() {
        return this.cmdl;
    }

    public void setCommandline(String[] commandline) {
        this.cmdl = commandline;
    }

    public void setNewenvironment(boolean newenv) {
        this.newEnvironment = newenv;
    }

    public String[] getEnvironment() {
        if (this.env == null || this.newEnvironment) {
            return this.env;
        }
        return this.patchEnvironment();
    }

    public void setEnvironment(String[] env) {
        this.env = env;
    }

    public void setWorkingDirectory(File wd) {
        this.workingDirectory = wd == null || wd.getAbsolutePath().equals(antWorkingDirectory) ? null : wd;
    }

    public void setAntRun(Project project) throws BuildException {
        this.project = project;
    }

    public void setVMLauncher(boolean useVMLauncher) {
        this.useVMLauncher = useVMLauncher;
    }

    public static Process launch(Project project, String[] command, String[] env, File dir, boolean useVM) throws IOException {
        CommandLauncher launcher;
        CommandLauncher commandLauncher = launcher = vmLauncher != null ? vmLauncher : shellLauncher;
        if (!useVM) {
            launcher = shellLauncher;
        }
        return launcher.exec(project, command, env, dir);
    }

    public int execute() throws IOException {
        Process process = Execute.launch(this.project, this.getCommandline(), this.getEnvironment(), this.workingDirectory, this.useVMLauncher);
        try {
            this.streamHandler.setProcessInputStream(process.getOutputStream());
            this.streamHandler.setProcessOutputStream(process.getInputStream());
            this.streamHandler.setProcessErrorStream(process.getErrorStream());
        }
        catch (IOException e) {
            process.destroy();
            throw e;
        }
        this.streamHandler.start();
        processDestroyer.add(process);
        if (this.watchdog != null) {
            this.watchdog.start(process);
        }
        this.waitFor(process);
        processDestroyer.remove(process);
        if (this.watchdog != null) {
            this.watchdog.stop();
        }
        this.streamHandler.stop();
        if (this.watchdog != null) {
            this.watchdog.checkException();
        }
        return this.getExitValue();
    }

    protected void waitFor(Process process) {
        try {
            process.waitFor();
            this.setExitValue(process.exitValue());
        }
        catch (InterruptedException e) {
            process.destroy();
        }
    }

    protected void setExitValue(int value) {
        this.exitValue = value;
    }

    public int getExitValue() {
        return this.exitValue;
    }

    public boolean killedProcess() {
        return this.watchdog != null && this.watchdog.killedProcess();
    }

    private String[] patchEnvironment() {
        Vector osEnv = (Vector)Execute.getProcEnvironment().clone();
        int i = 0;
        while (i < this.env.length) {
            int pos = this.env[i].indexOf(61);
            String key = this.env[i].substring(0, pos + 1);
            int size = osEnv.size();
            int j = 0;
            while (j < size) {
                if (((String)osEnv.elementAt(j)).startsWith(key)) {
                    osEnv.removeElementAt(j);
                    break;
                }
                ++j;
            }
            osEnv.addElement(this.env[i]);
            ++i;
        }
        Object[] result = new String[osEnv.size()];
        osEnv.copyInto(result);
        return result;
    }

    public static void runCommand(Task task, String[] cmdline) throws BuildException {
        try {
            task.log(Commandline.describeCommand(cmdline), 3);
            Execute exe = new Execute(new LogStreamHandler(task, 2, 0));
            exe.setAntRun(task.getProject());
            exe.setCommandline(cmdline);
            int retval = exe.execute();
            if (retval != 0) {
                throw new BuildException(cmdline[0] + " failed with return code " + retval, task.getLocation());
            }
        }
        catch (IOException exc) {
            throw new BuildException("Could not launch " + cmdline[0] + ": " + exc, task.getLocation());
        }
    }

    static {
        try {
            vmLauncher = new Java13CommandLauncher();
        }
        catch (NoSuchMethodException exc) {
            // empty catch block
        }
        if (Os.isFamily("mac")) {
            shellLauncher = new MacCommandLauncher(new CommandLauncher());
        } else if (Os.isFamily("os/2")) {
            shellLauncher = new OS2CommandLauncher(new CommandLauncher());
        } else if (Os.isFamily("windows")) {
            CommandLauncher baseLauncher = System.getProperty("java.version").startsWith("1.1") ? new Java11CommandLauncher() : new CommandLauncher();
            shellLauncher = !Os.isFamily("win9x") ? new WinNTCommandLauncher(baseLauncher) : new ScriptCommandLauncher("bin/antRun.bat", baseLauncher);
        } else if (Os.isFamily("netware")) {
            CommandLauncher baseLauncher = System.getProperty("java.version").startsWith("1.1") ? new Java11CommandLauncher() : new CommandLauncher();
            shellLauncher = new PerlScriptCommandLauncher("bin/antRun.pl", baseLauncher);
        } else {
            shellLauncher = new ScriptCommandLauncher("bin/antRun", new CommandLauncher());
        }
    }

    private static class PerlScriptCommandLauncher
    extends CommandLauncherProxy {
        private String _script;

        PerlScriptCommandLauncher(String script, CommandLauncher launcher) {
            super(launcher);
            this._script = script;
        }

        public Process exec(Project project, String[] cmd, String[] env, File workingDir) throws IOException {
            if (project == null) {
                if (workingDir == null) {
                    return this.exec(project, cmd, env);
                }
                throw new IOException("Cannot locate antRun script: No project provided");
            }
            String antHome = project.getProperty("ant.home");
            if (antHome == null) {
                throw new IOException("Cannot locate antRun script: Property 'ant.home' not found");
            }
            String antRun = project.resolveFile(antHome + File.separator + this._script).toString();
            File commandDir = workingDir;
            if (workingDir == null && project != null) {
                commandDir = project.getBaseDir();
            }
            String[] newcmd = new String[cmd.length + 3];
            newcmd[0] = "perl";
            newcmd[1] = antRun;
            newcmd[2] = commandDir.getAbsolutePath();
            System.arraycopy(cmd, 0, newcmd, 3, cmd.length);
            return this.exec(project, newcmd, env);
        }
    }

    private static class ScriptCommandLauncher
    extends CommandLauncherProxy {
        private String _script;

        ScriptCommandLauncher(String script, CommandLauncher launcher) {
            super(launcher);
            this._script = script;
        }

        public Process exec(Project project, String[] cmd, String[] env, File workingDir) throws IOException {
            if (project == null) {
                if (workingDir == null) {
                    return this.exec(project, cmd, env);
                }
                throw new IOException("Cannot locate antRun script: No project provided");
            }
            String antHome = project.getProperty("ant.home");
            if (antHome == null) {
                throw new IOException("Cannot locate antRun script: Property 'ant.home' not found");
            }
            String antRun = project.resolveFile(antHome + File.separator + this._script).toString();
            File commandDir = workingDir;
            if (workingDir == null && project != null) {
                commandDir = project.getBaseDir();
            }
            String[] newcmd = new String[cmd.length + 2];
            newcmd[0] = antRun;
            newcmd[1] = commandDir.getAbsolutePath();
            System.arraycopy(cmd, 0, newcmd, 2, cmd.length);
            return this.exec(project, newcmd, env);
        }
    }

    private static class MacCommandLauncher
    extends CommandLauncherProxy {
        MacCommandLauncher(CommandLauncher launcher) {
            super(launcher);
        }

        public Process exec(Project project, String[] cmd, String[] env, File workingDir) throws IOException {
            Process process;
            if (workingDir == null) {
                return this.exec(project, cmd, env);
            }
            ((Hashtable)System.getProperties()).put("user.dir", workingDir.getAbsolutePath());
            try {
                process = this.exec(project, cmd, env);
                Object var7_6 = null;
                ((Hashtable)System.getProperties()).put("user.dir", antWorkingDirectory);
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                ((Hashtable)System.getProperties()).put("user.dir", antWorkingDirectory);
                throw throwable;
            }
            return process;
        }
    }

    private static class WinNTCommandLauncher
    extends CommandLauncherProxy {
        WinNTCommandLauncher(CommandLauncher launcher) {
            super(launcher);
        }

        public Process exec(Project project, String[] cmd, String[] env, File workingDir) throws IOException {
            File commandDir = workingDir;
            if (workingDir == null) {
                if (project != null) {
                    commandDir = project.getBaseDir();
                } else {
                    return this.exec(project, cmd, env);
                }
            }
            String[] newcmd = new String[cmd.length + 6];
            newcmd[0] = "cmd";
            newcmd[1] = "/c";
            newcmd[2] = "cd";
            newcmd[3] = "/d";
            newcmd[4] = commandDir.getAbsolutePath();
            newcmd[5] = "&&";
            System.arraycopy(cmd, 0, newcmd, 6, cmd.length);
            return this.exec(project, newcmd, env);
        }
    }

    private static class OS2CommandLauncher
    extends CommandLauncherProxy {
        OS2CommandLauncher(CommandLauncher launcher) {
            super(launcher);
        }

        public Process exec(Project project, String[] cmd, String[] env, File workingDir) throws IOException {
            File commandDir = workingDir;
            if (workingDir == null) {
                if (project != null) {
                    commandDir = project.getBaseDir();
                } else {
                    return this.exec(project, cmd, env);
                }
            }
            String cmdDir = commandDir.getAbsolutePath();
            String[] newcmd = new String[cmd.length + 7];
            newcmd[0] = "cmd";
            newcmd[1] = "/c";
            newcmd[2] = cmdDir.substring(0, 2);
            newcmd[3] = "&&";
            newcmd[4] = "cd";
            newcmd[5] = cmdDir.substring(2);
            newcmd[6] = "&&";
            System.arraycopy(cmd, 0, newcmd, 7, cmd.length);
            return this.exec(project, newcmd, env);
        }
    }

    private static class CommandLauncherProxy
    extends CommandLauncher {
        private CommandLauncher _launcher;

        CommandLauncherProxy(CommandLauncher launcher) {
            this._launcher = launcher;
        }

        public Process exec(Project project, String[] cmd, String[] env) throws IOException {
            return this._launcher.exec(project, cmd, env);
        }
    }

    private static class Java13CommandLauncher
    extends CommandLauncher {
        private Method _execWithCWD = (class$java$lang$Runtime == null ? (class$java$lang$Runtime = Java13CommandLauncher.class$("java.lang.Runtime")) : class$java$lang$Runtime).getMethod("exec", array$Ljava$lang$String == null ? (array$Ljava$lang$String = Java13CommandLauncher.class$("[Ljava.lang.String;")) : array$Ljava$lang$String, array$Ljava$lang$String == null ? (array$Ljava$lang$String = Java13CommandLauncher.class$("[Ljava.lang.String;")) : array$Ljava$lang$String, class$java$io$File == null ? (class$java$io$File = Java13CommandLauncher.class$("java.io.File")) : class$java$io$File);
        static /* synthetic */ Class array$Ljava$lang$String;
        static /* synthetic */ Class class$java$io$File;
        static /* synthetic */ Class class$java$lang$Runtime;

        public Process exec(Project project, String[] cmd, String[] env, File workingDir) throws IOException {
            try {
                if (project != null) {
                    project.log("Execute:Java13CommandLauncher: " + Commandline.describeCommand(cmd), 4);
                }
                Object[] arguments = new Object[]{cmd, env, workingDir};
                return (Process)this._execWithCWD.invoke((Object)Runtime.getRuntime(), arguments);
            }
            catch (InvocationTargetException exc) {
                Throwable realexc = exc.getTargetException();
                if (realexc instanceof ThreadDeath) {
                    throw (ThreadDeath)realexc;
                }
                if (realexc instanceof IOException) {
                    throw (IOException)realexc;
                }
                throw new BuildException("Unable to execute command", realexc);
            }
            catch (Exception exc) {
                throw new BuildException("Unable to execute command", exc);
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private static class Java11CommandLauncher
    extends CommandLauncher {
        private Java11CommandLauncher() {
        }

        public Process exec(Project project, String[] cmd, String[] env) throws IOException {
            String[] newcmd = new String[cmd.length];
            int i = 0;
            while (i < cmd.length) {
                newcmd[i] = Commandline.quoteArgument(cmd[i]);
                ++i;
            }
            if (project != null) {
                project.log("Execute:Java11CommandLauncher: " + Commandline.describeCommand(newcmd), 4);
            }
            return Runtime.getRuntime().exec(newcmd, env);
        }
    }

    private static class CommandLauncher {
        private CommandLauncher() {
        }

        public Process exec(Project project, String[] cmd, String[] env) throws IOException {
            if (project != null) {
                project.log("Execute:CommandLauncher: " + Commandline.describeCommand(cmd), 4);
            }
            return Runtime.getRuntime().exec(cmd, env);
        }

        public Process exec(Project project, String[] cmd, String[] env, File workingDir) throws IOException {
            if (workingDir == null) {
                return this.exec(project, cmd, env);
            }
            throw new IOException("Cannot execute a process in different directory under this JVM");
        }
    }
}

