/* connection.c generated by valac 0.11.6, the Vala compiler
 * generated from connection.vala, do not modify */

/*
 * Copyright(C) 2010 Neil Jagdish Patel
 * Copyright(C) 2010 Canonical Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 * Authored by Ken VaDine <ken.vandine@canonical.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <dbus/dbus-glib.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <string.h>
#include <dbus/dbus.h>
#include "gwibber.h"
#include <stdlib.h>


#define TYPE_CONNECTION_INTERFACE (connection_interface_get_type ())
#define CONNECTION_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONNECTION_INTERFACE, ConnectionInterface))
#define IS_CONNECTION_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONNECTION_INTERFACE))
#define CONNECTION_INTERFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_CONNECTION_INTERFACE, ConnectionInterfaceIface))

typedef struct _ConnectionInterface ConnectionInterface;
typedef struct _ConnectionInterfaceIface ConnectionInterfaceIface;
typedef struct _DBusObjectVTable _DBusObjectVTable;
typedef struct _ConnectionInterfaceDBusProxy ConnectionInterfaceDBusProxy;
typedef DBusGProxyClass ConnectionInterfaceDBusProxyClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _dbus_g_connection_unref0(var) ((var == NULL) ? NULL : (var = (dbus_g_connection_unref (var), NULL)))

struct _ConnectionInterfaceIface {
	GTypeInterface parent_iface;
	gboolean (*isConnected) (ConnectionInterface* self, GError** error);
};

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};

struct _ConnectionInterfaceDBusProxy {
	DBusGProxy parent_instance;
	gboolean disposed;
};

struct _GwibberConnectionPrivate {
	ConnectionInterface* conn_service;
	GwibberUtils* utils;
};


static gpointer gwibber_connection_parent_class = NULL;

ConnectionInterface* connection_interface_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
GType connection_interface_get_type (void) G_GNUC_CONST;
gboolean connection_interface_isConnected (ConnectionInterface* self, GError** error);
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);
static void _vala_dbus_unregister_object (gpointer connection, GObject* object);
void connection_interface_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _connection_interface_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult connection_interface_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_connection_interface_introspect (ConnectionInterface* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_connection_interface_property_get_all (ConnectionInterface* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_connection_interface_isConnected (ConnectionInterface* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_connection_interface_connection_offline (GObject* _sender, DBusConnection* _connection);
static void _dbus_connection_interface_connection_online (GObject* _sender, DBusConnection* _connection);
GType connection_interface_dbus_proxy_get_type (void) G_GNUC_CONST;
static void _dbus_handle_connection_interface_connection_offline (ConnectionInterface* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_handle_connection_interface_connection_online (ConnectionInterface* self, DBusConnection* connection, DBusMessage* message);
DBusHandlerResult connection_interface_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
enum  {
	CONNECTION_INTERFACE_DBUS_PROXY_DUMMY_PROPERTY
};
static gboolean connection_interface_dbus_proxy_isConnected (ConnectionInterface* self, GError** error);
static void connection_interface_dbus_proxy_connection_interface__interface_init (ConnectionInterfaceIface* iface);
static void _vala_connection_interface_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_connection_interface_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define GWIBBER_CONNECTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GWIBBER_TYPE_CONNECTION, GwibberConnectionPrivate))
enum  {
	GWIBBER_CONNECTION_DUMMY_PROPERTY
};
#define GWIBBER_CONNECTION_conn_name "com.Gwibber.Connection"
#define GWIBBER_CONNECTION_conn_path "/com/gwibber/Connection"
#define GWIBBER_CONNECTION_conn_iface "com.Gwibber.Connection"
static void gwibber_connection_connection_offline (GwibberConnection* self);
static void gwibber_connection_connection_online (GwibberConnection* self);
static GObject * gwibber_connection_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
GwibberUtils* gwibber_utils_new (void);
GwibberUtils* gwibber_utils_construct (GType object_type);
void gwibber_utils_setup (GwibberUtils* self, const gchar* name, GError** error);
static void _gwibber_connection_conn_available_gwibber_utils_available (GwibberUtils* _sender, gboolean up, gpointer self);
static void _gwibber_connection_connection_offline_connection_interface_connection_offline (ConnectionInterface* _sender, gpointer self);
static void _gwibber_connection_connection_online_connection_interface_connection_online (ConnectionInterface* _sender, gpointer self);
static void gwibber_connection_finalize (GObject* obj);

static const DBusObjectPathVTable _connection_interface_dbus_path_vtable = {_connection_interface_dbus_unregister, connection_interface_dbus_message};
static const _DBusObjectVTable _connection_interface_dbus_vtable = {connection_interface_dbus_register_object};

gboolean connection_interface_isConnected (ConnectionInterface* self, GError** error) {
	return CONNECTION_INTERFACE_GET_INTERFACE (self)->isConnected (self, error);
}


static void connection_interface_base_init (ConnectionInterfaceIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("connection_offline", TYPE_CONNECTION_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
		g_signal_new ("connection_online", TYPE_CONNECTION_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	}
}


static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	if (vtable) {
		vtable->register_object (connection, path, object);
	} else {
		g_warning ("Object does not implement any D-Bus interface");
	}
}


static void _vala_dbus_unregister_object (gpointer connection, GObject* object) {
	char* path;
	path = g_object_steal_data ((GObject*) object, "dbus_object_path");
	dbus_connection_unregister_object_path (connection, path);
	g_free (path);
}


void _connection_interface_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_connection_interface_introspect (ConnectionInterface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"com.Gwibber.Connection\">\n  <method name=\"isConnected\">\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <signal name=\"ConnectionOffline\">\n  </signal>\n  <signal name=\"ConnectionOnline\">\n  </signal>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_connection_interface_property_get_all (ConnectionInterface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp0_;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp0_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp0_);
	if (strcmp (interface_name, "com.Gwibber.Connection") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_connection_interface_isConnected (ConnectionInterface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	gboolean result;
	DBusMessage* reply;
	dbus_bool_t _tmp1_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	result = connection_interface_isConnected (self, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp1_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_BOOLEAN, &_tmp1_);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


DBusHandlerResult connection_interface_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_connection_interface_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		result = _dbus_connection_interface_property_get_all (object, connection, message);
	} else if (dbus_message_is_method_call (message, "com.Gwibber.Connection", "isConnected")) {
		result = _dbus_connection_interface_isConnected (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static void _dbus_connection_interface_connection_offline (GObject* _sender, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "com.Gwibber.Connection", "ConnectionOffline");
	dbus_message_iter_init_append (_message, &_iter);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


static void _dbus_connection_interface_connection_online (GObject* _sender, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "com.Gwibber.Connection", "ConnectionOnline");
	dbus_message_iter_init_append (_message, &_iter);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


void connection_interface_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_connection_interface_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
	g_signal_connect (object, "connection-offline", (GCallback) _dbus_connection_interface_connection_offline, connection);
	g_signal_connect (object, "connection-online", (GCallback) _dbus_connection_interface_connection_online, connection);
}


GType connection_interface_get_type (void) {
	static volatile gsize connection_interface_type_id__volatile = 0;
	if (g_once_init_enter (&connection_interface_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ConnectionInterfaceIface), (GBaseInitFunc) connection_interface_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType connection_interface_type_id;
		connection_interface_type_id = g_type_register_static (G_TYPE_INTERFACE, "ConnectionInterface", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (connection_interface_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (connection_interface_type_id, g_quark_from_string ("ValaDBusInterfaceProxyType"), &connection_interface_dbus_proxy_get_type);
		g_type_set_qdata (connection_interface_type_id, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_connection_interface_dbus_vtable));
		g_once_init_leave (&connection_interface_type_id__volatile, connection_interface_type_id);
	}
	return connection_interface_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (ConnectionInterfaceDBusProxy, connection_interface_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_CONNECTION_INTERFACE, connection_interface_dbus_proxy_connection_interface__interface_init) );
ConnectionInterface* connection_interface_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	ConnectionInterface* self;
	self = g_object_new (connection_interface_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "com.Gwibber.Connection", NULL);
	return self;
}


static GObject* connection_interface_dbus_proxy_construct (GType gtype, guint n_properties, GObjectConstructParam* properties) {
	GObject* self;
	DBusGConnection *connection;
	char* path;
	char* filter;
	self = G_OBJECT_CLASS (connection_interface_dbus_proxy_parent_class)->constructor (gtype, n_properties, properties);
	g_object_get (self, "connection", &connection, NULL);
	g_object_get (self, "path", &path, NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), connection_interface_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s',interface='com.Gwibber.Connection'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	dbus_g_connection_unref (connection);
	g_free (path);
	g_free (filter);
	return self;
}


static void _dbus_handle_connection_interface_connection_offline (ConnectionInterface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	DBusMessage* reply;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return;
	}
	dbus_message_iter_init (message, &iter);
	g_signal_emit_by_name (self, "connection-offline");
}


static void _dbus_handle_connection_interface_connection_online (ConnectionInterface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	DBusMessage* reply;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return;
	}
	dbus_message_iter_init (message, &iter);
	g_signal_emit_by_name (self, "connection-online");
}


DBusHandlerResult connection_interface_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
		if (dbus_message_is_signal (message, "com.Gwibber.Connection", "ConnectionOffline")) {
			_dbus_handle_connection_interface_connection_offline (user_data, connection, message);
		} else if (dbus_message_is_signal (message, "com.Gwibber.Connection", "ConnectionOnline")) {
			_dbus_handle_connection_interface_connection_online (user_data, connection, message);
		}
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void connection_interface_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	if (((ConnectionInterfaceDBusProxy*) self)->disposed) {
		return;
	}
	((ConnectionInterfaceDBusProxy*) self)->disposed = TRUE;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), connection_interface_dbus_proxy_filter, self);
	G_OBJECT_CLASS (connection_interface_dbus_proxy_parent_class)->dispose (self);
}


static void connection_interface_dbus_proxy_class_init (ConnectionInterfaceDBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->constructor = connection_interface_dbus_proxy_construct;
	G_OBJECT_CLASS (klass)->dispose = connection_interface_dbus_proxy_dispose;
	G_OBJECT_CLASS (klass)->get_property = _vala_connection_interface_dbus_proxy_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_connection_interface_dbus_proxy_set_property;
}


static void connection_interface_dbus_proxy_init (ConnectionInterfaceDBusProxy* self) {
}


static gboolean connection_interface_dbus_proxy_isConnected (ConnectionInterface* self, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	gboolean _result;
	dbus_bool_t _tmp10_;
	if (((ConnectionInterfaceDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return FALSE;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "com.Gwibber.Connection", "isConnected");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain = 0;
		gint _ecode = 0;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp11_;
			_edomain = DBUS_GERROR;
			_tmp11_ = _dbus_error.name + 27;
			if (strcmp (_tmp11_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp11_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp11_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp11_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp11_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp11_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp11_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp11_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp11_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp11_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp11_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp11_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp11_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp11_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp11_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp11_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp11_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp11_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp11_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp11_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp11_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp11_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp11_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp11_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp11_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp11_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp11_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp11_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp11_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp11_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp11_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp11_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp11_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return FALSE;
	}
	if (strcmp (dbus_message_get_signature (_reply), "b")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "b", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return FALSE;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp10_);
	dbus_message_iter_next (&_iter);
	_result = _tmp10_;
	dbus_message_unref (_reply);
	return _result;
}


static void connection_interface_dbus_proxy_connection_interface__interface_init (ConnectionInterfaceIface* iface) {
	iface->isConnected = connection_interface_dbus_proxy_isConnected;
}


static void _vala_connection_interface_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
}


static void _vala_connection_interface_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
}


GwibberConnection* gwibber_connection_construct (GType object_type) {
	GwibberConnection * self = NULL;
	self = (GwibberConnection*) g_object_new (object_type, NULL);
	return self;
}


GwibberConnection* gwibber_connection_new (void) {
	return gwibber_connection_construct (GWIBBER_TYPE_CONNECTION);
}


gboolean gwibber_connection_is_connected (GwibberConnection* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = connection_interface_isConnected (self->priv->conn_service, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DBUS_GERROR) {
			goto __catch7_dbus_gerror;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = _tmp1_;
	return result;
	goto __finally7;
	__catch7_dbus_gerror:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("connection.vala:88: %s", e->message);
		result = FALSE;
		_g_error_free0 (e);
		return result;
	}
	__finally7:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return FALSE;
}


static void gwibber_connection_connection_offline (GwibberConnection* self) {
	g_return_if_fail (self != NULL);
	g_signal_emit_by_name (self, "connection-changed", FALSE);
}


static void gwibber_connection_connection_online (GwibberConnection* self) {
	g_return_if_fail (self != NULL);
	g_signal_emit_by_name (self, "connection-changed", TRUE);
}


void gwibber_connection_conn_available (GwibberConnection* self, gboolean is_up) {
	g_return_if_fail (self != NULL);
	g_signal_emit_by_name (self, "is-available", is_up);
}


static void _gwibber_connection_conn_available_gwibber_utils_available (GwibberUtils* _sender, gboolean up, gpointer self) {
	gwibber_connection_conn_available (self, up);
}


static void _gwibber_connection_connection_offline_connection_interface_connection_offline (ConnectionInterface* _sender, gpointer self) {
	gwibber_connection_connection_offline (self);
}


static void _gwibber_connection_connection_online_connection_interface_connection_online (ConnectionInterface* _sender, gpointer self) {
	gwibber_connection_connection_online (self);
}


static GObject * gwibber_connection_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GwibberConnection * self;
	DBusGConnection* _tmp0_ = NULL;
	DBusGConnection* dbus_conn;
	ConnectionInterface* _tmp1_;
	GwibberUtils* _tmp2_ = NULL;
	GwibberUtils* _tmp3_;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (gwibber_connection_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GWIBBER_CONNECTION (obj);
	_tmp0_ = dbus_g_bus_get (DBUS_BUS_SESSION, &_inner_error_);
	dbus_conn = _tmp0_;
	if (_inner_error_ != NULL) {
		goto __catch8_g_error;
	}
	_tmp1_ = connection_interface_dbus_proxy_new (dbus_conn, GWIBBER_CONNECTION_conn_name, GWIBBER_CONNECTION_conn_path);
	_g_object_unref0 (self->priv->conn_service);
	self->priv->conn_service = _tmp1_;
	_tmp2_ = gwibber_utils_new ();
	_tmp3_ = _tmp2_;
	_g_object_unref0 (self->priv->utils);
	self->priv->utils = _tmp3_;
	gwibber_utils_setup (self->priv->utils, GWIBBER_CONNECTION_conn_name, &_inner_error_);
	if (_inner_error_ != NULL) {
		_dbus_g_connection_unref0 (dbus_conn);
		goto __catch8_g_error;
	}
	g_signal_connect_object (self->priv->utils, "available", (GCallback) _gwibber_connection_conn_available_gwibber_utils_available, self, 0);
	g_signal_connect_object (self->priv->conn_service, "connection-offline", (GCallback) _gwibber_connection_connection_offline_connection_interface_connection_offline, self, 0);
	g_signal_connect_object (self->priv->conn_service, "connection-online", (GCallback) _gwibber_connection_connection_online_connection_interface_connection_online, self, 0);
	_dbus_g_connection_unref0 (dbus_conn);
	goto __finally8;
	__catch8_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("connection.vala:79: Unable to get Gwibber connection service");
		_g_error_free0 (e);
	}
	__finally8:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	return obj;
}


static void gwibber_connection_class_init (GwibberConnectionClass * klass) {
	gwibber_connection_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GwibberConnectionPrivate));
	G_OBJECT_CLASS (klass)->constructor = gwibber_connection_constructor;
	G_OBJECT_CLASS (klass)->finalize = gwibber_connection_finalize;
	/** 
	            Connection::is_available:
	            @arg0: The current state
	
	            Emitted when com.Gwibber.Connection availability state changes
	*/
	g_signal_new ("is_available", GWIBBER_TYPE_CONNECTION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
	/** 
	            Connection::connection_changed:
	            @arg0: The current state
	
	            Emitted when network connection state changes
	        */
	g_signal_new ("connection_changed", GWIBBER_TYPE_CONNECTION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
}


static void gwibber_connection_instance_init (GwibberConnection * self) {
	self->priv = GWIBBER_CONNECTION_GET_PRIVATE (self);
}


static void gwibber_connection_finalize (GObject* obj) {
	GwibberConnection * self;
	self = GWIBBER_CONNECTION (obj);
	_g_object_unref0 (self->priv->conn_service);
	_g_object_unref0 (self->priv->utils);
	G_OBJECT_CLASS (gwibber_connection_parent_class)->finalize (obj);
}


GType gwibber_connection_get_type (void) {
	static volatile gsize gwibber_connection_type_id__volatile = 0;
	if (g_once_init_enter (&gwibber_connection_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GwibberConnectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gwibber_connection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GwibberConnection), 0, (GInstanceInitFunc) gwibber_connection_instance_init, NULL };
		GType gwibber_connection_type_id;
		gwibber_connection_type_id = g_type_register_static (G_TYPE_OBJECT, "GwibberConnection", &g_define_type_info, 0);
		g_once_init_leave (&gwibber_connection_type_id__volatile, gwibber_connection_type_id);
	}
	return gwibber_connection_type_id__volatile;
}



