/*
 * Copyright(C) 2010 Canonical Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Ken VaDine <ken.vandine@canonical.com>
 */

namespace Gwibber
{

    public class Account : GLib.Object {
        [Description(id = "Gwibber account id", blurb = "This is id Gwibber uses to identify the account")]
        public string id { get; set; }
        [Description(username = "username associated with an account", blurb = "This is the account's username assigned by the service")]
        public string username { get; set; default = null; }
        public string name { get; set; default = null; }
        public string service { get; set; default = null; }
        public string color { get; set; default = null; }
        public string site_display_name { get; set; default = null; }
        public string session_key { get; set; default = null; }
        public string secret_key { get; set; default = null; }
        public string access_token { get; set; default = null; }
        public string password { get; set; default = null; }
        public string url_prefix { get; set; default = null; }
        public string domain { get; set; default = null; }
        public string secret_token { get; set; default = null; }
        public string user_id { get; set; default = null; }
        public string send_enabled { get; set; default = null; }
        public string receive_enabled { get; set; default = null; }

        public Account (string id) {
            var accounts_service = new Gwibber.Accounts ();
            var account_string = accounts_service.lookup_str_by_id(id);
            var parser = new Json.Parser();
            try {
                parser.load_from_data(account_string, -1);
                var root_object = parser.get_root().get_object();

                foreach (var param in root_object.get_members()) {
                    GLib.Value? value = null;
                    if (root_object.get_member(param).type_name() == "gboolean") {
                        if (param == "send_enabled") {
                            this.set_property("send_enabled", root_object.get_member(param).get_boolean()?"1":"0");
                        }
                        if (param == "receive_enabled") {
                            this.set_property("receive_enabled", root_object.get_member(param).get_boolean()?"1":"0");
                        }
                    } else {
                        root_object.get_member(param).get_value(out value);
                        if (value != null) {
                          this.set_property(param, value);
                        }
                    }
                }

            } catch (GLib.Error e) {
                warning (e.message);
            }
        }
    }
}
