/*
 * Copyright (C) 2010 Neil Jagdish Patel
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <njpatel@gmail.com>
 */

namespace GwibberGtk
{
  public class StreamViewTile : Gtk.HBox
  {
    private Gtk.Alignment alignment;
    private Gtk.Image  icon;
    private Gtk.VBox   vbox;
    private new Gtk.Label  name;
    private Gtk.Label  time;
    private Gtk.Label  message;
    private Gdk.Color  color;

    public uint uid = 0;

    public StreamViewTile ()
    {
      Object (homogeneous:false, spacing:12);
      set_border_width (4);
    }

    construct
    {
      alignment = new Gtk.Alignment (0.5f, 0.0f, 0.0f, 0.0f);
      pack_start (alignment, false, false, 0);

      icon = new Gtk.Image.from_icon_name ("stock_person", Gtk.IconSize.DIALOG);
      alignment.add (icon);

      vbox = new Gtk.VBox (false, 0);
      pack_start (vbox, true, true, 0);
      
      var hbox = new Gtk.HBox (false, 0);
      vbox.pack_start (hbox, false, false, 2);
      
      name = new Gtk.Label ("");
      name.set_markup ("<b>Neil Jagdish Patel</b>");
      name.set_alignment (0.0f, 0.5f);
      hbox.pack_start (name, true, true, 0);

      time = new Gtk.Label ("");
      time.set_markup ("<span font_weight='light' font_size='small'>24 mins</span>");
      time.set_alignment (0.0f, 1.0f);
      hbox.pack_start (time, false, false, 0);

      message = new Gtk.Label ("");
      message.set_single_line_mode (false);
      message.set_line_wrap (true);
      message.set_line_wrap_mode (Pango.WrapMode.WORD_CHAR);
      message.set_alignment (0.0f, 0.0f);
      vbox.pack_start (message, false, false, 2);
    }

    private void rounded_rect (Cairo.Context cr, int x1, int y1, int x2, int y2, int radius)
    {
      var x = x1;
      var y = y1;

      var width = x2;
      var height = y2;

      cr.move_to  (x, y + radius * 2.2);
      cr.curve_to (x - 2, y + radius *2,
                   x - 2, y + radius *2,
                   x - 8, y + radius * 1.5);
      cr.curve_to (x, y + radius * 1.5,
                   x, y + radius * 1.5,
                   x, y + radius);

      cr.curve_to (x, y,
                   x, y,
                   x + radius, y);
      cr.line_to  (width - radius, y);
      cr.curve_to (width, y,
                   width, y,
                    
                   
                   width, y + radius);
      cr.line_to  (width, height - radius);
      cr.curve_to (width, height,
                   width, height,
                   width - radius, height);
      cr.line_to  (x + radius, height);
      cr.curve_to (x, height,
                   x, height,
                   x, height - radius);
      cr.close_path ();
    }

    public override bool expose_event (Gdk.EventExpose event)
    {
      var radius = 10;
      Gtk.Allocation alloc;    
      var cr = Gdk.cairo_create (this.window);

      cr.rectangle (event.area.x, event.area.y,
                    event.area.width, event.area.height);
      cr.clip ();

      cr.set_operator (Cairo.Operator.OVER);
      cr.set_line_width (1.0f);
      cr.translate (-0.5, -0.5);
      
      vbox.get_allocation (out alloc);
  
      rounded_rect (cr,
                    alloc.x - 3, alloc.y + 1,
                    alloc.x + alloc.width + 3,
                    alloc.y + alloc.height - 1,
                    radius);

      var p = new Cairo.Pattern.linear (alloc.x, alloc.y,
                                        alloc.x, alloc.y + alloc.height);
      p.add_color_stop_rgba (1, color.red / 65535.0 , color.green / 65535.0, color.blue / 65535.0, 0.2);
      p.add_color_stop_rgba (0.0, 1, 1, 1, 1);
      cr.set_source (p);
      cr.fill_preserve ();

      cr.set_source_rgba (102/255.0f, 102/255.0f, 102/255.0f, 0.5f);
      cr.stroke ();

      propagate_expose (alignment, event);
      propagate_expose (vbox, event);      

      return true;
    }
    
    public void reset ()
    {
      hide ();
    }

    public void set_details (uint   _uid,
                             string _service,
                             string _name,
                             uint   _timestamp,
                             string _message,
                             string _icon_uri,
                             string _color)
    {
      Gtk.Allocation alloc;
      uid = _uid;
      name.set_markup ("<b>" + _name + "</b>");

      message.set_markup (_message);

      vbox.get_allocation (out alloc);
      message.set_size_request (alloc.width, -1);

      Gdk.Color.parse(_color, out color);
      
      queue_resize ();
      show ();
    }                        
  }
}
