/*
 * Copyright (C) 2010 Canonical Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Ken VanDine <ken.vandine@canonical.com>
 */

using System;
using Gwibber;
using GLib;

namespace GwibberExample
{
	class MainClass
	{
		public static void Main (string[] args) {
			GType.Init ();

                        for (int idx = 0; idx < args.Length; idx++) {
                                switch (args [idx]) {
                                case "--refresh":
					Refresh ();
                                        break;
                                case "--version":
					Console.WriteLine ("Gwibber service version: " +  Version ());
                                        break;
                                case "--start":
					Start ();
                                        break;
                                case "--shutdown":
					Quit ();
                                        break;
                                case "--accounts":
					List ();
                                        break;
                                case "--send-message":
                                        if (idx + 1 < args.Length
                                                        && args [idx + 1] != null
                                                        && args [idx + 1] != String.Empty
                                                        && args [idx + 1][0] != '-') {
                                                SendMessage ((string) args [++idx]);
                                        } else {
						PrintUsage();
					}
                                        break;
                                case "--help":
                                case "--usage":
                                        PrintUsage ();
                                        break;
                                default:
                                        PrintUsage ();
                                        break;
                                }
			}
		}

                public static void PrintUsage () {
                        string usage = "Usage:\n" +
                                        "  --help\t\t\tPrint this usage message.\n" +
                                        "  --start\t\t\tStart the gwibber-service\n" +
                                        "  --shutdown\t\t\tShutdown the gwibber-service\n" +
                                        "  --refresh\t\t\tRefresh the gwibber-service\n" +
                                        "  --accounts\t\t\tList accounts\n" +
                                        "  --send-message [message]\t\tMessage to post\n" +
                                        "  --version\t\t\tReturns the version of the gwibber-service\n";
                        Console.WriteLine (usage);
                }

		public static void Start () {
			Gwibber.Service service = new Gwibber.Service ();
			service.Start ();
			Console.WriteLine ("Starting the Gwibber service");
		}

		public static void Quit () {
			Gwibber.Service service = new Gwibber.Service ();
			service.Quit ();
			Console.WriteLine ("Shutting down the Gwibber service");
		}

		public static void Refresh () {
			Gwibber.Service service = new Gwibber.Service ();
			service.Refresh ();
			Console.WriteLine ("Gwibber service refreshed");
		}

		public static string Version () {
			Gwibber.Service service = new Gwibber.Service ();
			string version = service.Version ();
			return version;
		}

		public static void SendMessage (string message) {
			Gwibber.Service service = new Gwibber.Service ();
			service.SendMessage (message);
		}
		public static void List () {
			Gwibber.Accounts accounts_service = new Gwibber.Accounts ();
			var accounts = accounts_service.List ();
		}
	}
}


