// the runtime does not care about handling specifics...
#define __NO_GTKOL_DIALOG__
#define __NO_GTKOL_MENU__
#define __NO_GTKOL_BUTTON__
#define __NO_GTKOL_LAYOUT__
#define __NO_GTKOL_VIEW__

// get the gtkol application definition and the generics metamodule importer API
#include "capplication.h"
#include "cmetamoduleimporter.h"

//------------------------------------------------------------------------------------------------------------------------------------------
// gtkol-runtime entry point
//------------------------------------------------------------------------------------------------------------------------------------------
int main (int argc, char **argv)
{
	// check command line
	if (argc != 2)
	{
		printf ("%s file.xml\n", argv[0]);
		return 0;
	}

	// get the potential runtime modules
	CStrings inMetaModuleNames (CMetaModuleImporter::GetLibNames (CString("./modules/")));

	// declare a metamodule importer list
	TBuffer <CMetaModuleImporter *> theMetaModuleImporters;

	// foreach potential module, try to link it with the metamodule importer API
	for (size_t i=inMetaModuleNames.GetLength(), j=0; i>0; i--, j++)
	{
		try
		{
			theMetaModuleImporters += new CMetaModuleImporter (*inMetaModuleNames[i-1]);
			printf ("%s : imported %s\n", argv[0], (*theMetaModuleImporters[j]) -> GetModuleMetaClass() -> ClassName.Get());
		}
		catch (CException *e)
		{
			printf ("An exception occured : %s\n", e->GetMessage().Get());
		}
	}
	
	// we got the runtime modules, so try to instanciate the whole xml described gtkol application
	try
	{
		// get an xml doc, check its root element
		CXMLDocument XMLDoc (CString(argv[1]), XML_READ, CString("gtkol"));
		CXMLElementNode *inXMLNode = XMLDoc.GetRootElement();

		// instanciate the specified gtkol hierarchy
		CSerialized *inSerialized = CSerialized::Instanciate (inXMLNode);

		// check we got an expected CApplication instance and launch it if so !
		if (inSerialized -> ClassIs (__metaclass(CApplication))) static_cast <CApplication *> (inSerialized) -> Run ();

		// free the pointers
		delete inXMLNode;
		delete inSerialized;
	}
	// so sad...
	catch (CException *e)
	{
		printf ("An exception occured : %s\n", e->GetMessage().Get());
		return -1;
	}

	// unlink the modules and free any resource
	for (size_t i=theMetaModuleImporters.GetLength(); i>0; i--) delete *theMetaModuleImporters[i-1];

	// ok
	return 0;
}
