/*****************************************************************************************************************************************
 gtkol-hello-world.c

 Simple gtkol hello world !
*****************************************************************************************************************************************/

#include "capplication.h"

//----------------------------------------------------------------------------------------------------------------------------------------
// CHelloWorldForm
//----------------------------------------------------------------------------------------------------------------------------------------
class CHelloWorldForm : public CForm
{
	protected :

		// specific form listener
		class CHelloWorldFormListener : public CFormListener
		{
			// called when the form is painted
			virtual void OnPaint (CObject *, CGraphics &ioGraphics)
			{
				ioGraphics.DrawString (CString("Hello World !"), TPoint(10,10));
			}
		};

	public :

		// hello world form constructor
		CHelloWorldForm (CApplication *inApplication) : CForm (inApplication, new CHelloWorldFormListener())
		{
			// caption and bounds affectation
			SetCaption (CString("Gtkol Demo"));
			SetBounds  (TBounds(0, 0, 320, 240));

			// show the form
			Show ();
		}
};

//----------------------------------------------------------------------------------------------------------------------------------------
// demonstration entry point
//----------------------------------------------------------------------------------------------------------------------------------------
int main (int argc, char **argv)
{
	// be proper, catch any potential exception
	try
	{
		// declare a gtkol application instance giving it the command line arguments; those arguments are used to 
		// initialize the gtk library (there won't be any initilization if you do not specify those arguments).
		CApplication Application (argc, argv);

		// instanciate our main form
		new CHelloWorldForm (&Application);

		// launch the application event queue dispatching
		Application.Run ();
	}
	// an exception occurred, just print it and return (libgenerics implements an exceptions garbage, so no need to delete it)
	catch (CException *inException)
	{
		// so sad, aren't you ?
		fprintf (stderr, "%s\n", inException->GetMessage().Get());

		// stop
		return -1;
	}

	// fine...
	return 0;
}

