/*******************************************************************************************************************************************
 cradiobutton.h
 
 CClass						CClass
 |--CSerialized					|--CSerialized
    |--CMetaModule				   |--CMetaModule
       |--CObject				      |--CObjectListener
          |--CComponent				         |
	     |--CControl				 |
	        |--CWidget				 |--CWidgetListener
		   |--CContainer			    |
		      |--CButton			    |--CButtonListener
		         |--CToggleButton
			    |--CCheckButton
			       |--CRadioButton

 Standard radio button definition. A radio button is a member of some group of radio buttons. When one is selected, all other radio buttons
 in the same group are deselected. A radio button is one way of giving the user a choice and only one from many options.
 GtkOL does not need the programmer to specifiy the group the radio button belongs to. Unstead, the library considers that all of the radio
 buttons that are instanciated under the same owner are members of the same logical group.
*******************************************************************************************************************************************/

#ifndef __CRADIOBUTTON_H__
#define __CRADIOBUTTON_H__

#include "ccheckbutton.h"

//-----------------------------------------------------------------------------------------------------------------------------------------
// CRadioButton class
//-----------------------------------------------------------------------------------------------------------------------------------------
class CRadioButton : public CCheckButton
{
	// instanciation section
	public :

		CRadioButton			(CContainer *inOwner=NULL, const CButtonListener *inListener=NULL);
		virtual ~CRadioButton		();

	// protected instanciation process definition
	protected :

		// specific gtk widget instanciation
		virtual GtkWidget *		PerformWidgetInstanciate	();

	// CComponent redefinition
	public :

		// owner affectation, implicit radio group modification handling
		virtual bool			SetOwner			(CComponent *inOwner, const SInt16 inIndex=-1);

	// CToggleButton check functions redefinition
	public :

		// toggle state; true if pressed, does not generate a OnClick event on this instance
		virtual void			Check				(const bool inCheck=true);

		// metaclass association
		SECTION_DYNAMIC_METACLASS;
};

// class tag and metaclass declaration
DECLARE_DYNAMIC_METACLASS ('rbtn', CRadioButton, CCheckButton);

#endif
