/*******************************************************************************************************************************************
 cprogressbar.h
 
 CClass					CClass
 |--CSerialized				|--CSerialized
    |--CMetaModule			   |--CMetaModule
       |--CObject			      |--CObjectListener
          |--CComponent			         |
	     |--CControl			 |
	        |--CWidget			 |--CWidgetListener
		   |--CProgressBar

 The CProgressBar is typically used to display the progress of a long running operation.
*******************************************************************************************************************************************/

#ifndef __CPROGRESSBAR_H__
#define __CPROGRESSBAR_H__

#include "ccontainer.h"

//-----------------------------------------------------------------------------------------------------------------------------------------
// cprogressbar xml serialization constant definition
//-----------------------------------------------------------------------------------------------------------------------------------------
// <cprogressbar caption="string" fraction="double" pulse-step="double"
//		 orientation="left-to-right|right-to-left|bottom-to-top|top-to-bottom">
//   ...
// </cprogressbar>
//-----------------------------------------------------------------------------------------------------------------------------------------
static CString XML_PROGRESSBAR_ELEMENT			("cprogressbar");
static CString XML_PROGRESSBAR_ATTR_CAPTION		("caption");
static CString XML_PROGRESSBAR_ATTR_FRACTION		("fraction");
static CString XML_PROGRESSBAR_ATTR_PULSE_STEP		("pulse-step");
static CString XML_PROGRESSBAR_ATTR_ORIENTATION		("orientation");

//-----------------------------------------------------------------------------------------------------------------------------------------
// CProgressBar class
//-----------------------------------------------------------------------------------------------------------------------------------------
class CProgressBar : public CWidget
{
	// instanciation section
	public :

		CProgressBar				(CContainer *inOwner=NULL, const CWidgetListener *inListener=NULL);
		virtual ~CProgressBar			();

	// protected requests handling
	protected :

		// gtk instanciation and initialization
		virtual GtkWidget *			PerformWidgetInstanciate	();
		virtual void				PerformWidgetInitialize		();

	// CComponent redefinition
	public :

		// expected owner type __metaclasses(CContainer)
		virtual CMetaClasses			OwnerMustBe			() const;

	// progress bar specifics
	public :

		// progress bar caption
		virtual void				SetCaption			(const CString &);
		virtual CString 			GetCaption			() const;

		// progress fraction
		virtual void				SetFraction			(const double);
		virtual double				GetFraction			() const;

		// pulse step
		virtual void				SetPulseStep			(const double);
		virtual double				GetPulseStep			() const;

		// pulse
		virtual void				Pulse				();

		// progress bar orientation
		virtual void				SetOrientation			(const GtkProgressBarOrientation);
		virtual GtkProgressBarOrientation	GetOrientation			() const;

	// serialization
	public :

		// progress bar serialization definition
		virtual void				Serialize			(CXMLElementNode *&ioXMLElementNode, 
											 const int inMode) THROWABLE;

		// metaclass association
		SECTION_DYNAMIC_METACLASS;
};

// metaclass and class tag declaration
DECLARE_DYNAMIC_METACLASS ('pgbr', CProgressBar, CWidget);

#endif
