/******************************************************************************************************************************************
 caboutdialog.h
 
 CClass
 |--CSerialized
    |--CMetaModule
       |--CObject
          |--CComponent
	     |--CControl
	        |--CWidget
		   |--CContainer
		      |--CForm
		         |--CDialog
			    |--CAboutDialog

 The about dialog offers a simple way to display information about a program like its logo, name, copyright, website and license. It is 
 also possible to give credits to the authors, documenters, translators and artists who have worked on the program. An about dialog is
 typically opened when the user selects the About option from the Help menu. All parts of the dialog are optional.

 About dialog often contain links and email addresses. GtkAboutDialog supports this by offering global hooks, which are called when the
 user clicks on a link or email address, see gtk_about_dialog_set_email_hook() and gtk_about_dialog_set_url_hook(). Email addresses in the
 authors, documenters and artists properties are recognized by looking for <user@host>, URLs are recognized by looking for http://url, 
 with $url extending to the next space, tab or line break.

******************************************************************************************************************************************

 SERIALIZATION NOT IMPLEMENTED YET ON THE ABOUT DIALOG.

******************************************************************************************************************************************/

#ifndef __CABOUTDIALOG_H__
#define __CABOUTDIALOG_H__

#include "cdialog.h"

//-----------------------------------------------------------------------------------------------------------------------------------------
// xml constants
//-----------------------------------------------------------------------------------------------------------------------------------------
// <caboutdialog name="string" version="string" copyright="string" license="string" web-url="string" authors="str[,str]" 
//  artits="str[,str]" documenters="str[,str]">
//   <caboutdialog-comments>string</caboutdialog-comments>
//   <caboutdialog-web-label>string</caboutdialog-web-label>
// </caboutdialog>
//-----------------------------------------------------------------------------------------------------------------------------------------
static CString XML_ABOUTDIALOG_ELEMENT		("caboutdialog");
static CString XML_ABOUTDIALOG_ATTR_NAME	("name");
static CString XML_ABOUTDIALOG_ATTR_VERSION	("version");
static CString XML_ABOUTDIALOG_ATTR_COPYRIGHT	("copyright");
static CString XML_ABOUTDIALOG_ATTR_LICENSE	("license");
static CString XML_ABOUTDIALOG_ATTR_WEBURL	("web-url");
static CString XML_ABOUTDIALOG_ATTR_AUTHORS	("authors");
static CString XML_ABOUTDIALOG_ATTR_ARTITS	("artits");
static CString XML_ABOUTDIALOG_ATTR_DOCUMENTERS	("documenters");
static CString XML_ABOUTDIALOG_ELEMENT_WEBLABEL	("caboutdialog-web-label");
static CString XML_ABOUTDIALOG_ELEMENT_COMMENTS	("caboutdialog-comments");

//-----------------------------------------------------------------------------------------------------------------------------------------
// CAboutDialog class
//-----------------------------------------------------------------------------------------------------------------------------------------
class CAboutDialog : public CDialog
{
	// instanciation section
	public :

		CAboutDialog			(CForm *inOwner=NULL, const CString &inCaption=CString(), const bool inModal=false, 
						 const CDialogListener *inListener=NULL);
		virtual ~CAboutDialog		();

	// protected gtk widget handling
	protected :

		// perform the widget instanciation and initialization
		virtual GtkWidget *		PerformWidgetInstanciate	();
		virtual void			PerformWidgetInitialize		();

	// about dialog specifics
	public :

		// name  
		virtual void			SetName				(const CString &);
		CString				GetName				() const;

		// set the version 
		virtual void			SetVersion			(const CString &);
		CString				GetVersion			() const;

		// set the copyright
		virtual void			SetCopyright			(const CString &);
		CString				GetCopyright			() const;

		// set the license 
		virtual void			SetLicense			(const CString &);
		CString				GetLicense			() const;

		// set the comments
		virtual void			SetComments			(const CString &);
		CString				GetComments			() const;

		// set website "http://"
		virtual void			SetWebSite			(const CString &inLabel, const CString &inURL);
		CString				GetWebSiteLabel			() const;
		CString				GetWebSiteURL			() const;

		// authors
		virtual void			SetAuthors			(const CStrings &);
		CStrings			GetAuthors			() const;

		// artits
		virtual void			SetArtits			(const CStrings &);
		CStrings			GetArtits			() const;

		// documenters
		virtual void			SetDocumenters			(const CStrings &);
		CStrings			GetDocumenters			() const;

		// logo
		virtual void			SetLogo				(const CPixbuf *);
		const CPixbuf *			GetLogo				() const;

	// CSerialized redefinition
	public :

		// message dialog xml serialization
		virtual void			Serialize			(CXMLElementNode *&ioXMLElementNode, const int inMode)
										 THROWABLE;

	// protected components
	protected :

		CPixbuf *			m_Pixbuf;

		// metaclass assocation
		SECTION_DYNAMIC_METACLASS;
};

// metaclass and class tag declaration
DECLARE_DYNAMIC_METACLASS ('adlg', CAboutDialog, CDialog);

#endif
