/*
 * Copyright (c) 2002 Robert Collins.
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     A copy of the GNU General Public License can be found at
 *     http://www.gnu.org/
 *
 * Written by Robert Collins <robertc@hotmail.com>
 *
 */

#ifndef _NUMERICOPTION_H_
#define _NUMERICOPTION_H_

#include <getopt++/Option.h>
#include <getopt++/GetOption.h>
#include <sstream>

// Each registered option must implement this class.
template <typename N> class NumericOption : public Option
{
public:
  NumericOption(N const defaultvalue, char shortopt, char const *longopt = 0,
	     std::string const &shorthelp = std::string(), bool const optional = true,
	     OptionSet &owner=GetOption::GetInstance());
  virtual ~ NumericOption ();
  virtual std::string const shortOption () const;
  virtual std::string const longOption () const;
  virtual std::string const shortHelp () const;
  virtual Result Process (char const *);
  virtual Argument argument () const;
  operator N () const;

private:
  Argument _optional;
  N _value;
  char _shortopt;
  char const *_longopt;
  std::string _shorthelp;
};

template <typename N> 
NumericOption<N>::NumericOption(N const defaultvalue, char shortopt, 
		       char const *longopt, std::string const &shorthelp, 
		       bool const optional, OptionSet &owner) : 
		       _value (defaultvalue) , _shortopt(shortopt),
		       _longopt (longopt), _shorthelp (shorthelp)
{
  if (!optional)
    _optional = Required;
  else
    _optional = Optional;
  owner.Register (this);
};

template <typename N> 
NumericOption<N>::~ NumericOption () {};

template <typename N> 
std::string const 
NumericOption<N>::shortOption () const
{
  return std::string() + _shortopt + ":";
}

template <typename N> 
std::string const
NumericOption<N>::longOption () const
{
  return _longopt;
}

template <typename N> 
std::string const 
NumericOption<N>::shortHelp () const
{
  return _shorthelp;
}

template <typename N> 
Option::Result 
NumericOption<N>::Process (char const *optarg)
{
  if (optarg) {
    std::istringstream arg(optarg);
    arg >> _value;
  }
  if (optarg || _optional == Optional)
      return Ok;
  return Failed;
}

template <typename N> 
NumericOption<N>::operator N () const
{
  return _value;
}

template <typename N> 
Option::Argument
NumericOption<N>::argument () const
{
    return _optional;
}

#endif // _NUMERICOPTION_H_
