/**
 * =========================================
 * LibFormula : a free Java formula library
 * =========================================
 *
 * Project Info:  http://reporting.pentaho.org/libformula/
 *
 * (C) Copyright 2006-2008, by Pentaho Corporation and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 *
 * ------------
 * FormulaParser.java
 * ------------
 */
package org.pentaho.reporting.libraries.formula.parser;

import java.io.StringReader;

import org.pentaho.reporting.libraries.formula.LibFormulaBoot;
import org.pentaho.reporting.libraries.formula.lvalues.LValue;
import org.pentaho.reporting.libraries.formula.operators.DefaultOperatorFactory;
import org.pentaho.reporting.libraries.formula.operators.OperatorFactory;

public class FormulaParser extends GeneratedFormulaParser
{
  // This is my parser class
  private OperatorFactory operatorFactory;

  public FormulaParser()
  {
    super(new StringReader(""));
    operatorFactory = new DefaultOperatorFactory();
    operatorFactory.initalize(LibFormulaBoot.getInstance().getGlobalConfig());
  }

  protected OperatorFactory getOperatorFactory()
  {
    return operatorFactory;
  }

  /** @noinspection ThrowableInstanceNeverThrown,ThrowableResultOfMethodCallIgnored */
  public ParseException generateParseException()
  {
    final ParseException parent = super.generateParseException();
    return new FormulaParseException
        (parent.currentToken, parent.expectedTokenSequences, parent.tokenImage);
  }

  public LValue parse(final String formula) throws ParseException
  {
    if (formula == null)
    {
      throw new NullPointerException("Formula-text given must not be null.");
    }
    try
    {
      ReInit(new StringReader(formula));
      final LValue expression = getExpression();
      if (token.next != null && token.next.image.length() > 0)
      {
        throw new FormulaParseException("Extra content");
      }
      return expression;
    }
    catch (ParseException pe)
    {
      if (pe instanceof FormulaParseException)
      {
        throw pe;
      }
      throw new FormulaParseException(pe);
    }
  }
}
