//  This software code is made available "AS IS" without warranties of any
//  kind.  You may copy, display, modify and redistribute the software
//  code either by itself or as incorporated into your code; provided that
//  you do not remove any proprietary notices.  Your use of this software
//  code is at your own risk and you waive any claim against Amazon
//  Digital Services, Inc. or its affiliates with respect to your use of
//  this software code. (c) 2006 Amazon Digital Services, Inc. or its
//  affiliates.

package net.noderunner.amazon.s3;

/**
 * A representation of a single object stored in S3.
 */
public class S3Object {

	/**
	 * Data itself.
	 */
    private byte[] data;

    /**
     * Meta-data headers.
     */
    private Headers metadata;

    /**
     * Constructs a new S3Object.
     * @param data
     * @param metadata
     */
    public S3Object(byte[] data, Headers metadata) {
        this.data = data;
        this.metadata = metadata;
    }
    
    /**
     * Constructs a new S3Object.
     */
	public S3Object(byte[] data) {
		this(data, null);
	}
	
    /**
     * Constructs a new S3Object; data is converted to bytes.
     */
	public S3Object(String data) {
		this(data.getBytes());
	}

	/**
	 * Returns data.
	 */
	public byte[] getData() {
		return data;
	}

	/**
	 * Returns the length of data.
	 */
	public int getLength() {
		return data.length;
	}
	
	/**
	 * Returns metadata, unmodifiable.
	 */
	public Headers getMetadata() {
		return metadata;
	}

	/**
	 * Sets the metadata.
	 */
	public void setMetadata(Headers metadata) {
		this.metadata = metadata;
	}

	/**
	 * Returns a debug string.
	 */
	@Override
	public String toString()
	{
	    return "S3Object[" +
	        " data.length=" + this.data.length + 
	        " metadata=" + this.metadata + "]";
	}

}
