/*--------------------------------------------------------------------------+
$Id: MathUtilsTest.java 26268 2010-02-18 10:44:30Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.math;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import junit.framework.TestCase;

/**
 * Test class for {@link MathUtils}.
 * 
 * 
 * @author deissenb
 * @author $Author: juergens $
 * @version $Rev: 26268 $
 * @levd.rating GREEN Hash: 08924AC55CC3E10AD81E84660BF6D122
 */
public class MathUtilsTest extends TestCase {

	/**
	 * Array for testing aggregations. Note: {@link Arrays#asList(Object...)}
	 * does not work for primitives.
	 */
	private final Integer[] testValueArray = { 1, 7, 9, 29, 31 };

	/**
	 * Tests {@link MathUtils#sum(java.util.Collection)} and thereby
	 * {@link SumAggregator}.
	 */
	public void testSum() {
		assertEquals(77d, MathUtils.sum(Arrays.asList(testValueArray)));
	}

	/**
	 * Tests {@link MathUtils#max(java.util.Collection)} and thereby
	 * {@link MaxAggregator}.
	 */
	public void testMax() {
		assertEquals(31d, MathUtils.max(Arrays.asList(testValueArray)));
	}

	/**
	 * Tests {@link MathUtils#min(java.util.Collection)} and thereby
	 * {@link MinAggregator}.
	 */
	public void testMin() {
		assertEquals(1d, MathUtils.min(Arrays.asList(testValueArray)));
	}

	/**
	 * Tests {@link MathUtils#mean(java.util.Collection)} and thereby
	 * {@link MeanAggregator}.
	 */
	public void testMean() {
		assertEquals(15.4d, MathUtils.mean(Arrays.asList(testValueArray)));
	}

	/**
	 * Tests {@link MathUtils#median(java.util.Collection)} and thereby
	 * {@link MedianAggregator}.
	 */
	public void testMedian() {
		assertEquals(9d, MathUtils.median(Arrays.asList(testValueArray)));

		// List returned by Arrays.asList is unmodifiable
		List<Integer> testValues = new ArrayList<Integer>(Arrays
				.asList(testValueArray));
		testValues.remove(0);
		assertEquals(19d, MathUtils.median(testValues));

		testValues = new ArrayList<Integer>(Arrays.asList(testValueArray));
		testValues.remove(4);
		assertEquals(8d, MathUtils.median(testValues));

		testValues = new ArrayList<Integer>(Arrays.asList(testValueArray));
		testValues.add(35);
		assertEquals(19d, MathUtils.median(testValues));
	}

	/** Tests the {@link MathUtils#factorial(int)} method. */
	public void testFactorial() {
		assertEquals(1, MathUtils.factorial(-1));
		assertEquals(1, MathUtils.factorial(0));
		assertEquals(1, MathUtils.factorial(1));
		assertEquals(2, MathUtils.factorial(2));
		assertEquals(120, MathUtils.factorial(5));
	}
}