/*--------------------------------------------------------------------------+
$Id: MinAggregator.java 28099 2010-06-09 13:17:22Z hummelb $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.math;

/**
 * Minimum aggregator.
 * 
 * @author deissenb
 * @author $Author: hummelb $
 * @version $Rev: 28099 $
 * @levd.rating GREEN Hash: C47D5B70A68ABDC1C3CAE2320770D3E1
 */
public class MinAggregator extends PairwiseAggregatorBase {

	/** Returns {@link Double#POSITIVE_INFINITY}. */
	@Override
	public double getNeutralElement() {
		return Double.POSITIVE_INFINITY;
	}

	/** {@inheritDoc} */
	@Override
	protected double aggregate(double aggregate, double value) {
		return Math.min(aggregate, value);
	}
}