
# test new xtic code
use Chart::Strip;
use strict;

my $MK = 0;
my $H = 3600;
my $D = $H * 24;
my @t;

eval {
    # tests assume US/eastern, en_us. skip if we can't make compat.
    require POSIX;
    POSIX->import();
    $ENV{TZ} = 'EST5EDT';
    setlocale( LC_ALL(), "C" );
    tzset();
    if( localtime(1151726400) ne 'Sat Jul  1 00:00:00 2006' ){
	die "tests not configured for this timezone/locale\n";
    }
};
if($@){
    print "1..0 # Skipped: cannot make timezone/locale compatible\n";
    exit;
}

if( localtime(1175400000) ne 'Sun Apr  1 00:00:00 2007' ){
    # the US govmit changed the daylight saving time rules.
    # most OSes don't know that
    # expect the fallout from this to be much worse than y2k.

    print "1..0 # Skipped: OS has out of date daylight saving time rules\n";
    exit;
}

# return xtic data for specified time range
sub gen {
    my $t0  = shift;
    my $dur = shift;
    
    my $c = Chart::Strip->new();
    $c->add_data( [ {time => $t0,        value => 1},
		    {time => $t0 + $dur, value => 1}],
		  { style => 'line' });
    $c->plot();
    $c->{grid}{x};
}

sub test {
    my $t  = shift;
    my $mk = shift;

    if( !ref $t ){
	print "$t\n" if $mk;
	return 'ok';
    }
    
    my $t0  = $t->{start};
    my $dur = $t->{dur};
    my $exp = $t->{exp};
    
    $dur = $1 * $D if $dur =~ /(\d+)D/;
    $dur = $1 * $H if $dur =~ /(\d+)H/;
    
    my $res = gen( $t0, $dur );

    my $err;
    $err = 1 if @$res != @$exp;

    if( $mk ){
	my $pv;
	for my $r (@$res){
	    my $dt = $pv ? $r->[0] - $pv : '';
	    print "$t->{dur}\t$t0\t$r->[0]\t$r->[1]\t$r->[2]\t$dt\n";
	    $pv = $r->[0];
	}
	print "\n";
    }
    
    for my $e (@$exp){
	my $terr;
	my $r = shift @$res;
	$terr = 1 unless $e->[0] == $r->[0];
	$terr = 1 unless $e->[1] == $r->[1];
	$terr = 1 unless $e->[2] eq $r->[2];
	$err ||= $terr;

	print STDERR "error: @$e != @$r\n"
	  if $terr;
    }


    $err ? 'not ok' : 'ok';
}


my $pd = '';
while(<DATA>){
    chop;
    my @l = split;
    my $dur = $l[0];
    my $t0  = $l[1];
    my $exp = [@l[2,3,4,5]];

    if( /^\#/ ){
	# preserve comments
	push @t, $_;
	next;
    }
    next unless $dur;
    
    if($dur eq $pd){
	push @{$t[-1]{exp}}, $exp;
    }else{
	push @t, { dur => $dur, start => $t0, exp => [$exp] };
    }
    $pd = $dur;
}

print "1..", scalar @t, "\n" unless $MK;
my $n = 1;
foreach my $t (@t){
    my $r = test($t, $MK);
    print "$r ", $n++, "\n" unless $MK;
}

# duration start expected result: tic-time, redmark, label, delta(not-used)
__END__
2100D	1151726400	1167627600	0	2007	
2100D	1151726400	1199163600	0	2008	31536000
2100D	1151726400	1230786000	0	2009	31622400
2100D	1151726400	1262322000	0	2010	31536000
2100D	1151726400	1293858000	0	2011	31536000
2100D	1151726400	1325394000	0	2012	31536000

1500D	1151726400	1151726400	0	01/Jul	
1500D	1151726400	1167627600	0	2007	15901200
1500D	1151726400	1183262400	0	01/Jul	15634800
1500D	1151726400	1199163600	0	2008	15901200
1500D	1151726400	1214884800	0	01/Jul	15721200
1500D	1151726400	1230786000	0	2009	15901200
1500D	1151726400	1246420800	0	01/Jul	15634800
1500D	1151726400	1262322000	0	2010	15901200
1500D	1151726400	1277956800	0	01/Jul	15634800

750D	1151726400	1151726400	0	01/Jul	
750D	1151726400	1159675200	0	01/Oct	7948800
750D	1151726400	1167627600	1	2007	7952400
750D	1151726400	1175400000	0	01/Apr	7776000
750D	1151726400	1183262400	0	01/Jul	7858800
750D	1151726400	1191211200	0	01/Oct	7948800
750D	1151726400	1199163600	1	2008	7952400
750D	1151726400	1207022400	0	01/Apr	7862400
750D	1151726400	1214884800	0	01/Jul	7858800

400D	1151726400	1151726400	0	01/Jul	
400D	1151726400	1157083200	0	01/Sep	5356800
400D	1151726400	1162357200	0	01/Nov	5274000
400D	1151726400	1167627600	1	2007	5270400
400D	1151726400	1172725200	0	01/Mar	5097600
400D	1151726400	1177992000	0	01/May	5266800
400D	1151726400	1183262400	0	01/Jul	5270400

200D	1151726400	1151726400	0	01/Jul	
200D	1151726400	1154404800	0	01/Aug	2678400
200D	1151726400	1157083200	0	01/Sep	2678400
200D	1151726400	1159675200	0	01/Oct	2592000
200D	1151726400	1162357200	0	01/Nov	2682000
200D	1151726400	1164949200	0	01/Dec	2592000
200D	1151726400	1167627600	1	2007	2678400

100D	1151726400	1151726400	0	01/Jul	
100D	1151726400	1152936000	0	15/Jul	1209600
100D	1151726400	1154404800	0	01/Aug	1468800
100D	1151726400	1155614400	0	15/Aug	1209600
100D	1151726400	1157083200	0	01/Sep	1468800
100D	1151726400	1158292800	0	15/Sep	1209600
100D	1151726400	1159675200	0	01/Oct	1382400

50D	1151726400	1151726400	1	01/Jul	
50D	1151726400	1152331200	0	08/Jul	604800
50D	1151726400	1152936000	0	15/Jul	604800
50D	1151726400	1153540800	0	22/Jul	604800
50D	1151726400	1154404800	1	01/Aug	864000
50D	1151726400	1155009600	0	08/Aug	604800
50D	1151726400	1155614400	0	15/Aug	604800

20D	1151726400	1151726400	1	01/Jul	
20D	1151726400	1151899200	0	03/Jul	172800
20D	1151726400	1152072000	0	05/Jul	172800
20D	1151726400	1152244800	0	07/Jul	172800
20D	1151726400	1152417600	0	09/Jul	172800
20D	1151726400	1152590400	0	11/Jul	172800
20D	1151726400	1152763200	0	13/Jul	172800
20D	1151726400	1152936000	0	15/Jul	172800
20D	1151726400	1153108800	0	17/Jul	172800
20D	1151726400	1153281600	0	19/Jul	172800

12D	1151726400	1151726400	0	Sat	
12D	1151726400	1151812800	1	02/Jul	86400
12D	1151726400	1151899200	0	Mon	86400
12D	1151726400	1151985600	0	Tue	86400
12D	1151726400	1152072000	0	Wed	86400
12D	1151726400	1152158400	0	Thu	86400
12D	1151726400	1152244800	0	Fri	86400
12D	1151726400	1152331200	0	Sat	86400
12D	1151726400	1152417600	1	09/Jul	86400
12D	1151726400	1152504000	0	Mon	86400
12D	1151726400	1152590400	0	Tue	86400
12D	1151726400	1152676800	0	Wed	86400

6D	1151726400	1151726400	0	Sat	
6D	1151726400	1151812800	1	02/Jul	86400
6D	1151726400	1151899200	0	Mon	86400
6D	1151726400	1151985600	0	Tue	86400
6D	1151726400	1152072000	0	Wed	86400
6D	1151726400	1152158400	0	Thu	86400

3D	1151726400	1151726400	1	01/Jul	
3D	1151726400	1151748000	0	6:00	21600
3D	1151726400	1151769600	0	12:00	21600
3D	1151726400	1151791200	0	18:00	21600
3D	1151726400	1151812800	1	02/Jul	21600
3D	1151726400	1151834400	0	6:00	21600
3D	1151726400	1151856000	0	12:00	21600
3D	1151726400	1151877600	0	18:00	21600
3D	1151726400	1151899200	1	03/Jul	21600
3D	1151726400	1151920800	0	6:00	21600
3D	1151726400	1151942400	0	12:00	21600
3D	1151726400	1151964000	0	18:00	21600

2D	1151726400	1151726400	1	01/Jul	
2D	1151726400	1151740800	0	4:00	14400
2D	1151726400	1151755200	0	8:00	14400
2D	1151726400	1151769600	0	12:00	14400
2D	1151726400	1151784000	0	16:00	14400
2D	1151726400	1151798400	0	20:00	14400
2D	1151726400	1151812800	1	02/Jul	14400
2D	1151726400	1151827200	0	4:00	14400
2D	1151726400	1151841600	0	8:00	14400
2D	1151726400	1151856000	0	12:00	14400
2D	1151726400	1151870400	0	16:00	14400
2D	1151726400	1151884800	0	20:00	14400

18H	1151726400	1151726400	1	01/Jul	
18H	1151726400	1151733600	0	2:00	7200
18H	1151726400	1151740800	0	4:00	7200
18H	1151726400	1151748000	0	6:00	7200
18H	1151726400	1151755200	0	8:00	7200
18H	1151726400	1151762400	0	10:00	7200
18H	1151726400	1151769600	0	12:00	7200
18H	1151726400	1151776800	0	14:00	7200
18H	1151726400	1151784000	0	16:00	7200

9H	1151726400	1151726400	1	01/Jul	
9H	1151726400	1151730000	0	1:00	3600
9H	1151726400	1151733600	0	2:00	3600
9H	1151726400	1151737200	0	3:00	3600
9H	1151726400	1151740800	0	4:00	3600
9H	1151726400	1151744400	0	5:00	3600
9H	1151726400	1151748000	0	6:00	3600
9H	1151726400	1151751600	0	7:00	3600
9H	1151726400	1151755200	0	8:00	3600

# check near leap year (near 1Mar2004)
6H	1078106400	1078106400	0	21:00	
6H	1078106400	1078110000	0	22:00	3600
6H	1078106400	1078113600	0	23:00	3600
6H	1078106400	1078117200	1	01/Mar	3600
6H	1078106400	1078120800	0	1:00	3600
6H	1078106400	1078124400	0	2:00	3600

22H	1078074000	1078074000	0	12:00	
22H	1078074000	1078081200	0	14:00	7200
22H	1078074000	1078088400	0	16:00	7200
22H	1078074000	1078095600	0	18:00	7200
22H	1078074000	1078102800	0	20:00	7200
22H	1078074000	1078110000	0	22:00	7200
22H	1078074000	1078117200	1	01/Mar	7200
22H	1078074000	1078124400	0	2:00	7200
22H	1078074000	1078131600	0	4:00	7200
22H	1078074000	1078138800	0	6:00	7200
22H	1078074000	1078146000	0	8:00	7200

14D	1077512400	1077512400	0	Mon	
14D	1077512400	1077598800	0	Tue	86400
14D	1077512400	1077685200	0	Wed	86400
14D	1077512400	1077771600	0	Thu	86400
14D	1077512400	1077858000	0	Fri	86400
14D	1077512400	1077944400	0	Sat	86400
14D	1077512400	1078030800	1	29/Feb	86400
14D	1077512400	1078117200	0	Mon	86400
14D	1077512400	1078203600	0	Tue	86400
14D	1077512400	1078290000	0	Wed	86400
14D	1077512400	1078376400	0	Thu	86400
14D	1077512400	1078462800	0	Fri	86400
14D	1077512400	1078549200	0	Sat	86400
14D	1077512400	1078635600	1	07/Mar	86400

20D	1077512400	1077512400	0	23/Feb	
20D	1077512400	1077685200	0	25/Feb	172800
20D	1077512400	1077858000	0	27/Feb	172800
20D	1077512400	1078030800	0	29/Feb	172800
20D	1077512400	1078117200	1	01/Mar	86400
20D	1077512400	1078290000	0	03/Mar	172800
20D	1077512400	1078462800	0	05/Mar	172800
20D	1077512400	1078635600	0	07/Mar	172800
20D	1077512400	1078808400	0	09/Mar	172800
20D	1077512400	1078981200	0	11/Mar	172800
20D	1077512400	1079154000	0	13/Mar	172800

# and near non-leap year (near 1Mar2005)
6H	1109642400	1109642400	0	21:00	
6H	1109642400	1109646000	0	22:00	3600
6H	1109642400	1109649600	0	23:00	3600
6H	1109642400	1109653200	1	01/Mar	3600
6H	1109642400	1109656800	0	1:00	3600
6H	1109642400	1109660400	0	2:00	3600

22H	1109610000	1109610000	0	12:00	
22H	1109610000	1109617200	0	14:00	7200
22H	1109610000	1109624400	0	16:00	7200
22H	1109610000	1109631600	0	18:00	7200
22H	1109610000	1109638800	0	20:00	7200
22H	1109610000	1109646000	0	22:00	7200
22H	1109610000	1109653200	1	01/Mar	7200
22H	1109610000	1109660400	0	2:00	7200
22H	1109610000	1109667600	0	4:00	7200
22H	1109610000	1109674800	0	6:00	7200
22H	1109610000	1109682000	0	8:00	7200

14D	1109048400	1109048400	0	Tue	
14D	1109048400	1109134800	0	Wed	86400
14D	1109048400	1109221200	0	Thu	86400
14D	1109048400	1109307600	0	Fri	86400
14D	1109048400	1109394000	0	Sat	86400
14D	1109048400	1109480400	1	27/Feb	86400
14D	1109048400	1109566800	0	Mon	86400
14D	1109048400	1109653200	0	Tue	86400
14D	1109048400	1109739600	0	Wed	86400
14D	1109048400	1109826000	0	Thu	86400
14D	1109048400	1109912400	0	Fri	86400
14D	1109048400	1109998800	0	Sat	86400
14D	1109048400	1110085200	1	06/Mar	86400
14D	1109048400	1110171600	0	Mon	86400

20D	1109048400	1109134800	0	23/Feb	
20D	1109048400	1109307600	0	25/Feb	172800
20D	1109048400	1109480400	0	27/Feb	172800
20D	1109048400	1109653200	1	01/Mar	172800
20D	1109048400	1109826000	0	03/Mar	172800
20D	1109048400	1109998800	0	05/Mar	172800
20D	1109048400	1110171600	0	07/Mar	172800
20D	1109048400	1110344400	0	09/Mar	172800
20D	1109048400	1110517200	0	11/Mar	172800
20D	1109048400	1110690000	0	13/Mar	172800

# check near time change (2Apr)
4H	1143954000	1143954000	1	02/Apr	
4H	1143954000	1143955800	0	0:30	1800
4H	1143954000	1143957600	0	1:00	1800
4H	1143954000	1143959400	0	1:30	1800
4H	1143954000	1143961200	0	3:00	1800
4H	1143954000	1143963000	0	3:30	1800
4H	1143954000	1143964800	0	4:00	1800
4H	1143954000	1143966600	0	4:30	1800

8H	1143954000	1143954000	1	02/Apr	
8H	1143954000	1143957600	0	1:00	3600
8H	1143954000	1143961200	0	3:00	3600
8H	1143954000	1143964800	0	4:00	3600
8H	1143954000	1143968400	0	5:00	3600
8H	1143954000	1143972000	0	6:00	3600
8H	1143954000	1143975600	0	7:00	3600
8H	1143954000	1143979200	0	8:00	3600

2D	1143954000	1143954000	1	02/Apr	
2D	1143954000	1143964800	0	4:00	10800
2D	1143954000	1143979200	0	8:00	14400
2D	1143954000	1143993600	0	12:00	14400
2D	1143954000	1144008000	0	16:00	14400
2D	1143954000	1144022400	0	20:00	14400
2D	1143954000	1144036800	1	03/Apr	14400
2D	1143954000	1144051200	0	4:00	14400
2D	1143954000	1144065600	0	8:00	14400
2D	1143954000	1144080000	0	12:00	14400
2D	1143954000	1144094400	0	16:00	14400
2D	1143954000	1144108800	0	20:00	14400
2D	1143954000	1144123200	1	04/Apr	14400

4D	1143954000	1143954000	1	02/Apr	
4D	1143954000	1144036800	0	Mon	82800
4D	1143954000	1144123200	0	Tue	86400
4D	1143954000	1144209600	0	Wed	86400
4D	1143954000	1144296000	0	Thu	86400

# check near time change (29Oct)
4H	1162094400	1162094400	1	29/Oct	
4H	1162094400	1162096200	0	0:30	1800
4H	1162094400	1162098000	0	1:00	1800
4H	1162094400	1162099800	0	1:30	1800
4H	1162094400	1162101600	0	1:00	1800
4H	1162094400	1162103400	0	1:30	1800
4H	1162094400	1162105200	0	2:00	1800
4H	1162094400	1162107000	0	2:30	1800

8H	1162094400	1162094400	1	29/Oct	
8H	1162094400	1162098000	0	1:00	3600
8H	1162094400	1162101600	0	1:00	3600
8H	1162094400	1162105200	0	2:00	3600
8H	1162094400	1162108800	0	3:00	3600
8H	1162094400	1162112400	0	4:00	3600
8H	1162094400	1162116000	0	5:00	3600
8H	1162094400	1162119600	0	6:00	3600

2D	1162094400	1162094400	1	29/Oct	
2D	1162094400	1162112400	0	4:00	18000
2D	1162094400	1162126800	0	8:00	14400
2D	1162094400	1162141200	0	12:00	14400
2D	1162094400	1162155600	0	16:00	14400
2D	1162094400	1162170000	0	20:00	14400
2D	1162094400	1162184400	1	30/Oct	14400
2D	1162094400	1162198800	0	4:00	14400
2D	1162094400	1162213200	0	8:00	14400
2D	1162094400	1162227600	0	12:00	14400
2D	1162094400	1162242000	0	16:00	14400
2D	1162094400	1162256400	0	20:00	14400

4D	1162094400	1162094400	1	29/Oct	
4D	1162094400	1162184400	0	Mon	90000
4D	1162094400	1162270800	0	Tue	86400
4D	1162094400	1162357200	0	Wed	86400

