# lustre.spec
%{!?version: %define version 1.8.5}
%{!?kversion: %define kversion }
%{!?release: %define release }
%{!?lustre_name: %define lustre_name lustre}
%{!?build_lustre_tests: %define build_lustre_tests 1}

# in order to get kernel symset and/or kernel module dependencies into
# the RPM, in order to support weak-modules, the internal dependency gen-
# erator needs to be disabled
# this is done with (reduce the double % down to a single %):
#
# %%global _use_internal_dependency_generator 0
#
# on SLES10, /usr/lib/rpm/macros already sets this, so no harm in also
# defining it here (until Suse changes their mind)
#
# on RHEL5, however, we do need to explicitly disable the internal dep-
# endency generator and allow the external one be used
# but since RedHat's kABI is only a subset of the total kernel ABI, it
# doesn't include all of the symbols we (or OFED for that matter) need
# until RedHat includes all of the symbols we need in their symsets we
# cannot support weak-modules
# we did e-mail the maintainer of all of this stuff @redhat but got no
# response from them
#%%global _use_internal_dependency_generator 0

%define is_client %(bash -c "if [[ %{lustre_name} = *-client ]]; then echo -n '1'; else echo -n '0'; fi")
# for those uses that don't want the -smp/-bigsmp on the end of %kversion
%define krequires %(bash -c "echo %{kversion} | sed -e 's/-smp$//' -e 's/-bigsmp$//' -e 's/-ppc64$//' -e 's/-default$//'")

%define sles10 %(bash -c "if [ "%sles_version" = "10" ]; then echo -n '1'; else echo -n '0'; fi")

%if %sles10
%define flavor %(bash -c "echo %{kversion} | sed -e 's/^.*-//'")
%endif

Summary: Lustre File System
Name: %{lustre_name}
Version: %{version}
Release: %{release}
License: GPL
Group: Utilities/System
Source: lustre-%{version}.tar.gz
URL: http://www.sun.com/software/products/lustre/index.xml
BuildRoot: %{_tmppath}/lustre-%{version}-root
Obsoletes: lustre-lite, lustre-lite-utils, lustre-ldap nfs-utils-lustre
Provides: lustre-lite = %{version}, lustre-lite-utils = %{version}
Requires: %{name}-modules = %{version}
# GSS requires this: BuildRequires: pkgconfig, libgssapi-devel >= 0.10

%description
Userspace tools and files for the Lustre file system.

%package modules
Summary: Kernel Lustre modules for Linux %{kversion}
# for RHEL5 and SLES11, we need nothing here
# for SLES10, we need (where %{flavor} is, i.e. smp):
%if %sles10
Requires: kernel-%{flavor}
%endif
Group: Development/Kernel

%description modules
Lustre file system, server and network drivers for Linux %{kversion}.

%package source
Summary: Object-Based Disk storage driver source
Group: Development/Kernel

%description source
Lustre sources for further development

# Since the RPMs we ship are to be used on both SLES and RHEL, we
# can't include any dependency information (since the package names
# are different on the two platforms).
#
# Instead, we can build these empty meta-packages that only include
# dependency information.  These let people get the correct
# dependencies for their platform and lets them use tools like yum and
# red carpet to install the correct files.
#
# Unfortunately I have not seen this come up on the lists much, so I
# have disabled them (by commenting out their empty files section
# below) until it's clear that they resolve more confusion than they
# add.

%package deps-sles
Summary: Lustre dependencies meta-package for SLES
Group: Utilities/System
Provides: lustre-deps = %{version}
Requires: %{name} = %{version}, sles-release
Conflicts: %{name}-deps-rhel

%description deps-sles
This package has RPM dependencies appropriate for SLES systems.

%package deps-rhel
Summary: Lustre dependencies meta-package for RHEL
Group: Utilities/System
Provides: lustre-deps = %{version}
Requires: %{name} = %{version}, redhat-release
Conflicts: %{name}-deps-sles

%description deps-rhel
This package has RPM dependencies appropriate for RHEL, RHL, and FC
systems.

%package tests
Summary: Lustre testing framework
Group: Development/Kernel
Provides: %{name}-tests = %{version}
Requires: %{name} = %{version}, %{name}-modules = %{version}

%description tests
This package contains a set of test binaries and scripts that are intended
to be used by the Lustre testing framework.

%if 0%{?suse_version}
%debug_package
%endif
%prep
%setup -qn lustre-%{version}
ln lustre/ChangeLog ChangeLog-lustre
ln lnet/ChangeLog ChangeLog-lnet

%build
# if RPM_BUILD_NCPUS unset, set it
if [ -z "$RPM_BUILD_NCPUS" ] ; then
    RPM_BUILD_NCPUS=$(egrep -c "^cpu[0-9]+" /proc/stat 2>/dev/null || echo 0 :)
    if [ $RPM_BUILD_NCPUS -eq 0 ] ; then
        RPM_BUILD_NCPUS=1
    fi
    if [ $RPM_BUILD_NCPUS -gt 8 ] ; then
        RPM_BUILD_NCPUS=8
    fi
fi

rm -rf $RPM_BUILD_ROOT

# Set an explicit path to our Linux tree, if we can.
cd $RPM_BUILD_DIR/lustre-%{version}
# override %optflags so that the vendor's overzealous flags don't create
# build failures
%define optflags -g -O2 -Werror
CONFIGURE_ARGS=""
%if %{build_lustre_tests}
CONFIGURE_ARGS="$CONFIGURE_ARGS --enable-tests --enable-liblustre-tests"
%else
CONFIGURE_ARGS="$CONFIGURE_ARGS --disable-tests --disable-liblustre-tests"
%endif
%configure %{?configure_args:%configure_args} $CONFIGURE_ARGS
make -j $RPM_BUILD_NCPUS -s

%install
make install DESTDIR=$RPM_BUILD_ROOT
# hack to avoid changing the libsysio code for "make install"
rm -f $RPM_BUILD_ROOT%{_libdir}/libsysio.a
# Remove ldiskfs module(s) - they are packaged by the ldiskfs .spec.
rm -rf $RPM_BUILD_ROOT/lib/modules/%{kversion}/updates/kernel/fs/lustre-ldiskfs

# hack to include the llog_test module in lustre-tests
llog_base=$RPM_BUILD_DIR/lustre-%{version}/lustre/obdclass/llog_test
if [ -e ${llog_base}.ko ]; then
  cp ${llog_base}.ko $RPM_BUILD_ROOT/lib/modules/%{kversion}/updates/kernel/fs/lustre
elif [ -e ${llog_base}.o ]; then
  cp ${llog_base}.o $RPM_BUILD_ROOT/lib/modules/%{kversion}/updates/kernel/fs/lustre
fi

# Create the pristine source directory.
cd $RPM_BUILD_DIR/lustre-%{version}
mkdir -p $RPM_BUILD_ROOT/usr/src
rm -f lustre-source
ln -s $RPM_BUILD_ROOT/usr/src lustre-source
make distdir distdir=lustre-source/lustre-%{version}
chmod -R go-w lustre-source/lustre-%{version}

cat >lustre.files <<EOF
%attr(-, root, root) /sbin/mount.lustre
%attr(-, root, root) /usr/sbin/*
%attr(-, root, root) /usr/bin/*

%attr(-, root, root) /usr/share/lustre

%attr(-, root, root) %{_libdir}/libptlctl.a
%attr(-, root, root) %{_libdir}/liblustreapi.a
%attr(-, root, root) /usr/include/lustre

%attr(-, root, root) %{_mandir}/man?/*

%attr(-, root, root) %{_libexecdir}/lustre/lc_common

%attr(-, root, root) %{_sysconfdir}/udev/rules.d/99-lustre.rules
EOF

if [ -f $RPM_BUILD_ROOT%{_libdir}/libcfsutil.a ] ; then
  echo '%attr(-, root, root) %{_libdir}/libcfsutil.a' >>lustre.files
fi

if [ -f $RPM_BUILD_ROOT%{_libdir}/liblustre.so ] ; then
  echo '%attr(-, root, root) %{_libdir}/liblustre.a' >>lustre.files
  echo '%attr(-, root, root) %{_libdir}/liblustre.so' >>lustre.files
fi

if [ -f $RPM_BUILD_DIR/lustre-%{version}/lustre/utils/libiam.c ] ; then
  echo '%attr(-, root, root) %{_libdir}/libiam.a' >>lustre.files
fi

if [ -d $RPM_BUILD_ROOT%{_libdir}/lustre/snmp ] ; then
  echo '%attr(-, root, root) %{_libdir}/lustre/snmp' >>lustre.files
  echo '%attr(-, root, root) %{_datadir}/lustre/snmp/mibs' >>lustre.files
fi

# Have universal lustre headers 
if [ -f $RPM_BUILD_DIR/lustre-%{version}/lustre/include/lustre/lustre_idl.h ] ; then
  echo '%attr(-, root, root) /usr/include/linux/lustre_user.h' >>lustre.files
else
  echo '%attr(-, root, root) /usr/include/linux/lustre_idl.h' >>lustre.files
fi

if [ -f $RPM_BUILD_DIR/lustre-%{version}/lustre/include/linux/lustre_types.h ] ; then
  echo '%attr(-, root, root) /usr/include/linux/lustre_types.h' >>lustre.files
fi

%if %{build_lustre_tests}
echo '%attr(-, root, root) %{_libdir}/lustre/tests/*' >lustre-tests.files
echo '%attr(-, root, root) /lib/modules/%{kversion}/updates/kernel/fs/lustre/llog_test.*' >>lustre-tests.files
modules_excludes="|llog_test"
if [ -d $RPM_BUILD_ROOT%{_libdir}/lustre/liblustre/tests ] ; then
  echo '%attr(-, root, root) %{_libdir}/lustre/liblustre/tests/*' >>lustre-tests.files
fi
%endif

pushd $RPM_BUILD_ROOT >/dev/null
find lib/modules/%{kversion}/updates -type f | awk "!/(ZZZZZZZZZZ$modules_excludes)/ {print \"%attr(-, root, root) /\"\$0}" >>$RPM_BUILD_DIR/lustre-%{version}/lustre-modules.files
popd >/dev/null

%files -f lustre.files

%files modules -f lustre-modules.files
%attr(-, root, root) %doc COPYING
%attr(-, root, root) %doc ChangeLog-lustre
%attr(-, root, root) %doc ChangeLog-lnet

%files source
%attr(-, root, root) /usr/src/lustre-%{version}

# uncomment these lines to enable deps packages
# %files deps-sles
# %files deps-rhel

%if %{build_lustre_tests}
%files tests -f lustre-tests.files
%endif

%post modules
if [ -f /boot/System.map-%{kversion} ]; then
	depmod -ae -F /boot/System.map-%{kversion} %{kversion} || exit 0
else
	depmod -ae %{kversion} || exit 0
fi

# "weak modules" support
# Suse
if [ -x /usr/lib/module-init-tools/weak-modules ]; then
    rpm -ql %{name}-modules-%{version}-%{release} | grep '\.ko$' |
        /usr/lib/module-init-tools/weak-modules --add-modules
fi
# RedHat
if [ -x /sbin/weak-modules ]; then
    rpm -ql %{name}-modules-%{version}-%{release} | grep '\.ko$' |
        /sbin/weak-modules --add-modules
fi

cat <<EOF
Congratulations on finishing your Lustre installation!  To register
your copy of Lustre and find out more about Lustre Support, Service,
and Training offerings please visit

http://www.sun.com/software/products/lustre/lustre_reg.jsp
EOF

# for update from < v1.4.6

for f in /etc/modules.conf /etc/modprobe.conf /etc/modprobe.conf.local ; 
do
	if [ -f $f ]; then
		if grep 'lustre llite' $f >/dev/null 2>/dev/null ; then
			[ ! -f $f.rpmsave ] && cp $f $f.rpmsave
			TMPFILE=`mktemp $f.XXXXXX` && \
			rm -f $TMPFILE && touch $TMPFILE && \
			grep -v 'lustre llite' $f >> $TMPFILE && \
			mv $TMPFILE $f
		fi
		if egrep "^[^#]*(add below|install) ptlrpc" $f ; then
			[ ! -f $f.rpmsave ] && cp $f $f.rpmsave
			TMPFILE=`mktemp $f.XXXXXX` && \
			rm -f $TMPFILE && touch $TMPFILE && \
			sed -e "s/^[^#]*\(add below\|install\) ptlrpc.*/#&/" $f >> $TMPFILE && \
			mv $TMPFILE $f
		fi
	fi
done

# If the kernel was built to reject unsupported modules (e.g. not a Lustre
# kernel), and this hasn't been overridden in /etc/modprobe.d yet, then
# print a warning so that users are aware of this issue.
if sysctl kernel.unsupported >/dev/null 2>&1 &&
   [ "$(sysctl -n kernel.unsupported 2>/dev/null)" = "0" ] &&
    ! modprobe -c | grep -q "^allow_unsupported_modules[ \t]1" ; then
     echo "
     warning: the Lustre modules are not supported by Novell. To use Lustre
              on this system, you should put

     allow_unsupported_modules 1

     into /etc/modprobe.d/unsupported_modules"
fi

%preun modules
rpm -ql %{name}-modules-%{version}-%{release} | grep '\.ko$' > /var/run/%{name}-modules

%postun modules
if [ -f /boot/System.map-%{kversion} ]; then
	depmod -ae -F /boot/System.map-%{kversion} %{kversion} || exit 0
else
	depmod -ae %{kversion} || exit 0
fi

# "weak modules" support
# Suse
if [ -x /usr/lib/module-init-tools/weak-modules ]; then
    cat /var/run/%{name}-modules | grep '\.ko$' |
        /usr/lib/module-init-tools/weak-modules --remove-modules
fi
# RedHat
if [ -x /sbin/weak-modules ]; then
    cat /var/run/%{name}-modules | grep '\.ko$' |
        /sbin/weak-modules --remove-modules
fi
rm /var/run/%{name}-modules

%if %{build_lustre_tests}
%post tests
if [ -f /boot/System.map-%{kversion} ]; then
	depmod -ae -F /boot/System.map-%{kversion} %{kversion} || exit 0
else
	depmod -ae %{kversion} || exit 0
fi

%postun tests
if [ -f /boot/System.map-%{kversion} ]; then
	depmod -ae -F /boot/System.map-%{kversion} %{kversion} || exit 0
else
	depmod -ae %{kversion} || exit 0
fi
%endif

%clean
rm -rf $RPM_BUILD_ROOT
