/* ---------------------------------- modifyDialog.h ---------------------------------------------------------------------------
 Header file for modifyDialog.cpp

===============================================================================================================================
===============================================================================================================================
     This file is part of "luckyBackup" project
     Copyright 2008-2010, Loukas Avgeriou
     luckyBackup is distributed under the terms of the GNU General Public License
     luckyBackup is free software: you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation, either version 3 of the License, or
     (at your option) any later version.
 
     luckyBackup is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.
 
     You should have received a copy of the GNU General Public License
     along with luckyBackup.  If not, see <http://www.gnu.org/licenses/>.

 project version	: Please see "main.cpp" for project version

 developer 		: luckyb 
 last modified 		: 11 Jun 2010
===============================================================================================================================
===============================================================================================================================
*/

#ifndef MODIFYDIALOG_H
#define MODIFYDIALOG_H

//include  header file that qmake produces from "*.ui" created with qt designer
#include "ui_modifyDialog.h"
#include "operationClass.h"
#include "patternEditor.h"

//==============================================================================================================
//Declaration of rsyncDialog class (this will execute rsync and show progress in a dialog)
class modifyDialog : public QDialog
{
	Q_OBJECT
	
	public:
		modifyDialog (int, QDialog *parent=0);

		operation *fillOperationArray();	//function to fill the data of an operation array item from the window fields
		void fillModifyWindow(operation*);	//function to fill the window fields from the data of an operation array item
		void modifyTrailing();			//function to add a remove a trailing "/" at the end of the source or dest dir
		QStringList StdArguments;		//this variable holds the standard arguments used by rsync
		int ArrayPosition;			//this holds the item's position in the "operation array"
		//bool validation;			//becomes true if "validation check" button is pressed
		int count;		//simple count variable !!

	private slots:
		void advancedPressed(bool);	//SLOT when advanced buutton pressed to hide part of widget
		void cancelPressed();		//SLOT when cancel pushbutton pressed
		void okayPressed();		//SLOT when okay pushbutton pressed
		void commandPressed();		//SLOT when show command pushbutton pressed
		void addListItem(const int);	//SLOT to add an item in the excluded list
		void removeListItem(const int);	//SLOT to remove an item from the excluded list
		void browse(const int);		//SLOT to browse for a directory or file
		void getPattern(const int);	//SLOT to launch the pattern editor and insert the pattern to a lineEdit
		void TaskTypeChanged(int);	// SLOT to act upon task type changes

	private:
		Ui::modifyDialog uiM;
		int stdWindowWidth, minWindowHeight, maxWindowHeight;	//standard window dimensions
		QString stripInvalidCharacters(QString);	//Strips off invalid filename characters from a string

	protected:
		void closeEvent(QCloseEvent *event);	//when the close button of the dialog pressed

};

#endif

// end of modifyDialog.h ---------------------------------------------------------------------------
