/*
 *  Linux snipes, a text-based maze-oriented game for linux.
 *  Copyright (C) 1997 Jeremy Boulton.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Jeremy Boulton is reachable via electronic mail at
 *  boultonj@ugcs.caltech.edu.
 */

#ifndef _SNIPES_COLLISION_H
#define _SNIPES_COLLISION_H

#define MAZE_OBJECT_NONE		0
#define MAZE_OBJECT_PLAYER		1
#define MAZE_OBJECT_SNIPE		2
#define MAZE_OBJECT_SNIPE_GHOST		4
#define MAZE_OBJECT_SNIPE_MAKER		8
#define MAZE_OBJECT_PLAYER_BULLET	16
#define MAZE_OBJECT_SNIPE_BULLET	32
#define MAZE_OBJECT_WALL		64
#define MAZE_OBJECT_EVERYTHING		127

void init_collision_detector( int xsquares, int ysquares );
void destroy_collision_detector( void );
char check_collisions( int x0, int y0, int w, int h, char obj_mask );
char check_adjacent_collisions( int x0, int y0, int w, int h, char obj_mask );
char check_line_collisions( int x0, int y0, int dx, int dy, int len, char obj_mask );
void collision_map_place_obj( int x0, int y0, int w, int h, char obj_type );
void collision_map_remove_obj( int x0, int y0, int w, int h, char obj_type );

#endif
