/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 */

 /* (C) Marcin Kwadrans <quar@vitea.pl> */

#include "include/support.h"
#include "include/environment.h"

#include "icon32x32.xpm"
#include "icon48x48.xpm"
#include "icon64x64.xpm"

#include <string>

extern void create_interface ();
extern void set_title (gchar *name);
extern GData *get_symbols ();

gboolean enable_debug = FALSE;

int
main (int argc, char *argv[])
{
#ifdef ENABLE_NLS
#ifdef _WIN32
	gchar *localedir = g_win32_get_package_installation_subdirectory(NULL, NULL, "share\\locale");
	bindtextdomain (GETTEXT_PACKAGE, localedir);
	g_free (localedir);
#else
	bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
#endif

	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
#endif

	gtk_set_locale ();
	
	if (argc > 1)
		if (!strcmp ("--help", argv[1])) {
			char *prgname = g_path_get_basename(argv[0]);

			g_print (_("Syntax: %s [OPTION] [FILE]\n"\
					   "Load little wizard project file or start new project\n"\
					   " --help     Show this message and exit\n"\
			           " --version  Print version info and exit\n"),
						prgname);

			g_free (prgname);
			return 0;
			
		} else if (!strcmp ("--version", argv[1])) {
			g_print ("Little Wizard %s\n",VERSION);
			g_print ("(C) Marcin Kwadrans <quar@vitea.pl>\n"\
					 "This program is distributed in the hope that it will be useful,\n"\
					 "but WITHOUT ANY WARRANTY; without even the implied warranty of\n"\
					 "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"\
					 "GNU General Public License for more details.\n");
			
			return 0;
		}

	gtk_init (&argc, &argv);
	
	GList *icon_list=NULL;
	icon_list = g_list_append(icon_list,
		  (gpointer) gdk_pixbuf_new_from_xpm_data((const char**) icon32x32));
	icon_list = g_list_append(icon_list,
		  (gpointer) gdk_pixbuf_new_from_xpm_data((const char**) icon48x48));
	icon_list = g_list_append(icon_list,
		  (gpointer) gdk_pixbuf_new_from_xpm_data((const char**) icon64x64));
	gtk_window_set_default_icon_list (icon_list);
	g_list_foreach (icon_list, (GFunc) g_object_unref, NULL);
	g_list_free (icon_list);
	
	GData *symbols = get_symbols();
	LWEnvironment::init(symbols);
	LWProject *project = new LWProject();
	LWEnvironment::setProject (project);

	create_interface();

	if (argc > 1) {
		if (!strcmp ("--debug-tree", argv[1])) {
			enable_debug = TRUE;
	
			if (argc > 2) {
				project->load (argv[2]);
				set_title (argv[2]);
			}
		} else {
			project->load (argv[1]);
			set_title (argv[1]);
		}
	}

	gtk_main ();

	return 0;
}
